/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.packer.gui.launcher;

import ch.docuteam.packer.gui.PackerConstants;
import ch.docuteam.packer.gui.launcher.LauncherView;
import ch.docuteam.tools.file.FileFilter;
import ch.docuteam.tools.gui.GUIUtil;
import ch.docuteam.tools.gui.GridBagPanel;
import ch.docuteam.tools.translations.I18N;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class CreateNewSIPFromTemplateDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final LauncherView launcherView;
    protected JButton selectDestinationZIPOrFolderButton;
    protected JButton selectDestinationIsWorkspaceButton;
    protected JButton goButton;
    protected JTextField destinationFolderTextField;
    protected JTextField destinationNameTextField;
    protected JComboBox templateComboBox;
    protected JCheckBox beZIPCheckBox;
    protected JLabel messageLabel;
    protected boolean goButtonWasClicked = false;

    protected CreateNewSIPFromTemplateDialog(LauncherView owner) {
        super(owner, I18N.translate((String)"TitleCreateNewSIPFromTemplate"), true);
        this.launcherView = owner;
        this.setIconImage(PackerConstants.getImage("DocuteamPacker.png"));
        this.setDefaultCloseOperation(2);
        this.getRootPane().registerKeyboardAction(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateNewSIPFromTemplateDialog.this.close();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        this.templateComboBox = new JComboBox<String>(this.getTemplateNames());
        this.templateComboBox.setToolTipText(I18N.translate((String)"ToolTipSelectTemplate"));
        this.templateComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateNewSIPFromTemplateDialog.this.templateSelected();
            }
        });
        this.selectDestinationZIPOrFolderButton = new JButton(PackerConstants.getImageIcon("OpenFolder.png"));
        this.selectDestinationZIPOrFolderButton.setToolTipText(I18N.translate((String)"ToolTipSelectDestinationFolder"));
        this.selectDestinationZIPOrFolderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateNewSIPFromTemplateDialog.this.selectDestinationFolderButtonClicked();
            }
        });
        this.selectDestinationIsWorkspaceButton = new JButton(PackerConstants.getImageIcon("Workspace.png"));
        this.selectDestinationIsWorkspaceButton.setToolTipText(I18N.translate((String)"ToolTipSelectDestinationIsWorkspaceFolder"));
        this.selectDestinationIsWorkspaceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateNewSIPFromTemplateDialog.this.selectDestinationIsWorkspaceButtonClicked();
            }
        });
        this.destinationFolderTextField = new JTextField(new File(owner.getLastUsedOpenOrSaveDirectory()).getAbsolutePath());
        this.destinationFolderTextField.setToolTipText(I18N.translate((String)"ToolTipDestinationFolder"));
        this.destinationNameTextField = new JTextField((String)this.templateComboBox.getSelectedItem());
        this.destinationNameTextField.setToolTipText(I18N.translate((String)"ToolTipDestinationName"));
        this.destinationNameTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                CreateNewSIPFromTemplateDialog.this.enableOrDisableButtonsAndFields();
            }
        });
        this.beZIPCheckBox = new JCheckBox("ZIP", owner.isNewSIPZippedByDefault());
        this.beZIPCheckBox.setToolTipText(I18N.translate((String)"ToolTipBeZIP"));
        this.messageLabel = new JLabel();
        this.goButton = new JButton(PackerConstants.getImageIcon("Save.png"));
        this.goButton.setToolTipText(I18N.translate((String)"ToolTipCreateNew"));
        this.goButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateNewSIPFromTemplateDialog.this.goButtonClicked();
            }
        });
        GridBagPanel gridBag = new GridBagPanel((Border)new EmptyBorder(10, 10, 10, 10), new Insets(0, 5, 0, 0));
        gridBag.add((Component)new JLabel(I18N.translate((String)"LabelTemplate")), 1, 0, 13);
        gridBag.add((Component)this.templateComboBox, 1, 3, 17, 2, 1.0, 0.0);
        gridBag.add((Component)new JLabel(I18N.translate((String)"LabelNewSIPDestination")), 2, 0, 13);
        gridBag.add((Component)this.selectDestinationIsWorkspaceButton, 2, 1);
        gridBag.add((Component)this.selectDestinationZIPOrFolderButton, 2, 2);
        gridBag.add((Component)this.destinationFolderTextField, 2, 3, 17, 2, 2.0, 0.0);
        gridBag.add((Component)this.destinationNameTextField, 2, 4, 17, 2, 1.0, 0.0);
        gridBag.add((Component)this.beZIPCheckBox, 2, 5);
        gridBag.add((Component)this.messageLabel, 3, 3, 0, 4, 13, 2, 1.0, 0.0);
        gridBag.add((Component)this.goButton, 3, 5, 13);
        this.add((Component)gridBag);
        this.setPreferredSize(new Dimension(800, 150));
        this.pack();
        this.setLocationRelativeTo(owner);
        this.templateComboBox.requestFocusInWindow();
        this.enableOrDisableButtonsAndFields();
        this.setVisible(true);
    }

    protected void templateSelected() {
        this.destinationNameTextField.setText((String)this.templateComboBox.getSelectedItem());
        this.enableOrDisableButtonsAndFields();
    }

    protected void selectDestinationFolderButtonClicked() {
        JFileChooser fileChooser = new JFileChooser(this.destinationFolderTextField.getText());
        fileChooser.setFileSelectionMode(1);
        fileChooser.setDialogTitle(I18N.translate((String)"TitleSelectDestinationFolder"));
        fileChooser.setMultiSelectionEnabled(false);
        int result = fileChooser.showSaveDialog(this);
        if (result == 1) {
            return;
        }
        this.destinationFolderTextField.setText(fileChooser.getSelectedFile().getPath());
    }

    protected void selectDestinationIsWorkspaceButtonClicked() {
        this.destinationFolderTextField.setText(this.launcherView.getSipDirectory());
    }

    protected void goButtonClicked() {
        File destinationFile;
        String templateName = (String)this.templateComboBox.getSelectedItem();
        String destinationFolder = this.destinationFolderTextField.getText();
        String destinationName = this.destinationNameTextField.getText();
        if (templateName == null) {
            GUIUtil.shake((Window)this);
            this.messageLabel.setText(I18N.translate((String)"MessageTemplateNameIsEmpty"));
            return;
        }
        if (destinationName.isEmpty()) {
            GUIUtil.shake((Window)this);
            this.messageLabel.setText(I18N.translate((String)"MessageDestinationNameIsEmpty"));
            return;
        }
        if (this.beZIPCheckBox.isSelected()) {
            if (!destinationName.toLowerCase().endsWith(".zip")) {
                destinationName = destinationName + ".zip";
            }
        } else if (destinationName.toLowerCase().endsWith(".zip")) {
            destinationName = destinationName.substring(0, destinationName.length() - 4);
        }
        if ((destinationFile = new File(destinationFolder + "/" + destinationName)).exists()) {
            GUIUtil.shake((Window)this);
            this.messageLabel.setText(I18N.translate((String)"MessageSIPExistsAlready"));
            return;
        }
        this.launcherView.setLastUsedOpenOrSaveDirectory(destinationFolder);
        this.goButtonWasClicked = true;
        this.close();
    }

    protected void close() {
        this.setVisible(false);
        this.dispose();
    }

    private String[] getTemplateNames() {
        File templateDirectory = new File(this.launcherView.getTemplateDirectory());
        if (!templateDirectory.exists() || templateDirectory.isFile()) {
            return new String[0];
        }
        File[] templates = templateDirectory.listFiles((FilenameFilter)FileFilter.VisibleAll);
        Vector<String> templateNames = new Vector<String>();
        for (File file : templates) {
            templateNames.add(file.getName());
        }
        return templateNames.toArray(new String[0]);
    }

    protected void enableOrDisableButtonsAndFields() {
        this.goButton.setEnabled(!this.destinationNameTextField.getText().isEmpty() && this.templateComboBox.getSelectedItem() != null);
    }
}

