/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.model.filetable;

import com.exlibris.core.infra.model.HOwneredEntity;
import java.util.Calendar;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.validator.Length;

@Entity
@NamedQueries(value={@NamedQuery(name="FIND_FILE_TABLE_BY_FILE_KEY", query="from HFileTable hft where hft.fileKey = :fileKey and hft.owner = :owner"), @NamedQuery(name="FIND_FILE_TABLE_BY_SUBGROUPID", query="from HFileTable hft where hft.subGroupId = :subGroupId and hft.owner = :owner"), @NamedQuery(name="COUNT_FILE_TABLE_BY_SUBGROUPID", query="select count(hft.id) from HFileTable hft where hft.subGroupId = :subGroupId and hft.owner = :owner")})
@Table(name="FILE_TABLE", uniqueConstraints={@UniqueConstraint(columnNames={"FILE_KEY", "OWNER"})})
public class HFileTable
extends HOwneredEntity {
    private String fileKey;
    private String file;
    private String checksum;
    private Long subGroupId;
    private String fileName;
    private String description;
    private String validator;

    public HFileTable() {
    }

    public HFileTable(String fileKey, Long subGroupId, String fileName, String description, String modifiedBy, Calendar modificationDate, String validator, String content) {
        this.fileKey = fileKey;
        this.subGroupId = subGroupId;
        this.fileName = fileName;
        this.description = description;
        this.setModifiedBy(modifiedBy);
        this.setModificationDate(modificationDate);
        this.validator = validator;
        this.file = content;
    }

    @Length(max=300)
    @Column(name="FILE_KEY")
    public String getFileKey() {
        return this.fileKey;
    }

    public void setFileKey(String fileKey) {
        this.fileKey = fileKey;
    }

    @Lob
    @Length(max=0xFFFFFF)
    @Column(name="FILE_CONTENT")
    public String getFile() {
        return this.file;
    }

    public void setFile(String fileContent) {
        this.file = fileContent;
    }

    @Column(name="CHECKSUM")
    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    @Column(name="SUBGROUPID")
    public Long getSubGroupId() {
        return this.subGroupId;
    }

    public void setSubGroupId(Long subGroupId) {
        this.subGroupId = subGroupId;
    }

    @Column(name="FILENAME")
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Column(name="DESCRIPTION")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Column(name="VALIDATOR")
    public String getValidator() {
        return this.validator;
    }

    public void setValidator(String validator) {
        this.validator = validator;
    }

    public String toString() {
        return "FileKey(" + this.fileKey + ")";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fileKey == null ? 0 : this.fileKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HFileTable)) {
            return false;
        }
        HFileTable other = (HFileTable)obj;
        return !(this.fileKey == null ? other.fileKey != null : !this.fileKey.equals(other.fileKey));
    }
}

