/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.scriptRunner;

import com.exlibris.core.infra.svc.api.scriptRunner.ExecAbstract;
import com.exlibris.core.infra.svc.api.scriptRunner.ExecStrategy;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ExecLocal
extends ExecAbstract
implements ExecStrategy,
Serializable {
    @Override
    public int execExternalProcess(String cmd, List<String> args) {
        super.execExternalProcess(cmd, args);
        ArrayList<String> processArgs = new ArrayList<String>();
        for (int i = 0; i < args.size(); ++i) {
            processArgs.add(args.get(i));
        }
        Process proc = null;
        try {
            processArgs.add(0, cmd);
            String osName = System.getProperty("os.name");
            if (osName.equals("Unix") || osName.equals("Linux") || osName.equals("SunOS")) {
                proc = new ProcessBuilder(processArgs).start();
            } else {
                for (int i = 1; i < processArgs.size(); ++i) {
                    processArgs.set(i, "\"" + (String)processArgs.get(i) + "\"");
                }
                processArgs.add(0, "/C");
                processArgs.add(0, "cmd.exe");
                ProcessBuilder processBuilder = new ProcessBuilder(processArgs);
                proc = processBuilder.start();
            }
            StringBuffer output = ExecLocal.readInputStream(proc, false);
            proc.waitFor();
            this.exitValue = proc.exitValue();
            if (this.exitValue == 0) {
                this.inputStream = output.toString();
            } else {
                output = ExecLocal.readInputStream(proc, true);
                this.errorStream = output.toString();
            }
            if (proc != null) {
                proc.destroy();
                proc = null;
            }
        }
        catch (Throwable t) {
            this.errorStream = t.getMessage();
            this.exitValue = 1;
            if (proc != null) {
                proc.destroy();
                proc = null;
            }
            return 1;
        }
        return this.exitValue;
    }

    private static StringBuffer readInputStream(Process proc, boolean error) throws IOException {
        InputStream is = error ? proc.getErrorStream() : proc.getInputStream();
        int len = 0;
        byte[] buf = new byte[10000];
        StringBuffer output = new StringBuffer();
        while ((len = is.read(buf)) != -1) {
            String str = new String(buf, 0, len);
            output.append(str);
        }
        if (is != null) {
            is.close();
        }
        return output;
    }
}

