/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.repository.dataObjects;

import com.exlibris.core.infra.common.cache.SessionUtils;
import com.exlibris.core.infra.common.shared.dataObjects.KeyValuePair;
import com.exlibris.core.infra.model.codetables.HCodeTables;
import com.exlibris.core.infra.svc.api.CodeTablesManager;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.core.sdk.interfaces.PidWrapper;
import com.exlibris.core.sdk.strings.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DescriptorRow
implements Serializable,
PidWrapper {
    private static final long serialVersionUID = 1314677257427200105L;
    public static final String ACCESS_RIGHTS_POLICY = "AccessRightsPolicy";
    public static final int MIN_LINE_PARTS_WO_AR_POLICY = 17;
    private static final String DESCRIPTOR_HEADER = "DescriptorHeader";
    private static CodeTablesManager codeTablesManager = null;
    private String[] values;
    private List<KeyValuePair<String, String>> additionalParameters;
    private DescriptorHeader[] additionalDefaultHeaders;

    public DescriptorRow(Object[] values, List<KeyValuePair<String, String>> additionalParameters, DescriptorHeader ... additionalDefaultHeaders) {
        String[] sValues = new String[values.length];
        this.additionalDefaultHeaders = additionalDefaultHeaders;
        int size = sValues.length;
        for (int i = 0; i < size; ++i) {
            sValues[i] = values[i] != null ? values[i].toString() : null;
        }
        this.construct(sValues, additionalParameters, additionalDefaultHeaders);
    }

    public DescriptorRow(String[] values, List<KeyValuePair<String, String>> additionalParameters, DescriptorHeader ... additionalDefaultHeaders) {
        this.additionalDefaultHeaders = additionalDefaultHeaders;
        this.construct(values, additionalParameters, additionalDefaultHeaders);
    }

    private void construct(String[] values, List<KeyValuePair<String, String>> additionalParameters, DescriptorHeader ... additionalDefaultHeaders) {
        int size = 17 + additionalDefaultHeaders.length;
        if (values.length == size) {
            this.values = values;
        } else if (values.length > size) {
            this.values = new String[size];
            for (int i = 0; i < size; ++i) {
                this.values[i] = values[i];
            }
        } else if (values.length < size) {
            int i;
            this.values = new String[size];
            for (i = 0; i < values.length; ++i) {
                this.values[i] = values[i];
            }
            while (i < size) {
                this.values[i] = null;
                ++i;
            }
        }
        this.additionalParameters = additionalParameters;
    }

    public DescriptorRow(DescriptorHeader ... additionalDefaultHeaders) {
        this.additionalDefaultHeaders = additionalDefaultHeaders;
        this.values = new String[17 + additionalDefaultHeaders.length];
        this.additionalParameters = new ArrayList<KeyValuePair<String, String>>();
    }

    public void set(DescriptorHeader header, String value) {
        this.values[header.ordinal()] = value;
    }

    public void set(int header, String value) {
        this.values[header] = value;
    }

    public void set(String header, String value) {
        DescriptorHeader descriptorHeader;
        try {
            descriptorHeader = DescriptorHeader.valueOf(header);
        }
        catch (Exception e) {
            return;
        }
        this.set(descriptorHeader, value);
    }

    public String get(int header) {
        return this.values[header];
    }

    public String get(DescriptorHeader header) {
        return this.values[header.ordinal()];
    }

    public String get(String header) {
        DescriptorHeader descriptorHeader;
        try {
            descriptorHeader = DescriptorHeader.valueOf(header);
        }
        catch (Exception e) {
            return null;
        }
        return this.get(descriptorHeader);
    }

    private void initAdditionalParametets() {
        if (this.additionalParameters == null) {
            this.additionalParameters = new ArrayList<KeyValuePair<String, String>>();
        }
    }

    public void addAdditionalParameter(String key, String value) {
        this.initAdditionalParametets();
        this.additionalParameters.add(new KeyValuePair<String, String>(key, value));
    }

    public void addAdditionalParameter(KeyValuePair<String, String> pair) {
        this.initAdditionalParametets();
        if (pair != null) {
            this.additionalParameters.add(pair);
        }
    }

    public void addAdditionalParameters(List<KeyValuePair<String, String>> pairs) {
        this.initAdditionalParametets();
        if (pairs != null) {
            this.additionalParameters.addAll(pairs);
        }
    }

    public String getAdditionalParameter(String key) {
        this.initAdditionalParametets();
        for (KeyValuePair<String, String> pair : this.additionalParameters) {
            if (!pair.getKey().equals(key)) continue;
            return pair.getValue();
        }
        return null;
    }

    public List<KeyValuePair<String, String>> getAdditionalParameters() {
        this.initAdditionalParametets();
        return this.additionalParameters;
    }

    public String[] getRow() {
        ArrayList<String> rowValues = new ArrayList<String>();
        for (String str : this.values) {
            rowValues.add(str);
        }
        if (this.additionalParameters != null) {
            for (KeyValuePair keyValuePair : this.additionalParameters) {
                rowValues.add((String)keyValuePair.getValue());
            }
        }
        return rowValues.toArray(new String[rowValues.size()]);
    }

    public String[] getHeaderRow() {
        ArrayList<String> headerRow = new ArrayList<String>();
        for (DescriptorHeader descriptorHeader : Arrays.copyOf(DescriptorHeader.values(), 17)) {
            headerRow.add(descriptorHeader.toString());
        }
        if (this.additionalDefaultHeaders != null) {
            for (DescriptorHeader descriptorHeader : this.additionalDefaultHeaders) {
                headerRow.add(descriptorHeader.toString());
            }
        }
        if (this.additionalParameters != null) {
            for (KeyValuePair keyValuePair : this.additionalParameters) {
                headerRow.add((String)keyValuePair.getKey());
            }
        }
        return headerRow.toArray(new String[headerRow.size()]);
    }

    public boolean validate() {
        return !StringUtils.isEmptyString(this.get(DescriptorHeader.IePid)) && !StringUtils.isEmptyString(this.get(DescriptorHeader.RepresentationPid)) && !StringUtils.isEmptyString(this.get(DescriptorHeader.OriginalPid)) && !StringUtils.isEmptyString(this.get(DescriptorHeader.PreservationType)) && !StringUtils.isEmptyString(this.get(DescriptorHeader.Filename));
    }

    public boolean validateHeader(List<KeyValuePair<String, Object[]>> errors) {
        List<HCodeTables> codeTables = null;
        try {
            codeTables = this.getCodeTablesManager().findEnabledCodeTableByLanguageAndName(SessionUtils.getSessionLanguage(), DESCRIPTOR_HEADER, "CRS00");
        }
        catch (Exception e) {
            e.getMessage();
        }
        int i = 0;
        for (HCodeTables curRow : codeTables) {
            if (DescriptorHeader.AccessRightsPolicy.name().equals(curRow.getDescription()) || DescriptorHeader.ChecksumType.name().equals(curRow.getDescription()) || DescriptorHeader.FileOriginalPath.name().equals(curRow.getDescription())) continue;
            if (curRow.getDescription() == null || !curRow.getDescription().equals(this.values[i])) {
                errors.add(new KeyValuePair<String, Object[]>("ui.alternative_list.errors.descriptorConstruct", new Object[]{curRow.getDescription()}));
                return false;
            }
            ++i;
        }
        return true;
    }

    private CodeTablesManager getCodeTablesManager() {
        if (codeTablesManager == null) {
            codeTablesManager = (CodeTablesManager)ServiceLocator.getInstance().lookUp(CodeTablesManager.class);
        }
        return codeTablesManager;
    }

    @Override
    public String getPid() {
        return this.values[DescriptorHeader.OriginalPid.ordinal()];
    }

    public static enum DescriptorHeader {
        IePid,
        RepresentationPid,
        PreservationType,
        OriginalPid,
        Filename,
        FileLocation,
        UsageType,
        ConversionRequired,
        Label,
        RepresentationCode,
        RepresentationEntityType,
        MimeType,
        FileLabel,
        FileStructMapLabel,
        Checksum,
        SubmissionReason,
        Notes,
        AccessRightsPolicy,
        ChecksumType,
        FileOriginalPath;

    }
}

