/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.endpoint;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.EndpointResolver;
import org.apache.cxf.endpoint.EndpointResolverRegistry;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointResolverRegistryImpl
implements EndpointResolverRegistry {
    private Bus bus;
    private List<EndpointResolver> resolvers;

    @PostConstruct
    public void init() {
        this.resolvers = new ArrayList<EndpointResolver>();
        if (this.bus != null) {
            this.bus.setExtension((Object)this, EndpointResolverRegistry.class);
        }
    }

    public synchronized void register(EndpointResolver resolver) {
        this.resolvers.add(resolver);
    }

    public synchronized void unregister(EndpointResolver resolver) {
        this.resolvers.remove(resolver);
    }

    public synchronized EndpointReferenceType resolve(EndpointReferenceType logical) {
        EndpointResolver resolver;
        EndpointReferenceType physical = null;
        Iterator<EndpointResolver> i$ = this.resolvers.iterator();
        while (i$.hasNext() && (physical = (resolver = i$.next()).resolve(logical)) == null) {
        }
        return physical;
    }

    public EndpointReferenceType renew(EndpointReferenceType logical, EndpointReferenceType physical) {
        EndpointResolver resolver;
        EndpointReferenceType fresh = null;
        Iterator<EndpointResolver> i$ = this.resolvers.iterator();
        while (i$.hasNext() && (fresh = (resolver = i$.next()).renew(logical, physical)) == null) {
        }
        return fresh;
    }

    public EndpointReferenceType mint(QName serviceName) {
        EndpointResolver resolver;
        EndpointReferenceType logical = null;
        Iterator<EndpointResolver> i$ = this.resolvers.iterator();
        while (i$.hasNext() && (logical = (resolver = i$.next()).mint(serviceName)) == null) {
        }
        return logical;
    }

    public EndpointReferenceType mint(EndpointReferenceType physical) {
        EndpointResolver resolver;
        EndpointReferenceType logical = null;
        Iterator<EndpointResolver> i$ = this.resolvers.iterator();
        while (i$.hasNext() && (logical = (resolver = i$.next()).mint(physical)) == null) {
        }
        return logical;
    }

    protected List<EndpointResolver> getResolvers() {
        return this.resolvers;
    }

    public void setBus(Bus b) {
        this.bus = b;
    }
}

