/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.OracleResultSetMetaData;
import oracle.jdbc.driver.BfileAccessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DynamicByteArray;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4CMAREngine;

class T4CBfileAccessor
extends BfileAccessor {
    T4CMAREngine mare;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
    public static final boolean TRACE = false;

    T4CBfileAccessor(OracleStatement oracleStatement, int n2, short s2, int n3, boolean bl, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, 530, s2, n3, bl);
        this.mare = t4CMAREngine;
    }

    T4CBfileAccessor(OracleStatement oracleStatement, int n2, boolean bl, int n3, int n4, int n5, int n6, int n7, short s2, int n8, int n9, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, 530, bl, n3, n4, n5, n6, n7, s2);
        this.mare = t4CMAREngine;
        this.definedColumnType = n8;
        this.definedColumnSize = n9;
    }

    public T4CMAREngine getMAREngine() {
        return this.mare;
    }

    public void unmarshalColumnMetadata() throws SQLException, IOException {
        if (this.statement.statementType != 2 && !this.statement.sqlKind.isPlsqlOrCall() && this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.ENABLED) {
            this.setRowMetadata(this.lastRowProcessed, (byte)this.mare.unmarshalUB1());
        }
    }

    public void processIndicator(int n2) throws IOException, SQLException {
        if (this.internalType == 1 && this.describeType == 112 || this.internalType == 23 && this.describeType == 113) {
            this.mare.unmarshalUB2();
            this.mare.unmarshalUB2();
        } else if (this.statement.connection.versionNumber < 9200) {
            this.mare.unmarshalSB2();
            if (!this.statement.sqlKind.isPlsqlOrCall()) {
                this.mare.unmarshalSB2();
            }
        } else if (this.statement.sqlKind.isPlsqlOrCall() || this.isDMLReturnedParam) {
            this.mare.processIndicator(n2 <= 0, n2);
        }
    }

    @Override
    int getPreviousRowProcessed() {
        if (this.previousRowProcessed == -1) {
            this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
        }
        return this.previousRowProcessed;
    }

    @Override
    boolean unmarshalOneRow() throws SQLException, IOException {
        boolean bl = false;
        if (!this.isUseless()) {
            if (this.isUnexpected()) {
                long l2 = this.rowData.getPosition();
                this.unmarshalColumnMetadata();
                this.unmarshalBytes();
                this.rowData.setPosition(l2);
                this.setNull(this.lastRowProcessed, true);
            } else if (this.isNullByDescribe()) {
                this.setNull(this.lastRowProcessed, true);
                this.unmarshalColumnMetadata();
                if (this.statement.connection.versionNumber < 9200) {
                    this.processIndicator(0);
                }
            } else {
                this.unmarshalColumnMetadata();
                bl = this.unmarshalBytes();
            }
        }
        this.previousRowProcessed = this.lastRowProcessed++;
        return bl;
    }

    @Override
    void copyRow() throws SQLException, IOException {
        if (this.isNullByDescribe) {
            this.setNull(this.lastRowProcessed, true);
        } else if (this.lastRowProcessed == 0) {
            long l2 = this.getOffset(this.previousRowProcessed);
            long l3 = this.getPrefetchedDataOffset(this.previousRowProcessed);
            this.setNull(this.lastRowProcessed, this.isNull(this.previousRowProcessed));
            this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
            if (!this.isNull(this.previousRowProcessed)) {
                if (this.isPrefetched()) {
                    this.setPrefetchedLength(this.lastRowProcessed, this.getPrefetchedLength(this.previousRowProcessed));
                    this.setPrefetchedChunkSize(this.lastRowProcessed, this.getPrefetchedChunkSize(this.previousRowProcessed));
                    this.setPrefetchedDataLength(this.lastRowProcessed, this.getPrefetchedDataLength(this.previousRowProcessed));
                    this.setPrefetchedDataOffset(this.lastRowProcessed);
                    ((DynamicByteArray)this.rowData).copyLeft(l3, this.getPrefetchedDataLength(this.previousRowProcessed));
                }
                this.setOffset(this.lastRowProcessed);
                ((DynamicByteArray)this.rowData).copyLeft(l2, this.getLength(this.previousRowProcessed));
                this.setLength(this.lastRowProcessed, this.getLength(this.previousRowProcessed));
            }
        } else {
            int n2 = this.lastRowProcessed - 1;
            if (this.isPrefetched()) {
                this.setPrefetchedLength(this.lastRowProcessed, this.getPrefetchedLength(n2));
                this.setPrefetchedChunkSize(this.lastRowProcessed, this.getPrefetchedChunkSize(n2));
                this.setPrefetchedDataLength(this.lastRowProcessed, this.getPrefetchedDataLength(n2));
                this.setPrefetchedDataOffset(this.lastRowProcessed, this.getPrefetchedDataOffset(n2));
            }
            this.setNull(this.lastRowProcessed, this.isNull(n2));
            this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[n2];
            this.setOffset(this.lastRowProcessed, this.getOffset(n2));
            this.setLength(this.lastRowProcessed, this.getLength(n2));
        }
        this.previousRowProcessed = this.lastRowProcessed++;
    }

    boolean unmarshalBytes() throws IOException, SQLException {
        int n2 = (int)this.mare.unmarshalUB4();
        if (n2 == 0) {
            this.setNull(this.lastRowProcessed, true);
            this.processIndicator(0);
        } else {
            if (this.isPrefetched()) {
                this.unmarshalPrefetchData();
            }
            this.setOffset(this.lastRowProcessed);
            int n3 = ((DynamicByteArray)this.rowData).unmarshalCLR(this.mare);
            this.setNull(this.lastRowProcessed, n3 == 0);
            this.setLength(this.lastRowProcessed, n3);
            this.processIndicator(n3);
        }
        return false;
    }

    void unmarshalPrefetchData() throws SQLException, IOException {
        this.setPrefetchedLength(this.lastRowProcessed, this.mare.unmarshalSB8());
        this.setPrefetchedDataOffset(this.lastRowProcessed);
        this.setPrefetchedDataLength(this.lastRowProcessed, 0);
        if (this.getPrefetchLength() > 0) {
            this.mare.unmarshalUB1();
        }
    }

    @Override
    Object getObject(int n2) throws SQLException {
        if (this.definedColumnType == 0) {
            return super.getObject(n2);
        }
        if (this.isNull(n2)) {
            return null;
        }
        if (this.definedColumnType == -13) {
            return this.getBFILE(n2);
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
        sQLException.fillInStackTrace();
        throw sQLException;
    }
}

