/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.converter;

import ch.docuteam.converter.exceptions.BadPronomIdException;
import ch.docuteam.converter.exceptions.FileConversionException;
import ch.docuteam.tools.file.FileUtil;
import ch.docuteam.tools.file.FileWithMetadata;
import ch.docuteam.tools.file.MetadataProviderDROID;
import ch.docuteam.tools.file.ResourceUtil;
import ch.docuteam.tools.file.exception.DROIDCouldNotInitializeException;
import ch.docuteam.tools.file.exception.DROIDMultipleIdentificationsFoundException;
import ch.docuteam.tools.file.exception.DROIDNoIdentificationFoundException;
import ch.docuteam.tools.file.exception.FileIsNotADirectoryException;
import ch.docuteam.tools.file.exception.FileUtilExceptionListException;
import ch.docuteam.tools.id.UniqueID;
import ch.docuteam.tools.os.OperatingSystem;
import ch.docuteam.tools.os.SystemProcess;
import ch.docuteam.tools.out.Logger;
import ch.docuteam.tools.string.DateFormatter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public abstract class FileConverter {
    private static final String DefaultMigrationConfigFile = "config/migration-config.xml";
    private static final String DefaultMigrationHomeFolder = ".";
    private static String DefaultCommandlineSeparator = "#";
    private static String[] AlternativeCommandlineSeparators = new String[]{";", "&", "@", ",", ":"};
    private static String MigrationConfigFile = "config/migration-config.xml";
    private static String MigrationHomeFolder = ".";
    private static Document MigrationConfigFileDocument;
    private static String RecentlyUsedFileConverterName;

    public static File convertFile(File file) throws DocumentException, IllegalArgumentException, SecurityException, IOException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException, InterruptedException, IndexOutOfBoundsException, FileIsNotADirectoryException, BadPronomIdException, FileUtilExceptionListException, DROIDCouldNotInitializeException, DROIDNoIdentificationFoundException, DROIDMultipleIdentificationsFoundException, FileConversionException {
        return FileConverter.convertFile(file.getPath());
    }

    public static String getSyntax() {
        return String.format("[--%s=[path/to/]migrationConfig] --%s=[path/to/]sourceFile [--%s=[path/to/]DestinationFolder]", Parameter.MigrationConfig.getName(), Parameter.SourceFile.getName(), Parameter.DestinationFolder.getName());
    }

    public static void main(String[] args) {
        OptionSet options;
        OptionParser parser = new OptionParser();
        parser.accepts(Parameter.MigrationConfig.getName()).withRequiredArg();
        parser.accepts(Parameter.SourceFile.getName()).withRequiredArg().required();
        parser.accepts(Parameter.DestinationFolder.getName()).withRequiredArg();
        try {
            options = parser.parse(args);
        }
        catch (NullPointerException | OptionException e) {
            Logger.error((Object)"Wrong arguments !");
            Logger.error((Object)String.format("Usage: %s", FileConverter.getSyntax()));
            return;
        }
        if (options.has(Parameter.MigrationConfig.getName())) {
            String migrationConfig = options.valueOf(Parameter.MigrationConfig.getName()).toString();
            try {
                FileConverter.setMigrationConfigFile(migrationConfig);
            }
            catch (DocumentException e) {
                Logger.error((Object)("Exception on setMigrationConfigFile(" + migrationConfig + ")"), (Throwable)e);
                return;
            }
        }
        String sourceFilePath = options.valueOf(Parameter.SourceFile.getName()).toString();
        String destinationFolderPath = null;
        if (options.has(Parameter.DestinationFolder.getName())) {
            destinationFolderPath = options.valueOf(Parameter.DestinationFolder.getName()).toString();
        }
        try {
            if (destinationFolderPath != null) {
                FileConverter.convertFile(sourceFilePath, destinationFolderPath);
            } else {
                FileConverter.convertFile(sourceFilePath);
            }
        }
        catch (BadPronomIdException | FileConversionException | DROIDCouldNotInitializeException | DROIDMultipleIdentificationsFoundException | DROIDNoIdentificationFoundException | FileIsNotADirectoryException | FileUtilExceptionListException | IOException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | IndexOutOfBoundsException | InterruptedException | NoSuchMethodException | SecurityException | InvocationTargetException | DocumentException e) {
            Logger.error((Object)"Exception occurred during conversion !", (Throwable)e);
        }
    }

    public static File convertFile(File sourceFile, File destinationFolder) throws DocumentException, IllegalArgumentException, SecurityException, IOException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException, InterruptedException, IndexOutOfBoundsException, FileIsNotADirectoryException, BadPronomIdException, FileUtilExceptionListException, DROIDCouldNotInitializeException, DROIDNoIdentificationFoundException, DROIDMultipleIdentificationsFoundException, FileConversionException {
        return FileConverter.convertFile(sourceFile.getPath(), destinationFolder.getPath());
    }

    public static File convertFile(String fileName) throws DocumentException, IllegalArgumentException, SecurityException, IOException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException, InterruptedException, IndexOutOfBoundsException, FileIsNotADirectoryException, BadPronomIdException, FileUtilExceptionListException, DROIDCouldNotInitializeException, DROIDNoIdentificationFoundException, DROIDMultipleIdentificationsFoundException, FileConversionException {
        return FileConverter.convertFile(fileName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File convertFile(String filePath, String destinationFolderPath) throws DocumentException, IllegalArgumentException, SecurityException, IOException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException, InterruptedException, IndexOutOfBoundsException, FileIsNotADirectoryException, BadPronomIdException, FileUtilExceptionListException, DROIDCouldNotInitializeException, DROIDNoIdentificationFoundException, DROIDMultipleIdentificationsFoundException, FileConversionException {
        File convertedFile;
        block14: {
            String destinationFilePath;
            FileWithMetadata file;
            filePath = new File(filePath).getAbsolutePath();
            if (destinationFolderPath != null) {
                destinationFolderPath = new File(destinationFolderPath).getAbsolutePath();
            }
            if (!(file = new FileWithMetadata(filePath)).exists()) {
                Logger.error((Object)("File not found: '" + filePath + "'"));
                throw new FileNotFoundException(filePath);
            }
            Logger.info((Object)("Converting file: " + filePath));
            RecentlyUsedFileConverterName = "";
            List<?> migrationInstructions = FileConverter.getMigrationInstructions(file);
            if (migrationInstructions.isEmpty()) {
                Logger.info((Object)"... no conversion instruction found.");
                return null;
            }
            if (migrationInstructions.size() >= 2) {
                Logger.error((Object)("Can't handle multiple conversion instructions for file '" + file.getName() + "'"));
                throw new IndexOutOfBoundsException("Can't handle multiple conversion instructions for file '" + file.getName() + "'");
            }
            Element migrationInstruction = (Element)migrationInstructions.get(0);
            ArrayList<Element> migrationSteps = new ArrayList<Element>();
            List steps = migrationInstruction.selectNodes("step");
            if (steps.isEmpty()) {
                if (migrationInstruction.attribute("applicationID") == null) {
                    return null;
                }
            } else {
                for (Object step : steps) {
                    if (!(step instanceof Element) || ((Element)step).attribute("applicationID") == null) continue;
                    migrationSteps.add((Element)step);
                }
                if (migrationSteps.isEmpty()) {
                    return null;
                }
            }
            if (destinationFolderPath != null) {
                FileUtil.createFolderMerging((String)destinationFolderPath);
            }
            Logger.info((Object)("Treating file as " + migrationInstruction.attributeValue("name") + "..."));
            boolean usingTempFolder = false;
            String originalFilePath = null;
            String originalDestinationFolderPath = null;
            convertedFile = null;
            try {
                if (OperatingSystem.isWindows() && filePath.length() >= 255 || destinationFolderPath != null && destinationFolderPath.length() >= 255) {
                    usingTempFolder = true;
                    originalFilePath = filePath;
                    originalDestinationFolderPath = destinationFolderPath;
                    filePath = FileUtil.copySourceFileInTemp((File)new File(originalFilePath)).getAbsolutePath();
                    file = new FileWithMetadata(filePath);
                    destinationFolderPath = FileUtil.getTempFolder() + "/FileConverter";
                    Logger.debug((Object)("Too long paths, using temp file: " + filePath));
                }
                File file2 = convertedFile = migrationSteps.isEmpty() ? FileConverter.convertFile(file, destinationFolderPath, migrationInstruction) : FileConverter.convertFile(file, destinationFolderPath, migrationSteps);
                if (!usingTempFolder || convertedFile == null) break block14;
                destinationFilePath = originalDestinationFolderPath + "/" + FileUtil.asFileNameWithoutExtension((String)originalFilePath) + DefaultMigrationHomeFolder + FileUtil.asFileNameExtension((String)convertedFile.getName());
            }
            catch (Throwable throwable) {
                if (usingTempFolder && convertedFile != null) {
                    String destinationFilePath2 = originalDestinationFolderPath + "/" + FileUtil.asFileNameWithoutExtension((String)originalFilePath) + DefaultMigrationHomeFolder + FileUtil.asFileNameExtension((String)convertedFile.getName());
                    convertedFile = FileUtil.moveTo((String)convertedFile.getPath(), (String)destinationFilePath2);
                    new File(filePath).delete();
                }
                throw throwable;
            }
            convertedFile = FileUtil.moveTo((String)convertedFile.getPath(), (String)destinationFilePath);
            new File(filePath).delete();
        }
        return convertedFile;
    }

    public static String getRecentlyUsedFileConverterName() {
        return RecentlyUsedFileConverterName;
    }

    public static void setMigrationConfigFile(String newMigrationConfigFile) throws DocumentException {
        MigrationConfigFile = newMigrationConfigFile;
        FileConverter.initialize();
    }

    public static void setMigrationHomeFolder(String newMigrationHomeFolder) {
        MigrationHomeFolder = newMigrationHomeFolder;
    }

    private static File convertFile(FileWithMetadata file, String destinationFolderName, Element migrationInstruction) throws IOException, IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException, InterruptedException, FileIsNotADirectoryException, BadPronomIdException, DROIDCouldNotInitializeException, DROIDNoIdentificationFoundException, DROIDMultipleIdentificationsFoundException, FileConversionException {
        if (destinationFolderName == null) {
            destinationFolderName = file.getParentFile().getAbsolutePath();
        }
        String destinationPath = FileConverter.calculateDestinationFilePath((File)file, destinationFolderName, migrationInstruction.attributeValue("targetExtension"));
        Logger.info((Object)("Destination file: " + destinationPath));
        String conversionTargetPath = destinationFolderName + File.separator + UniqueID.getString();
        if (migrationInstruction.attributeValue("targetExtension").length() > 0) {
            conversionTargetPath = conversionTargetPath + DefaultMigrationHomeFolder + migrationInstruction.attributeValue("targetExtension");
        }
        Logger.info((Object)("Conversion target file: " + conversionTargetPath));
        String[] commandLine = FileConverter.constructCommandLine(migrationInstruction, new String[]{file.getAbsolutePath(), conversionTargetPath});
        FileConverter.executeCommandLine(commandLine);
        FileUtil.renameTo((String)conversionTargetPath, (String)destinationPath);
        String expectedPronomIds = migrationInstruction.attributeValue("targetPronom");
        if (expectedPronomIds != null && !expectedPronomIds.isEmpty()) {
            Path destination = Paths.get(destinationPath, new String[0]);
            final ArrayList files = new ArrayList();
            Files.walkFileTree(destination, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (attrs.isRegularFile()) {
                        files.add(file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            boolean isValid = true;
            List<String> expectedPronomIdsList = Arrays.asList(expectedPronomIds.split(","));
            String wrongPronomId = null;
            for (Path filePath : files) {
                String currentPronomId = MetadataProviderDROID.getFileFormatPUID((String)filePath.toString());
                if (expectedPronomIdsList.contains(currentPronomId)) continue;
                wrongPronomId = currentPronomId;
                isValid = false;
                break;
            }
            if (!isValid) {
                throw new BadPronomIdException(expectedPronomIds, wrongPronomId);
            }
        }
        return new File(destinationPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File convertFile(FileWithMetadata file, String destinationFolderName, List<?> migrationInstructions) throws IOException, IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException, InterruptedException, FileIsNotADirectoryException, BadPronomIdException, FileUtilExceptionListException, DROIDCouldNotInitializeException, DROIDNoIdentificationFoundException, DROIDMultipleIdentificationsFoundException, FileConversionException {
        ArrayList<String> tempFilePathsToDelete = new ArrayList<String>();
        String sourcePathString = file.getAbsolutePath();
        String destinationPathString = "";
        int stepNumber = migrationInstructions.size();
        try {
            int stepCounter = 1;
            for (Object i : migrationInstructions) {
                Element migrationInstruction = (Element)i;
                String[] expectedPronomIds = null;
                String expected = migrationInstruction.attributeValue("targetPronom");
                if (destinationFolderName == null) {
                    destinationFolderName = file.getParentFile().getAbsolutePath();
                }
                destinationPathString = FileConverter.calculateDestinationFilePath((File)file, destinationFolderName, migrationInstruction.attributeValue("targetExtension"));
                Logger.info((Object)("Step " + stepCounter + "/" + stepNumber + ": Destination file: " + destinationPathString));
                if (stepCounter != stepNumber) {
                    tempFilePathsToDelete.add(destinationPathString);
                }
                String conversionTargetPath = destinationFolderName + File.separator + UniqueID.getString() + DefaultMigrationHomeFolder + migrationInstruction.attributeValue("targetExtension");
                Logger.info((Object)("Conversion target file: " + conversionTargetPath));
                String[] commandLine = FileConverter.constructCommandLine(migrationInstruction, new String[]{sourcePathString, conversionTargetPath});
                FileConverter.executeCommandLine(commandLine);
                FileUtil.renameTo((String)conversionTargetPath, (String)destinationPathString);
                String currentPronomId = MetadataProviderDROID.getFileFormatPUID((String)destinationPathString);
                expectedPronomIds = null;
                if (expected != null && !expected.isEmpty()) {
                    expectedPronomIds = expected.split(",");
                    boolean found = false;
                    for (String expectedPronomId : expectedPronomIds) {
                        if (!currentPronomId.equalsIgnoreCase(expectedPronomId)) continue;
                        found = true;
                    }
                    if (!found) {
                        throw new BadPronomIdException(expectedPronomIds.toString(), currentPronomId);
                    }
                }
                sourcePathString = destinationPathString;
                ++stepCounter;
            }
        }
        finally {
            for (String path : tempFilePathsToDelete) {
                FileUtil.delete((String)path);
            }
        }
        return new File(destinationPathString);
    }

    private static void initializeIfNecessary() throws DocumentException {
        if (MigrationConfigFileDocument == null) {
            FileConverter.initialize();
        }
    }

    private static void initialize() throws DocumentException {
        Logger.info((Object)("Initializing File Migration, from " + MigrationConfigFile + "..."));
        File migrationConfigFile = new File(MigrationConfigFile);
        if (migrationConfigFile.exists()) {
            MigrationConfigFileDocument = new SAXReader().read(migrationConfigFile);
        } else {
            Logger.debug((Object)"read MigrationConfigFileDocument from the classpath as resource URL");
            MigrationConfigFileDocument = new SAXReader().read(ResourceUtil.getResourceURL((String)MigrationConfigFile));
        }
    }

    public static String calculateDestinationFilePath(File file, String destinationFolderName, String newExtension) {
        String destinationFilePath = destinationFolderName + "/" + FileUtil.asFileNameWithoutExtension((String)file.getName());
        String suffix = "";
        if (newExtension.length() > 0) {
            suffix = DefaultMigrationHomeFolder + newExtension;
        }
        if (new File(destinationFilePath + suffix).exists()) {
            destinationFilePath = destinationFilePath + "_" + DateFormatter.getCurrentDateTimeString((String)"yyyyMMddHHmmssSSS");
        }
        destinationFilePath = destinationFilePath + suffix;
        return destinationFilePath;
    }

    public static List<?> getMigrationInstructions(FileWithMetadata file) throws DocumentException {
        FileConverter.initializeIfNecessary();
        Logger.info((Object)("Looking for PUID " + file.getFormatPronomID() + "..."));
        List instructions = MigrationConfigFileDocument.selectNodes("//puid[@name='" + file.getFormatPronomID() + "']");
        if (!instructions.isEmpty()) {
            return instructions;
        }
        Logger.info((Object)("Looking for mimetype " + file.getMimeType() + "..."));
        instructions = MigrationConfigFileDocument.selectNodes("//mimeType[@name='" + file.getMimeType() + "']");
        if (!instructions.isEmpty()) {
            return instructions;
        }
        String fileNameExtension = file.getName().substring(file.getName().lastIndexOf(DefaultMigrationHomeFolder) + 1);
        Logger.info((Object)("Looking for extension " + fileNameExtension + "..."));
        return MigrationConfigFileDocument.selectNodes("//extension[@name='" + fileNameExtension + "']");
    }

    private static String[] constructCommandLine(Element migrationInstruction, String[] args) {
        String argPlaceholderString;
        Element applicationElement = (Element)MigrationConfigFileDocument.selectSingleNode("//application[@id='" + migrationInstruction.attributeValue("applicationID") + "']");
        String commandLine = applicationElement.attributeValue("executable");
        RecentlyUsedFileConverterName = applicationElement.attributeValue("name");
        String applicationParameter = applicationElement.attributeValue("parameter");
        String instructionParameter = migrationInstruction.attributeValue("parameter");
        if (instructionParameter != null && !instructionParameter.trim().isEmpty()) {
            commandLine = commandLine + DefaultCommandlineSeparator + instructionParameter;
        } else if (applicationParameter != null && !applicationParameter.trim().isEmpty()) {
            commandLine = commandLine + DefaultCommandlineSeparator + applicationParameter;
        }
        String separator = FileConverter.determineApplicableSeparator(commandLine, args[0]);
        if (!separator.equals(DefaultCommandlineSeparator)) {
            commandLine = commandLine.replace(DefaultCommandlineSeparator, separator);
        }
        int argIndex = 0;
        while (commandLine.indexOf(argPlaceholderString = "{[arg" + (argIndex + 1) + "]}") != -1) {
            commandLine = commandLine.replace(argPlaceholderString, args[argIndex]);
            ++argIndex;
        }
        return commandLine.trim().split(separator);
    }

    private static String determineApplicableSeparator(String parameters, String filepath) {
        if (!filepath.contains(DefaultCommandlineSeparator)) {
            return DefaultCommandlineSeparator;
        }
        for (String separator : AlternativeCommandlineSeparators) {
            if (filepath.contains(separator) || parameters.contains(separator)) continue;
            return separator;
        }
        return DefaultCommandlineSeparator;
    }

    private static void executeCommandLine(String[] commandLine) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException, FileNotFoundException, IOException, InterruptedException, FileIsNotADirectoryException, FileConversionException {
        if (commandLine[0].startsWith("Class:")) {
            String className = commandLine[0].substring(6);
            Logger.debug((Object)("Calling java class: " + className));
            commandLine = Arrays.copyOfRange(commandLine, 1, commandLine.length);
            Logger.debug((Object)("Using the following parameters: " + Arrays.toString(commandLine)));
            Object result = Class.forName(className).getMethod("main", commandLine.getClass()).invoke(null, new Object[]{commandLine});
            Logger.info((Object)("Conversion-process finished" + (result != null ? ": " + result : "")));
        } else {
            Logger.info((Object)("Executing command line: " + Arrays.toString(commandLine)));
            int errorCode = SystemProcess.execute((String)MigrationHomeFolder, (String[])commandLine);
            Logger.info((Object)("Conversion-process finished: " + errorCode));
            if (errorCode != 0) {
                throw new FileConversionException(errorCode);
            }
        }
    }

    static {
        RecentlyUsedFileConverterName = "";
    }

    private static class Copy {
        private Copy() {
        }

        public static void main(String ... args) throws IOException, FileUtilExceptionListException {
            if (args.length != 2) {
                Logger.error((Object)"Wrong number of arguments.");
                Logger.error((Object)"Usage: FileConverter.Copy [path/to/]sourceFile [path/to/]destinationFile");
                return;
            }
            FileUtil.copyToOverwriting((String)args[0], (String)args[1]);
        }
    }

    private static enum Parameter {
        MigrationConfig("migrationConfig"),
        SourceFile("sourceFile"),
        DestinationFolder("destinationFolder");

        private final String name;

        private Parameter(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

