/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.bar;

import ch.docuteam.darc.common.DocumentAbstract;
import ch.docuteam.darc.exceptions.DocumentIsReadOnlyException;
import ch.docuteam.darc.exceptions.FileAlreadyExistsException;
import ch.docuteam.darc.exceptions.FileOperationNotAllowedException;
import ch.docuteam.darc.exceptions.FolderNameIsEmptyException;
import ch.docuteam.darc.exceptions.LevelMetadataElementIsReadOnly;
import ch.docuteam.darc.exceptions.MetadataElementAllowedValuesException;
import ch.docuteam.darc.exceptions.MetadataElementIsNotAllowedException;
import ch.docuteam.darc.exceptions.MetadataElementIsNotDefinedException;
import ch.docuteam.darc.exceptions.MetadataElementSetterPostActionException;
import ch.docuteam.darc.exceptions.MetadataElementValidatorException;
import ch.docuteam.darc.mdconfig.LevelOfDescription;
import ch.docuteam.darc.mdconfig.MetadataElement;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.darc.mets.structmap.NodeFile;
import ch.docuteam.darc.mets.structmap.NodeFolder;
import ch.docuteam.darc.util.XMLUtil;
import ch.docuteam.tools.exception.ExceptionCollector;
import ch.docuteam.tools.file.FileFilter;
import ch.docuteam.tools.file.FileUtil;
import ch.docuteam.tools.file.ResourceUtil;
import ch.docuteam.tools.file.Zipper;
import ch.docuteam.tools.file.exception.FileUtilExceptionListException;
import ch.docuteam.tools.id.UniqueID;
import ch.docuteam.tools.os.OperatingSystem;
import ch.docuteam.tools.out.Logger;
import ch.docuteam.tools.out.Tracer;
import ch.docuteam.tools.string.DateFormatter;
import ch.docuteam.tools.string.StringUtil;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.TreeMap;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.Visitor;
import org.dom4j.VisitorSupport;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;

public class Document
extends DocumentAbstract {
    private static final long serialVersionUID = 1L;
    private static final String TEMPLATES_BARSIP_PATH = "/templates/BARSIP";
    private static final String BARNamespacePrefix = "BAR";
    private static final String BARNamespaceURI = "http://bar.admin.ch/arelda/v4";
    private static final String RelativePathToMetadata_xml = "/header/metadata.xml";
    private static final String RelativePathToContent = "/content";
    private static final String BARFileNamePrefix = "SIP_" + DateFormatter.getCurrentDateTimeString((String)"yyyyMMdd") + "_";

    public static void main(String[] args) throws IOException, FileUtilExceptionListException {
        String workspace = OperatingSystem.userHome() + "Desktop/Workspace/";
        String sipPath = workspace + "SIPs";
        String barSipPath = workspace + "BAR-SIPs";
        LevelOfDescription.setInitializationFilePath("/config/levels_BAR.xml");
        try {
            String sipName = "SIP_20130307_Test1_Lem_LotsOfMetadata";
            String createdPath = Document.createFromSIPIntoFolder(sipPath + "/" + "SIP_20130307_Test1_Lem_LotsOfMetadata", barSipPath, "BARDocument.createFromSIPIntoFolder", new ObserverTracer());
            Tracer.trace((Object)("Created: " + createdPath));
        }
        catch (Throwable x) {
            Logger.error((Object)x.getMessage(), (Throwable)x);
        }
        if (!ExceptionCollector.isEmpty().booleanValue()) {
            Tracer.trace((Object)ExceptionCollector.toStringAll());
        }
    }

    public static String createFromSIPIntoFolder(String documentPath, String barSIPDestinationFolderPath) throws Exception {
        return Document.createFromSIPIntoFolder(documentPath, barSIPDestinationFolderPath, "");
    }

    public static String createFromSIPIntoFolder(String documentPath, String barSIPDestinationFolderPath, String operatorName) throws Exception {
        return Document.createFromSIPIntoFolder(documentPath, barSIPDestinationFolderPath, operatorName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createFromSIPIntoFolder(String documentPath, String barSIPDestinationFolderPath, String operatorName, Observer observer) throws Exception {
        String barSIPPath = barSIPDestinationFolderPath + "/" + BARFileNamePrefix + FileUtil.asFileNameWithoutExtension((String)documentPath);
        if (new File(barSIPPath).exists()) {
            throw new FileAlreadyExistsException(BARFileNamePrefix + FileUtil.asFileNameWithoutExtension((String)documentPath), barSIPDestinationFolderPath);
        }
        Logger.info((Object)("Creating BAR-SIP: '" + barSIPPath + "'..."));
        FileUtil.copyToOverwriting((String)ResourceUtil.getResourceCanonicalPath((String)TEMPLATES_BARSIP_PATH), (String)barSIPPath);
        SAXReader reader = new SAXReader();
        reader.setDocumentFactory((DocumentFactory)new BARSIPFactory());
        Document barSIPDocument = (Document)reader.read(new File(barSIPPath + RelativePathToMetadata_xml));
        barSIPDocument.addObserver(observer);
        ch.docuteam.darc.mets.Document doc = ch.docuteam.darc.mets.Document.openReadOnly(documentPath, operatorName);
        try {
            Node insertPointAblieferungNode = barSIPDocument.selectSingleNode("/BAR:paket");
            Node insertPointInhaltsverzeichnisNode = barSIPDocument.selectSingleNode("/BAR:paket/BAR:inhaltsverzeichnis/BAR:ordner/BAR:name[text()='content']/..");
            File insertPointFolder = new File(barSIPPath + RelativePathToContent);
            barSIPDocument.insertRecursively(doc.getStructureMap().getRoot(), (Element)insertPointAblieferungNode, (Element)insertPointInhaltsverzeichnisNode, insertPointFolder);
            barSIPDocument.changeNamespace(Namespace.get((String)BARNamespacePrefix, (String)BARNamespaceURI), Namespace.get((String)BARNamespaceURI));
            OutputStreamWriter oswriter = new OutputStreamWriter((OutputStream)new FileOutputStream(barSIPPath + RelativePathToMetadata_xml), "utf-8");
            XMLWriter writer = new XMLWriter((Writer)oswriter, new OutputFormat("  ", false, "utf-8"));
            writer.write((org.dom4j.Document)barSIPDocument);
            writer.close();
        }
        finally {
            if (doc != null) {
                doc.cleanupWorkingCopy();
            }
        }
        Logger.info((Object)("Creating BAR-SIP: '" + barSIPPath + "'... done!"));
        return barSIPPath;
    }

    public static String convertToSIPIntoFolder(String barSIPPath, String destinationFolderPath) throws FileAlreadyExistsException, IOException, FileOperationNotAllowedException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, MetadataElementValidatorException, DocumentException, FileUtilExceptionListException, DocumentIsReadOnlyException, Exception {
        return Document.convertToSIPIntoFolder(barSIPPath, destinationFolderPath, "");
    }

    public static String convertToSIPIntoFolder(String barSIPPath, String destinationFolderPath, String operatorName) throws FileAlreadyExistsException, IOException, FileOperationNotAllowedException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, MetadataElementValidatorException, DocumentException, FileUtilExceptionListException, DocumentIsReadOnlyException, Exception {
        return Document.convertToSIPIntoFolder(barSIPPath, destinationFolderPath, operatorName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertToSIPIntoFolder(String barSIPPath, String destinationFolderPath, String operatorName, Observer observer) throws FileAlreadyExistsException, IOException, FileOperationNotAllowedException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, MetadataElementValidatorException, DocumentException, FileUtilExceptionListException, DocumentIsReadOnlyException, Exception {
        String newZIPOrFolderFilePath = destinationFolderPath + "/" + FileUtil.asFileNameWithoutExtension((String)barSIPPath);
        if (new File(newZIPOrFolderFilePath).exists()) {
            throw new FileAlreadyExistsException(FileUtil.asFileNameWithoutExtension((String)barSIPPath), destinationFolderPath);
        }
        Logger.info((Object)("Converting BAR-SIP to SIP: '" + newZIPOrFolderFilePath + "'..."));
        ch.docuteam.darc.mets.Document document = null;
        Document barSIP = null;
        boolean isZIP = false;
        try {
            if (barSIPPath.toLowerCase().endsWith(".zip")) {
                isZIP = true;
                String barSIPName = new File(barSIPPath).getName();
                barSIPName = barSIPName.substring(0, barSIPName.length() - 4);
                String workingFolder = FileUtil.getTempFolder() + "/" + DateFormatter.getCurrentDateTimeString((String)"yyyyMMddHHmmssSSS");
                Zipper.unzip((String)barSIPPath, (String)workingFolder);
                new File(workingFolder).deleteOnExit();
                barSIPPath = workingFolder;
                List<File> zipContents = null;
                int counter = 0;
                while (!(zipContents = Arrays.asList(new File(barSIPPath).listFiles((java.io.FileFilter)FileFilter.VisibleDirectories))).contains(new File(barSIPPath + RelativePathToContent)) || !zipContents.contains(new File(barSIPPath + "/header"))) {
                    File intermediateFolder = zipContents.get(0);
                    barSIPPath = barSIPPath + "/" + intermediateFolder.getName();
                    if (++counter <= 2) continue;
                }
            }
            SAXReader reader = new SAXReader();
            reader.setDocumentFactory((DocumentFactory)new BARSIPFactory());
            barSIP = (Document)reader.read(new File(barSIPPath + RelativePathToMetadata_xml));
            barSIP.filePath = barSIPPath;
            document = ch.docuteam.darc.mets.Document.createNewWithRootFolderName(newZIPOrFolderFilePath, "Paket", "sa_all-formats-01", "dss-01", operatorName, observer);
            barSIP.insertPaketInto((NodeFolder)document.getStructureMap().getRoot());
            document.saveWithoutBackup();
        }
        finally {
            if (isZIP) {
                FileUtil.deleteOnExit((File)new File(barSIPPath));
            }
            if (document != null) {
                document.unlockIfNecessary();
                document.cleanupWorkingCopy();
            }
        }
        Logger.info((Object)("Converting BAR-SIP to SIP: '" + newZIPOrFolderFilePath + "'... done!"));
        return newZIPOrFolderFilePath;
    }

    @Override
    public DocumentAbstract.Type getDocumentType() {
        return DocumentAbstract.Type.BAR;
    }

    private void insertRecursively(NodeAbstract node, Element insertPointAblieferungElement, Element insertPointInhaltsverzeichnisElement, File insertPointFolder) throws IOException, FileUtilExceptionListException {
        String level = node.getLevel().getName().toLowerCase();
        Logger.debug((Object)("Inserting node: '" + node.getLabel() + "' with level: '" + level + "'"));
        Element newAblieferungElement = null;
        if (level.equals("paket")) {
            newAblieferungElement = this.fillPaket(insertPointAblieferungElement, node);
        } else if (level.equals("ablieferung")) {
            newAblieferungElement = this.createAblieferung(insertPointAblieferungElement, node);
        } else if (level.equals("ordnungssystem")) {
            newAblieferungElement = this.createOrdnungssystem(insertPointAblieferungElement, node);
        } else if (level.equals("ordnungssystemposition")) {
            newAblieferungElement = this.createOrdnungssystemposition(insertPointAblieferungElement, node);
        } else if (level.equals("dossier")) {
            newAblieferungElement = this.createDossier(insertPointAblieferungElement, node);
        } else if (level.equals("dokument")) {
            newAblieferungElement = this.createDokument(insertPointAblieferungElement, node);
        } else if (level.equals("datei")) {
            newAblieferungElement = insertPointAblieferungElement;
        } else {
            if (level.equals("undefiniert")) {
                return;
            }
            return;
        }
        if (newAblieferungElement == null) {
            return;
        }
        this.createInhaltsverzeichnisElementAndFileOrFolder_ThenDiveIn(node, newAblieferungElement, insertPointInhaltsverzeichnisElement, insertPointFolder);
        this.cleanupIfNecessary(node, level, newAblieferungElement);
    }

    private void createInhaltsverzeichnisElementAndFileOrFolder_ThenDiveIn(NodeAbstract node, Element newAblieferungElement, Element insertPointInhaltsverzeichnisElement, File insertPointFolder) throws IOException, FileUtilExceptionListException {
        if (node.isFile()) {
            NodeFile fileNode = (NodeFile)node;
            String id = DateiId.getNext();
            this.createInhaltsverzeichnisElement(insertPointInhaltsverzeichnisElement, fileNode, id);
            newAblieferungElement.addElement("BAR:dateiRef").addText(id);
            try {
                FileUtil.copyToFolderOverwriting((File)node.getFile(), (File)insertPointFolder, (boolean)false);
            }
            catch (IOException ex) {
                Logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
            catch (FileUtilExceptionListException ex) {
                Logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            NodeFolder folderNode = (NodeFolder)node;
            Element newInhaltsverzeichnisElement = this.createInhaltsverzeichnisElement(insertPointInhaltsverzeichnisElement, folderNode);
            File newFolder = FileUtil.createFolderOverwriting((String)node.getFile().getName(), (File)insertPointFolder);
            for (MutableTreeTableNode child : folderNode.getChildren()) {
                this.insertRecursively((NodeAbstract)child, newAblieferungElement, newInhaltsverzeichnisElement, newFolder);
            }
        }
    }

    private Element fillPaket(Element paketElement, NodeAbstract node) {
        Logger.debug((Object)("Filling paket for: '" + node.getLabel() + "'"));
        this.distributeMessage("Filling paket for: '" + node.getLabel() + "'");
        this.addZusatzDatenElementFromDynamicMetadata(paketElement, node, "usage");
        this.addZusatzDatenElementFromUnconfiguredMetadata(paketElement, node);
        return paketElement;
    }

    private Element createAblieferung(Element insertPointAblieferungElement, NodeAbstract node) {
        Logger.debug((Object)("Creating ablieferung for: '" + node.getLabel() + "'"));
        this.distributeMessage("Creating ablieferung for: '" + node.getLabel() + "'");
        Element ablieferungElement = insertPointAblieferungElement.addElement("BAR:ablieferung");
        this.setAttribute(ablieferungElement, "xsi:type", "ablieferungFilesSIP");
        this.addElementAndSetTextFromDynamicMetadata(ablieferungElement, "BAR:ablieferungstyp", node, "objectType");
        this.addElementAndSetTextFromDynamicMetadata(ablieferungElement, "BAR:ablieferndeStelle", node, "accessNr");
        this.addElementAndSetTextFromDynamicMetadata(ablieferungElement, "BAR:entstehungszeitraum/BAR:von/BAR:datum", node, "fromYear");
        this.addElementAndSetTextFromDynamicMetadata(ablieferungElement, "BAR:entstehungszeitraum/BAR:bis/BAR:datum", node, "toYear");
        this.addElementAndSetTextFromDynamicMetadata(ablieferungElement, "BAR:ablieferungsteile", node, "material");
        this.addElementAndSetTextFromDynamicMetadata(ablieferungElement, "BAR:bemerkung", node, "comment");
        this.addZusatzDatenElementFromUnconfiguredMetadata(ablieferungElement, node);
        this.addElementAndSetTextFromDynamicMetadata(ablieferungElement, "BAR:ablieferungsnummer", node, "refCode");
        this.addElementAndSetTextFromDynamicMetadata(ablieferungElement, "BAR:angebotsnummer", node, "refCodeAdmin");
        this.addElementAndSetTextFromDynamicMetadata(ablieferungElement, "BAR:referenzBewertungsentscheid", node, "appraisalAndDestruction");
        this.addElementAndSetTextFromDynamicMetadata(ablieferungElement, "BAR:referenzSchutzfristenFormular", node, "accessRestriction");
        this.addElementAndSetTextFromDynamicMetadata(ablieferungElement, "BAR:schutzfristenkategorie", node, "accessPolicy");
        this.addElementAndSetTextFromDynamicMetadata(ablieferungElement, "BAR:schutzfrist", node, "accessRestrictionPeriod");
        this.addElementAndSetTextFromDynamicMetadata(ablieferungElement, "BAR:provenienz/BAR:aktenbildnerName", node, "origination");
        return ablieferungElement;
    }

    private Element createOrdnungssystem(Element insertPointAblieferungElement, NodeAbstract node) {
        Logger.debug((Object)("Creating ordnungssystem for: '" + node.getLabel() + "'"));
        this.distributeMessage("Creating ordnungssystem for: '" + node.getLabel() + "'");
        Element ordnungssystemElement = insertPointAblieferungElement.addElement("BAR:ordnungssystem");
        this.addElementAndSetTextFromDynamicMetadata(ordnungssystemElement, "BAR:generation", node, "refCode");
        this.addElementAndSetTextFromDynamicMetadata(ordnungssystemElement, "BAR:anwendungszeitraum/BAR:von/BAR:datum", node, "fromYear");
        this.addElementAndSetTextFromDynamicMetadata(ordnungssystemElement, "BAR:anwendungszeitraum/BAR:bis/BAR:datum", node, "toYear");
        this.addElementAndSetTextFromDynamicMetadata(ordnungssystemElement, "BAR:mitbenutzung", node, "involved");
        this.addElementAndSetTextFromDynamicMetadata(ordnungssystemElement, "BAR:bemerkung", node, "comment");
        this.addZusatzDatenElementFromUnconfiguredMetadata(ordnungssystemElement, node);
        this.addElementAndSetText(ordnungssystemElement, "BAR:name", node.getUnitTitle());
        return ordnungssystemElement;
    }

    private Element createOrdnungssystemposition(Element insertPointAblieferungElement, NodeAbstract node) {
        Logger.debug((Object)("Creating ordnungssystemposition for: '" + node.getLabel() + "'"));
        this.distributeMessage("Creating ordnungssystemposition for: '" + node.getLabel() + "'");
        Element newOrdnungssystempositionElement = insertPointAblieferungElement.addElement("BAR:ordnungssystemposition");
        this.addElementAndSetTextFromDynamicMetadata(newOrdnungssystempositionElement, "BAR:federfuehrendeOrganisationseinheit", node, "origination");
        this.addElementAndSetTextFromDynamicMetadata(newOrdnungssystempositionElement, "BAR:klassifizierungskategorie", node, "accessRestrictionClassification");
        this.addElementAndSetTextFromDynamicMetadata(newOrdnungssystempositionElement, "BAR:datenschutz", node, "accessRestrictionPrivacy");
        this.addElementAndSetTextFromDynamicMetadata(newOrdnungssystempositionElement, "BAR:oeffentlichkeitsstatus", node, "accessRestrictionStatus");
        this.addElementAndSetTextFromDynamicMetadata(newOrdnungssystempositionElement, "BAR:oeffentlichkeitsstatusBegruendung", node, "accessRestrictionStatusExplanation");
        this.addElementAndSetTextFromDynamicMetadata(newOrdnungssystempositionElement, "BAR:sonstigeBestimmungen", node, "accessRestriction");
        this.addZusatzDatenElementFromUnconfiguredMetadata(newOrdnungssystempositionElement, node);
        this.addElementAndSetTextFromDynamicMetadata(newOrdnungssystempositionElement, "BAR:nummer", node, "refCode");
        this.addElementAndSetText(newOrdnungssystempositionElement, "BAR:titel", node.getUnitTitle());
        this.setAttributeFromDynamicMetadata(newOrdnungssystempositionElement, "id", node, "refCodeAdmin");
        this.addElementAndSetTextFromDynamicMetadata(newOrdnungssystempositionElement, "BAR:schutzfristenkategorie", node, "accessPolicy");
        this.addElementAndSetTextFromDynamicMetadata(newOrdnungssystempositionElement, "BAR:schutzfrist", node, "accessRestrictionPeriod");
        this.addElementAndSetTextFromDynamicMetadata(newOrdnungssystempositionElement, "BAR:schutzfristenBegruendung", node, "accessRestrictionExplanation");
        return newOrdnungssystempositionElement;
    }

    private Element createDossier(Element insertPointAblieferungElement, NodeAbstract node) {
        Logger.debug((Object)("Creating dossier for: '" + node.getLabel() + "'"));
        this.distributeMessage("Creating dossier for: '" + node.getLabel() + "'");
        Element newDossierElement = insertPointAblieferungElement.addElement("BAR:dossier");
        this.addElementAndSetTextFromDynamicMetadata(newDossierElement, "BAR:zusatzmerkmal", node, "archivalHistory");
        this.addElementAndSetText(newDossierElement, "BAR:titel", node.getUnitTitle());
        this.addElementAndSetTextFromDynamicMetadata(newDossierElement, "BAR:inhalt", node, "abstract");
        this.addElementAndSetTextFromDynamicMetadata(newDossierElement, "BAR:formInhalt", node, "scopeContent");
        this.addElementAndSetTextFromDynamicMetadata(newDossierElement, "BAR:erscheinungsform", node, "characteristics");
        this.addElementAndSetTextFromDynamicMetadata(newDossierElement, "BAR:federfuehrendeOrganisationseinheit", node, "origination");
        this.addElementAndSetTextFromDynamicMetadata(newDossierElement, "BAR:entstehungszeitraum/BAR:von/BAR:datum", node, "fromYear");
        this.addElementAndSetTextFromDynamicMetadata(newDossierElement, "BAR:entstehungszeitraum/BAR:bis/BAR:datum", node, "toYear");
        this.addElementAndSetTextFromDynamicMetadata(newDossierElement, "BAR:entstehungszeitraumAnmerkung", node, "creationPeriodNotes");
        this.addElementAndSetTextFromDynamicMetadata(newDossierElement, "BAR:klassifizierungskategorie", node, "accessRestrictionClassification");
        this.addElementAndSetTextFromDynamicMetadata(newDossierElement, "BAR:datenschutz", node, "accessRestrictionPrivacy");
        this.addElementAndSetTextFromDynamicMetadata(newDossierElement, "BAR:oeffentlichkeitsstatus", node, "accessRestrictionStatus");
        this.addElementAndSetTextFromDynamicMetadata(newDossierElement, "BAR:oeffentlichkeitsstatusBegruendung", node, "accessRestrictionStatusExplanation");
        this.addElementAndSetTextFromDynamicMetadata(newDossierElement, "BAR:sonstigeBestimmungen", node, "accessRestriction");
        this.addElementAndSetTextFromDynamicMetadata(newDossierElement, "BAR:bemerkung", node, "comment");
        this.addZusatzDatenElementFromUnconfiguredMetadata(newDossierElement, node);
        this.setAttributeFromDynamicMetadata(newDossierElement, "id", node, "refCodeAdmin");
        this.addElementAndSetTextFromDynamicMetadata(newDossierElement, "BAR:aktenzeichen", node, "refCode");
        this.addElementAndSetTextFromDynamicMetadata(newDossierElement, "BAR:schutzfristenkategorie", node, "accessPolicy");
        this.addElementAndSetTextFromDynamicMetadata(newDossierElement, "BAR:schutzfrist", node, "accessRestrictionPeriod");
        this.addElementAndSetTextFromDynamicMetadata(newDossierElement, "BAR:schutzfristenBegruendung", node, "accessRestrictionExplanation");
        this.addElementAndSetTextFromDynamicMetadata(newDossierElement, "BAR:umfang", node, "material");
        return newDossierElement;
    }

    private Element createDokument(Element insertPointAblieferungElement, NodeAbstract node) {
        Logger.debug((Object)("Creating dokument for: '" + node.getLabel() + "'"));
        this.distributeMessage("Creating dokument for: '" + node.getLabel() + "'");
        Element newDokumentElement = insertPointAblieferungElement.addElement("BAR:dokument");
        this.addElementAndSetText(newDokumentElement, "BAR:titel", node.getLabel());
        this.addElementAndSetTextFromDynamicMetadata(newDokumentElement, "BAR:autor", node, "origination");
        this.addElementAndSetTextFromDynamicMetadata(newDokumentElement, "BAR:erscheinungsform", node, "characteristics");
        this.addElementAndSetTextFromDynamicMetadata(newDokumentElement, "BAR:dokumenttyp", node, "scopeContent");
        this.addElementAndSetTextFromDynamicMetadata(newDokumentElement, "BAR:registrierdatum/BAR:datum", node, "creationPeriod");
        this.addElementAndSetTextFromDynamicMetadata(newDokumentElement, "BAR:entstehungszeitraum/BAR:von/BAR:datum", node, "fromYear");
        this.addElementAndSetTextFromDynamicMetadata(newDokumentElement, "BAR:entstehungszeitraum/BAR:bis/BAR:datum", node, "toYear");
        this.addElementAndSetTextFromDynamicMetadata(newDokumentElement, "BAR:klassifizierungskategorie", node, "accessRestrictionClassification");
        this.addElementAndSetTextFromDynamicMetadata(newDokumentElement, "BAR:datenschutz", node, "accessRestrictionPrivacy");
        this.addElementAndSetTextFromDynamicMetadata(newDokumentElement, "BAR:oeffentlichkeitsstatus", node, "accessRestrictionStatus");
        this.addElementAndSetTextFromDynamicMetadata(newDokumentElement, "BAR:oeffentlichkeitsstatusBegruendung", node, "accessRestrictionStatusExplanation");
        this.addElementAndSetTextFromDynamicMetadata(newDokumentElement, "BAR:sonstigeBestimmungen", node, "accessRestriction");
        this.addElementAndSetTextFromDynamicMetadata(newDokumentElement, "BAR:bemerkung", node, "comment");
        this.addZusatzDatenElementFromUnconfiguredMetadata(newDokumentElement, node);
        this.setAttributeFromDynamicMetadata(newDokumentElement, "id", node, "refCodeAdmin");
        return newDokumentElement;
    }

    private Element createInhaltsverzeichnisElement(Element insertPointInhaltsverzeichnisElement, NodeFile fileNode, String id) {
        Logger.debug((Object)("Creating inhaltsverzeichnis element for: '" + fileNode.getLabel() + "'"));
        this.distributeMessage("Creating inhaltsverzeichnis element for: '" + fileNode.getLabel() + "'");
        String fileName = fileNode.getFile().getName();
        Element newInhaltsverzeichnisElement = insertPointInhaltsverzeichnisElement.addElement("BAR:datei");
        this.setAttribute(newInhaltsverzeichnisElement, "id", id);
        this.addElementAndSetText(newInhaltsverzeichnisElement, "BAR:name", fileName);
        this.addElementAndSetText(newInhaltsverzeichnisElement, "BAR:originalName", fileName);
        this.addElementAndSetText(newInhaltsverzeichnisElement, "BAR:pruefalgorithmus", fileNode.getChecksumType());
        this.addElementAndSetText(newInhaltsverzeichnisElement, "BAR:pruefsumme", fileNode.getChecksum());
        return newInhaltsverzeichnisElement;
    }

    private Element createInhaltsverzeichnisElement(Element insertPointInhaltsverzeichnisElement, NodeFolder folderNode) {
        Logger.debug((Object)("Creating inhaltsverzeichnis element for: '" + folderNode.getLabel() + "'"));
        this.distributeMessage("Creating inhaltsverzeichnis element for: '" + folderNode.getLabel() + "'");
        String fileName = folderNode.getFile().getName();
        Element newInhaltsverzeichnisElement = insertPointInhaltsverzeichnisElement.addElement("BAR:ordner");
        this.addElementAndSetText(newInhaltsverzeichnisElement, "BAR:name", fileName);
        this.addElementAndSetText(newInhaltsverzeichnisElement, "BAR:originalName", fileName);
        return newInhaltsverzeichnisElement;
    }

    private void cleanupIfNecessary(NodeAbstract node, String level, Element newAblieferungElement) {
        if (level.equals("paket")) {
            Node zusatzDatenElement = newAblieferungElement.selectSingleNode("BAR:zusatzDaten");
            if (zusatzDatenElement != null) {
                for (int i = 0; i < newAblieferungElement.content().size(); ++i) {
                    if (!"paketTyp".equals(((Node)newAblieferungElement.content().get(i)).getName())) continue;
                    zusatzDatenElement.detach();
                    newAblieferungElement.content().add(i + 1, zusatzDatenElement);
                    break;
                }
            }
        } else if (!(level.equals("ablieferung") || level.equals("ordnungssystem") || level.equals("ordnungssystemposition"))) {
            if (level.equals("dossier")) {
                Node umfangNode = newAblieferungElement.selectSingleNode("BAR:umfang");
                if (umfangNode != null) {
                    umfangNode.detach();
                    newAblieferungElement.content().add(newAblieferungElement.content().size(), umfangNode);
                }
            } else if (level.equals("dokument") || level.equals("datei") || level.equals("undefiniert")) {
                // empty if block
            }
        }
    }

    private void changeNamespace(Namespace oldNS, Namespace newNS) throws Exception {
        Logger.debug((Object)"Make 'BAR' the default namespace...");
        this.distributeMessage("Make 'BAR' the default namespace...");
        class NamespaceChangingVisitor
        extends VisitorSupport {
            private final Namespace from;
            private final Namespace to;

            public NamespaceChangingVisitor(Namespace from, Namespace to) {
                this.from = from;
                this.to = to;
            }

            public void visit(Element node) {
                Namespace ns = node.getNamespace();
                if (ns.getURI().equals(this.from.getURI())) {
                    QName newQName = new QName(node.getName(), this.to);
                    node.setQName(newQName);
                }
                ListIterator namespaces = node.additionalNamespaces().listIterator();
                while (namespaces.hasNext()) {
                    if (!((Namespace)namespaces.next()).getURI().equals(this.from.getURI())) continue;
                    namespaces.remove();
                }
            }
        }
        this.accept((Visitor)new NamespaceChangingVisitor(oldNS, newNS));
    }

    private void insertPaketInto(NodeFolder rootFolder) throws FileAlreadyExistsException, IOException, FileOperationNotAllowedException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, MetadataElementValidatorException, FolderNameIsEmptyException, FileUtilExceptionListException, MetadataElementIsNotAllowedException, MetadataElementIsNotDefinedException, LevelMetadataElementIsReadOnly, MetadataElementSetterPostActionException, MetadataElementAllowedValuesException {
        Element paketNode = this.getRootElement();
        Logger.debug((Object)"Inserting Paket");
        rootFolder.setLevel(this.levels.get("Paket"));
        rootFolder.setDynamicMetadataValueForName("usage", this.getZusatzDaten((Node)paketNode, "BAR:zusatzDaten"));
        this.insertAblieferungInto(rootFolder, (Node)paketNode);
    }

    private void insertAblieferungInto(NodeFolder parentFolder, Node parentNode) throws FileAlreadyExistsException, IOException, FileOperationNotAllowedException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, MetadataElementValidatorException, FolderNameIsEmptyException, FileUtilExceptionListException, MetadataElementIsNotAllowedException, MetadataElementIsNotDefinedException, LevelMetadataElementIsReadOnly, MetadataElementSetterPostActionException, MetadataElementAllowedValuesException {
        Node ablieferungNode = parentNode.selectSingleNode("BAR:ablieferung");
        Logger.debug((Object)"Inserting Ablieferung");
        NodeFolder ablieferungFolder = parentFolder.createNewFolder("Ablieferung");
        ablieferungFolder.setLevel(this.levels.get("Ablieferung"));
        ablieferungFolder.setDynamicMetadataValueForName("accessNr", this.getText(ablieferungNode, "BAR:ablieferndeStelle"));
        ablieferungFolder.setDynamicMetadataValueForName("refCode", this.getText(ablieferungNode, "BAR:ablieferungsnummer"));
        ablieferungFolder.setDynamicMetadataValueForName("objectType", this.getText(ablieferungNode, "BAR:ablieferungstyp"));
        ablieferungFolder.setDynamicMetadataValueForName("material", this.getText(ablieferungNode, "BAR:ablieferungsteile"));
        ablieferungFolder.setDynamicMetadataValueForName("refCodeAdmin", this.getText(ablieferungNode, "BAR:angebotsnummer"));
        ablieferungFolder.setDynamicMetadataValueForName("fromYear", this.getText(ablieferungNode, "BAR:entstehungszeitraum/BAR:von/BAR:datum"));
        ablieferungFolder.setDynamicMetadataValueForName("toYear", this.getText(ablieferungNode, "BAR:entstehungszeitraum/BAR:bis/BAR:datum"));
        ablieferungFolder.setDynamicMetadataValueForName("comment", this.getText(ablieferungNode, "BAR:bemerkung"));
        ablieferungFolder.setDynamicMetadataValueForName("appraisalAndDestruction", this.getText(ablieferungNode, "BAR:referenzBewertungsentscheid"));
        ablieferungFolder.setDynamicMetadataValueForName("accessRestriction", this.getText(ablieferungNode, "BAR:referenzSchutzfristenFormular"));
        ablieferungFolder.setDynamicMetadataValueForName("accessPolicy", this.getText(ablieferungNode, "BAR:schutzfristenkategorie"));
        ablieferungFolder.setDynamicMetadataValueForName("accessRestrictionPeriod", this.getText(ablieferungNode, "BAR:schutzfrist"));
        ablieferungFolder.setDynamicMetadataValueForName("origination", this.getText(ablieferungNode, "BAR:provenienz/BAR:aktenbildnerName"));
        this.insertOrdnungssystemInto(ablieferungFolder, ablieferungNode);
    }

    private void insertOrdnungssystemInto(NodeFolder parentFolder, Node parentNode) throws FileAlreadyExistsException, IOException, FileOperationNotAllowedException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, MetadataElementValidatorException, FolderNameIsEmptyException, FileUtilExceptionListException, MetadataElementIsNotAllowedException, MetadataElementIsNotDefinedException, LevelMetadataElementIsReadOnly, MetadataElementSetterPostActionException, MetadataElementAllowedValuesException {
        Node osNode = parentNode.selectSingleNode("BAR:ordnungssystem");
        String label = this.getAsFileName(osNode, "BAR:name");
        Logger.debug((Object)("Inserting Ordnungssystem " + label));
        NodeFolder osFolder = parentFolder.createNewFolder(label, true);
        osFolder.setLevel(this.levels.get("Ordnungssystem"));
        osFolder.setDynamicMetadataValueForName("refCode", this.getText(osNode, "BAR:generation"));
        osFolder.setDynamicMetadataValueForName("fromYear", this.getText(osNode, "BAR:anwendungszeitraum/BAR:von/BAR:datum"));
        osFolder.setDynamicMetadataValueForName("toYear", this.getText(osNode, "BAR:anwendungszeitraum/BAR:bis/BAR:datum"));
        osFolder.setDynamicMetadataValueForName("involved", this.getText(osNode, "BAR:mitbenutzung"));
        osFolder.setDynamicMetadataValueForName("comment", this.getText(osNode, "BAR:bemerkung"));
        this.insertOrdnungssystempositionenInto(osFolder, osNode);
    }

    private void insertOrdnungssystempositionenInto(NodeFolder parentFolder, Node parentNode) throws FileAlreadyExistsException, IOException, FileOperationNotAllowedException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, MetadataElementValidatorException, FolderNameIsEmptyException, FileUtilExceptionListException, MetadataElementIsNotAllowedException, MetadataElementIsNotDefinedException, LevelMetadataElementIsReadOnly, MetadataElementSetterPostActionException, MetadataElementAllowedValuesException {
        List osPositions = parentNode.selectNodes("BAR:ordnungssystemposition");
        for (Object o : osPositions) {
            Node osPosNode = (Node)o;
            String label = this.getAsFileName(osPosNode, "BAR:titel");
            Logger.debug((Object)("Inserting Ordnungssystemposition " + label));
            NodeFolder osPosFolder = parentFolder.createNewFolder(label, true);
            osPosFolder.setLevel(this.levels.get("Ordnungssystemposition"));
            osPosFolder.setDynamicMetadataValueForName("refCode", this.getText(osPosNode, "BAR:nummer"));
            osPosFolder.setDynamicMetadataValueForName("refCodeAdmin", ((Element)osPosNode).attributeValue("id"));
            osPosFolder.setDynamicMetadataValueForName("origination", this.getText(osPosNode, "BAR:federfuehrendeOrganisationseinheit"));
            osPosFolder.setDynamicMetadataValueForName("accessPolicy", this.getText(osPosNode, "BAR:schutzfristenkategorie"));
            osPosFolder.setDynamicMetadataValueForName("accessRestrictionPeriod", this.getText(osPosNode, "BAR:schutzfrist"));
            osPosFolder.setDynamicMetadataValueForName("accessRestrictionExplanation", this.getText(osPosNode, "BAR:schutzfristenBegruendung"));
            osPosFolder.setDynamicMetadataValueForName("accessRestrictionClassification", this.getText(osPosNode, "BAR:klassifizierungskategorie"));
            osPosFolder.setDynamicMetadataValueForName("accessRestrictionPrivacy", this.getText(osPosNode, "BAR:datenschutz"));
            osPosFolder.setDynamicMetadataValueForName("accessRestrictionStatus", this.getText(osPosNode, "BAR:oeffentlichkeitsstatus"));
            osPosFolder.setDynamicMetadataValueForName("accessRestrictionStatusExplanation", this.getText(osPosNode, "BAR:oeffentlichkeitsstatusBegruendung"));
            osPosFolder.setDynamicMetadataValueForName("accessRestriction", this.getText(osPosNode, "BAR:sonstigeBestimmungen"));
            this.insertOrdnungssystempositionenInto(osPosFolder, osPosNode);
            this.insertDossiersInto(osPosFolder, osPosNode);
        }
    }

    private void insertDossiersInto(NodeFolder parentFolder, Node parentNode) throws FileAlreadyExistsException, IOException, FileOperationNotAllowedException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, MetadataElementValidatorException, FolderNameIsEmptyException, FileUtilExceptionListException, MetadataElementIsNotAllowedException, MetadataElementIsNotDefinedException, LevelMetadataElementIsReadOnly, MetadataElementSetterPostActionException, MetadataElementAllowedValuesException {
        List dossiers = parentNode.selectNodes("BAR:dossier");
        for (Object o : dossiers) {
            Node dossierNode = (Node)o;
            String label = this.getAsFileName(dossierNode, "BAR:titel");
            Logger.debug((Object)("Inserting Dossier " + label));
            NodeFolder dossierFolder = parentFolder.createNewFolder(label, true);
            dossierFolder.setLevel(this.levels.get("Dossier"));
            dossierFolder.setDynamicMetadataValueForName("refCode", this.getText(dossierNode, "BAR:aktenzeichen"));
            dossierFolder.setDynamicMetadataValueForName("archivalHistory", this.getText(dossierNode, "BAR:zusatzmerkmal"));
            dossierFolder.setDynamicMetadataValueForName("abstract", this.getText(dossierNode, "BAR:inhalt"));
            dossierFolder.setDynamicMetadataValueForName("refCodeAdmin", ((Element)dossierNode).attributeValue("id"));
            dossierFolder.setDynamicMetadataValueForName("characteristics", this.getText(dossierNode, "BAR:erscheinungsform"));
            dossierFolder.setDynamicMetadataValueForName("scopeContent", this.getText(dossierNode, "BAR:formInhalt"));
            dossierFolder.setDynamicMetadataValueForName("material", this.getText(dossierNode, "BAR:umfang"));
            dossierFolder.setDynamicMetadataValueForName("origination", this.getText(dossierNode, "BAR:federfuehrendeOrganisationseinheit"));
            dossierFolder.setDynamicMetadataValueForName("fromYear", this.getText(dossierNode, "BAR:entstehungszeitraum/BAR:von/BAR:datum"));
            dossierFolder.setDynamicMetadataValueForName("toYear", this.getText(dossierNode, "BAR:entstehungszeitraum/BAR:bis/BAR:datum"));
            dossierFolder.setDynamicMetadataValueForName("creationPeriodNotes", this.getText(dossierNode, "BAR:entstehungszeitraumAnmerkung"));
            dossierFolder.setDynamicMetadataValueForName("comment", this.getText(dossierNode, "BAR:bemerkung"));
            dossierFolder.setDynamicMetadataValueForName("accessPolicy", this.getText(dossierNode, "BAR:schutzfristenkategorie"));
            dossierFolder.setDynamicMetadataValueForName("accessRestrictionPeriod", this.getText(dossierNode, "BAR:schutzfrist"));
            dossierFolder.setDynamicMetadataValueForName("accessRestrictionExplanation", this.getText(dossierNode, "BAR:schutzfristenBegruendung"));
            dossierFolder.setDynamicMetadataValueForName("accessRestrictionClassification", this.getText(dossierNode, "BAR:klassifizierungskategorie"));
            dossierFolder.setDynamicMetadataValueForName("accessRestrictionPrivacy", this.getText(dossierNode, "BAR:datenschutz"));
            dossierFolder.setDynamicMetadataValueForName("accessRestrictionStatus", this.getText(dossierNode, "BAR:oeffentlichkeitsstatus"));
            dossierFolder.setDynamicMetadataValueForName("accessRestrictionStatusExplanation", this.getText(dossierNode, "BAR:oeffentlichkeitsstatusBegruendung"));
            dossierFolder.setDynamicMetadataValueForName("accessRestriction", this.getText(dossierNode, "BAR:sonstigeBestimmungen"));
            this.insertDossiersInto(dossierFolder, dossierNode);
            this.insertDocumentsInto(dossierFolder, dossierNode);
            this.insertDateiRefsInto(dossierFolder, dossierNode);
        }
    }

    private void insertDocumentsInto(NodeFolder parentFolder, Node parentNode) throws FileAlreadyExistsException, IOException, FileOperationNotAllowedException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, MetadataElementValidatorException, FolderNameIsEmptyException, FileUtilExceptionListException, MetadataElementIsNotAllowedException, MetadataElementIsNotDefinedException, LevelMetadataElementIsReadOnly, MetadataElementSetterPostActionException, MetadataElementAllowedValuesException {
        List documents = parentNode.selectNodes("BAR:dokument");
        for (Object o : documents) {
            Node documentNode = (Node)o;
            String label = this.getAsFileName(documentNode, "BAR:titel");
            Logger.debug((Object)("Inserting Document " + label));
            NodeFolder documentFolder = parentFolder.createNewFolder(label, true);
            documentFolder.setLevel(this.levels.get("Dokument"));
            documentFolder.setDynamicMetadataValueForName("refCodeAdmin", ((Element)documentNode).attributeValue("id"));
            documentFolder.setDynamicMetadataValueForName("characteristics", this.getText(documentNode, "BAR:erscheinungsform"));
            documentFolder.setDynamicMetadataValueForName("scopeContent", this.getText(documentNode, "BAR:dokumenttyp"));
            documentFolder.setDynamicMetadataValueForName("origination", this.getText(documentNode, "BAR:autor"));
            documentFolder.setDynamicMetadataValueForName("fromYear", this.getText(documentNode, "BAR:entstehungszeitraum/BAR:von/BAR:datum"));
            documentFolder.setDynamicMetadataValueForName("toYear", this.getText(documentNode, "BAR:entstehungszeitraum/BAR:bis/BAR:datum"));
            documentFolder.setDynamicMetadataValueForName("creationPeriod", this.getText(documentNode, "BAR:registrierdatum/BAR:datum"));
            documentFolder.setDynamicMetadataValueForName("comment", this.getText(documentNode, "BAR:bemerkung"));
            documentFolder.setDynamicMetadataValueForName("accessRestrictionClassification", this.getText(documentNode, "BAR:klassifizierungskategorie"));
            documentFolder.setDynamicMetadataValueForName("accessRestrictionPrivacy", this.getText(documentNode, "BAR:datenschutz"));
            documentFolder.setDynamicMetadataValueForName("accessRestrictionStatus", this.getText(documentNode, "BAR:oeffentlichkeitsstatus"));
            documentFolder.setDynamicMetadataValueForName("accessRestrictionStatusExplanation", this.getText(documentNode, "BAR:oeffentlichkeitsstatusBegruendung"));
            documentFolder.setDynamicMetadataValueForName("accessRestriction", this.getText(documentNode, "BAR:sonstigeBestimmungen"));
            this.insertDateiRefsInto(documentFolder, documentNode);
        }
    }

    private void insertDateiRefsInto(NodeFolder parentFolder, Node parentNode) throws FileAlreadyExistsException, IOException, FileOperationNotAllowedException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, FileUtilExceptionListException {
        List fileRefs = parentNode.selectNodes("BAR:dateiRef");
        for (Object o : fileRefs) {
            Node fileRefNode = (Node)o;
            String relativeFilePath = this.getFilePath(fileRefNode);
            Logger.debug((Object)("Inserting FileRef " + relativeFilePath));
            NodeAbstract fileRefFile = parentFolder.insertFileOrFolder(this.filePath + relativeFilePath, true);
            fileRefFile.setLevel(this.levels.get("Datei"));
        }
    }

    private String getFilePath(Node fileRefNode) {
        Node fileNode;
        String fileRefId = fileRefNode.getText();
        Node parent = fileNode = this.getRootElement().selectSingleNode("BAR:inhaltsverzeichnis//BAR:datei [@id='" + fileRefId + "']");
        String relativeFilePath = "";
        do {
            relativeFilePath = "/" + parent.selectSingleNode("BAR:name").getText() + relativeFilePath;
        } while ((parent = parent.getParent()).selectSingleNode("BAR:name") != null);
        return relativeFilePath;
    }

    private void addElementAndSetTextFromDynamicMetadata(Element insertPoint, String newElementName, NodeAbstract node, String metadataName) {
        try {
            for (String text : node.getAllDynamicMetadataValuesForName(metadataName)) {
                this.addElementAndSetText(insertPoint, newElementName, text);
            }
        }
        catch (Exception ex) {
            Logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    private void addElementAndSetText(Element insertPoint, String newElementName, String text) {
        if (text == null || text.isEmpty()) {
            return;
        }
        XMLUtil.add(insertPoint, newElementName, text);
    }

    private void setAttributeFromDynamicMetadata(Element insertPoint, String attributeName, NodeAbstract node, String metadataName) {
        try {
            String text = node.getDynamicMetadataValueForName(metadataName);
            this.setAttribute(insertPoint, attributeName, text);
        }
        catch (Exception ex) {
            Logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    private void setAttribute(Element insertPoint, String attributeName, String text) {
        if (text == null) {
            return;
        }
        insertPoint.addAttribute(attributeName, text);
    }

    private void addZusatzDatenElementFromDynamicMetadata(Element insertPoint, NodeAbstract node, String metadataName) {
        List<String> jsonStrings;
        try {
            jsonStrings = node.getAllDynamicMetadataValuesForName(metadataName);
        }
        catch (Exception ex) {
            Logger.error((Object)ex.getMessage(), (Throwable)ex);
            return;
        }
        for (String jsonString : jsonStrings) {
            Map keyValueMap;
            try {
                keyValueMap = (Map)new Gson().fromJson(jsonString, Map.class);
            }
            catch (JsonSyntaxException ex) {
                keyValueMap = new HashMap<String, String>();
                keyValueMap.put(metadataName, jsonString);
            }
            if (keyValueMap.isEmpty()) continue;
            for (Map.Entry entry : keyValueMap.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (value == null || value.isEmpty()) continue;
                this.addElementAndSetText(insertPoint, "BAR:zusatzDaten/BAR:merkmal[@name='" + key + "']", value);
            }
        }
    }

    private void addZusatzDatenElementFromUnconfiguredMetadata(Element insertPoint, NodeAbstract node) {
        Element zusatzDatenElement = (Element)insertPoint.selectSingleNode("BAR:zusatzDaten");
        if (zusatzDatenElement == null) {
            zusatzDatenElement = insertPoint.addElement("BAR:zusatzDaten");
        }
        Set<String> configuredMetadata = node.getLevel().getDynamicMetadataElements().keySet();
        for (String accessorName : MetadataElement.getAll().keySet()) {
            if (configuredMetadata.contains(accessorName)) continue;
            List<String> values = null;
            try {
                values = node.getAllDynamicMetadataValuesForName_NoCheck(accessorName);
            }
            catch (Exception ex) {
                Logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
            if (values == null || values.isEmpty()) continue;
            for (String value : values) {
                if (value == null || value.isEmpty()) continue;
                Element newElement = zusatzDatenElement.addElement("BAR:merkmal");
                newElement.addAttribute("name", accessorName);
                newElement.setText(value);
            }
        }
        if (zusatzDatenElement.content().size() == 0) {
            zusatzDatenElement.detach();
        }
    }

    private String getText(Node node, String xPath) {
        if (node == null) {
            return null;
        }
        Node subNode = node.selectSingleNode(xPath);
        if (subNode == null) {
            return null;
        }
        return subNode.getText();
    }

    private String getAsFileName(Node node, String xPath) {
        String label = this.getText(node, xPath);
        label = label == null || label.isEmpty() ? node.getName() + UniqueID.getXML() : FileUtil.asSafeFileName((String)label);
        return label;
    }

    private String getZusatzDaten(Node node, String xPath) {
        if (node == null) {
            return null;
        }
        Node subNode = node.selectSingleNode(xPath);
        if (subNode == null) {
            return null;
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (Object o : subNode.selectNodes("BAR:merkmal")) {
            Element itemElement = (Element)o;
            map.put(itemElement.attributeValue("name"), itemElement.getText());
        }
        return new Gson().toJson(map);
    }

    private static class ObserverTracer
    implements Observer {
        private ObserverTracer() {
        }

        @Override
        public void update(Observable o, Object arg) {
            Tracer.trace((Object)arg);
        }
    }

    private static class DateiId {
        private static int DateiIdCounter = 0;

        private DateiId() {
        }

        private static String getNext() {
            return "d" + StringUtil.last((String)("000000" + DateiIdCounter++), (Integer)6);
        }
    }

    private static class BARSIPFactory
    extends DocumentFactory {
        private static final long serialVersionUID = 1L;

        private BARSIPFactory() {
        }

        public Document createDocument() {
            TreeMap<String, String> namespaces = new TreeMap<String, String>();
            namespaces.put(Document.BARNamespacePrefix, Document.BARNamespaceURI);
            this.setXPathNamespaceURIs(namespaces);
            Document barSIP = new Document();
            barSIP.setDocumentFactory(this);
            return barSIP;
        }
    }
}

