/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.ead;

import ch.docuteam.darc.common.DocumentAbstract;
import ch.docuteam.darc.common.NodeAbstract;
import ch.docuteam.darc.ead.C;
import ch.docuteam.darc.ead.DID;
import ch.docuteam.darc.ead.EADNodeAbstract;
import ch.docuteam.darc.mdconfig.LevelOfDescription;
import ch.docuteam.darc.mets.dmdsec.DMDSectionWithEAD;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;

public abstract class ComponentAbstract
extends EADNodeAbstract {
    protected static final String Level = "otherlevel";
    protected static final String Role = "simple";
    protected static final String Xmlns_xlink = "http://www.w3.org/1999/xlink";
    protected static final String XPathPID = "EAD:dao[@xlink:role = 'simple']";
    protected static final String XPathAccessPolicy = "EAD:accessrestrict[@type = 'accessPolicy']/EAD:p";
    protected static final String XPathAccessRestrictionClassification = "EAD:accessrestrict[@type = 'accessRestrictionsClassification']/EAD:p";
    protected static final String XPathAccessRestrictionExplanation = "EAD:accessrestrict[@type = 'accessRestrictionsExplanation']/EAD:p";
    protected static final String XPathAccessRestrictionPeriod = "EAD:accessrestrict[@type = 'accessRestrictionsPeriod']/EAD:p";
    protected static final String XPathAccessRestrictionPeriodBaseYear = "EAD:accessrestrict[@type = 'accessRestrictionsPeriodBaseYear']/EAD:p";
    protected static final String XPathAccessRestrictionPrivacy = "EAD:accessrestrict[@type = 'accessRestrictionsPrivacy']/EAD:p";
    protected static final String XPathAccessRestrictionStatus = "EAD:accessrestrict[@type = 'accessRestrictionsStatus']/EAD:p";
    protected static final String XPathAccessRestrictionStatusExplanation = "EAD:accessrestrict[@type = 'accessRestrictionsStatusExplanation']/EAD:p";
    protected static final String XPathAccessRestrictionIsPublic = "EAD:accessrestrict[@type = 'accessRestrictionsIsPublic']/EAD:p";
    protected static final String XPathAccessRestrictionIsMetadataPublic = "EAD:accessrestrict[@type = 'accessRestrictionsIsMetadataPublic']/EAD:p";
    protected static final String XPathAccessRestrictionClosureYear = "EAD:accessrestrict[@type = 'accessRestrictionsClosureYear']/EAD:p";
    protected static final String XPathRetentionPeriodBaseYear = "EAD:accessrestrict[@type = 'baseYear']/EAD:p";
    protected static final String XPathAccessRestriction = "EAD:accessrestrict[@type = 'restrictions']/EAD:p";
    protected static final String XPathRetentionPeriod = "EAD:accessrestrict[@type = 'retentionPeriod']/EAD:p";
    protected static final String XPathRetentionPolicy = "EAD:accessrestrict[@type = 'retentionPolicy']/EAD:p";
    protected static final String XPathUsagePermission = "EAD:accessrestrict[@type = 'usagePermission']/EAD:p";
    protected static final String XPathUsagePermissionExpiringDate = "EAD:accessrestrict[@type = 'usagePermissionExpiringDate']/EAD:p";
    protected static final String XPathAccruals = "EAD:accruals/EAD:p";
    protected static final String XPathAccessNr = "EAD:acqinfo/EAD:p";
    protected static final String XPathReproductions = "EAD:altformavail/EAD:p";
    protected static final String XPathAppraisalAndDestruction = "EAD:appraisal/EAD:p";
    protected static final String XPathAppraisalIsOnHold = "EAD:appraisal/EAD:note[@type = 'isOnHold']/EAD:p";
    protected static final String XPathAppraisalDateDisposed = "EAD:appraisal/EAD:note[@type = 'dateDisposed']/EAD:p";
    protected static final String XPathAppraisalRetentionPeriod = "EAD:appraisal/EAD:note[@type ='retentionPeriod']/EAD:p";
    protected static final String XPathArrangement = "EAD:arrangement/EAD:p";
    protected static final String XPathBibliography = "EAD:bibliography/EAD:p";
    protected static final String XPathDeathOfAuthor = "EAD:bioghist/EAD:note/EAD:p/EAD:date[@type = 'deathAuthor']";
    protected static final String XPathBiographicalHistory = "EAD:bioghist/EAD:p";
    protected static final String XPathLastname = "EAD:bioghist/EAD:note[@type = 'lastName']/EAD:p";
    protected static final String XPathFirstname = "EAD:bioghist/EAD:note[@type = 'firstName']/EAD:p";
    protected static final String XPathDateOfBirth = "EAD:bioghist/EAD:note[@type = 'dateBirth']/EAD:p";
    protected static final String XPathNationality = "EAD:bioghist/EAD:note[@type = 'nationality']/EAD:p";
    protected static final String XPathSex = "EAD:bioghist/EAD:note[@type = 'sex']/EAD:p";
    protected static final String XPathInstitution = "EAD:controlaccess/EAD:corpname[not(@role)]";
    protected static final String XPATH_INSTITUTION_CREATOR = "EAD:controlaccess/EAD:corpname[@role = 'creator']";
    protected static final String XPATH_INSTITUTION_INVOLVED = "EAD:controlaccess/EAD:corpname[@role = 'involved']";
    protected static final String XPathFamilyName = "EAD:controlaccess/EAD:famname[@role = 'general']";
    protected static final String XPathFunction = "EAD:controlaccess/EAD:function[@rules = 'general']";
    protected static final String XPathObjectType = "EAD:controlaccess/EAD:genreform";
    protected static final String XPATH_GEOG_NAME = "EAD:controlaccess/EAD:geogname[@role = 'general']";
    protected static final String XPathCompartment = "EAD:controlaccess/EAD:name[@role = 'compartment']";
    protected static final String XPathFundingSource = "EAD:controlaccess/EAD:name[@role = 'fundingSource']";
    protected static final String XPathInstitute = "EAD:controlaccess/EAD:name[@role = 'institute']";
    protected static final String XPathJournal = "EAD:controlaccess/EAD:name[@role = 'journal']";
    protected static final String XPathKeyword = "EAD:controlaccess/EAD:name[@role = 'keyword']";
    protected static final String XPathLocation = "EAD:controlaccess/EAD:name[@role = 'location']";
    protected static final String XPathMethod = "EAD:controlaccess/EAD:name[@role = 'method']";
    protected static final String XPATH_PLACE_OF_PUBLICATION = "EAD:controlaccess/EAD:name[@role = 'placeOfPublication']";
    protected static final String XPathPublisher = "EAD:controlaccess/EAD:name[@role = 'publisher']";
    protected static final String XPathEditor = "EAD:controlaccess/EAD:name[@role = 'editor']";
    protected static final String XPathAuthorGeneric = "EAD:controlaccess/EAD:name[@role = 'author']";
    protected static final String XPathDesigner = "EAD:controlaccess/EAD:name[@role = 'designer']";
    protected static final String XPathPhotographer = "EAD:controlaccess/EAD:name[@role = 'photographer']";
    protected static final String XPathIllustrator = "EAD:controlaccess/EAD:name[@role = 'illustrator']";
    protected static final String XPathTypeOfAcquisition = "EAD:controlaccess/EAD:name[@role = 'typeOfAcquisition']";
    protected static final String XPathStatus = "EAD:controlaccess/EAD:name[@role = 'status']";
    protected static final String XPathSubmitStatus = "EAD:controlaccess/EAD:name[@role = 'submitStatus']";
    protected static final String XPathUniversity = "EAD:controlaccess/EAD:name[@role = 'university']";
    protected static final String XPathOccupation = "EAD:controlaccess/EAD:occupation[@rules = 'general']";
    protected static final String XPathAuthor = "EAD:controlaccess/EAD:persname[@role = 'author']";
    protected static final String XPATH_CREATOR = "EAD:controlaccess/EAD:persname[@role = 'creator']";
    protected static final String XPathInvolved = "EAD:controlaccess/EAD:persname[@role = 'involved']";
    protected static final String XPathResponsible = "EAD:controlaccess/EAD:persname[@role = 'responsible']";
    protected static final String XPathStaff = "EAD:controlaccess/EAD:persname[@role = 'staff']";
    protected static final String XPathSubject = "EAD:controlaccess/EAD:subject[not(@rules) and not(@role)]";
    protected static final String XPATH_SUBJECT_GENERAL = "EAD:controlaccess/EAD:subject[@rules = 'general' or @role='general']";
    protected static final String XPATH_UNIFORM_TITLE = "EAD:controlaccess/EAD:title[@type = 'uniform']";
    protected static final String XPathModeOfAcquisition = "EAD:custodhist/EAD:acqinfo/EAD:p";
    protected static final String XPathSourceType = "EAD:custodhist/EAD:note/EAD:p";
    protected static final String XPathArchivalHistory = "EAD:custodhist/EAD:p";
    protected static final String XPathComment = "EAD:note/EAD:p";
    protected static final String XPathDOIJournal = "EAD:odd[@type = 'doiJournal']/EAD:p";
    protected static final String XPATH_EDITION_STATEMENT = "EAD:odd[@type = 'edition']/EAD:p";
    protected static final String XPathProject = "EAD:odd[@type = 'project']/EAD:p";
    protected static final String XPathProjectAbbreviation = "EAD:odd[@type = 'projectAbbreviation']/EAD:p";
    protected static final String XPathProjectName = "EAD:odd[@type = 'projectName']/EAD:p";
    protected static final String XPathProjectTitle = "EAD:odd[@type = 'projectTitle']/EAD:p";
    protected static final String XPathUsage = "EAD:odd[@type = 'usage']/EAD:p";
    protected static final String XPathEvent = "EAD:odd[@type = 'event']/EAD:p";
    protected static final String XPathLocationOfOriginals = "EAD:originalsloc/EAD:p";
    protected static final String XPathFindingAids = "EAD:otherfindaid/EAD:p";
    protected static final String XPathCharacteristicsNote = "EAD:phystech/EAD:note/EAD:p";
    protected static final String XPathCharacteristics = "EAD:phystech/EAD:p";
    protected static final String XPathDigitization = "EAD:processinfo[@type = 'digitization']/EAD:p";
    protected static final String XPathDescriptionLevel = "EAD:processinfo[@type = 'level']/EAD:p";
    protected static final String XPathDescriptionLevelNotes = "EAD:processinfo[@type = 'levelNotes']/EAD:p";
    protected static final String XPathRevisions = "EAD:processinfo[@type = 'revisions']/EAD:p";
    protected static final String XPathDescriptionRules = "EAD:processinfo[@type = 'rules']/EAD:p";
    protected static final String XPathProcessInfoArchivist = "EAD:processinfo[@type = 'archivist']/EAD:p";
    protected static final String XPathProcessInfoDate = "EAD:processinfo[@type = 'date']/EAD:p";
    protected static final String XPathRelatedMaterial = "EAD:relatedmaterial/EAD:p";
    protected static final String XPathRelatedMaterialExtern = "EAD:relatedmaterial/EAD:extref[@role = 'general']";
    protected static final String XPathScopeContent = "EAD:scopecontent/EAD:p";
    protected static final String XPathConditionsOfReproductions = "EAD:userestrict/EAD:p";
    protected static final String XPathFilePlanPosition = "EAD:fileplan/EAD:note[@type = 'position']/EAD:p";
    protected int depth = 0;
    protected LevelOfDescription otherLevel = LevelOfDescription.getUndefined();
    protected DID did;
    protected List<C> cs = new ArrayList<C>();
    protected List<String> pid;
    protected NodeAbstract.SubmitStatus submitStatus;
    protected List<String> author;
    protected List<String> comment;
    protected List<String> accessNr;
    protected List<String> scopeContent;
    protected List<String> accessPolicy;
    protected List<String> accessRestriction;
    protected List<String> accessRestrictionExplanation;
    protected List<String> accessRestrictionPeriod;
    protected List<String> accessRestrictionPeriodBaseYear;
    protected List<String> accessRestrictionClassification;
    protected List<String> accessRestrictionPrivacy;
    protected List<String> accessRestrictionStatus;
    protected List<String> accessRestrictionStatusExplanation;
    protected List<String> accessRestrictionIsPublic;
    protected List<String> accessRestrictionIsMetadataPublic;
    protected List<String> accessRestrictionClosureYear;
    protected List<String> usagePermission;
    protected List<String> usagePermissionExpiringDate;
    protected List<String> retentionPolicy;
    protected List<String> retentionPeriodBaseYear;
    protected List<String> archivalHistory;
    protected List<String> sourceType;
    protected List<String> modeOfAcquisition;
    protected List<String> objectType;
    protected List<String> conditionsOfReproductions;
    protected List<String> characteristics;
    protected List<String> findingAids;
    protected List<String> locationOfOriginals;
    protected List<String> reproductions;
    protected List<String> relatedMaterial;
    protected List<String> relatedMaterialExtern;
    protected List<String> institution;
    protected List<String> appraisalAndDestruction;
    protected List<String> appraisalIsOnHold;
    protected List<String> appraisalDateDisposed;
    protected List<String> appraisalRetentionPeriod;
    protected List<String> arrangement;
    protected List<String> bibliography;
    protected List<String> descriptionLevel;
    protected List<String> descriptionLevelNotes;
    protected List<String> descriptionRules;
    protected List<String> processInfoArchivist;
    protected List<String> processInfoDate;
    protected List<String> revisions;
    protected List<String> digitization;
    protected List<String> biographicalHistory;
    protected List<String> firstname;
    protected List<String> lastname;
    protected List<String> dateOfBirth;
    protected List<String> nationality;
    protected List<String> sex;
    protected List<String> deathOfAuthor;
    protected List<String> accruals;
    protected List<String> characteristicsNote;
    protected List<String> subject;
    protected List<String> responsible;
    protected List<String> involved;
    protected List<String> staff;
    protected List<String> projectName;
    protected List<String> projectTitle;
    protected List<String> project;
    protected List<String> projectAbbreviation;
    protected List<String> location;
    protected List<String> journal;
    protected List<String> university;
    protected List<String> institute;
    protected List<String> compartment;
    protected List<String> method;
    protected List<String> keyword;
    protected List<String> fundingSource;
    protected List<String> status;
    protected List<String> publisher;
    protected List<String> editor;
    protected List<String> authorGeneric;
    protected List<String> designer;
    protected List<String> photographer;
    protected List<String> illustrator;
    protected List<String> typeOfAcquisition;
    protected List<String> doiJournal;
    protected List<String> retentionPeriod;
    protected List<String> usage;
    protected List<String> event;
    protected List<String> creator;
    protected List<String> editionStatement;
    protected List<String> geogName;
    protected List<String> institutionCreator;
    protected List<String> institutionInvolved;
    protected List<String> familyName;
    protected List<String> function;
    protected List<String> occupation;
    protected List<String> placeOfPublication;
    protected List<String> subjectGeneral;
    protected List<String> uniformTitle;
    protected List<String> filePlanPosition;

    protected ComponentAbstract(NodeAbstract parent, Element element, int depth) {
        this(parent.getDocument(), element, depth);
        this.parent = parent;
    }

    protected ComponentAbstract(DocumentAbstract document, Element element, int depth) {
        this.document = document;
        this.element = element;
        this.depth = depth;
        this.otherLevel = this.document.getLevels().get(element.attributeValue(Level));
        Vector<String> pids = new Vector<String>(3);
        for (Object e : element.selectNodes(XPathPID)) {
            pids.add(((Element)e).attributeValue("href"));
        }
        if (!pids.isEmpty()) {
            this.pid = pids;
        }
        this.submitStatus = NodeAbstract.SubmitStatus.named(this.getElementText(XPathSubmitStatus, false));
        this.author = this.getDynamicElementTexts(XPathAuthor);
        this.comment = this.getDynamicElementTexts(XPathComment);
        this.accessNr = this.getDynamicElementTexts(XPathAccessNr);
        this.scopeContent = this.getDynamicElementTexts(XPathScopeContent);
        this.accessPolicy = this.getDynamicElementTexts(XPathAccessPolicy);
        this.accessRestriction = this.getDynamicElementTexts(XPathAccessRestriction);
        this.accessRestrictionExplanation = this.getDynamicElementTexts(XPathAccessRestrictionExplanation);
        this.accessRestrictionPeriod = this.getDynamicElementTexts(XPathAccessRestrictionPeriod);
        this.accessRestrictionPeriodBaseYear = this.getDynamicElementTexts(XPathAccessRestrictionPeriodBaseYear);
        this.accessRestrictionClassification = this.getDynamicElementTexts(XPathAccessRestrictionClassification);
        this.accessRestrictionPrivacy = this.getDynamicElementTexts(XPathAccessRestrictionPrivacy);
        this.accessRestrictionStatus = this.getDynamicElementTexts(XPathAccessRestrictionStatus);
        this.accessRestrictionStatusExplanation = this.getDynamicElementTexts(XPathAccessRestrictionStatusExplanation);
        this.accessRestrictionIsPublic = this.getDynamicElementTexts(XPathAccessRestrictionIsPublic);
        this.accessRestrictionIsMetadataPublic = this.getDynamicElementTexts(XPathAccessRestrictionIsMetadataPublic);
        this.accessRestrictionClosureYear = this.getDynamicElementTexts(XPathAccessRestrictionClosureYear);
        this.usagePermission = this.getDynamicElementTexts(XPathUsagePermission);
        this.usagePermissionExpiringDate = this.getDynamicElementTexts(XPathUsagePermissionExpiringDate);
        this.retentionPolicy = this.getDynamicElementTexts(XPathRetentionPolicy);
        this.retentionPeriodBaseYear = this.getDynamicElementTexts(XPathRetentionPeriodBaseYear);
        this.archivalHistory = this.getDynamicElementTexts(XPathArchivalHistory);
        this.sourceType = this.getDynamicElementTexts(XPathSourceType);
        this.modeOfAcquisition = this.getDynamicElementTexts(XPathModeOfAcquisition);
        this.objectType = this.getDynamicElementTexts(XPathObjectType);
        this.conditionsOfReproductions = this.getDynamicElementTexts(XPathConditionsOfReproductions);
        this.characteristics = this.getDynamicElementTexts(XPathCharacteristics);
        this.findingAids = this.getDynamicElementTexts(XPathFindingAids);
        this.locationOfOriginals = this.getDynamicElementTexts(XPathLocationOfOriginals);
        this.reproductions = this.getDynamicElementTexts(XPathReproductions);
        this.relatedMaterial = this.getDynamicElementTexts(XPathRelatedMaterial);
        this.relatedMaterialExtern = this.getDynamicElementTexts(XPathRelatedMaterialExtern);
        this.institution = this.getDynamicElementTexts(XPathInstitution);
        this.appraisalAndDestruction = this.getDynamicElementTexts(XPathAppraisalAndDestruction);
        this.appraisalIsOnHold = this.getDynamicElementTexts(XPathAppraisalIsOnHold);
        this.appraisalDateDisposed = this.getDynamicElementTexts(XPathAppraisalDateDisposed);
        this.appraisalRetentionPeriod = this.getDynamicElementTexts(XPathAppraisalRetentionPeriod);
        this.arrangement = this.getDynamicElementTexts(XPathArrangement);
        this.bibliography = this.getDynamicElementTexts(XPathBibliography);
        this.descriptionLevel = this.getDynamicElementTexts(XPathDescriptionLevel);
        this.descriptionLevelNotes = this.getDynamicElementTexts(XPathDescriptionLevelNotes);
        this.descriptionRules = this.getDynamicElementTexts(XPathDescriptionRules);
        this.processInfoArchivist = this.getDynamicElementTexts(XPathProcessInfoArchivist);
        this.processInfoDate = this.getDynamicElementTexts(XPathProcessInfoDate);
        this.revisions = this.getDynamicElementTexts(XPathRevisions);
        this.digitization = this.getDynamicElementTexts(XPathDigitization);
        this.biographicalHistory = this.getDynamicElementTexts(XPathBiographicalHistory);
        this.firstname = this.getDynamicElementTexts(XPathFirstname);
        this.lastname = this.getDynamicElementTexts(XPathLastname);
        this.dateOfBirth = this.getDynamicElementTexts(XPathDateOfBirth);
        this.nationality = this.getDynamicElementTexts(XPathNationality);
        this.sex = this.getDynamicElementTexts(XPathSex);
        this.deathOfAuthor = this.getDynamicElementTexts(XPathDeathOfAuthor);
        this.accruals = this.getDynamicElementTexts(XPathAccruals);
        this.characteristicsNote = this.getDynamicElementTexts(XPathCharacteristicsNote);
        this.subject = this.getDynamicElementTexts(XPathSubject);
        this.responsible = this.getDynamicElementTexts(XPathResponsible);
        this.involved = this.getDynamicElementTexts(XPathInvolved);
        this.staff = this.getDynamicElementTexts(XPathStaff);
        this.projectName = this.getDynamicElementTexts(XPathProjectName);
        this.projectTitle = this.getDynamicElementTexts(XPathProjectTitle);
        this.project = this.getDynamicElementTexts(XPathProject);
        this.projectAbbreviation = this.getDynamicElementTexts(XPathProjectAbbreviation);
        this.location = this.getDynamicElementTexts(XPathLocation);
        this.journal = this.getDynamicElementTexts(XPathJournal);
        this.university = this.getDynamicElementTexts(XPathUniversity);
        this.institute = this.getDynamicElementTexts(XPathInstitute);
        this.compartment = this.getDynamicElementTexts(XPathCompartment);
        this.method = this.getDynamicElementTexts(XPathMethod);
        this.keyword = this.getDynamicElementTexts(XPathKeyword);
        this.fundingSource = this.getDynamicElementTexts(XPathFundingSource);
        this.status = this.getDynamicElementTexts(XPathStatus);
        this.publisher = this.getDynamicElementTexts(XPathPublisher);
        this.editor = this.getDynamicElementTexts(XPathEditor);
        this.authorGeneric = this.getDynamicElementTexts(XPathAuthorGeneric);
        this.designer = this.getDynamicElementTexts(XPathDesigner);
        this.photographer = this.getDynamicElementTexts(XPathPhotographer);
        this.illustrator = this.getDynamicElementTexts(XPathIllustrator);
        this.typeOfAcquisition = this.getDynamicElementTexts(XPathTypeOfAcquisition);
        this.doiJournal = this.getDynamicElementTexts(XPathDOIJournal);
        this.retentionPeriod = this.getDynamicElementTexts(XPathRetentionPeriod);
        this.usage = this.getDynamicElementTexts(XPathUsage);
        this.event = this.getDynamicElementTexts(XPathEvent);
        this.creator = this.getDynamicElementTexts(XPATH_CREATOR);
        this.editionStatement = this.getDynamicElementTexts(XPATH_EDITION_STATEMENT);
        this.geogName = this.getDynamicElementTexts(XPATH_GEOG_NAME);
        this.institutionCreator = this.getDynamicElementTexts(XPATH_INSTITUTION_CREATOR);
        this.institutionInvolved = this.getDynamicElementTexts(XPATH_INSTITUTION_INVOLVED);
        this.familyName = this.getDynamicElementTexts(XPathFamilyName);
        this.function = this.getDynamicElementTexts(XPathFunction);
        this.occupation = this.getDynamicElementTexts(XPathOccupation);
        this.placeOfPublication = this.getDynamicElementTexts(XPATH_PLACE_OF_PUBLICATION);
        this.subjectGeneral = this.getDynamicElementTexts(XPATH_SUBJECT_GENERAL);
        this.uniformTitle = this.getDynamicElementTexts(XPATH_UNIFORM_TITLE);
        this.filePlanPosition = this.getDynamicElementTexts(XPathFilePlanPosition);
        this.cs = C.parse(this, this.element, depth + 1);
        this.did = DID.parse(this, this.element);
    }

    protected ComponentAbstract(ComponentAbstract parent, Element element, String title) {
        this.document = parent.getDocument();
        this.element = element;
        this.element.addAttribute("level", Level);
        this.depth = parent.depth + 1;
        this.did = new DID(this, title);
        this.document.setIsModified();
    }

    protected ComponentAbstract(DMDSectionWithEAD parent, Element element, String title) {
        this.document = parent.getDocument();
        this.element = element;
        this.element.addAttribute("level", Level).addAttribute(Level, this.otherLevel.getName());
        this.depth = 0;
        this.did = new DID(this, title);
        this.document.setIsModified();
    }

    protected void copyEADPropertiesFrom(ComponentAbstract source) {
        this.setOtherLevel(source.getOtherLevel());
        this.setPID(source.getPID());
        this.setSubmitStatus(source.getSubmitStatus());
        this.setAuthor(source.getAuthor());
        this.setComment(source.getComment());
        this.setAccessNr(source.getAccessNr());
        this.setScopeContent(source.getScopeContent());
        this.setAccessPolicy(source.getAccessPolicy());
        this.setAccessRestriction(source.getAccessRestriction());
        this.setAccessRestrictionExplanation(source.getAccessRestrictionExplanation());
        this.setAccessRestrictionPeriod(source.getAccessRestrictionPeriod());
        this.setAccessRestrictionPeriodBaseYear(source.getAccessRestrictionPeriodBaseYear());
        this.setAccessRestrictionClassification(source.getAccessRestrictionClassification());
        this.setAccessRestrictionPrivacy(source.getAccessRestrictionPrivacy());
        this.setAccessRestrictionStatus(source.getAccessRestrictionStatus());
        this.setAccessRestrictionStatusExplanation(source.getAccessRestrictionStatusExplanation());
        this.setAccessRestrictionIsPublic(source.getAccessRestrictionIsPublic());
        this.setAccessRestrictionIsMetadataPublic(source.getAccessRestrictionIsMetadataPublic());
        this.setAccessRestrictionClosureYear(source.getAccessRestrictionClosureYear());
        this.setUsagePermission(source.getUsagePermission());
        this.setUsagePermissionExpiringDate(source.getUsagePermissionExpiringDate());
        this.setRetentionPolicy(source.getRetentionPolicy());
        this.setRetentionPeriodBaseYear(source.getRetentionPeriodBaseYear());
        this.setArchivalHistory(source.getArchivalHistory());
        this.setSourceType(source.getSourceType());
        this.setModeOfAcquisition(source.getModeOfAcquisition());
        this.setObjectType(source.getObjectType());
        this.setConditionsOfReproductions(source.getConditionsOfReproductions());
        this.setCharacteristics(source.getCharacteristics());
        this.setFindingAids(source.getFindingAids());
        this.setLocationOfOriginals(source.getLocationOfOriginals());
        this.setReproductions(source.getReproductions());
        this.setRelatedMaterial(source.getRelatedMaterial());
        this.setRelatedMaterialExtern(source.getRelatedMaterialExtern());
        this.setInstitution(source.getInstitution());
        this.setAppraisalAndDestruction(source.getAppraisalAndDestruction());
        this.setArrangement(source.getArrangement());
        this.setBibliography(source.getBibliography());
        this.setDescriptionLevel(source.getDescriptionLevel());
        this.setDescriptionLevelNotes(source.getDescriptionLevelNotes());
        this.setDescriptionRules(source.getDescriptionRules());
        this.setRevisions(source.getRevisions());
        this.setDigitization(source.getDigitization());
        this.setResponsible(source.getResponsible());
        this.setInvolved(source.getInvolved());
        this.setStaff(source.getStaff());
        this.setProjectName(source.getProjectName());
        this.setProjectTitle(source.getProjectTitle());
        this.setProject(source.getProject());
        this.setProjectAbbreviation(source.getProjectAbbreviation());
        this.setLocation(source.getLocation());
        this.setJournal(source.getJournal());
        this.setUniversity(source.getUniversity());
        this.setInstitute(source.getInstitute());
        this.setCompartment(source.getCompartment());
        this.setMethod(source.getMethod());
        this.setKeyword(source.getKeyword());
        this.setFundingSource(source.getFundingSource());
        this.setStatus(source.getStatus());
        this.setPublisher(source.getPublisher());
        this.setEditor(source.getEditor());
        this.setAuthorGeneric(source.getAuthorGeneric());
        this.setDesigner(source.getDesigner());
        this.setPhotographer(source.getPhotographer());
        this.setIllustrator(source.getIllustrator());
        this.setTypeOfAcquisition(source.getTypeOfAcquisition());
        this.setDoiJournal(source.getDoiJournal());
        this.setRetentionPeriod(source.getRetentionPeriod());
        this.setUsage(source.getUsage());
        this.setEvent(source.getEvent());
        this.setBiographicalHistory(source.getBiographicalHistory());
        this.setFirstname(source.getFirstname());
        this.setLastname(source.getLastname());
        this.setDateOfBirth(source.getDateOfBirth());
        this.setNationality(source.getNationality());
        this.setSex(source.getSex());
        this.setDeathOfAuthor(source.getDeathOfAuthor());
        this.setAccruals(source.getAccruals());
        this.setCharacteristicsNote(source.getCharacteristicsNote());
        this.setSubject(source.getSubject());
        this.setUnitTitle(source.getUnitTitle());
        this.setUnitTitleAdditional(source.getUnitTitleAdditional());
        this.setOrigination(source.getOrigination());
        this.setOriginationAgency(source.getOriginationAgency());
        this.setOriginationDepartment(source.getOriginationDepartment());
        this.setCreationPeriod(source.getCreationPeriod());
        this.setCreationPeriodNotes(source.getCreationPeriodNotes());
        this.setFrom(source.getFrom());
        this.setFromYear(source.getFromYear());
        this.setTo(source.getTo());
        this.setToYear(source.getToYear());
        this.setRelationPeriod(source.getRelationPeriod());
        this.setLanguage(source.getLanguage());
        this.setLanguageNotes(source.getLanguageNotes());
        this.setRefCode(source.getRefCode());
        this.setRefCodeOld(source.getRefCodeOld());
        this.setRefCodeAdmin(source.getRefCodeAdmin());
        this.setRefCodeIsVisible(source.getRefCodeIsVisible());
        this.setRefCodeSeparator(source.getRefCodeSeparator());
        this.setPublication(source.getPublication());
        this.setEdition(source.getEdition());
        this.setInvalid(source.getInvalid());
        this.setLetter(source.getLetter());
        this.setAccessionNumber(source.getAccessionNumber());
        this.setExtent(source.getExtent());
        this.setExtentUnit(source.getExtentUnit());
        this.setExtentNote(source.getExtentNote());
        this.setExtentPrint(source.getExtentPrint());
        this.setMaterial(source.getMaterial());
        this.setYear(source.getYear());
        this.setAbstract(source.getAbstract());
        this.setCartographicMaterial(source.getCartographicMaterial());
        this.setScale(source.getScale());
        this.setCodeLocation(source.getCodeLocation());
        this.setCreator(source.getCreator());
        this.setDimensions(source.getDimensions());
        this.setDimensionsCategory(source.getDimensionsCategory());
        this.setDOI(source.getDOI());
        this.setEditionStatement(source.getEditionStatement());
        this.setFullLocation(source.getFullLocation());
        this.setGeogName(source.getGeogName());
        this.setInstitutionCreator(source.getInstitutionCreator());
        this.setInstitutionInvolved(source.getInstitutionInvolved());
        this.setFamilyName(source.getFamilyName());
        this.setFunction(source.getFunction());
        this.setOccupation(source.getOccupation());
        this.setISBN(source.getISBN());
        this.setISSN(source.getISSN());
        this.setPlaceOfPublication(source.getPlaceOfPublication());
        this.setSubjectGeneral(source.getSubjectGeneral());
        this.setUniformTitle(source.getUniformTitle());
        this.setUnitTitleVarying(source.getUnitTitleVarying());
        this.setFormat(source.getFormat());
        this.setSize(source.getSize());
        this.setDate(source.getDate());
        this.setUnitTitleOriginal(source.getUnitTitleOriginal());
        this.setFilePlanPosition(source.getFilePlanPosition());
    }

    public DID getDid() {
        return this.did;
    }

    public List<C> getCs() {
        return this.cs;
    }

    public C getC(int i) {
        return this.cs.get(i);
    }

    public String getOtherLevelName() {
        return this.otherLevel.getName();
    }

    public void setOtherLevelName(String newLevel) {
        this.setOtherLevel(this.document.getLevels().get(newLevel));
    }

    public LevelOfDescription getOtherLevel() {
        return this.otherLevel;
    }

    public void setOtherLevel(LevelOfDescription level) {
        this.otherLevel = level;
        this.element.addAttribute(Level, this.otherLevel.getName());
        this.document.setIsModified();
    }

    public String getUnitTitle() {
        return this.did.getUnitTitle();
    }

    public void setUnitTitle(String unitTitle) {
        this.did.setUnitTitle(unitTitle);
    }

    public NodeAbstract.SubmitStatus getSubmitStatus() {
        if (this.submitStatus == null) {
            return NodeAbstract.SubmitStatus.SubmitUndefined;
        }
        return this.submitStatus;
    }

    public void setSubmitStatus(NodeAbstract.SubmitStatus submitStatus) {
        if (submitStatus == null) {
            submitStatus = NodeAbstract.SubmitStatus.SubmitUndefined;
        }
        this.submitStatus = submitStatus;
        Node submitStatusNode = this.element.selectSingleNode(XPathSubmitStatus);
        if (submitStatusNode == null) {
            Element controlAccessNode = (Element)this.element.selectSingleNode("EAD:controlaccess");
            if (controlAccessNode == null) {
                controlAccessNode = this.element.addElement("EAD:controlaccess");
            }
            submitStatusNode = controlAccessNode.addElement("EAD:name").addAttribute("role", "submitStatus");
        }
        submitStatusNode.setText(this.submitStatus.name());
        this.document.setIsModified();
    }

    public List<String> getPID() {
        return this.pid;
    }

    public void setPID(List<String> values) {
        this.pid = values;
        for (Object node : this.element.selectNodes(XPathPID)) {
            ((Node)node).detach();
        }
        if (values != null) {
            for (String pid : values) {
                this.element.addElement("EAD:dao").addAttribute(new QName("role", new Namespace("xlink", Xmlns_xlink)), Role).addAttribute(new QName("href", new Namespace("xlink", Xmlns_xlink)), pid);
            }
        }
        this.document.setIsModified();
    }

    public List<String> getUnitTitleAdditional() {
        return this.did.getUnitTitleAdditional();
    }

    public void setUnitTitleAdditional(List<String> s) {
        this.did.setUnitTitleAdditional(s);
    }

    public List<String> getAuthor() {
        return this.author;
    }

    public void setAuthor(List<String> s) {
        this.author = s;
        this.setDynamicElementTexts(this.author, XPathAuthor);
        if (this.author == null) {
            this.deleteParentElementIfEmpty(XPathAuthor);
        }
        this.document.setIsModified();
    }

    public List<String> getComment() {
        return this.comment;
    }

    public void setComment(List<String> values) {
        this.comment = values;
        this.setDynamicElementTexts(this.comment, XPathComment);
        if (this.comment == null) {
            this.deleteParentElementIfEmpty(XPathComment);
        }
        this.document.setIsModified();
    }

    public List<String> getAccessNr() {
        return this.accessNr;
    }

    public void setAccessNr(List<String> values) {
        this.accessNr = values;
        this.setDynamicElementTexts(this.accessNr, XPathAccessNr);
        if (this.accessNr == null) {
            this.deleteParentElementIfEmpty(XPathAccessNr);
        }
        this.document.setIsModified();
    }

    public List<String> getOrigination() {
        return this.did.getOrigination();
    }

    public void setOrigination(List<String> s) {
        this.did.setOrigination(s);
    }

    public List<String> getOriginationAgency() {
        return this.did.getOriginationAgency();
    }

    public void setOriginationAgency(List<String> s) {
        this.did.setOriginationAgency(s);
    }

    public List<String> getOriginationDepartment() {
        return this.did.getOriginationDepartment();
    }

    public void setOriginationDepartment(List<String> s) {
        this.did.setOriginationDepartment(s);
    }

    public List<String> getCreationPeriod() {
        return this.did.getCreationPeriod();
    }

    public void setCreationPeriod(List<String> s) {
        this.did.setCreationPeriod(s);
    }

    public List<String> getCreationPeriodNotes() {
        return this.did.getCreationPeriodNotes();
    }

    public void setCreationPeriodNotes(List<String> s) {
        this.did.setCreationPeriodNotes(s);
    }

    public List<String> getFromYear() {
        return this.did.getFromYear();
    }

    public void setFromYear(List<String> s) {
        this.did.setFromYear(s);
    }

    public List<String> getToYear() {
        return this.did.getToYear();
    }

    public void setToYear(List<String> s) {
        this.did.setToYear(s);
    }

    public List<String> getFrom() {
        return this.did.getFrom();
    }

    public void setFrom(List<String> from) {
        this.did.setFrom(from);
    }

    public List<String> getTo() {
        return this.did.getTo();
    }

    public void setTo(List<String> to) {
        this.did.setTo(to);
    }

    public List<String> getRelationPeriod() {
        return this.did.getRelationPeriod();
    }

    public void setRelationPeriod(List<String> s) {
        this.did.setRelationPeriod(s);
    }

    public List<String> getScopeContent() {
        return this.scopeContent;
    }

    public void setScopeContent(List<String> values) {
        this.scopeContent = values;
        this.setDynamicElementTexts(this.scopeContent, XPathScopeContent);
        if (this.scopeContent == null) {
            this.deleteParentElementIfEmpty(XPathScopeContent);
        }
        this.document.setIsModified();
    }

    public List<String> getLanguage() {
        return this.did.getLanguage();
    }

    public void setLanguage(List<String> s) {
        this.did.setLanguage(s);
    }

    public List<String> getLanguageNotes() {
        return this.did.getLanguageNotes();
    }

    public void setLanguageNotes(List<String> s) {
        this.did.setLanguageNotes(s);
    }

    public List<String> getAccessPolicy() {
        return this.accessPolicy;
    }

    public void setAccessPolicy(List<String> values) {
        this.accessPolicy = values;
        this.setDynamicElementTexts(this.accessPolicy, XPathAccessPolicy);
        if (this.accessPolicy == null) {
            this.deleteParentElementIfEmpty(XPathAccessPolicy);
        }
        this.document.setIsModified();
    }

    public List<String> getAccessRestriction() {
        return this.accessRestriction;
    }

    public void setAccessRestriction(List<String> values) {
        this.accessRestriction = values;
        this.setDynamicElementTexts(this.accessRestriction, XPathAccessRestriction);
        if (this.accessRestriction == null) {
            this.deleteParentElementIfEmpty(XPathAccessRestriction);
        }
        this.document.setIsModified();
    }

    public List<String> getAccessRestrictionExplanation() {
        return this.accessRestrictionExplanation;
    }

    public void setAccessRestrictionExplanation(List<String> values) {
        this.accessRestrictionExplanation = values;
        this.setDynamicElementTexts(this.accessRestrictionExplanation, XPathAccessRestrictionExplanation);
        if (this.accessRestrictionExplanation == null) {
            this.deleteParentElementIfEmpty(XPathAccessRestrictionExplanation);
        }
        this.document.setIsModified();
    }

    public List<String> getAccessRestrictionPeriod() {
        return this.accessRestrictionPeriod;
    }

    public void setAccessRestrictionPeriod(List<String> values) {
        this.accessRestrictionPeriod = values;
        this.setDynamicElementTexts(this.accessRestrictionPeriod, XPathAccessRestrictionPeriod);
        if (this.accessRestrictionPeriod == null) {
            this.deleteParentElementIfEmpty(XPathAccessRestrictionPeriod);
        }
        this.document.setIsModified();
    }

    public List<String> getAccessRestrictionPeriodBaseYear() {
        return this.accessRestrictionPeriodBaseYear;
    }

    public void setAccessRestrictionPeriodBaseYear(List<String> values) {
        this.accessRestrictionPeriodBaseYear = values;
        this.setDynamicElementTexts(this.accessRestrictionPeriodBaseYear, XPathAccessRestrictionPeriodBaseYear);
        if (this.accessRestrictionPeriodBaseYear == null) {
            this.deleteParentElementIfEmpty(XPathAccessRestrictionPeriodBaseYear);
        }
        this.document.setIsModified();
    }

    public List<String> getAccessRestrictionClassification() {
        return this.accessRestrictionClassification;
    }

    public void setAccessRestrictionClassification(List<String> values) {
        this.accessRestrictionClassification = values;
        this.setDynamicElementTexts(this.accessRestrictionClassification, XPathAccessRestrictionClassification);
        if (this.accessRestrictionClassification == null) {
            this.deleteParentElementIfEmpty(XPathAccessRestrictionClassification);
        }
        this.document.setIsModified();
    }

    public List<String> getAccessRestrictionPrivacy() {
        return this.accessRestrictionPrivacy;
    }

    public void setAccessRestrictionPrivacy(List<String> values) {
        this.accessRestrictionPrivacy = values;
        this.setDynamicElementTexts(this.accessRestrictionPrivacy, XPathAccessRestrictionPrivacy);
        if (this.accessRestrictionPrivacy == null) {
            this.deleteParentElementIfEmpty(XPathAccessRestrictionPrivacy);
        }
        this.document.setIsModified();
    }

    public List<String> getAccessRestrictionStatus() {
        return this.accessRestrictionStatus;
    }

    public void setAccessRestrictionStatus(List<String> values) {
        this.accessRestrictionStatus = values;
        this.setDynamicElementTexts(this.accessRestrictionStatus, XPathAccessRestrictionStatus);
        if (this.accessRestrictionStatus == null) {
            this.deleteParentElementIfEmpty(XPathAccessRestrictionStatus);
        }
        this.document.setIsModified();
    }

    public List<String> getAccessRestrictionStatusExplanation() {
        return this.accessRestrictionStatusExplanation;
    }

    public void setAccessRestrictionStatusExplanation(List<String> values) {
        this.accessRestrictionStatusExplanation = values;
        this.setDynamicElementTexts(this.accessRestrictionStatusExplanation, XPathAccessRestrictionStatusExplanation);
        if (this.accessRestrictionStatusExplanation == null) {
            this.deleteParentElementIfEmpty(XPathAccessRestrictionStatusExplanation);
        }
        this.document.setIsModified();
    }

    public List<String> getAccessRestrictionIsPublic() {
        return this.accessRestrictionIsPublic;
    }

    public void setAccessRestrictionIsPublic(List<String> values) {
        this.accessRestrictionIsPublic = values;
        this.setDynamicElementTexts(this.accessRestrictionIsPublic, XPathAccessRestrictionIsPublic);
        if (this.accessRestrictionIsPublic == null) {
            this.deleteParentElementIfEmpty(XPathAccessRestrictionIsPublic);
        }
        this.document.setIsModified();
    }

    public List<String> getAccessRestrictionIsMetadataPublic() {
        return this.accessRestrictionIsMetadataPublic;
    }

    public void setAccessRestrictionIsMetadataPublic(List<String> values) {
        this.accessRestrictionIsMetadataPublic = values;
        this.setDynamicElementTexts(this.accessRestrictionIsMetadataPublic, XPathAccessRestrictionIsMetadataPublic);
        if (this.accessRestrictionIsMetadataPublic == null) {
            this.deleteParentElementIfEmpty(XPathAccessRestrictionIsMetadataPublic);
        }
        this.document.setIsModified();
    }

    public List<String> getAccessRestrictionClosureYear() {
        return this.accessRestrictionClosureYear;
    }

    public void setAccessRestrictionClosureYear(List<String> values) {
        this.accessRestrictionClosureYear = values;
        this.setDynamicElementTexts(this.accessRestrictionClosureYear, XPathAccessRestrictionClosureYear);
        if (this.accessRestrictionClosureYear == null) {
            this.deleteParentElementIfEmpty(XPathAccessRestrictionClosureYear);
        }
        this.document.setIsModified();
    }

    public List<String> getUsagePermission() {
        return this.usagePermission;
    }

    public void setUsagePermission(List<String> values) {
        this.usagePermission = values;
        this.setDynamicElementTexts(this.usagePermission, XPathUsagePermission);
        if (this.usagePermission == null) {
            this.deleteParentElementIfEmpty(XPathUsagePermission);
        }
        this.document.setIsModified();
    }

    public List<String> getUsagePermissionExpiringDate() {
        return this.usagePermissionExpiringDate;
    }

    public void setUsagePermissionExpiringDate(List<String> values) {
        this.usagePermissionExpiringDate = values;
        this.setDynamicElementTexts(this.usagePermissionExpiringDate, XPathUsagePermissionExpiringDate);
        if (this.usagePermissionExpiringDate == null) {
            this.deleteParentElementIfEmpty(XPathUsagePermissionExpiringDate);
        }
        this.document.setIsModified();
    }

    public List<String> getRetentionPolicy() {
        return this.retentionPolicy;
    }

    public void setRetentionPolicy(List<String> retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
        this.setDynamicElementTexts(this.retentionPolicy, XPathRetentionPolicy);
        if (this.retentionPolicy == null) {
            this.deleteParentElementIfEmpty(XPathRetentionPolicy);
        }
        this.document.setIsModified();
    }

    public List<String> getRetentionPeriodBaseYear() {
        return this.retentionPeriodBaseYear;
    }

    public void setRetentionPeriodBaseYear(List<String> retentionPeriodBaseYear) {
        this.retentionPeriodBaseYear = retentionPeriodBaseYear;
        this.setDynamicElementTexts(this.retentionPeriodBaseYear, XPathRetentionPeriodBaseYear);
        if (this.retentionPeriodBaseYear == null) {
            this.deleteParentElementIfEmpty(XPathRetentionPeriodBaseYear);
        }
        this.document.setIsModified();
    }

    public List<String> getArchivalHistory() {
        return this.archivalHistory;
    }

    public void setArchivalHistory(List<String> values) {
        this.archivalHistory = values;
        this.setDynamicElementTexts(this.archivalHistory, XPathArchivalHistory);
        if (this.archivalHistory == null) {
            this.deleteParentElementIfEmpty(XPathArchivalHistory);
        }
        this.document.setIsModified();
    }

    public List<String> getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(List<String> values) {
        this.sourceType = values;
        this.setDynamicElementTexts(this.sourceType, XPathSourceType);
        if (this.sourceType == null) {
            this.deleteParentElementIfEmpty(XPathSourceType);
        }
        this.document.setIsModified();
    }

    public List<String> getModeOfAcquisition() {
        return this.modeOfAcquisition;
    }

    public void setModeOfAcquisition(List<String> values) {
        this.modeOfAcquisition = values;
        this.setDynamicElementTexts(this.modeOfAcquisition, XPathModeOfAcquisition);
        if (this.modeOfAcquisition == null) {
            this.deleteParentElementIfEmpty(XPathModeOfAcquisition);
        }
        this.document.setIsModified();
    }

    public List<String> getObjectType() {
        return this.objectType;
    }

    public void setObjectType(List<String> objectType) {
        this.objectType = objectType;
        this.setDynamicElementTexts(this.objectType, XPathObjectType);
        if (this.objectType == null) {
            this.deleteParentElementIfEmpty(XPathObjectType);
        }
        this.document.setIsModified();
    }

    public List<String> getRefCode() {
        return this.did.getRefCode();
    }

    public void setRefCode(List<String> refCode) {
        this.did.setRefCode(refCode);
    }

    public List<String> getRefCodeOld() {
        return this.did.getRefCodeOld();
    }

    public void setRefCodeOld(List<String> refCodeOld) {
        this.did.setRefCodeOld(refCodeOld);
    }

    public List<String> getRefCodeAdmin() {
        return this.did.getRefCodeAdmin();
    }

    public void setRefCodeAdmin(List<String> refCodeAdmin) {
        this.did.setRefCodeAdmin(refCodeAdmin);
    }

    public List<String> getRefCodeIsVisible() {
        return this.did.getRefCodeIsVisible();
    }

    public void setRefCodeIsVisible(List<String> refCodeIsVisible) {
        this.did.setRefCodeIsVisible(refCodeIsVisible);
    }

    public List<String> getRefCodeSeparator() {
        return this.did.getRefCodeSeparator();
    }

    public void setRefCodeSeparator(List<String> refCodeSeparator) {
        this.did.setRefCodeSeparator(refCodeSeparator);
    }

    public List<String> getAccessionNumber() {
        return this.did.getAccessionNumber();
    }

    public void setAccessionNumber(List<String> accessionNumber) {
        this.did.setAccessionNumber(accessionNumber);
    }

    public List<String> getExtent() {
        return this.did.getExtent();
    }

    public void setExtent(List<String> extent) {
        this.did.setExtent(extent);
    }

    public List<String> getExtentNote() {
        return this.did.getExtentNote();
    }

    public void setExtentNote(List<String> extentNote) {
        this.did.setExtentNote(extentNote);
    }

    public List<String> getExtentPrint() {
        return this.did.getExtentPrint();
    }

    public void setExtentPrint(List<String> extentPrint) {
        this.did.setExtentPrint(extentPrint);
    }

    public List<String> getExtentUnit() {
        return this.did.getExtentUnit();
    }

    public void setExtentUnit(List<String> extentUnit) {
        this.did.setExtentUnit(extentUnit);
    }

    public List<String> getMaterial() {
        return this.did.getMaterial();
    }

    public void setMaterial(List<String> material) {
        this.did.setMaterial(material);
    }

    public List<String> getConditionsOfReproductions() {
        return this.conditionsOfReproductions;
    }

    public void setConditionsOfReproductions(List<String> values) {
        this.conditionsOfReproductions = values;
        this.setDynamicElementTexts(this.conditionsOfReproductions, XPathConditionsOfReproductions);
        if (this.conditionsOfReproductions == null) {
            this.deleteParentElementIfEmpty(XPathConditionsOfReproductions);
        }
        this.document.setIsModified();
    }

    public List<String> getCharacteristics() {
        return this.characteristics;
    }

    public void setCharacteristics(List<String> values) {
        this.characteristics = values;
        this.setDynamicElementTexts(this.characteristics, XPathCharacteristics);
        if (this.characteristics == null) {
            this.deleteParentElementIfEmpty(XPathCharacteristics);
        }
        this.document.setIsModified();
    }

    public List<String> getFindingAids() {
        return this.findingAids;
    }

    public void setFindingAids(List<String> values) {
        this.findingAids = values;
        this.setDynamicElementTexts(this.findingAids, XPathFindingAids);
        if (this.findingAids == null) {
            this.deleteParentElementIfEmpty(XPathFindingAids);
        }
        this.document.setIsModified();
    }

    public List<String> getLocationOfOriginals() {
        return this.locationOfOriginals;
    }

    public void setLocationOfOriginals(List<String> values) {
        this.locationOfOriginals = values;
        this.setDynamicElementTexts(this.locationOfOriginals, XPathLocationOfOriginals);
        if (this.locationOfOriginals == null) {
            this.deleteParentElementIfEmpty(XPathLocationOfOriginals);
        }
        this.document.setIsModified();
    }

    public List<String> getReproductions() {
        return this.reproductions;
    }

    public void setReproductions(List<String> values) {
        this.reproductions = values;
        this.setDynamicElementTexts(this.reproductions, XPathReproductions);
        if (this.reproductions == null) {
            this.deleteParentElementIfEmpty(XPathReproductions);
        }
        this.document.setIsModified();
    }

    public List<String> getRelatedMaterial() {
        return this.relatedMaterial;
    }

    public void setRelatedMaterial(List<String> values) {
        this.relatedMaterial = values;
        this.setDynamicElementTexts(this.relatedMaterial, XPathRelatedMaterial);
        if (this.relatedMaterial == null) {
            this.deleteParentElementIfEmpty(XPathRelatedMaterial);
        }
        this.document.setIsModified();
    }

    public List<String> getRelatedMaterialExtern() {
        return this.relatedMaterialExtern;
    }

    public void setRelatedMaterialExtern(List<String> relatedMaterialExtern) {
        this.relatedMaterialExtern = relatedMaterialExtern;
        this.setDynamicElementTexts(this.relatedMaterialExtern, XPathRelatedMaterialExtern);
        if (this.relatedMaterialExtern == null) {
            this.deleteParentElementIfEmpty(XPathRelatedMaterialExtern);
        }
        this.document.setIsModified();
    }

    public List<String> getInstitution() {
        return this.institution;
    }

    public void setInstitution(List<String> institution) {
        this.institution = institution;
        this.setDynamicElementTexts(this.institution, XPathInstitution);
        if (this.institution == null) {
            this.deleteParentElementIfEmpty(XPathInstitution);
        }
        this.document.setIsModified();
    }

    public List<String> getAppraisalAndDestruction() {
        return this.appraisalAndDestruction;
    }

    public void setAppraisalAndDestruction(List<String> values) {
        this.appraisalAndDestruction = values;
        this.setDynamicElementTexts(this.appraisalAndDestruction, XPathAppraisalAndDestruction);
        if (this.appraisalAndDestruction == null) {
            this.deleteParentElementIfEmpty(XPathAppraisalAndDestruction);
        }
        this.document.setIsModified();
    }

    public List<String> getAppraisalIsOnHold() {
        return this.appraisalIsOnHold;
    }

    public void setAppraisalIsOnHold(List<String> values) {
        this.appraisalIsOnHold = values;
        this.setDynamicElementTexts(this.appraisalIsOnHold, XPathAppraisalIsOnHold);
        if (this.appraisalIsOnHold == null) {
            this.deleteParentElementIfEmpty(XPathAppraisalIsOnHold);
        }
        this.document.setIsModified();
    }

    public List<String> getAppraisalDateDisposed() {
        return this.appraisalDateDisposed;
    }

    public void setAppraisalDateDisposed(List<String> values) {
        this.appraisalDateDisposed = values;
        this.setDynamicElementTexts(this.appraisalDateDisposed, XPathAppraisalDateDisposed);
        if (this.appraisalDateDisposed == null) {
            this.deleteParentElementIfEmpty(XPathAppraisalDateDisposed);
        }
        this.document.setIsModified();
    }

    public List<String> getAppraisalRetentionPeriod() {
        return this.appraisalRetentionPeriod;
    }

    public void setAppraisalRetentionPeriod(List<String> values) {
        this.appraisalRetentionPeriod = values;
        this.setDynamicElementTexts(this.appraisalRetentionPeriod, XPathAppraisalRetentionPeriod);
        if (this.appraisalRetentionPeriod == null) {
            this.deleteParentElementIfEmpty(XPathAppraisalRetentionPeriod);
        }
        this.document.setIsModified();
    }

    public List<String> getArrangement() {
        return this.arrangement;
    }

    public void setArrangement(List<String> values) {
        this.arrangement = values;
        this.setDynamicElementTexts(this.arrangement, XPathArrangement);
        if (this.arrangement == null) {
            this.deleteParentElementIfEmpty(XPathArrangement);
        }
        this.document.setIsModified();
    }

    public List<String> getBibliography() {
        return this.bibliography;
    }

    public void setBibliography(List<String> values) {
        this.bibliography = values;
        this.setDynamicElementTexts(this.bibliography, XPathBibliography);
        if (this.bibliography == null) {
            this.deleteParentElementIfEmpty(XPathBibliography);
        }
        this.document.setIsModified();
    }

    public List<String> getDescriptionLevel() {
        return this.descriptionLevel;
    }

    public void setDescriptionLevel(List<String> descriptionLevel) {
        this.descriptionLevel = descriptionLevel;
        this.setDynamicElementTexts(this.descriptionLevel, XPathDescriptionLevel);
        if (this.descriptionLevel == null) {
            this.deleteParentElementIfEmpty(XPathDescriptionLevel);
        }
        this.document.setIsModified();
    }

    public List<String> getDescriptionLevelNotes() {
        return this.descriptionLevelNotes;
    }

    public void setDescriptionLevelNotes(List<String> values) {
        this.descriptionLevelNotes = values;
        this.setDynamicElementTexts(this.descriptionLevelNotes, XPathDescriptionLevelNotes);
        if (this.descriptionLevelNotes == null) {
            this.deleteParentElementIfEmpty(XPathDescriptionLevelNotes);
        }
        this.document.setIsModified();
    }

    public List<String> getDescriptionRules() {
        return this.descriptionRules;
    }

    public void setDescriptionRules(List<String> values) {
        this.descriptionRules = values;
        this.setDynamicElementTexts(this.descriptionRules, XPathDescriptionRules);
        if (this.descriptionRules == null) {
            this.deleteParentElementIfEmpty(XPathDescriptionRules);
        }
        this.document.setIsModified();
    }

    public List<String> getProcessInfoArchivist() {
        return this.processInfoArchivist;
    }

    public void setProcessInfoArchivist(List<String> values) {
        this.processInfoArchivist = values;
        this.setDynamicElementTexts(this.processInfoArchivist, XPathProcessInfoArchivist);
        if (this.processInfoArchivist == null) {
            this.deleteParentElementIfEmpty(XPathProcessInfoArchivist);
        }
        this.document.setIsModified();
    }

    public List<String> getProcessInfoDate() {
        return this.processInfoDate;
    }

    public void setProcessInfoDate(List<String> values) {
        this.processInfoDate = values;
        this.setDynamicElementTexts(this.processInfoDate, XPathProcessInfoDate);
        if (this.processInfoDate == null) {
            this.deleteParentElementIfEmpty(XPathProcessInfoDate);
        }
        this.document.setIsModified();
    }

    public List<String> getRevisions() {
        return this.revisions;
    }

    public void setRevisions(List<String> revisions) {
        this.revisions = revisions;
        this.setDynamicElementTexts(this.revisions, XPathRevisions);
        if (this.revisions == null) {
            this.deleteParentElementIfEmpty(XPathRevisions);
        }
        this.document.setIsModified();
    }

    public List<String> getDigitization() {
        return this.digitization;
    }

    public void setDigitization(List<String> value) {
        this.digitization = value;
        this.setDynamicElementTexts(this.digitization, XPathDigitization);
        if (this.digitization == null) {
            this.deleteParentElementIfEmpty(XPathDigitization);
        }
        this.document.setIsModified();
    }

    public List<String> getResponsible() {
        return this.responsible;
    }

    public void setResponsible(List<String> responsible) {
        this.responsible = responsible;
        this.setDynamicElementTexts(this.responsible, XPathResponsible);
        if (this.responsible == null) {
            this.deleteParentElementIfEmpty(XPathResponsible);
        }
        this.document.setIsModified();
    }

    public List<String> getInvolved() {
        return this.involved;
    }

    public void setInvolved(List<String> involved) {
        this.involved = involved;
        this.setDynamicElementTexts(this.involved, XPathInvolved);
        if (this.involved == null) {
            this.deleteParentElementIfEmpty(XPathInvolved);
        }
        this.document.setIsModified();
    }

    public List<String> getStaff() {
        return this.staff;
    }

    public void setStaff(List<String> staff) {
        this.staff = staff;
        this.setDynamicElementTexts(this.staff, XPathStaff);
        if (this.staff == null) {
            this.deleteParentElementIfEmpty(XPathStaff);
        }
        this.document.setIsModified();
    }

    public List<String> getProjectName() {
        return this.projectName;
    }

    public void setProjectName(List<String> projectName) {
        this.projectName = projectName;
        this.setDynamicElementTexts(this.projectName, XPathProjectName);
        if (this.projectName == null) {
            this.deleteParentElementIfEmpty(XPathProjectName);
        }
        this.document.setIsModified();
    }

    public List<String> getProjectTitle() {
        return this.projectTitle;
    }

    public void setProjectTitle(List<String> projectTitle) {
        this.projectTitle = projectTitle;
        this.setDynamicElementTexts(this.projectTitle, XPathProjectTitle);
        if (this.projectTitle == null) {
            this.deleteParentElementIfEmpty(XPathProjectTitle);
        }
        this.document.setIsModified();
    }

    public List<String> getProject() {
        return this.project;
    }

    public void setProject(List<String> project) {
        this.project = project;
        this.setDynamicElementTexts(this.project, XPathProject);
        if (this.project == null) {
            this.deleteParentElementIfEmpty(XPathProject);
        }
        this.document.setIsModified();
    }

    public List<String> getProjectAbbreviation() {
        return this.projectAbbreviation;
    }

    public void setProjectAbbreviation(List<String> projectAbbreviation) {
        this.projectAbbreviation = projectAbbreviation;
        this.setDynamicElementTexts(this.projectAbbreviation, XPathProjectAbbreviation);
        if (this.projectAbbreviation == null) {
            this.deleteParentElementIfEmpty(XPathProjectAbbreviation);
        }
        this.document.setIsModified();
    }

    public List<String> getLocation() {
        return this.location;
    }

    public void setLocation(List<String> location) {
        this.location = location;
        this.setDynamicElementTexts(this.location, XPathLocation);
        if (this.location == null) {
            this.deleteParentElementIfEmpty(XPathLocation);
        }
        this.document.setIsModified();
    }

    public List<String> getJournal() {
        return this.journal;
    }

    public void setJournal(List<String> journal) {
        this.journal = journal;
        this.setDynamicElementTexts(this.journal, XPathJournal);
        if (this.journal == null) {
            this.deleteParentElementIfEmpty(XPathJournal);
        }
        this.document.setIsModified();
    }

    public List<String> getUniversity() {
        return this.university;
    }

    public void setUniversity(List<String> university) {
        this.university = university;
        this.setDynamicElementTexts(this.university, XPathUniversity);
        if (this.university == null) {
            this.deleteParentElementIfEmpty(XPathUniversity);
        }
        this.document.setIsModified();
    }

    public List<String> getInstitute() {
        return this.institute;
    }

    public void setInstitute(List<String> institute) {
        this.institute = institute;
        this.setDynamicElementTexts(this.institute, XPathInstitute);
        if (this.institute == null) {
            this.deleteParentElementIfEmpty(XPathInstitute);
        }
        this.document.setIsModified();
    }

    public List<String> getCompartment() {
        return this.compartment;
    }

    public void setCompartment(List<String> compartment) {
        this.compartment = compartment;
        this.setDynamicElementTexts(this.compartment, XPathCompartment);
        if (this.compartment == null) {
            this.deleteParentElementIfEmpty(XPathCompartment);
        }
        this.document.setIsModified();
    }

    public List<String> getMethod() {
        return this.method;
    }

    public void setMethod(List<String> method) {
        this.method = method;
        this.setDynamicElementTexts(this.method, XPathMethod);
        if (this.method == null) {
            this.deleteParentElementIfEmpty(XPathMethod);
        }
        this.document.setIsModified();
    }

    public List<String> getYear() {
        return this.did.getYear();
    }

    public void setYear(List<String> year) {
        this.did.setYear(year);
    }

    public List<String> getKeyword() {
        return this.keyword;
    }

    public void setKeyword(List<String> keyword) {
        this.keyword = keyword;
        this.setDynamicElementTexts(this.keyword, XPathKeyword);
        if (this.keyword == null) {
            this.deleteParentElementIfEmpty(XPathKeyword);
        }
        this.document.setIsModified();
    }

    public List<String> getFundingSource() {
        return this.fundingSource;
    }

    public void setFundingSource(List<String> fundingSource) {
        this.fundingSource = fundingSource;
        this.setDynamicElementTexts(this.fundingSource, XPathFundingSource);
        if (this.fundingSource == null) {
            this.deleteParentElementIfEmpty(XPathFundingSource);
        }
        this.document.setIsModified();
    }

    public List<String> getStatus() {
        return this.status;
    }

    public void setStatus(List<String> status) {
        this.status = status;
        this.setDynamicElementTexts(this.status, XPathStatus);
        if (this.status == null) {
            this.deleteParentElementIfEmpty(XPathStatus);
        }
        this.document.setIsModified();
    }

    public List<String> getPublisher() {
        return this.publisher;
    }

    public void setPublisher(List<String> publisher) {
        this.publisher = publisher;
        this.setDynamicElementTexts(this.publisher, XPathPublisher);
        if (this.publisher == null) {
            this.deleteParentElementIfEmpty(XPathPublisher);
        }
        this.document.setIsModified();
    }

    public List<String> getEditor() {
        return this.editor;
    }

    public void setEditor(List<String> editor) {
        this.editor = editor;
        this.setDynamicElementTexts(this.editor, XPathEditor);
        if (this.editor == null) {
            this.deleteParentElementIfEmpty(XPathEditor);
        }
        this.document.setIsModified();
    }

    public List<String> getAuthorGeneric() {
        return this.authorGeneric;
    }

    public void setAuthorGeneric(List<String> authorGeneric) {
        this.authorGeneric = authorGeneric;
        this.setDynamicElementTexts(this.authorGeneric, XPathAuthorGeneric);
        if (this.authorGeneric == null) {
            this.deleteParentElementIfEmpty(XPathAuthorGeneric);
        }
        this.document.setIsModified();
    }

    public List<String> getDesigner() {
        return this.designer;
    }

    public void setDesigner(List<String> designer) {
        this.designer = designer;
        this.setDynamicElementTexts(this.designer, XPathDesigner);
        if (this.designer == null) {
            this.deleteParentElementIfEmpty(XPathDesigner);
        }
        this.document.setIsModified();
    }

    public List<String> getPhotographer() {
        return this.photographer;
    }

    public void setPhotographer(List<String> photographer) {
        this.photographer = photographer;
        this.setDynamicElementTexts(this.photographer, XPathPhotographer);
        if (this.photographer == null) {
            this.deleteParentElementIfEmpty(XPathPhotographer);
        }
        this.document.setIsModified();
    }

    public List<String> getIllustrator() {
        return this.illustrator;
    }

    public void setIllustrator(List<String> illustrator) {
        this.illustrator = illustrator;
        this.setDynamicElementTexts(this.illustrator, XPathIllustrator);
        if (this.illustrator == null) {
            this.deleteParentElementIfEmpty(XPathIllustrator);
        }
        this.document.setIsModified();
    }

    public List<String> getTypeOfAcquisition() {
        return this.typeOfAcquisition;
    }

    public void setTypeOfAcquisition(List<String> typeOfAcquisition) {
        this.typeOfAcquisition = typeOfAcquisition;
        this.setDynamicElementTexts(this.typeOfAcquisition, XPathTypeOfAcquisition);
        if (this.typeOfAcquisition == null) {
            this.deleteParentElementIfEmpty(XPathTypeOfAcquisition);
        }
        this.document.setIsModified();
    }

    public List<String> getAbstract() {
        return this.did.getAbstract();
    }

    public void setAbstract(List<String> abstract_) {
        this.did.setAbstract(abstract_);
    }

    public List<String> getDoiJournal() {
        return this.doiJournal;
    }

    public void setDoiJournal(List<String> doiJournal) {
        this.doiJournal = doiJournal;
        this.setDynamicElementTexts(this.doiJournal, XPathDOIJournal);
        if (this.doiJournal == null) {
            this.deleteParentElementIfEmpty(XPathDOIJournal);
        }
        this.document.setIsModified();
    }

    public List<String> getRetentionPeriod() {
        return this.retentionPeriod;
    }

    public void setRetentionPeriod(List<String> retentionPeriod) {
        this.retentionPeriod = retentionPeriod;
        this.setDynamicElementTexts(this.retentionPeriod, XPathRetentionPeriod);
        if (this.retentionPeriod == null) {
            this.deleteParentElementIfEmpty(XPathRetentionPeriod);
        }
        this.document.setIsModified();
    }

    public List<String> getUsage() {
        return this.usage;
    }

    public void setUsage(List<String> usage) {
        this.usage = usage;
        this.setDynamicElementTexts(this.usage, XPathUsage);
        if (this.usage == null) {
            this.deleteParentElementIfEmpty(XPathUsage);
        }
        this.document.setIsModified();
    }

    public List<String> getEvent() {
        return this.event;
    }

    public void setEvent(List<String> event) {
        this.event = event;
        this.setDynamicElementTexts(this.event, XPathEvent);
        if (this.event == null) {
            this.deleteParentElementIfEmpty(XPathEvent);
        }
        this.document.setIsModified();
    }

    public List<String> getBiographicalHistory() {
        return this.biographicalHistory;
    }

    public void setBiographicalHistory(List<String> values) {
        this.biographicalHistory = values;
        this.setDynamicElementTexts(this.biographicalHistory, XPathBiographicalHistory);
        if (this.biographicalHistory == null) {
            this.deleteParentElementIfEmpty(XPathBiographicalHistory);
        }
        this.document.setIsModified();
    }

    public List<String> getFirstname() {
        return this.firstname;
    }

    public void setFirstname(List<String> values) {
        this.firstname = values;
        this.setDynamicElementTexts(this.firstname, XPathFirstname);
        if (this.firstname == null) {
            this.deleteParentElementIfEmpty(XPathFirstname);
        }
        this.document.setIsModified();
    }

    public List<String> getLastname() {
        return this.lastname;
    }

    public void setLastname(List<String> values) {
        this.lastname = values;
        this.setDynamicElementTexts(this.lastname, XPathLastname);
        if (this.lastname == null) {
            this.deleteParentElementIfEmpty(XPathLastname);
        }
        this.document.setIsModified();
    }

    public List<String> getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(List<String> values) {
        this.dateOfBirth = values;
        this.setDynamicElementTexts(this.dateOfBirth, XPathDateOfBirth);
        if (this.dateOfBirth == null) {
            this.deleteParentElementIfEmpty(XPathDateOfBirth);
        }
        this.document.setIsModified();
    }

    public List<String> getNationality() {
        return this.nationality;
    }

    public void setNationality(List<String> values) {
        this.nationality = values;
        this.setDynamicElementTexts(this.nationality, XPathNationality);
        if (this.nationality == null) {
            this.deleteParentElementIfEmpty(XPathNationality);
        }
        this.document.setIsModified();
    }

    public List<String> getSex() {
        return this.sex;
    }

    public void setSex(List<String> values) {
        this.sex = values;
        this.setDynamicElementTexts(this.sex, XPathSex);
        if (this.sex == null) {
            this.deleteParentElementIfEmpty(XPathSex);
        }
        this.document.setIsModified();
    }

    public List<String> getDeathOfAuthor() {
        return this.deathOfAuthor;
    }

    public void setDeathOfAuthor(List<String> values) {
        this.deathOfAuthor = values;
        this.setDynamicElementTexts(this.deathOfAuthor, XPathDeathOfAuthor);
        if (this.deathOfAuthor == null) {
            this.deleteParentElementIfEmpty(XPathDeathOfAuthor);
        }
        this.document.setIsModified();
    }

    public List<String> getAccruals() {
        return this.accruals;
    }

    public void setAccruals(List<String> values) {
        this.accruals = values;
        this.setDynamicElementTexts(this.accruals, XPathAccruals);
        if (this.accruals == null) {
            this.deleteParentElementIfEmpty(XPathAccruals);
        }
        this.document.setIsModified();
    }

    public List<String> getCharacteristicsNote() {
        return this.characteristicsNote;
    }

    public void setCharacteristicsNote(List<String> values) {
        this.characteristicsNote = values;
        this.setDynamicElementTexts(this.characteristicsNote, XPathCharacteristicsNote);
        if (this.characteristicsNote == null) {
            this.deleteParentElementIfEmpty(XPathCharacteristicsNote);
        }
        this.document.setIsModified();
    }

    public List<String> getSubject() {
        return this.subject;
    }

    public void setSubject(List<String> values) {
        this.subject = values;
        this.setDynamicElementTexts(this.subject, XPathSubject);
        if (this.subject == null) {
            this.deleteParentElementIfEmpty(XPathSubject);
        }
        this.document.setIsModified();
    }

    public List<String> getCartographicMaterial() {
        return this.did.getCartographicMaterial();
    }

    public void setCartographicMaterial(List<String> cartographicMaterial) {
        this.did.setCartographicMaterial(cartographicMaterial);
    }

    public List<String> getScale() {
        return this.did.getScale();
    }

    public void setScale(List<String> scale) {
        this.did.setScale(scale);
    }

    public List<String> getCodeLocation() {
        return this.did.getCodeLocation();
    }

    public void setCodeLocation(List<String> codeLocation) {
        this.did.setCodeLocation(codeLocation);
    }

    public List<String> getCreator() {
        return this.creator;
    }

    public void setCreator(List<String> creator) {
        this.creator = creator;
        this.setDynamicElementTexts(this.creator, XPATH_CREATOR);
        if (this.creator == null) {
            this.deleteParentElementIfEmpty(XPATH_CREATOR);
        }
        this.document.setIsModified();
    }

    public List<String> getDimensions() {
        return this.did.getDimensions();
    }

    public void setDimensions(List<String> dimensions) {
        this.did.setDimensions(dimensions);
    }

    public List<String> getDimensionsCategory() {
        return this.did.getDimensionsCategory();
    }

    public void setDimensionsCategory(List<String> dimensionsCategory) {
        this.did.setDimensionsCategory(dimensionsCategory);
    }

    public List<String> getDOI() {
        return this.did.getDOI();
    }

    public void setDOI(List<String> doi) {
        this.did.setDOI(doi);
    }

    public List<String> getEditionStatement() {
        return this.editionStatement;
    }

    public void setEditionStatement(List<String> editionStatement) {
        this.editionStatement = editionStatement;
        this.setDynamicElementTexts(this.editionStatement, XPATH_EDITION_STATEMENT);
        if (this.editionStatement == null) {
            this.deleteParentElementIfEmpty(XPATH_EDITION_STATEMENT);
        }
        this.document.setIsModified();
    }

    public List<String> getFullLocation() {
        return this.did.getFullLocation();
    }

    public void setFullLocation(List<String> fullLocation) {
        this.did.setFullLocation(fullLocation);
    }

    public List<String> getGeogName() {
        return this.geogName;
    }

    public void setGeogName(List<String> geogName) {
        this.geogName = geogName;
        this.setDynamicElementTexts(this.geogName, XPATH_GEOG_NAME);
        if (this.geogName == null) {
            this.deleteParentElementIfEmpty(XPATH_GEOG_NAME);
        }
        this.document.setIsModified();
    }

    public List<String> getInstitutionCreator() {
        return this.institutionCreator;
    }

    public void setInstitutionCreator(List<String> institutionCreator) {
        this.institutionCreator = institutionCreator;
        this.setDynamicElementTexts(this.institutionCreator, XPATH_INSTITUTION_CREATOR);
        if (this.institutionCreator == null) {
            this.deleteParentElementIfEmpty(XPATH_INSTITUTION_CREATOR);
        }
        this.document.setIsModified();
    }

    public List<String> getInstitutionInvolved() {
        return this.institutionInvolved;
    }

    public void setInstitutionInvolved(List<String> institutionInvolved) {
        this.institutionInvolved = institutionInvolved;
        this.setDynamicElementTexts(this.institutionInvolved, XPATH_INSTITUTION_INVOLVED);
        if (this.institutionInvolved == null) {
            this.deleteParentElementIfEmpty(XPATH_INSTITUTION_INVOLVED);
        }
        this.document.setIsModified();
    }

    public List<String> getFamilyName() {
        return this.familyName;
    }

    public void setFamilyName(List<String> familyName) {
        this.familyName = familyName;
        this.setDynamicElementTexts(this.familyName, XPathFamilyName);
        if (this.familyName == null) {
            this.deleteParentElementIfEmpty(XPathFamilyName);
        }
        this.document.setIsModified();
    }

    public List<String> getFunction() {
        return this.function;
    }

    public void setFunction(List<String> function) {
        this.function = function;
        this.setDynamicElementTexts(this.function, XPathFunction);
        if (this.function == null) {
            this.deleteParentElementIfEmpty(XPathFunction);
        }
        this.document.setIsModified();
    }

    public List<String> getOccupation() {
        return this.occupation;
    }

    public void setOccupation(List<String> occupation) {
        this.occupation = occupation;
        this.setDynamicElementTexts(this.occupation, XPathOccupation);
        if (this.occupation == null) {
            this.deleteParentElementIfEmpty(XPathOccupation);
        }
        this.document.setIsModified();
    }

    public List<String> getISBN() {
        return this.did.getISBN();
    }

    public void setISBN(List<String> isbn) {
        this.did.setISBN(isbn);
    }

    public List<String> getISSN() {
        return this.did.getISSN();
    }

    public void setISSN(List<String> issn) {
        this.did.setISSN(issn);
    }

    public List<String> getPlaceOfPublication() {
        return this.placeOfPublication;
    }

    public void setPlaceOfPublication(List<String> placeOfPublication) {
        this.placeOfPublication = placeOfPublication;
        this.setDynamicElementTexts(this.placeOfPublication, XPATH_PLACE_OF_PUBLICATION);
        if (this.placeOfPublication == null) {
            this.deleteParentElementIfEmpty(XPATH_PLACE_OF_PUBLICATION);
        }
        this.document.setIsModified();
    }

    public List<String> getSubjectGeneral() {
        return this.subjectGeneral;
    }

    public void setSubjectGeneral(List<String> subjectGeneral) {
        this.subjectGeneral = subjectGeneral;
        this.setDynamicElementTexts(this.subjectGeneral, XPATH_SUBJECT_GENERAL);
        if (this.subjectGeneral == null) {
            this.deleteParentElementIfEmpty(XPATH_SUBJECT_GENERAL);
        }
        this.document.setIsModified();
    }

    public List<String> getUniformTitle() {
        return this.uniformTitle;
    }

    public void setUniformTitle(List<String> uniformTitle) {
        this.uniformTitle = uniformTitle;
        this.setDynamicElementTexts(this.uniformTitle, XPATH_UNIFORM_TITLE);
        if (this.uniformTitle == null) {
            this.deleteParentElementIfEmpty(XPATH_UNIFORM_TITLE);
        }
        this.document.setIsModified();
    }

    public List<String> getFilePlanPosition() {
        return this.filePlanPosition;
    }

    public void setFilePlanPosition(List<String> filePlanPosition) {
        this.filePlanPosition = filePlanPosition;
        this.setDynamicElementTexts(this.filePlanPosition, XPathFilePlanPosition);
        if (this.filePlanPosition == null) {
            this.deleteParentElementIfEmpty(XPathFilePlanPosition);
        }
        this.document.setIsModified();
    }

    public List<String> getUnitTitleVarying() {
        return this.did.getUnitTitleVarying();
    }

    public void setUnitTitleVarying(List<String> unitTitleVarying) {
        this.did.setUnitTitleVarying(unitTitleVarying);
    }

    public List<String> getFormat() {
        return this.did.getFormat();
    }

    public void setFormat(List<String> format) {
        this.did.setFormat(format);
    }

    public List<String> getSize() {
        return this.did.getSize();
    }

    public void setSize(List<String> size) {
        this.did.setSize(size);
    }

    public List<String> getDate() {
        return this.did.getDate();
    }

    public void setDate(List<String> date) {
        this.did.setDate(date);
    }

    public List<String> getUnitTitleOriginal() {
        return this.did.getUnitTitleOriginal();
    }

    public void setUnitTitleOriginal(List<String> unitTitleOriginal) {
        this.did.setUnitTitleOriginal(unitTitleOriginal);
    }

    public List<String> getPublication() {
        return this.did.getPublication();
    }

    public void setPublication(List<String> publication) {
        this.did.setPublication(publication);
    }

    public List<String> getEdition() {
        return this.did.getEdition();
    }

    public void setEdition(List<String> edition) {
        this.did.setEdition(edition);
    }

    public List<String> getInvalid() {
        return this.did.getInvalid();
    }

    public void setInvalid(List<String> invalid) {
        this.did.setInvalid(invalid);
    }

    public List<String> getLetter() {
        return this.did.getLetter();
    }

    public void setLetter(List<String> letter) {
        this.did.setLetter(letter);
    }

    public ComponentAbstract searchUnitTitle(String title) {
        if (this.did.getUnitTitle().equals(title)) {
            return this;
        }
        for (C c : this.cs) {
            ComponentAbstract found = c.searchUnitTitle(title);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public abstract void fillEADElementsFromNodeRecursively(ch.docuteam.darc.mets.structmap.NodeAbstract var1);

    protected String toString(String name) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.depth; ++i) {
            stringBuilder.append("\t");
        }
        stringBuilder.append("[" + name + "(").append(this.depth).append("):'").append(this.otherLevel).append("':").append(this.did);
        for (C c : this.cs) {
            stringBuilder.append("\n").append(c);
        }
        return stringBuilder.append("]").toString();
    }

    protected String toStringShort(String name) {
        return "[" + name + "(" + this.depth + "):'" + this.otherLevel + "':" + this.did + "]";
    }
}

