/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.mets.structmap;

import bsh.EvalError;
import ch.docuteam.darc.common.DocumentAbstract;
import ch.docuteam.darc.dc.OAI_DC;
import ch.docuteam.darc.exceptions.CantSetSubmitStatusNotAllowedException;
import ch.docuteam.darc.exceptions.CantSetSubmitStatusRecursiveException;
import ch.docuteam.darc.exceptions.FileAlreadyExistsException;
import ch.docuteam.darc.exceptions.FileOperationNotAllowedException;
import ch.docuteam.darc.exceptions.LevelMetadataElementIsReadOnly;
import ch.docuteam.darc.exceptions.MetadataElementAllowedValuesException;
import ch.docuteam.darc.exceptions.MetadataElementCantAddException;
import ch.docuteam.darc.exceptions.MetadataElementCantDeleteException;
import ch.docuteam.darc.exceptions.MetadataElementIsNotAllowedException;
import ch.docuteam.darc.exceptions.MetadataElementIsNotDefinedException;
import ch.docuteam.darc.exceptions.MetadataElementSetterPostActionException;
import ch.docuteam.darc.exceptions.MetadataElementValidatorException;
import ch.docuteam.darc.mdconfig.LevelMetadataElement;
import ch.docuteam.darc.mdconfig.LevelOfDescription;
import ch.docuteam.darc.mdconfig.MetadataElement;
import ch.docuteam.darc.mdconfig.MetadataElementInstance;
import ch.docuteam.darc.mets.Document;
import ch.docuteam.darc.mets.amdsec.DigiprovWithPremis;
import ch.docuteam.darc.mets.dmdsec.DMDSectionAbstract;
import ch.docuteam.darc.mets.dmdsec.DMDSectionWithEAD;
import ch.docuteam.darc.mets.dmdsec.DMDSectionWithOAI_DC;
import ch.docuteam.darc.mets.structmap.NodeFile;
import ch.docuteam.darc.mets.structmap.NodeFolder;
import ch.docuteam.darc.mets.structmap.StructureMap;
import ch.docuteam.darc.premis.Event;
import ch.docuteam.darc.sa.SubmissionAgreement;
import ch.docuteam.darc.util.XMLUtil;
import ch.docuteam.tools.exception.Exception;
import ch.docuteam.tools.file.FileFilter;
import ch.docuteam.tools.file.FileUtil;
import ch.docuteam.tools.file.exception.FileUtilExceptionListException;
import ch.docuteam.tools.id.UniqueID;
import ch.docuteam.tools.os.OperatingSystem;
import ch.docuteam.tools.out.Logger;
import ch.docuteam.tools.string.StringUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.TreePath;
import org.dom4j.Element;
import org.jdesktop.swingx.treetable.AbstractMutableTreeTableNode;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;

public abstract class NodeAbstract
extends AbstractMutableTreeTableNode
implements Comparable<NodeAbstract> {
    protected DocumentAbstract document;
    protected Element element;
    protected String label;
    protected String type;
    protected Integer order;
    protected String admId;
    protected String dmdIdOAI_DC;
    protected String dmdIdEAD;
    protected boolean fileExists;
    protected boolean canRead;
    protected boolean canWrite;
    protected boolean canExecute;

    protected NodeAbstract() {
    }

    protected NodeAbstract(DocumentAbstract document, Element element) {
        this.document = document;
        this.element = element;
        this.label = element.attributeValue("LABEL");
        this.type = element.attributeValue("TYPE");
        this.admId = element.attributeValue("ADMID");
        Element e = (Element)element.selectSingleNode("./METS:div[@TYPE='metadata' and @LABEL='OAI_DC']");
        if (e != null) {
            this.dmdIdOAI_DC = e.attributeValue("DMDID");
        }
        if ((e = (Element)element.selectSingleNode("./METS:div[@TYPE='metadata' and @LABEL='EAD']")) != null) {
            this.dmdIdEAD = e.attributeValue("DMDID");
        }
        this.createDMDSectionWithEADIfNecessary();
    }

    protected NodeAbstract(NodeFolder parent, String label) {
        this.document = parent.getDocument();
        this.parent = parent;
        this.label = label;
        this.admId = UniqueID.getXML();
        parent.add((MutableTreeTableNode)this);
        this.document.setIsModified();
    }

    protected NodeAbstract(StructureMap parent, String label) {
        this.document = parent.getDocument();
        this.label = label;
        this.admId = UniqueID.getXML();
        this.document.setIsModified();
    }

    protected static NodeAbstract parse(StructureMap parent, Element element) {
        String type = element.attributeValue("TYPE");
        if (type == null) {
            throw new NullPointerException("Undefined root node type in the METS file's Structure Map");
        }
        if (type.equals("rootfolder")) {
            return new NodeFolder(parent, element);
        }
        if (type.equals("rootfile")) {
            return new NodeFile(parent, element);
        }
        throw new IllegalArgumentException("Bad root node type in the METS file's Structure Map: '" + type + "'");
    }

    protected static NodeAbstract parse(NodeFolder parent, Element element) {
        String type = element.attributeValue("TYPE");
        NodeAbstract node = null;
        if (type == null) {
            throw new NullPointerException("Undefined node type in the METS file's Structure Map");
        }
        if (type.equals("folder")) {
            node = new NodeFolder(parent, element);
        } else if (type.equals("file")) {
            node = new NodeFile(parent, element);
        } else {
            throw new IllegalArgumentException("Bad node type in the METS file's Structure Map: '" + type + "'");
        }
        if (element.attributeValue("ORDER") != null) {
            try {
                Integer order = Integer.parseInt(element.attributeValue("ORDER"));
                node.setOrder(order);
            }
            catch (NumberFormatException e) {
                Logger.warn((Object)("cannot parse the ORDER attribute: " + element.attributeValue("ORDER")), (Throwable)e);
            }
        }
        return node;
    }

    protected static NodeAbstract createRootNode(StructureMap structMap, File file) throws FileNotFoundException, IOException, FileAlreadyExistsException, FileOperationNotAllowedException, FileUtilExceptionListException {
        Document document = (Document)structMap.getDocument();
        if (!document.areFileOperationsAllowed()) {
            throw new FileOperationNotAllowedException(document, file.getPath(), "CreateRootNode");
        }
        String sipRelativeFilePath = file.getName();
        String newRootFilePath = document.getSIPFolder() + "/" + sipRelativeFilePath;
        if (file.isFile()) {
            if (!file.exists()) {
                throw new FileNotFoundException("File to be inserted does not exist: '" + file.getPath() + "'");
            }
            if (file.isHidden()) {
                return null;
            }
            SubmissionAgreement sa = document.getSubmissionAgreement();
            if (sa != null && !sa.allowsFile(document.getDSSId(), file.getPath())) {
                Exception.rememberWithType((String[])new String[]{"Submission Agreement '" + document.getSAId() + "' Data Submission Session '" + document.getDSSId() + "' doesn't allow file '" + file.getPath() + "'", ExceptionTypes.SA_DOESNT_ALLOW_FILE.name(), file.getPath()});
                return null;
            }
            FileUtil.copyToOverwriting((String)file.getPath(), (String)newRootFilePath);
            ch.docuteam.darc.mets.filesec.File fileSecFile = new ch.docuteam.darc.mets.filesec.File(structMap.getDocument(), sipRelativeFilePath);
            NodeFile nodeFile = new NodeFile(structMap, fileSecFile);
            if (nodeFile.getMimeType().isEmpty()) {
                Exception.remember((String)("No MimeType found for file: '" + nodeFile.getPathString() + "'"));
            }
            if (nodeFile.getFormatKey().isEmpty()) {
                Exception.remember((String)("No FormatID found for file: '" + nodeFile.getPathString() + "'"));
            }
            return nodeFile;
        }
        NodeFolder rootFolder = new NodeFolder(structMap, sipRelativeFilePath);
        for (File f : file.listFiles((FilenameFilter)FileFilter.VisibleAll)) {
            rootFolder.insertFileOrFolder(f.getPath());
        }
        return rootFolder;
    }

    public Document getDocument() {
        return (Document)this.document;
    }

    public Element getElement() {
        return this.element;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = XMLUtil.sanitizeXmlChars(label);
        this.element.addAttribute("LABEL", this.label);
        this.document.setIsModified();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
        this.element.addAttribute("TYPE", this.type);
        this.document.setIsModified();
    }

    public Integer getOrder() {
        if (this.order != null) {
            return this.order;
        }
        return -1;
    }

    public void setOrder(Integer order) {
        if (order != null && order.compareTo(0) > 0) {
            this.order = order;
            this.element.addAttribute("ORDER", this.order.toString());
            this.document.setIsModified();
        }
    }

    public void setOrderRecursive(int orderIndex, boolean withSort) {
        if (!Integer.valueOf(orderIndex).equals(this.getOrder())) {
            if (this.isRoot().booleanValue()) {
                this.setOrder(1);
            } else {
                this.setOrder(orderIndex);
            }
        }
        if (withSort) {
            Collections.sort(this.children);
        }
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            NodeAbstract childNode = (NodeAbstract)this.getChildAt(i);
            childNode.setOrderRecursive(i + 1, withSort);
        }
    }

    public String getAdmId() {
        return this.admId;
    }

    public void setAdmId(String admId) {
        this.admId = admId;
        this.element.addAttribute("ADMID", this.admId);
        this.document.setIsModified();
    }

    public String getDmdIdOAI_DC() {
        return this.dmdIdOAI_DC;
    }

    public String getDmdIdEAD() {
        return this.dmdIdEAD;
    }

    public SubmitStatus getSubmitStatus() {
        if (this.getMyDMDSectionWithEAD() == null) {
            return SubmitStatus.SubmitUndefined;
        }
        return this.getMyDMDSectionWithEAD().getC().getSubmitStatus();
    }

    public boolean isPartOfSubmission() {
        switch (this.getSubmitStatus()) {
            case SubmitRequestPending: 
            case SubmitRequested: {
                return true;
            }
            case SubmitUndefined: {
                if (!this.getRoot().getSubmitStatus().equals((Object)SubmitStatus.SubmitUndefined)) break;
                return true;
            }
        }
        return false;
    }

    public void setSubmitStatus(SubmitStatus newSubmitStatus) throws CantSetSubmitStatusNotAllowedException {
        this.setSubmitStatus_check(newSubmitStatus);
        this.setSubmitStatus_force(newSubmitStatus);
    }

    public void setSubmitStatus_check(SubmitStatus newSubmitStatus) throws CantSetSubmitStatusNotAllowedException {
        SubmitStatus currentSubmitStatus = this.getSubmitStatus();
        if (currentSubmitStatus == null) {
            currentSubmitStatus = SubmitStatus.SubmitUndefined;
        }
        if (!currentSubmitStatus.isNextSubmitStatusAllowed(newSubmitStatus)) {
            Logger.debug((Object)("Can't set submit status from: '" + (Object)((Object)currentSubmitStatus) + "' to: '" + (Object)((Object)newSubmitStatus) + "' in node: " + this.getPathString()));
            throw new CantSetSubmitStatusNotAllowedException(this, currentSubmitStatus, newSubmitStatus);
        }
    }

    public void setSubmitStatus_force(SubmitStatus newSubmitStatus) {
        this.getMyDMDSectionWithEAD().getC().setSubmitStatus(newSubmitStatus);
    }

    public void setSubmitStatusRecursivelyAllOrNone_check(SubmitStatus newSubmitStatus) throws CantSetSubmitStatusRecursiveException {
        List<NodeAbstract> meAndAllMyParentsAndDescendants = this.getWithDescendants();
        NodeAbstract nodeParent = this;
        while (!nodeParent.isRoot().booleanValue()) {
            if ((nodeParent = (NodeAbstract)nodeParent.getParent()).getSubmitStatus().equals((Object)SubmitStatus.Submitted)) continue;
            meAndAllMyParentsAndDescendants.add(0, nodeParent);
        }
        Vector<String> rejectMessages = new Vector<String>();
        for (NodeAbstract n : meAndAllMyParentsAndDescendants) {
            try {
                n.setSubmitStatus_check(newSubmitStatus);
            }
            catch (CantSetSubmitStatusNotAllowedException ex) {
                rejectMessages.add("MessageSubmitNodeCurrentStatusDoesntAllowNextStatus '" + ex.getNode().getPathString() + "'");
            }
        }
        if (!rejectMessages.isEmpty()) {
            throw new CantSetSubmitStatusRecursiveException(this, newSubmitStatus, rejectMessages);
        }
    }

    public void setSubmitStatusRecursivelyAllOrNone_force(SubmitStatus newSubmitStatus) {
        List<NodeAbstract> meAndAllMyParentsAndDescendants = this.getWithDescendants();
        NodeAbstract nodeParent = this;
        while (!nodeParent.isRoot().booleanValue()) {
            if ((nodeParent = (NodeAbstract)nodeParent.getParent()).getSubmitStatus().equals((Object)SubmitStatus.Submitted)) continue;
            meAndAllMyParentsAndDescendants.add(0, nodeParent);
        }
        for (NodeAbstract n : meAndAllMyParentsAndDescendants) {
            n.setSubmitStatus_force(newSubmitStatus);
        }
    }

    public void setSubmitStatusAllOrNone(SubmitStatus oldSubmitStatus, SubmitStatus newSubmitStatus) throws CantSetSubmitStatusRecursiveException {
        List<NodeAbstract> meAndAllMyDescendants = this.getWithDescendants();
        Vector<String> rejectMessages = new Vector<String>();
        for (NodeAbstract n : meAndAllMyDescendants) {
            if (!n.getSubmitStatus().equals((Object)oldSubmitStatus)) continue;
            try {
                n.setSubmitStatus_check(newSubmitStatus);
            }
            catch (CantSetSubmitStatusNotAllowedException ex) {
                rejectMessages.add("MessageSubmitNodeCurrentStatusDoesntAllowNextStatus '" + ex.getNode().getPathString() + "'");
            }
        }
        if (!rejectMessages.isEmpty()) {
            throw new CantSetSubmitStatusRecursiveException(this, newSubmitStatus, rejectMessages);
        }
        for (NodeAbstract n : meAndAllMyDescendants) {
            if (!n.getSubmitStatus().equals((Object)oldSubmitStatus)) continue;
            try {
                n.setSubmitStatus(newSubmitStatus);
            }
            catch (CantSetSubmitStatusNotAllowedException cantSetSubmitStatusNotAllowedException) {}
        }
    }

    public DigiprovWithPremis getMyDigiprov() {
        if (this.admId == null) {
            this.setAdmId(UniqueID.getXML());
            new DigiprovWithPremis(this);
        }
        return this.getDocument().getAMDSection().getDigiprov(this.admId);
    }

    public DMDSectionWithEAD getMyDMDSectionWithEAD() {
        if (this.dmdIdEAD == null) {
            return null;
        }
        return (DMDSectionWithEAD)this.getDocument().getDMDSection(this.dmdIdEAD);
    }

    public DMDSectionWithOAI_DC getMyDMDSectionWithOAI_DC() {
        if (this.dmdIdOAI_DC == null) {
            return null;
        }
        return (DMDSectionWithOAI_DC)this.getDocument().getDMDSection(this.dmdIdOAI_DC);
    }

    public LevelOfDescription getLevel() {
        if (this.dmdIdEAD == null) {
            return null;
        }
        return this.getMyDMDSectionWithEAD().getC().getOtherLevel();
    }

    public void setLevel(LevelOfDescription newLevel) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (this.dmdIdEAD == null) {
            return;
        }
        List<LevelMetadataElement> oldMDElements = this.getDynamicMetadataElementsOrdered();
        this.getMyDMDSectionWithEAD().getC().setOtherLevel(newLevel);
        for (LevelMetadataElement lmde : oldMDElements) {
            if (newLevel.getDynamicMetadataElements().containsKey(lmde.getId())) continue;
            Logger.debug((Object)("Clearing: " + lmde.getId() + " in Node: " + this));
            lmde.clearValueInNode(this);
        }
        this.initializeDynamicMetadataElementInstancesWhichAreMandatoryOrAlwaysDisplayed();
    }

    public String getUnitTitle() {
        if (this.dmdIdEAD == null) {
            return null;
        }
        return this.getMyDMDSectionWithEAD().getC().getDid().getUnitTitle();
    }

    public void setUnitTitle(String unitTitle) {
        if (this.dmdIdEAD == null) {
            return;
        }
        this.getMyDMDSectionWithEAD().getC().getDid().setUnitTitle(XMLUtil.sanitizeXmlChars(unitTitle));
    }

    public List<Event> getMyEvents() {
        return new ArrayList<Event>(this.getMyDigiprov().getEvents());
    }

    public Event getMyEvent(Integer index) {
        return this.getMyEvents().get(index);
    }

    public NodeAbstract getRoot() {
        return this.getDocument().getStructureMap().getRoot();
    }

    public int getDepth() {
        if (this.isRoot().booleanValue()) {
            return 0;
        }
        return ((NodeAbstract)this.parent).getDepth() + 1;
    }

    public TreePath getTreePath() {
        Vector<NodeAbstract> path = new Vector<NodeAbstract>(10);
        NodeAbstract parent = this;
        do {
            path.add(0, parent);
        } while ((parent = (NodeAbstract)parent.parent) != null);
        return new TreePath(path.toArray(new NodeAbstract[0]));
    }

    public String getPathString() {
        StringBuilder path = new StringBuilder(200);
        NodeAbstract parent = this;
        do {
            path.insert(0, "/" + parent.getLabel());
        } while ((parent = (NodeAbstract)parent.parent) != null);
        return path.toString().substring(1);
    }

    public String getAbsolutePathString() {
        return this.getDocument().getSIPFolder() + "/" + this.getPathString();
    }

    public File getFile() {
        return new File(this.getAbsolutePathString());
    }

    public String getOriginalPathString() {
        String originalSIPFolder = this.getDocument().getOriginalSIPFolder();
        if (originalSIPFolder == null || originalSIPFolder.toLowerCase().endsWith(".zip")) {
            return this.getAbsolutePathString();
        }
        return originalSIPFolder + "/" + this.getPathString();
    }

    public File getOriginalFile() {
        return new File(this.getOriginalPathString());
    }

    public Long getRelativeSize() {
        if (this.getRoot().getSize() == 0L) {
            return 0L;
        }
        return 100L * this.getSize() / this.getRoot().getSize();
    }

    public List<String> getPID() {
        return this.getMyDMDSectionWithEAD().getC().getPID();
    }

    public String getDynamicMetadataValueForName(String name) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, MetadataElementIsNotAllowedException, MetadataElementIsNotDefinedException {
        return this.getDynamicMetadataValueForName(name, 0);
    }

    public String getDynamicMetadataValueForName(String name, int index) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, MetadataElementIsNotAllowedException, MetadataElementIsNotDefinedException {
        return this.getLevel().getDynamicMetadataElement(name).getValueFromNode(index, this);
    }

    public List<String> getAllDynamicMetadataValuesForName(String name) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, MetadataElementIsNotAllowedException, MetadataElementIsNotDefinedException {
        return this.getLevel().getDynamicMetadataElement(name).getAllValuesFromNode(this);
    }

    public List<String> getAllDynamicMetadataValuesForName_NoCheck(String name) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, MetadataElementIsNotDefinedException {
        MetadataElement mde = MetadataElement.get(name);
        if (mde == null) {
            throw new MetadataElementIsNotDefinedException(name);
        }
        return mde.getValueFromNode(this);
    }

    public void setDynamicMetadataValueForName(String name, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, MetadataElementValidatorException, MetadataElementIsNotAllowedException, MetadataElementIsNotDefinedException, LevelMetadataElementIsReadOnly, MetadataElementSetterPostActionException, MetadataElementAllowedValuesException {
        this.setDynamicMetadataValueForName(name, 0, value);
    }

    public void setDynamicMetadataValueForName(String name, int index, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, MetadataElementValidatorException, MetadataElementIsNotAllowedException, MetadataElementIsNotDefinedException, LevelMetadataElementIsReadOnly, MetadataElementSetterPostActionException, MetadataElementAllowedValuesException {
        this.getLevel().getDynamicMetadataElement(name).setValueInNode(index, value, this);
    }

    public void setDynamicMetadataValueForName_force(String name, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, MetadataElementValidatorException, MetadataElementIsNotAllowedException, MetadataElementIsNotDefinedException, LevelMetadataElementIsReadOnly, MetadataElementSetterPostActionException, MetadataElementAllowedValuesException {
        this.setDynamicMetadataValueForName_force(name, 0, value);
    }

    public void setDynamicMetadataValueForName_force(String name, int index, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, MetadataElementValidatorException, MetadataElementIsNotAllowedException, MetadataElementIsNotDefinedException, LevelMetadataElementIsReadOnly, MetadataElementSetterPostActionException, MetadataElementAllowedValuesException {
        this.getLevel().getDynamicMetadataElement(name).setValueInNode_NoCheck(index, value, this);
    }

    public void addDynamicMetadataElementInstanceWithName(String name) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, MetadataElementCantAddException, EvalError, MetadataElementIsNotAllowedException, MetadataElementIsNotDefinedException, MetadataElementValidatorException, MetadataElementAllowedValuesException {
        this.getLevel().getDynamicMetadataElement(name).addMetadataElementInstanceToNode(this);
    }

    public void deleteDynamicMetadataElementInstanceWithName(String name, int index) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, MetadataElementCantDeleteException, MetadataElementIsNotAllowedException, MetadataElementIsNotDefinedException {
        this.getLevel().getDynamicMetadataElement(name).deleteMetadataElementInstanceFromNode(this, index);
    }

    public List<MetadataElementInstance> initializeDynamicMetadataElementInstancesWhichAreMandatoryOrAlwaysDisplayed() {
        Vector<MetadataElementInstance> mandatoryOrAlwaysDisplayedInstances = new Vector<MetadataElementInstance>();
        for (LevelMetadataElement lmde : this.getDynamicMetadataElementsOrdered()) {
            if (!lmde.isMandatory() && !lmde.isAlwaysDisplayed()) continue;
            try {
                List<MetadataElementInstance> mdeis = lmde.getMetadataElementInstancesOfNode(this);
                if (lmde.isRepeatable() && mdeis.isEmpty()) {
                    lmde.addMetadataElementInstanceToNode(this);
                }
                for (MetadataElementInstance mdei : mdeis) {
                    try {
                        mdei.initializeValueIfNecessary();
                    }
                    catch (java.lang.Exception ex) {
                        Logger.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                    mandatoryOrAlwaysDisplayedInstances.add(mdei);
                }
            }
            catch (java.lang.Exception ex) {
                Logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return mandatoryOrAlwaysDisplayedInstances;
    }

    public List<MetadataElementInstance> getDynamicMetadataElementInstances() {
        Vector<MetadataElementInstance> allInstances = new Vector<MetadataElementInstance>();
        for (LevelMetadataElement lmde : this.getDynamicMetadataElementsOrdered()) {
            try {
                allInstances.addAll(lmde.getMetadataElementInstancesOfNode(this));
            }
            catch (java.lang.Exception ex) {
                Logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return allInstances;
    }

    public List<MetadataElementInstance> getDynamicMetadataElementInstancesToBeDisplayed() {
        Vector<MetadataElementInstance> instancesToBeDisplayed = new Vector<MetadataElementInstance>();
        boolean wasDocumentModified = this.document.isModified();
        for (LevelMetadataElement lmde : this.getDynamicMetadataElementsOrdered()) {
            try {
                if ((lmde.isMandatory() || lmde.isAlwaysDisplayed()) && lmde.isRepeatable() && lmde.getMetadataElementInstancesOfNode(this).isEmpty()) {
                    lmde.addMetadataElementInstanceToNode(this);
                }
                for (MetadataElementInstance mdei : lmde.getMetadataElementInstancesOfNode(this)) {
                    if (!mdei.isToBeDisplayed()) continue;
                    instancesToBeDisplayed.add(mdei);
                }
            }
            catch (java.lang.Exception ex) {
                Logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        if (this.document.isModified() && !wasDocumentModified) {
            this.document.setIsNotModified();
        }
        return instancesToBeDisplayed;
    }

    public List<MetadataElementInstance> getDynamicMetadataElementInstancesWhichAreMandatoryButNotSet() {
        Vector<MetadataElementInstance> mandatoryButNotSetInstances = new Vector<MetadataElementInstance>();
        for (LevelMetadataElement lmde : this.getDynamicMetadataElementsOrdered()) {
            try {
                for (MetadataElementInstance mdei : lmde.getMetadataElementInstancesOfNode(this)) {
                    if (!mdei.isMandatoryButNotSet()) continue;
                    mandatoryButNotSetInstances.add(mdei);
                }
            }
            catch (java.lang.Exception ex) {
                Logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return mandatoryButNotSetInstances;
    }

    public boolean hasDynamicMetadataElementInstancesWhichAreMandatoryButNotSet() {
        for (LevelMetadataElement lmde : this.getDynamicMetadataElementsOrdered()) {
            try {
                for (MetadataElementInstance mdei : lmde.getMetadataElementInstancesOfNode(this)) {
                    if (!mdei.isMandatoryButNotSet()) continue;
                    return true;
                }
            }
            catch (java.lang.Exception ex) {
                Logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return false;
    }

    public List<LevelMetadataElement> getDynamicMetadataElementsWhichCanBeAdded() {
        Vector<LevelMetadataElement> elementsWhichCanBeAdded = new Vector<LevelMetadataElement>();
        for (LevelMetadataElement lmde : this.getDynamicMetadataElementsOrdered()) {
            try {
                if (!lmde.canAddOneInstanceToNode(this)) continue;
                elementsWhichCanBeAdded.add(lmde);
            }
            catch (java.lang.Exception ex) {
                Logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return elementsWhichCanBeAdded;
    }

    public abstract Long getSize();

    public abstract int getDescendantCount();

    public abstract List<NodeAbstract> getWithDescendants();

    public abstract List<NodeAbstract> getWithDescendantsDepthFirst();

    public abstract int getTreeDepth();

    public abstract String getChecksum();

    public abstract String getChecksumType();

    public abstract String getMimeType();

    public abstract String getFormatKey();

    public abstract String getFormatName();

    public boolean fileExists() {
        return this.fileExists;
    }

    public boolean canRead() {
        return this.canRead;
    }

    public boolean canWrite() {
        return this.canWrite;
    }

    public boolean canExecute() {
        return this.canExecute;
    }

    public Boolean isRoot() {
        return this.parent == null;
    }

    public void checkIfFileOperationNotAllowed(String fileName, String fileOp) throws FileOperationNotAllowedException {
        if (this.document.getDocumentType() == DocumentAbstract.Type.METS && !this.getDocument().areFileOperationsAllowed()) {
            throw new FileOperationNotAllowedException(this.document, fileName, fileOp);
        }
    }

    public boolean doesParentAllowSubLevel(LevelOfDescription level) {
        if (level == null) {
            return true;
        }
        return this.doesParentAllowSubLevel(level.getName());
    }

    public boolean doesParentAllowSubLevel(String levelName) {
        if (this.isRoot().booleanValue()) {
            return true;
        }
        return ((NodeFolder)this.parent).getLevel().allowsSubLevel(levelName);
    }

    public boolean doesParentAllowMyLevel() {
        return this.doesParentAllowSubLevel(this.getLevel());
    }

    public boolean hasPredecessorNotReadableByCurrentUser() {
        NodeFolder parent = (NodeFolder)this.parent;
        if (parent == null) {
            return false;
        }
        if (!parent.fileExists || !parent.canRead) {
            return true;
        }
        return parent.hasPredecessorNotReadableByCurrentUser();
    }

    public boolean hasPredecessorNotWritableByCurrentUser() {
        NodeFolder parent = (NodeFolder)this.parent;
        if (parent == null) {
            return false;
        }
        if (!parent.fileExists || !parent.canWrite) {
            return true;
        }
        return parent.hasPredecessorNotWritableByCurrentUser();
    }

    public boolean hasPredecessorNotReadableOrWritableByCurrentUser() {
        NodeFolder parent = (NodeFolder)this.parent;
        if (parent == null) {
            return false;
        }
        if (!(parent.fileExists && parent.canRead && parent.canWrite)) {
            return true;
        }
        return parent.hasPredecessorNotReadableOrWritableByCurrentUser();
    }

    public boolean doesSubmitStatusAllowEditing() {
        return this.getSubmitStatus().isEditingAllowed();
    }

    public abstract boolean isFile();

    public abstract boolean isFolder();

    public abstract boolean checkFixity();

    public abstract boolean checkAgainstSubmissionAgreement();

    public abstract List<NodeFile> filesNotAllowedBySubmissionAgreement();

    public abstract boolean checkAgainstSubmissionAgreement(SubmissionAgreement var1, String var2);

    public abstract List<NodeFile> filesNotAllowedBySubmissionAgreement(SubmissionAgreement var1, String var2);

    public abstract boolean isAllowedBySA();

    public abstract boolean hasMimeType();

    public abstract boolean hasFormatKey();

    public abstract NodeAbstract searchId(String var1);

    public abstract NodeAbstract searchFileId(String var1);

    public abstract List<NodeAbstract> searchLabel(String var1);

    @Deprecated
    public boolean searchFor(String searchString) {
        String searchStringLower = searchString.trim().toLowerCase();
        if (searchStringLower.isEmpty()) {
            return false;
        }
        if (this.getFile().getName().toLowerCase().contains(searchStringLower) || this.getUnitTitle().toLowerCase().contains(searchStringLower) || this.getLevel().getName().toLowerCase().contains(searchStringLower) || this.getMimeType() != null && this.getMimeType().toLowerCase().contains(searchStringLower) || this.getFormatKey() != null && this.getFormatKey().toLowerCase().contains(searchStringLower) || this.getFormatName() != null && this.getFormatName().toLowerCase().contains(searchStringLower)) {
            return true;
        }
        for (MetadataElementInstance mdei : this.getDynamicMetadataElementInstances()) {
            if (mdei.getValue() != null && mdei.getValue().toLowerCase().contains(searchStringLower)) {
                return true;
            }
            String displayValue = mdei.getDisplayValue();
            if (displayValue == null || !displayValue.toLowerCase().contains(searchString)) continue;
            return true;
        }
        return false;
    }

    public boolean searchForAllQuoted(String quotedSearchString) {
        String searchStringLower = quotedSearchString.trim().toLowerCase();
        if (searchStringLower.isEmpty()) {
            return false;
        }
        for (String searchString : StringUtil.splitQuoted((String)searchStringLower)) {
            boolean aMetadataElementContainsSearchString = false;
            for (MetadataElementInstance mdei : this.getDynamicMetadataElementInstances()) {
                if (mdei.getValue() != null && mdei.getValue().toLowerCase().contains(searchString)) {
                    aMetadataElementContainsSearchString = true;
                    break;
                }
                String displayValue = mdei.getDisplayValue();
                if (displayValue == null || !displayValue.toLowerCase().contains(searchString)) continue;
                aMetadataElementContainsSearchString = true;
                break;
            }
            if (aMetadataElementContainsSearchString || this.getFile().getName().toLowerCase().contains(searchString) || this.getUnitTitle().toLowerCase().contains(searchString) || this.getLevel().getName().toLowerCase().contains(searchString) || this.getMimeType() != null && this.getMimeType().contains(searchString) || this.getFormatKey() != null && this.getFormatKey().contains(searchString) || this.getFormatName() != null && this.getFormatName().contains(searchString)) continue;
            return false;
        }
        return true;
    }

    public boolean searchForAnyQuoted(String searchString) {
        String searchStringLower = searchString.trim().toLowerCase();
        if (searchStringLower.isEmpty()) {
            return false;
        }
        List searchStrings = StringUtil.splitQuoted((String)searchStringLower);
        if (StringUtil.containsAny((String)this.getFile().getName().toLowerCase(), (List)searchStrings) || StringUtil.containsAny((String)this.getUnitTitle().toLowerCase(), (List)searchStrings) || StringUtil.containsAny((String)this.getLevel().getName().toLowerCase(), (List)searchStrings) || this.getMimeType() != null && StringUtil.containsAny((String)this.getMimeType().toLowerCase(), (List)searchStrings) || this.getFormatKey() != null && StringUtil.containsAny((String)this.getFormatKey().toLowerCase(), (List)searchStrings) || this.getFormatName() != null && StringUtil.containsAny((String)this.getFormatName().toLowerCase(), (List)searchStrings)) {
            return true;
        }
        for (MetadataElementInstance mdei : this.getDynamicMetadataElementInstances()) {
            if (mdei.getValue() != null && StringUtil.containsAny((String)mdei.getValue().toLowerCase(), (List)searchStrings)) {
                return true;
            }
            String displayValue = mdei.getDisplayValue();
            if (displayValue == null || !StringUtil.containsAny((String)displayValue.toLowerCase(), (List)searchStrings)) continue;
            return true;
        }
        return false;
    }

    public void rename(String newLabel) throws FileAlreadyExistsException, IOException, FileOperationNotAllowedException {
        this.checkIfFileOperationNotAllowed(newLabel, "Rename");
        NodeFolder parent = (NodeFolder)this.parent;
        if (parent != null && parent.doesAlreadyContainChildWithThisName(newLabel)) {
            throw new FileAlreadyExistsException(newLabel, parent.label);
        }
        String oldLabel = this.getLabel();
        this.setLabel(newLabel);
        this.createNewEvent("Renaming", "Renamed from '" + oldLabel + "' to '" + newLabel + "'", "Success", "");
    }

    public void moveTo(NodeFolder toFolder) throws FileAlreadyExistsException, IOException, FileOperationNotAllowedException {
        this.checkIfFileOperationNotAllowed(toFolder.label, "Move");
        this.checkIfTheNewParentAlreadyContainChildWithThisName(toFolder);
        File file = new File(this.getPathString());
        String oldPath = file.getParent() == null ? "/" : file.getParent();
        NodeAbstract oldParent = (NodeAbstract)this.getParent();
        this.removeFromParent();
        this.parent = toFolder;
        toFolder.add((MutableTreeTableNode)this);
        toFolder.getElement().add(this.element);
        toFolder.setOrderRecursive(toFolder.getOrder(), false);
        if (oldParent != null) {
            oldParent.setOrderRecursive(-1, false);
        }
        this.createNewEvent("Path Modification", "Moved '" + this.getLabel() + "' from '" + oldPath + "'", "Success", "");
    }

    private void checkIfTheNewParentAlreadyContainChildWithThisName(NodeFolder toFolder) throws IOException, FileAlreadyExistsException {
        if (toFolder.doesAlreadyContainChildWithThisName(this.label)) {
            throw new FileAlreadyExistsException(this.label, toFolder.getLabel());
        }
    }

    public void moveBeforeNode(NodeAbstract node) throws FileOperationNotAllowedException, IOException, FileAlreadyExistsException {
        block5: {
            File file;
            this.checkIfFileOperationNotAllowed(this.getLabel(), "moveBeforeNode");
            this.checkIfCanMoveBeforeNode(node);
            NodeAbstract oldParent = (NodeAbstract)this.getParent();
            NodeAbstract newParent = (NodeAbstract)node.getParent();
            boolean hasSameParent = oldParent.equals(newParent);
            if (!hasSameParent) {
                this.checkIfTheNewParentAlreadyContainChildWithThisName((NodeFolder)newParent);
            }
            String oldPath = (file = new File(this.getPathString())).getParent() == null ? "/" : file.getParent();
            int newIndex = this.getNewIndexAtMoveBeforeNode(node);
            int oldIndex = this.getOldIndex();
            try {
                if (newIndex > -1) {
                    this.removeFromParent();
                    newParent.insert((MutableTreeTableNode)this, newIndex);
                    List elements = newParent.getElement().elements();
                    elements.add(newIndex, this.getElement());
                    newParent.setOrderRecursive(newParent.getOrder(), false);
                    oldParent.setOrderRecursive(-1, false);
                    if (!hasSameParent) {
                        this.createNewEvent("Path Modification", "Moved '" + this.getLabel() + "' from '" + oldPath + "'", "Success", "");
                    }
                }
            }
            catch (java.lang.Exception e) {
                Logger.error((Object)("moveBeforeNode this " + this.getLabel() + " before " + node.getLabel() + " failed: "), (Throwable)e);
                if (newParent.getWithDescendants().contains(this) || oldParent.getWithDescendants().contains(this)) break block5;
                List elements = oldParent.getElement().elements();
                elements.add(oldIndex, this.getElement());
                oldParent.setOrderRecursive(-1, false);
            }
        }
    }

    private int getOldIndex() {
        NodeAbstract oldParent = (NodeAbstract)this.getParent();
        int childCount = oldParent.getChildCount();
        int index = 0;
        for (int i = 0; i < childCount; ++i) {
            NodeAbstract metsChildNode = (NodeAbstract)oldParent.getChildAt(i);
            if (metsChildNode.equals(this)) {
                return index;
            }
            ++index;
        }
        return index;
    }

    int getNewIndexAtMoveBeforeNode(NodeAbstract node) {
        int newIndex = -1;
        int originalIndex = -1;
        NodeAbstract newParent = (NodeAbstract)node.getParent();
        int childCount = newParent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            NodeAbstract child = (NodeAbstract)newParent.getChildAt(i);
            if (child.equals(node)) {
                newIndex = i;
            }
            if (!child.equals(this)) continue;
            originalIndex = i;
        }
        if (originalIndex != -1 && originalIndex < newIndex && newIndex > 0) {
            --newIndex;
        }
        return newIndex;
    }

    private void checkIfCanMoveBeforeNode(NodeAbstract node) {
        if (this.isRoot().booleanValue()) {
            throw new IllegalStateException("cannot move root");
        }
        if (this.equals(node)) {
            throw new IllegalStateException("cannot move before self");
        }
        List<NodeAbstract> withDescendants = this.getWithDescendants();
        if (withDescendants.contains(node)) {
            throw new IllegalStateException("cannot move into self or descendent");
        }
        if (SubmitStatus.SubmitRequestPending.equals((Object)this.getSubmitStatus()) || SubmitStatus.Submitted.equals((Object)this.getSubmitStatus())) {
            throw new IllegalStateException("cannot move if SubmitRequestPending or Submitted");
        }
        if (!this.fileExists() || !this.canRead() || !this.canWrite() || this.hasPredecessorNotReadableOrWritableByCurrentUser()) {
            throw new IllegalStateException("cannot move - this or any of its predecessors is not readable or not writable");
        }
        if (node.isFolder() && ((NodeFolder)node).hasDescendantNotReadableOrWritableByCurrentUser()) {
            throw new IllegalStateException("cannot move - this or any of its descendants is not readable or not writable");
        }
    }

    public void delete() throws IOException, FileOperationNotAllowedException, FileUtilExceptionListException {
        String path = this.getPathString();
        this.delete("Delete", "Deletion", "Deleted '" + path + "'", "Success");
    }

    private void delete(String operationName, String eventName, String eventDetail, String eventOutcome) throws FileOperationNotAllowedException {
        this.checkIfFileOperationNotAllowed(this.label, operationName);
        this.removeFromParent();
        this.getRoot().createNewEvent(eventName, eventDetail, eventOutcome, "");
        if (this.getMyDMDSectionWithEAD() != null) {
            this.getMyDMDSectionWithEAD().delete();
        }
        if (this.getMyDMDSectionWithOAI_DC() != null) {
            this.getMyDMDSectionWithOAI_DC().delete();
        }
        if (this.getMyDigiprov() != null) {
            this.getMyDigiprov().delete();
        }
    }

    public void deleteAsDuplicate(NodeFile fileToKeep) throws FileOperationNotAllowedException, FileUtilExceptionListException {
        String path = this.getPathString();
        this.delete("Delete as duplicate", "Deletion as duplicate", "Deleted '" + path + "' as duplicate of " + fileToKeep.getPathString(), "Success");
    }

    public void addOAI_DCFromDocument(org.dom4j.Document oaiDcDocument) {
        OAI_DC oaiDc = OAI_DC.create(this.getDocument(), oaiDcDocument);
        if (oaiDc == null) {
            return;
        }
        this.setDmdIdOAI_DC(((DMDSectionAbstract)oaiDc.getParent()).getId());
    }

    @Override
    public int compareTo(NodeAbstract node) {
        return this.compareString().compareTo(node.compareString());
    }

    @Deprecated
    public int getColumnCount() {
        throw new RuntimeException("This method should never be used! It violates the MVC paradigm! It doesn't belong here!");
    }

    @Deprecated
    public Object getValueAt(int column) {
        throw new RuntimeException("This method should never be used! It violates the MVC paradigm! It doesn't belong here!");
    }

    public void removeFromParent() {
        if (this.parent != null) {
            super.removeFromParent();
        }
        this.element.detach();
        this.document.setIsModified();
    }

    public void createDMDSectionWithEADIfNecessary() {
        if (this.getMyDMDSectionWithEAD() != null) {
            return;
        }
        DMDSectionWithEAD newDMDSection = new DMDSectionWithEAD(this);
        this.setDmdIdEAD(newDMDSection.getId());
    }

    public abstract String toString();

    public abstract String treeString(Integer var1);

    protected abstract String compareString();

    protected void initializeFileAccessRights() {
        File file = this.getFile();
        this.fileExists = file.exists();
        this.canRead = file.canRead();
        this.canWrite = file.canWrite();
        this.canExecute = file.canExecute();
        if (!this.fileExists || !this.canRead) {
            this.document.setIsAtLeastOneFileNotReadable();
        }
        if (!this.canWrite) {
            this.document.setIsAtLeastOneFileNotWritable();
        }
    }

    protected void setDmdIdOAI_DC(String dmdIdOAI_DC) {
        this.dmdIdOAI_DC = dmdIdOAI_DC;
        Element metsDivOAI_DCLinkToDMD = (Element)this.element.selectSingleNode("./METS:div[@TYPE='metadata' and @LABEL='OAI_DC']");
        if (metsDivOAI_DCLinkToDMD == null) {
            metsDivOAI_DCLinkToDMD = this.element.addElement("METS:div").addAttribute("LABEL", "OAI_DC").addAttribute("TYPE", "metadata");
        }
        metsDivOAI_DCLinkToDMD.addAttribute("DMDID", this.dmdIdOAI_DC);
        this.document.setIsModified();
    }

    protected void setDmdIdEAD(String dmdIdEAD) {
        this.dmdIdEAD = dmdIdEAD;
        Element metsDivEADLinkToDMD = (Element)this.element.selectSingleNode("./METS:div[@TYPE='metadata' and @LABEL='EAD']");
        if (metsDivEADLinkToDMD == null) {
            metsDivEADLinkToDMD = this.element.addElement("METS:div").addAttribute("LABEL", "EAD").addAttribute("TYPE", "metadata");
        }
        metsDivEADLinkToDMD.addAttribute("DMDID", this.dmdIdEAD);
        this.document.setIsModified();
    }

    protected List<LevelMetadataElement> getDynamicMetadataElementsOrdered() {
        return this.getLevel().getDynamicMetadataElementsOrdered();
    }

    protected void createNewEvent(String type, String detail, String outcome, String outcomeDetail) {
        this.getMyDigiprov().addNewEvent(type, detail, outcome, outcomeDetail);
    }

    public static enum SubmitStatus {
        SubmitUndefined,
        SubmitRequested,
        SubmitRequestPending,
        Submitted,
        SubmitFailed;


        public static SubmitStatus named(String key) {
            if (key == null || key.isEmpty()) {
                return SubmitUndefined;
            }
            return SubmitStatus.valueOf(key);
        }

        public static String getSubmitRequestPendingLockId() {
            return OperatingSystem.userName() + " (" + (Object)((Object)SubmitRequestPending) + ")";
        }

        public static String getSubmittedLockId() {
            return OperatingSystem.userName() + " (" + (Object)((Object)Submitted) + ")";
        }

        public boolean isEditingAllowed() {
            return this == SubmitUndefined || this == SubmitFailed;
        }

        public boolean isNextSubmitStatusAllowed(SubmitStatus nextSubmitStatus) {
            if (this.equals((Object)nextSubmitStatus)) {
                return true;
            }
            switch (this) {
                case SubmitUndefined: {
                    return nextSubmitStatus == SubmitUndefined || nextSubmitStatus == SubmitRequested || nextSubmitStatus == SubmitRequestPending;
                }
                case SubmitRequested: {
                    return nextSubmitStatus == null || nextSubmitStatus == SubmitUndefined || nextSubmitStatus == SubmitRequested || nextSubmitStatus == SubmitRequestPending;
                }
                case SubmitRequestPending: {
                    return nextSubmitStatus == Submitted || nextSubmitStatus == SubmitFailed;
                }
                case Submitted: {
                    return false;
                }
                case SubmitFailed: {
                    return nextSubmitStatus == null || nextSubmitStatus == SubmitUndefined || nextSubmitStatus == SubmitRequested;
                }
            }
            return false;
        }
    }

    public static enum ExceptionTypes {
        SA_DOESNT_ALLOW_FILE;

    }
}

