/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.util;

import ch.docuteam.darc.mdconfig.MetadataElement;
import ch.docuteam.darc.mets.Document;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.tools.out.Logger;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public abstract class CSVExport {
    private static final String Separator = ";";
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File export(Document document, String exportFilePath) {
        File exportFile = new File(exportFilePath);
        exportFile.getParentFile().mkdirs();
        OutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(exportFile));
            StringBuilder line = new StringBuilder("Path");
            for (String mdName : MetadataElement.getAll().keySet()) {
                line.append(Separator).append(mdName);
            }
            line.append("\n");
            out.write(line.toString().getBytes());
            for (NodeAbstract node : document.getStructureMap().getRoot().getWithDescendants()) {
                Logger.debug((Object)node.getPathString());
                line = new StringBuilder(node.getPathString());
                for (String mdName : MetadataElement.getAll().keySet()) {
                    try {
                        List<String> values = node.getAllDynamicMetadataValuesForName_NoCheck(mdName);
                        Logger.debug((Object)(mdName + ": " + values));
                        line.append(Separator);
                        if (values == null) continue;
                        line.append(GSON.toJson(values));
                    }
                    catch (Exception ex) {
                        Logger.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                }
                line.append("\n");
                out.write(line.toString().getBytes());
            }
        }
        catch (Exception ex) {
            Logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {
                    Logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }
        return exportFile;
    }
}

