/*
 * Decompiled with CFR 0.152.
 */
package com.kerb4j.common.jaas.sun;

import com.sun.security.auth.module.Krb5LoginModule;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Krb5LoginConfig
extends Configuration {
    private static final Logger LOG = LoggerFactory.getLogger(Krb5LoginConfig.class);
    private static final String SUN_KRB5_LOGIN_MODULE_CLASS_NAME = Krb5LoginModule.class.getCanonicalName();
    private static final boolean SUN_KRB5_DEBUG = Boolean.getBoolean("sun.security.krb5.debug");
    private final AppConfigurationEntry[] appConfigurationEntries;

    public static Krb5LoginConfig createKeyTabClientConfig(String principal, String keyTabLocation) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("principal", principal);
        options.put("useKeyTab", "true");
        options.put("keyTab", keyTabLocation);
        options.put("storeKey", "true");
        options.put("doNotPrompt", "true");
        return new Krb5LoginConfig(options);
    }

    public static Krb5LoginConfig createTicketCacheClientConfig(String principal) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("renewTGT", "true");
        options.put("principal", principal);
        options.put("useTicketCache", "true");
        options.put("renewTGT", "true");
        options.put("doNotPrompt", "true");
        return new Krb5LoginConfig(options);
    }

    public static Krb5LoginConfig createUsernameAndPasswordClientConfig() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("storeKey", "true");
        return new Krb5LoginConfig(options);
    }

    protected Krb5LoginConfig(Map<String, String> additionalOptions) {
        HashMap<String, String> options = new HashMap<String, String>();
        if (SUN_KRB5_DEBUG) {
            options.put("debug", "true");
        }
        options.putAll(additionalOptions);
        this.appConfigurationEntries = new AppConfigurationEntry[]{new AppConfigurationEntry(SUN_KRB5_LOGIN_MODULE_CLASS_NAME, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
        return this.appConfigurationEntries;
    }
}

