/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.packer.gui.launcher;

import ch.docuteam.converter.OOConverter;
import ch.docuteam.converter.PDFToolsConverter;
import ch.docuteam.converter.exceptions.PDFToolsConverterBadVMArgumentException;
import ch.docuteam.darc.ingest.AIPCreator;
import ch.docuteam.darc.ingest.AIPCreatorProxy;
import ch.docuteam.darc.mdconfig.LevelOfDescription;
import ch.docuteam.darc.mets.Document;
import ch.docuteam.darc.premis.Object;
import ch.docuteam.darc.sa.SubmissionAgreement;
import ch.docuteam.packer.admin.BuildInfo;
import ch.docuteam.packer.gui.FileProperty;
import ch.docuteam.packer.gui.PackerConstants;
import ch.docuteam.packer.gui.filePreview.FilePreviewer;
import ch.docuteam.packer.gui.launcher.Column;
import ch.docuteam.packer.gui.launcher.CopySIPDialog;
import ch.docuteam.packer.gui.launcher.CreateNewSIPDialog;
import ch.docuteam.packer.gui.launcher.CreateNewSIPFromTemplateDialog;
import ch.docuteam.packer.gui.launcher.SIPFileChooser;
import ch.docuteam.packer.gui.launcher.SIPTable;
import ch.docuteam.packer.gui.launcher.SearchView;
import ch.docuteam.packer.gui.launcher.actions.AboutAction;
import ch.docuteam.packer.gui.launcher.actions.HelpAction;
import ch.docuteam.packer.gui.launcher.actions.OpenDocuteamHomepageAction;
import ch.docuteam.packer.gui.launcher.actions.OpenExceptionWindowAction;
import ch.docuteam.packer.gui.launcher.actions.OpenSIPInWorkspaceAction;
import ch.docuteam.packer.gui.sipView.SIPView;
import ch.docuteam.packer.gui.util.Util;
import ch.docuteam.tools.exception.ExceptionCollector;
import ch.docuteam.tools.file.FileChecksumCalculator;
import ch.docuteam.tools.file.FileUtil;
import ch.docuteam.tools.file.MetadataProviderDROID;
import ch.docuteam.tools.file.PropertyFile;
import ch.docuteam.tools.file.exception.DROIDCouldNotInitializeException;
import ch.docuteam.tools.file.exception.FileUtilExceptionListException;
import ch.docuteam.tools.gui.ScrollableMessageDialog;
import ch.docuteam.tools.gui.SmallPeskyMessageWindow;
import ch.docuteam.tools.gui.SystemOutView;
import ch.docuteam.tools.id.DOIGenerator;
import ch.docuteam.tools.os.OSXAdapter;
import ch.docuteam.tools.os.OperatingSystem;
import ch.docuteam.tools.out.Logger;
import ch.docuteam.tools.string.StringUtil;
import ch.docuteam.tools.translations.I18N;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Observer;
import java.util.Optional;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class LauncherView
extends JFrame {
    private static final long serialVersionUID = 1L;
    public String levelsConfigFileName = "./config/levels.xml";
    private String configDirectory = "./config";
    private String sipDirectory;
    private String dataDirectory;
    private String templateDirectory;
    private String exportsDirectory;
    private String reportsDirectory;
    private String reportsDestinationDirectory;
    private boolean inDevelopMode;
    private boolean newSIPDeleteSourcesByDefault;
    private boolean newSIPZippedByDefault;
    private boolean migrateFileKeepOriginal;
    private String lastUsedOpenOrSaveDirectory;
    protected FileProperty selectedSIP;
    protected List<SIPView> openedSIPViews = new Vector<SIPView>();
    protected List<FileProperty> sipsWithSavingInProgress = new Vector<FileProperty>();
    public static final String ACTION_HIDE_KEY = "actionHideKey";
    private List<String> hiddenActionKeyList = null;
    protected Action aboutAction;
    protected Action openExceptionWindowAction;
    protected OpenDocuteamHomepageAction openDocuteamHomepageAction;
    protected Action helpAction;
    protected Action quitAction;
    protected Action updateSAsFromServerAction;
    protected Action createNewSIPAction;
    protected Action createNewSIPFromTemplateAction;
    protected Action openSIPAction;
    protected Action openSIPReadWriteNoFileOpsAction;
    protected Action openSIPReadOnlyAction;
    protected Action showWorkspaceManagerAction;
    protected Action hideWorkspaceManagerAction;
    protected Action rereadWorkspaceFolderAction;
    protected Action selectWorkspaceFolderAction;
    protected Action searchWorkspaceAction;
    protected Action checkIngestFeedbackAction;
    private final Action openSIPInWorkspaceAction;
    private final Action openSIPInWorkspaceReadWriteNoFileOpsAction;
    private final Action openSIPInWorkspaceReadOnlyAction;
    protected Action renameSIPInWorkspaceAction;
    protected Action copySIPInWorkspaceAction;
    protected Action deleteSIPInWorkspaceAction;
    private final JPopupMenu popupMenu;
    protected JMenuBar menuBar;
    protected JMenu programMenu;
    protected JMenu workspaceMenu;
    protected JMenu sipMenu;
    protected JMenu saMenu;
    protected JMenu windowMenu;
    protected JPanel northPanel;
    protected JPanel workspaceManagerPanel;
    protected JButton showWorkspaceManagerButton;
    protected JButton hideWorkspaceManagerButton;
    protected SIPTable sipTable;
    private final JTextField footerTextField;
    protected Dimension ScreenSizeWithoutWorkspaceManager = PackerConstants.DEFAULT_SCREEN_SIZE_WITHOUT_WORKSPACE_MANAGER;
    protected Dimension ScreenSizeWithWorkspaceManager = PackerConstants.DEFAULT_SCREEN_SIZE_WITH_WORKSPACE_MANAGER;

    public String getSipDirectory() {
        return this.sipDirectory;
    }

    public void setSipDirectory(String sipDirectory) {
        this.sipDirectory = sipDirectory;
    }

    public String getLastUsedOpenOrSaveDirectory() {
        return this.lastUsedOpenOrSaveDirectory;
    }

    public void setLastUsedOpenOrSaveDirectory(String lastUsedOpenOrSaveDirectory) {
        this.lastUsedOpenOrSaveDirectory = lastUsedOpenOrSaveDirectory;
    }

    public String getDataDirectory() {
        return this.dataDirectory;
    }

    public void setDataDirectory(String dataDirectory) {
        this.dataDirectory = dataDirectory;
    }

    public String getTemplateDirectory() {
        return this.templateDirectory;
    }

    public void setTemplateDirectory(String templateDirectory) {
        this.templateDirectory = templateDirectory;
    }

    public String getExportsDirectory() {
        return this.exportsDirectory;
    }

    public void setExportsDirectory(String exportsDirectory) {
        this.exportsDirectory = exportsDirectory;
    }

    public String getReportsDirectory() {
        return this.reportsDirectory;
    }

    public void setReportsDirectory(String reportsDirectory) {
        this.reportsDirectory = reportsDirectory;
    }

    public String getReportsDestinationDirectory() {
        return this.reportsDestinationDirectory;
    }

    public boolean isDeleteSourcesByDefault() {
        return this.newSIPDeleteSourcesByDefault;
    }

    public boolean isNewSIPZippedByDefault() {
        return this.newSIPZippedByDefault;
    }

    public boolean isMigrateFileKeepOriginal() {
        return this.migrateFileKeepOriginal;
    }

    public boolean isInDevelopMode() {
        return this.inDevelopMode;
    }

    public Action getOpenSIPInWorkspaceAction() {
        return this.openSIPInWorkspaceAction;
    }

    public Action getOpenSIPInWorkspaceReadWriteNoFileOpsAction() {
        return this.openSIPInWorkspaceReadWriteNoFileOpsAction;
    }

    public Action getOpenSIPInWorkspaceReadOnlyAction() {
        return this.openSIPInWorkspaceReadOnlyAction;
    }

    public JTextField getFooterTextField() {
        return this.footerTextField;
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public SIPTable getSipTable() {
        return this.sipTable;
    }

    public void setSelectedSIP(FileProperty selectedSIP) {
        this.selectedSIP = selectedSIP;
    }

    public String getConfigDirectory() {
        return this.configDirectory;
    }

    public static void main(String[] args) throws DROIDCouldNotInitializeException {
        CommandLine commandLine = LauncherView.getCommandLine(args);
        final LauncherView l = new LauncherView(commandLine);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                l.shutdown();
            }
        });
        l.setVisible(true);
        l.checkIngestFeedback(false);
        l.openSIP(commandLine);
        LauncherView.debugClasspath();
    }

    protected LauncherView(String args) throws DROIDCouldNotInitializeException {
        this(LauncherView.getCommandLine(args));
    }

    protected LauncherView(CommandLine args) throws DROIDCouldNotInitializeException {
        this.initialize(args);
        this.setTitle(this.sipDirectory);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                LauncherView.this.requestQuit();
            }
        });
        Logger.info((java.lang.Object)"PACKER_PNG: DocuteamPacker.png");
        this.setIconImage(PackerConstants.getImage("DocuteamPacker.png"));
        DefaultTableCellRenderer rightAlignmentRenderer = new DefaultTableCellRenderer();
        rightAlignmentRenderer.setHorizontalAlignment(4);
        this.sipTable = new SIPTable(this);
        this.footerTextField = new JTextField();
        this.footerTextField.setName("FOOTER_TEXT_FIELD");
        this.footerTextField.setEditable(false);
        this.quitAction = new AbstractAction(I18N.translate((String)"ActionQuit"), PackerConstants.getImageIcon("Quit.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LauncherView.this.requestQuit();
            }
        };
        this.quitAction.putValue("AcceleratorKey", this.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), 115, 512));
        this.quitAction.putValue("ShortDescription", I18N.translate((String)"ToolTipQuit"));
        this.aboutAction = new AboutAction(this);
        try {
            OSXAdapter.setQuitHandler((java.lang.Object)this, (Method)this.getClass().getMethod("requestQuit", new Class[0]));
            Method openAboutWindowMethod = this.aboutAction.getClass().getMethod("openAboutWindow", new Class[0]);
            OSXAdapter.setAboutHandler((java.lang.Object)this, (Method)openAboutWindowMethod);
        }
        catch (Exception e) {
            Logger.error((java.lang.Object)e.getMessage(), (Throwable)e);
        }
        this.updateSAsFromServerAction = new AbstractAction(I18N.translate((String)"ActionLoadSAsFromServer"), PackerConstants.getImageIcon("Download.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LauncherView.this.updateSAsFromServer();
            }
        };
        this.updateSAsFromServerAction.putValue("ShortDescription", I18N.translate((String)"ToolTipLoadSAsFromServer"));
        this.showWorkspaceManagerAction = new AbstractAction(I18N.translate((String)"ActionShowWorkspaceManager"), PackerConstants.getImageIcon("WorkspaceManagerShow.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LauncherView.this.showWorkspaceManager(true);
            }
        };
        this.showWorkspaceManagerAction.putValue("ShortDescription", I18N.translate((String)"ToolTipShowWorkspaceManager"));
        this.hideWorkspaceManagerAction = new AbstractAction(I18N.translate((String)"ActionHideWorkspaceManager"), PackerConstants.getImageIcon("WorkspaceManagerHide.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LauncherView.this.showWorkspaceManager(false);
            }
        };
        this.hideWorkspaceManagerAction.putValue("ShortDescription", I18N.translate((String)"ToolTipHideWorkspaceManager"));
        this.selectWorkspaceFolderAction = new AbstractAction(I18N.translate((String)"ActionSelectWorkspaceFolder"), PackerConstants.getImageIcon("OpenFolder.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LauncherView.this.selectWorkspaceFolder();
            }
        };
        this.selectWorkspaceFolderAction.putValue("ShortDescription", I18N.translate((String)"ToolTipSelectWorkspaceFolder"));
        this.searchWorkspaceAction = new AbstractAction(I18N.translate((String)"ActionSearchWorkspace"), PackerConstants.getImageIcon("Search.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LauncherView.this.openSearchView();
            }
        };
        this.searchWorkspaceAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.searchWorkspaceAction.putValue("ShortDescription", I18N.translate((String)"ToolTipSearchWorkspace"));
        this.rereadWorkspaceFolderAction = new AbstractAction(I18N.translate((String)"ActionRereadWorkspaceFolder"), PackerConstants.getImageIcon("Redisplay.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LauncherView.this.rereadWorkspaceFolder();
            }
        };
        this.rereadWorkspaceFolderAction.putValue("ShortDescription", I18N.translate((String)"ToolTipRereadWorkspaceFolder"));
        this.createNewSIPAction = new AbstractAction(I18N.translate((String)"ActionCreateNew"), PackerConstants.getImageIcon("New.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LauncherView.this.createNewSIP();
            }
        };
        this.createNewSIPAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.createNewSIPAction.putValue("ShortDescription", I18N.translate((String)"ToolTipCreateNew"));
        this.createNewSIPFromTemplateAction = new AbstractAction(I18N.translate((String)"ActionCreateNewFromTemplate"), PackerConstants.getImageIcon("NewFromTemplate.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LauncherView.this.createNewSIPFromTemplate();
            }
        };
        this.createNewSIPFromTemplateAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x200));
        this.createNewSIPFromTemplateAction.putValue("ShortDescription", I18N.translate((String)"ToolTipCreateNewFromTemplate"));
        this.openSIPAction = new AbstractAction(I18N.translate((String)"ActionOpen"), PackerConstants.getImageIcon("Open.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LauncherView.this.openSIP(Document.Mode.ReadWrite);
            }
        };
        this.openSIPAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.openSIPAction.putValue("ShortDescription", I18N.translate((String)"ToolTipOpen"));
        this.openSIPReadWriteNoFileOpsAction = new AbstractAction(I18N.translate((String)"ActionOpenReadWriteNoFileOps"), PackerConstants.getImageIcon("OpenReadWriteNoFileOps.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LauncherView.this.openSIP(Document.Mode.ReadWriteNoFileOps);
            }
        };
        this.openSIPReadWriteNoFileOpsAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x200));
        this.openSIPReadWriteNoFileOpsAction.putValue("ShortDescription", I18N.translate((String)"ToolTipOpenReadWriteNoFileOps"));
        this.openSIPReadOnlyAction = new AbstractAction(I18N.translate((String)"ActionOpenReadOnly"), PackerConstants.getImageIcon("OpenReadOnly.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LauncherView.this.openSIP(Document.Mode.ReadOnly);
            }
        };
        this.openSIPReadOnlyAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40));
        this.openSIPReadOnlyAction.putValue("ShortDescription", I18N.translate((String)"ToolTipOpenReadOnly"));
        this.openSIPInWorkspaceAction = new OpenSIPInWorkspaceAction(this);
        this.openSIPInWorkspaceReadWriteNoFileOpsAction = new AbstractAction(I18N.translate((String)"ActionOpenInWorkspaceReadWriteNoFileOps"), PackerConstants.getImageIcon("OpenInWorkspaceReadWriteNoFileOps.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LauncherView.this.openSelectedSIPInWorkspace(Document.Mode.ReadWriteNoFileOps);
            }
        };
        this.openSIPInWorkspaceReadWriteNoFileOpsAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(10, 512));
        this.openSIPInWorkspaceReadWriteNoFileOpsAction.putValue("ShortDescription", I18N.translate((String)"ToolTipOpenInWorkspaceReadWriteNoFileOps"));
        this.openSIPInWorkspaceReadOnlyAction = new AbstractAction(I18N.translate((String)"ActionOpenInWorkspaceReadOnly"), PackerConstants.getImageIcon("OpenInWorkspaceReadOnly.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LauncherView.this.openSelectedSIPInWorkspace(Document.Mode.ReadOnly);
            }
        };
        this.openSIPInWorkspaceReadOnlyAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(10, 64));
        this.openSIPInWorkspaceReadOnlyAction.putValue("ShortDescription", I18N.translate((String)"ToolTipOpenInWorkspaceReadOnly"));
        this.renameSIPInWorkspaceAction = new AbstractAction(I18N.translate((String)"ActionRenameInWorkspace"), PackerConstants.getImageIcon("Rename.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LauncherView.this.renameSIP();
            }
        };
        this.renameSIPInWorkspaceAction.putValue("ShortDescription", I18N.translate((String)"ToolTipRenameSIP"));
        this.renameSIPInWorkspaceAction.putValue("AcceleratorKey", this.getKeyStroke(82, 512, 113, 512, 113, 128));
        this.copySIPInWorkspaceAction = new AbstractAction(I18N.translate((String)"ActionCopyInWorkspace"), PackerConstants.getImageIcon("Copy.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LauncherView.this.copySIP();
            }
        };
        this.copySIPInWorkspaceAction.putValue("ShortDescription", I18N.translate((String)"ToolTipCopySIP"));
        this.copySIPInWorkspaceAction.putValue("AcceleratorKey", this.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x200));
        this.deleteSIPInWorkspaceAction = new AbstractAction(I18N.translate((String)"ActionDeleteInWorkspace"), PackerConstants.getImageIcon("Delete.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LauncherView.this.deleteSIP();
            }
        };
        this.deleteSIPInWorkspaceAction.putValue("ShortDescription", I18N.translate((String)"ToolTipDeleteSIP"));
        this.deleteSIPInWorkspaceAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0));
        this.checkIngestFeedbackAction = new AbstractAction(I18N.translate((String)"ActionCheckIngestFeedback"), PackerConstants.getImageIcon("SubmitCheckIngestFeedback.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LauncherView.this.checkIngestFeedback(true);
            }
        };
        this.checkIngestFeedbackAction.putValue("ShortDescription", I18N.translate((String)"ToolTipCheckIngestFeedback"));
        this.checkIngestFeedbackAction.setEnabled(AIPCreatorProxy.isUsable());
        this.popupMenu = new JPopupMenu();
        this.popupMenu.setName("POPUP_MENU");
        this.addMenuItem(this.popupMenu, this.openSIPInWorkspaceAction, "SIP_OPEN_IN_WORKSPACE_MENU_ITEM");
        this.popupMenu.add(new JMenuItem(this.openSIPInWorkspaceReadWriteNoFileOpsAction));
        this.popupMenu.add(new JMenuItem(this.openSIPInWorkspaceReadOnlyAction));
        this.popupMenu.addSeparator();
        this.popupMenu.add(new JMenuItem(this.renameSIPInWorkspaceAction));
        this.popupMenu.add(new JMenuItem(this.copySIPInWorkspaceAction));
        this.popupMenu.add(new JMenuItem(this.deleteSIPInWorkspaceAction));
        this.programMenu = new JMenu(BuildInfo.getProduct());
        this.programMenu.setIcon(PackerConstants.getImageIcon("DocuteamPackerSmall.png"));
        this.programMenu.add(new JMenuItem(this.aboutAction));
        this.helpAction = new HelpAction(this);
        this.programMenu.add(new JMenuItem(this.helpAction));
        this.openDocuteamHomepageAction = new OpenDocuteamHomepageAction(this);
        this.programMenu.add(new JMenuItem(this.openDocuteamHomepageAction));
        this.programMenu.addSeparator();
        this.programMenu.add(new JMenuItem(this.quitAction));
        this.workspaceMenu = new JMenu(I18N.translate((String)"MenuWorkspace"));
        this.workspaceMenu.setName("WORKSPACE_MENU");
        this.workspaceMenu.setIcon(PackerConstants.getImageIcon("Workspace.png"));
        JMenuItem selectWorkspaceFolderMenuItem = new JMenuItem(this.selectWorkspaceFolderAction);
        selectWorkspaceFolderMenuItem.setName("WORKSPACE_SELECT_FOLDER_MENU_ITEM");
        this.workspaceMenu.add(selectWorkspaceFolderMenuItem);
        this.workspaceMenu.add(new JMenuItem(this.rereadWorkspaceFolderAction));
        this.workspaceMenu.addSeparator();
        this.workspaceMenu.add(new JMenuItem(this.showWorkspaceManagerAction));
        this.workspaceMenu.add(new JMenuItem(this.hideWorkspaceManagerAction));
        this.workspaceMenu.addSeparator();
        this.workspaceMenu.add(new JMenuItem(this.searchWorkspaceAction));
        this.workspaceMenu.addSeparator();
        this.workspaceMenu.add(new JMenuItem(this.checkIngestFeedbackAction));
        this.sipMenu = new JMenu(I18N.translate((String)"MenuFile"));
        this.sipMenu.setName("SIP_MENU");
        this.sipMenu.setIcon(PackerConstants.getImageIcon("MenuFile.png"));
        JMenuItem createNewMenuItem = new JMenuItem(this.createNewSIPAction);
        createNewMenuItem.setName("SIP_CREATE_NEW_MENU_ITEM");
        this.sipMenu.add(createNewMenuItem);
        this.sipMenu.add(new JMenuItem(this.createNewSIPFromTemplateAction));
        this.sipMenu.addSeparator();
        this.sipMenu.add(new JMenuItem(this.openSIPAction));
        this.sipMenu.add(new JMenuItem(this.openSIPReadWriteNoFileOpsAction));
        this.sipMenu.add(new JMenuItem(this.openSIPReadOnlyAction));
        this.sipMenu.addSeparator();
        this.sipMenu.add(new JMenuItem(this.openSIPInWorkspaceAction));
        this.sipMenu.add(new JMenuItem(this.openSIPInWorkspaceReadWriteNoFileOpsAction));
        this.sipMenu.add(new JMenuItem(this.openSIPInWorkspaceReadOnlyAction));
        this.sipMenu.addSeparator();
        this.sipMenu.add(new JMenuItem(this.renameSIPInWorkspaceAction));
        this.sipMenu.add(new JMenuItem(this.copySIPInWorkspaceAction));
        this.sipMenu.add(new JMenuItem(this.deleteSIPInWorkspaceAction));
        this.saMenu = new JMenu(I18N.translate((String)"MenuSA"));
        this.saMenu.setIcon(PackerConstants.getImageIcon("MenuSA.png"));
        this.saMenu.add(new JMenuItem(this.updateSAsFromServerAction));
        this.windowMenu = new JMenu(I18N.translate((String)"MenuWindow"));
        this.windowMenu.setIcon(PackerConstants.getImageIcon("MenuWindow.png"));
        this.openExceptionWindowAction = new OpenExceptionWindowAction(this);
        this.windowMenu.add(new JMenuItem(this.openExceptionWindowAction));
        this.menuBar = new JMenuBar();
        this.menuBar.add(this.programMenu);
        this.menuBar.add(this.workspaceMenu);
        this.menuBar.add(this.sipMenu);
        if (PropertyFile.isPropertyConfigured((String)"docuteamPacker.SA.BASE.URL")) {
            this.menuBar.add(this.saMenu);
        }
        this.menuBar.add(this.windowMenu);
        this.menuBar.setVisible(true);
        this.setJMenuBar(this.menuBar);
        JButton createNewSIPButton = new JButton(this.createNewSIPAction);
        createNewSIPButton.setHideActionText(true);
        JButton createNewSIPFromTemplateButton = new JButton(this.createNewSIPFromTemplateAction);
        createNewSIPFromTemplateButton.setHideActionText(true);
        JButton openSIPButton = new JButton(this.openSIPAction);
        openSIPButton.setHideActionText(true);
        JButton openSIPReadWriteNoFileOpsButton = new JButton(this.openSIPReadWriteNoFileOpsAction);
        openSIPReadWriteNoFileOpsButton.setHideActionText(true);
        JButton openSIPReadOnlyButton = new JButton(this.openSIPReadOnlyAction);
        openSIPReadOnlyButton.setHideActionText(true);
        JButton selectWorkspaceFolderButton = new JButton(this.selectWorkspaceFolderAction);
        selectWorkspaceFolderButton.setHideActionText(true);
        this.showWorkspaceManagerButton = new JButton(this.showWorkspaceManagerAction);
        this.showWorkspaceManagerButton.setHideActionText(true);
        this.hideWorkspaceManagerButton = new JButton(this.hideWorkspaceManagerAction);
        this.hideWorkspaceManagerButton.setHideActionText(true);
        JButton openSIPInWorkspaceButton = new JButton(this.openSIPInWorkspaceAction);
        openSIPInWorkspaceButton.setHideActionText(true);
        JButton openSIPInWorkspaceReadWriteNoFileOpsButton = new JButton(this.openSIPInWorkspaceReadWriteNoFileOpsAction);
        openSIPInWorkspaceReadWriteNoFileOpsButton.setHideActionText(true);
        JButton openSIPInWorkspaceReadOnlyButton = new JButton(this.openSIPInWorkspaceReadOnlyAction);
        openSIPInWorkspaceReadOnlyButton.setHideActionText(true);
        JButton renameSIPButton = new JButton(this.renameSIPInWorkspaceAction);
        renameSIPButton.setHideActionText(true);
        JButton copySIPButton = new JButton(this.copySIPInWorkspaceAction);
        copySIPButton.setHideActionText(true);
        JButton deleteSIPButton = new JButton(this.deleteSIPInWorkspaceAction);
        deleteSIPButton.setHideActionText(true);
        JButton searchWorkspaceButton = new JButton(this.searchWorkspaceAction);
        searchWorkspaceButton.setHideActionText(true);
        JButton logoButton = new JButton(PackerConstants.getImageIcon("Logo_docuteam_packer.png"));
        logoButton.setEnabled(true);
        logoButton.setHideActionText(true);
        logoButton.setContentAreaFilled(false);
        logoButton.setBorderPainted(false);
        logoButton.setToolTipText(I18N.translate((String)"ToolTipOpenDocuteamHomepage"));
        logoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LauncherView.this.openDocuteamHomepageAction.openDocuteamHomepage();
            }
        });
        Box buttonBox = new Box(0);
        buttonBox.add(searchWorkspaceButton);
        buttonBox.add(Box.createHorizontalStrut(20));
        buttonBox.add(createNewSIPButton);
        buttonBox.add(createNewSIPFromTemplateButton);
        buttonBox.add(Box.createHorizontalStrut(10));
        buttonBox.add(openSIPButton);
        buttonBox.add(openSIPReadWriteNoFileOpsButton);
        buttonBox.add(openSIPReadOnlyButton);
        buttonBox.add(Box.createHorizontalStrut(10));
        buttonBox.add(openSIPInWorkspaceButton);
        buttonBox.add(openSIPInWorkspaceReadWriteNoFileOpsButton);
        buttonBox.add(openSIPInWorkspaceReadOnlyButton);
        buttonBox.add(Box.createHorizontalStrut(10));
        buttonBox.add(renameSIPButton);
        buttonBox.add(copySIPButton);
        buttonBox.add(deleteSIPButton);
        this.northPanel = new JPanel(new BorderLayout());
        this.northPanel.setBorder(new EmptyBorder(0, 10, 0, 10));
        this.northPanel.add((Component)buttonBox, "West");
        this.northPanel.add((Component)logoButton, "East");
        JPanel footerPanel = new JPanel(new BorderLayout());
        footerPanel.setBorder(new EmptyBorder(5, 10, 5, 10));
        footerPanel.add(this.footerTextField);
        this.workspaceManagerPanel = new JPanel(new BorderLayout());
        this.workspaceManagerPanel.setBorder(new EmptyBorder(0, 10, 0, 10));
        this.workspaceManagerPanel.add((Component)new JScrollPane(this.sipTable.getTable()), "Center");
        this.add((Component)this.northPanel, "North");
        this.add((Component)this.workspaceManagerPanel, "Center");
        this.add((Component)footerPanel, "South");
        this.setLocation(PackerConstants.SCREEN_POSITION);
        this.showWorkspaceManager(true);
        this.enableOrDisableActions();
    }

    private List<String> getHiddenActionKeys() {
        String actionsNotVisible = PropertyFile.get((String)"docuteamPacker.actionsNotVisible", (String)"");
        return Arrays.asList(actionsNotVisible.split("\\s?,\\s?"));
    }

    public boolean isActionVisible(Action action) {
        String actionId = action.getValue(ACTION_HIDE_KEY) != null ? action.getValue(ACTION_HIDE_KEY).toString() : null;
        boolean isActionVisible = !this.isActionNotVisible(actionId);
        return isActionVisible;
    }

    public boolean isActionNotVisible(String actionId) {
        return this.hiddenActionKeyList.contains(actionId);
    }

    private void addMenuItem(JPopupMenu popupMenu, Action action, String name) {
        JMenuItem jMenuItem = new JMenuItem(action);
        jMenuItem.setName(name);
        popupMenu.add(jMenuItem);
    }

    protected static CommandLine getCommandLine(String ... args) {
        Options options = new Options();
        options.addOption("open", true, "(Optional) This SIP will be opened after startup");
        options.addOption("configDir", true, "(Optional) This directory is used as the configuration directory");
        options.addOption("help", false, "(Optional) What are the options? Display this text in the console");
        CommandLine commandLine = null;
        try {
            commandLine = new GnuParser().parse(options, args);
        }
        catch (ParseException ex) {
            System.err.println("Command line parsing failed: " + ex.getMessage());
            new HelpFormatter().printHelp("docuteam packer", options);
            System.exit(10);
            return null;
        }
        if (commandLine.hasOption("help")) {
            new HelpFormatter().printHelp("java -jar docuteamPacker.jar", options);
            System.exit(11);
            return null;
        }
        return commandLine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize(CommandLine commandLine) throws DROIDCouldNotInitializeException {
        JFrame splashWindow = new JFrame();
        splashWindow.setDefaultCloseOperation(0);
        splashWindow.setIconImage(PackerConstants.getImage("DocuteamPacker.png"));
        splashWindow.setUndecorated(true);
        splashWindow.add(new JLabel(BuildInfo.getVersion(), PackerConstants.getImageIcon("SplashScreen.png"), 0));
        splashWindow.setSize(300, 100);
        splashWindow.setLocationRelativeTo(null);
        try {
            splashWindow.setVisible(true);
            ToolTipManager.sharedInstance().setDismissDelay(60000);
            Toolkit.getDefaultToolkit().setDynamicLayout(true);
            Logger.info((java.lang.Object)"Initializing docuteam packer:");
            String propertyFileName = "./config/docuteamPacker.properties";
            if (commandLine.hasOption("configDir")) {
                String levelsConfigFile;
                this.configDirectory = commandLine.getOptionValue("configDir");
                Logger.info((java.lang.Object)("    configDir: " + this.configDirectory));
                String configFile = this.configDirectory + "/docuteamPacker.properties";
                if (new File(configFile).exists()) {
                    Logger.info((java.lang.Object)("    Init docuteam packer from: " + configFile));
                    propertyFileName = configFile;
                }
                if (new File(levelsConfigFile = this.configDirectory + "/levels.xml").exists()) {
                    Logger.info((java.lang.Object)("    Init levels from: " + levelsConfigFile));
                    this.levelsConfigFileName = levelsConfigFile;
                }
            } else {
                Logger.warn((java.lang.Object)("Command line doesn't have a configDir, commandLine:" + commandLine.getArgList()));
            }
            this.initializeProperties(propertyFileName);
            this.hiddenActionKeyList = this.getHiddenActionKeys();
            SIPView.initialize();
        }
        finally {
            splashWindow.setVisible(false);
            splashWindow.dispose();
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void initializeProperties(String propertyFileName) throws DROIDCouldNotInitializeException {
        PropertyFile.initialize((String)propertyFileName);
        language = PropertyFile.get((String)"docuteamPacker.displayLanguage", null);
        if (language != null) {
            Locale.setDefault(new Locale(language));
            JComponent.setDefaultLocale(Locale.getDefault());
        }
        doiGenNextNumberFilePath_prop = "docuteamPacker.DOIGenerator.nextNumberFilePath";
        doiGenPrefix_prop = "docuteamPacker.DOIGenerator.prefix";
        doiGenNextNumberFilePath = null;
        doiGenPrefix = null;
        if (PropertyFile.isPropertyConfigured((String)"docuteamPacker.DOIGenerator.nextNumberFilePath")) {
            doiGenNextNumberFilePath = PropertyFile.get((String)"docuteamPacker.DOIGenerator.nextNumberFilePath");
        }
        if (PropertyFile.isPropertyConfigured((String)"docuteamPacker.DOIGenerator.prefix")) {
            doiGenPrefix = PropertyFile.get((String)"docuteamPacker.DOIGenerator.prefix");
        }
        if (doiGenNextNumberFilePath != null) {
            DOIGenerator.initialize((String)doiGenPrefix, (String)doiGenNextNumberFilePath);
        } else if (doiGenPrefix != null) {
            DOIGenerator.initializePrefix((String)doiGenPrefix);
        }
        this.inDevelopMode = Boolean.parseBoolean(PropertyFile.get((String)"docuteamPacker.isDevMode", (String)"false"));
        Logger.info((java.lang.Object)("    isDevMode: " + this.inDevelopMode));
        if (!this.inDevelopMode) {
            SystemOutView.install();
            doOpenSystemOutViewOnOutput = "true".equalsIgnoreCase(PropertyFile.get((String)"docuteamPacker.openSystemOutViewOnOutput", (String)"true"));
            Logger.info((java.lang.Object)("    openSystemOutViewOnOutput: " + doOpenSystemOutViewOnOutput));
            SystemOutView.setDoPopUpOnWrite((boolean)doOpenSystemOutViewOnOutput);
        }
        additionalInfoText = new StringBuilder("----------\n").append(BuildInfo.getProduct()).append(" ").append(BuildInfo.getVersion()).append(" (").append(BuildInfo.getLastChange()).append(")\n----------\n").append(OperatingSystem.osName()).append(" ").append(OperatingSystem.osVersion()).append(" ").append(System.getProperty("os.arch")).append(" (").append(OperatingSystem.userLanguage()).append(")\n----------\n").append(System.getProperty("java.vendor")).append(" ").append(System.getProperty("java.version")).append(")\n----------\n").append(OperatingSystem.userName()).append("\n----------\n");
        for (String key : PropertyFile.getKeys()) {
            additionalInfoText.append(key).append(" = ").append(PropertyFile.get((String)key)).append("\n");
        }
        additionalInfoText.append("----------\n");
        SystemOutView.setAdditionalInfoText((String)additionalInfoText.toString());
        displayLanguageFromPropertyFile = PropertyFile.get((String)"docuteamPacker.displayLanguage", (String)"");
        usedDisplayLanguage = displayLanguageFromPropertyFile.isEmpty() != false ? OperatingSystem.userLanguage() : displayLanguageFromPropertyFile;
        I18N.initialize((String)usedDisplayLanguage, (String)"translations.Translations");
        Logger.info((java.lang.Object)("    displayLanguage: " + usedDisplayLanguage));
        defaultChecksumAlgorithm = PropertyFile.get((String)"docuteamPacker.defaultChecksumAlgorithm", (String)"");
        if (!defaultChecksumAlgorithm.equals("")) {
            try {
                Object.setDefaultMessageDigestAlgorithm(FileChecksumCalculator.Algorithm.lookup((String)defaultChecksumAlgorithm));
                Logger.info((java.lang.Object)("    defaultChecksumAlgorithm: " + defaultChecksumAlgorithm));
            }
            catch (NoSuchAlgorithmException e) {
                Logger.error((java.lang.Object)I18N.translate((String)"MessageNoSuchAlgorithmException", (java.lang.Object[])new java.lang.Object[]{defaultChecksumAlgorithm, Object.getDefaultMessageDigestAlgorithm().getCode()}));
            }
        }
        this.newSIPDeleteSourcesByDefault = Boolean.parseBoolean(PropertyFile.get((String)"docuteamPacker.newSIPDeleteSourcesByDefault", (String)"false"));
        Logger.info((java.lang.Object)("    newSIPDeleteSourcesByDefault: " + this.newSIPDeleteSourcesByDefault));
        this.newSIPZippedByDefault = Boolean.parseBoolean(PropertyFile.get((String)"docuteamPacker.newSIPDefaultsToZipped", (String)"true"));
        Logger.info((java.lang.Object)("    newSIPDefaultsToZipped: " + this.newSIPZippedByDefault));
        this.migrateFileKeepOriginal = Boolean.parseBoolean(PropertyFile.get((String)"docuteamPacker.migrateFileKeepOriginal", (String)"false"));
        Logger.info((java.lang.Object)("    migrateFileKeepOriginal: " + this.migrateFileKeepOriginal));
        this.sipDirectory = FileUtil.asCanonicalFileName((String)PropertyFile.get((String)("docuteamPacker.SIPDir" + PackerConstants.PROPERTY_FILE_PATH_OS_SUFFIX), (String)PackerConstants.USER_HOME, (String)PackerConstants.USER_HOME));
        sipDirPath = FileSystems.getDefault().getPath(this.sipDirectory, new String[0]);
        try {
            Files.createDirectories(sipDirPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            Logger.error((java.lang.Object)"error creating SIPDir: ", (Throwable)e);
        }
        this.lastUsedOpenOrSaveDirectory = this.sipDirectory;
        Logger.info((java.lang.Object)("    SIPDirectory: " + this.sipDirectory));
        this.dataDirectory = FileUtil.asCanonicalFileName((String)PropertyFile.get((String)("docuteamPacker.dataDir" + PackerConstants.PROPERTY_FILE_PATH_OS_SUFFIX), (String)this.sipDirectory, (String)this.sipDirectory));
        try {
            dataDirectoryPath = FileSystems.getDefault().getPath(this.dataDirectory, new String[0]);
            Files.createDirectories(dataDirectoryPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            Logger.error((java.lang.Object)"error creating dataDirectory: ", (Throwable)e);
        }
        Logger.info((java.lang.Object)("    dataDirectory: " + this.dataDirectory));
        this.templateDirectory = FileUtil.asCanonicalFileName((String)PropertyFile.get((String)("docuteamPacker.templateDir" + PackerConstants.PROPERTY_FILE_PATH_OS_SUFFIX), (String)this.sipDirectory, (String)this.sipDirectory));
        Logger.info((java.lang.Object)("    templateDirectory: " + this.templateDirectory));
        this.exportsDirectory = FileUtil.asCanonicalFileName((String)PropertyFile.get((String)("docuteamPacker.exportsDir" + PackerConstants.PROPERTY_FILE_PATH_OS_SUFFIX), (String)"./templates/exports/", (String)"./templates/exports/"));
        Logger.info((java.lang.Object)("    exportsDirectory: " + this.exportsDirectory));
        this.reportsDirectory = FileUtil.asCanonicalFileName((String)PropertyFile.get((String)("docuteamPacker.reportsDir" + PackerConstants.PROPERTY_FILE_PATH_OS_SUFFIX), (String)"./templates/reports/", (String)"./templates/reports/"));
        Logger.info((java.lang.Object)("    reportsDirectory: " + this.reportsDirectory));
        this.reportsDestinationDirectory = FileUtil.asCanonicalFileName((String)PropertyFile.get((String)("docuteamPacker.reportsDestinationDir" + PackerConstants.PROPERTY_FILE_PATH_OS_SUFFIX), (String)(OperatingSystem.userHome() + "Desktop"), (String)(OperatingSystem.userHome() + "Desktop")));
        Logger.info((java.lang.Object)("    reportsDestinationDirectory: " + this.reportsDestinationDirectory));
        Document.setBackupFolder(PropertyFile.get((String)("docuteamPacker.backupDir" + PackerConstants.PROPERTY_FILE_PATH_OS_SUFFIX), null, null));
        Logger.info((java.lang.Object)("    backupDirectory: " + Document.getBackupFolder()));
        FileUtil.setTempFolder((String)PropertyFile.get((String)("docuteamPacker.tempDir" + PackerConstants.PROPERTY_FILE_PATH_OS_SUFFIX), (String)(OperatingSystem.javaTempDir() + "DocuteamPacker"), (String)(OperatingSystem.javaTempDir() + "DocuteamPacker")));
        Logger.info((java.lang.Object)("    tempDirectory: " + FileUtil.getTempFolder()));
        try {
            AIPCreatorProxy.initializeImpl(PropertyFile.get((String)"docuteamPacker.AIPCreator.className", null));
            if (AIPCreatorProxy.isUsable()) {
                AIPCreatorProxy.initialize(PropertyFile.getProperties());
            }
        }
        catch (Exception e) {
            Logger.warn((java.lang.Object)I18N.translate((String)"MessageAIPCreatorInitializationException", (java.lang.Object[])new java.lang.Object[]{PropertyFile.get((String)"docuteamPacker.AIPCreator.className", null)}), (Throwable)e);
            AIPCreatorProxy.initializeImpl((AIPCreator)null);
        }
        Logger.info((java.lang.Object)("    levels: " + this.levelsConfigFileName));
        LevelOfDescription.setInitializationFilePath(this.levelsConfigFileName);
        droidSigFilePath = PropertyFile.get((String)"docuteamPacker.droid.signatureFile", (String)"");
        MetadataProviderDROID.setSignatureFileWithFallback((String)droidSigFilePath);
        droidContFilePath = PropertyFile.get((String)"docuteamPacker.droid.containerFile", (String)"");
        MetadataProviderDROID.setContainerSignatureFileWithFallback((String)droidContFilePath);
        droidExtensionUsage = PropertyFile.get((String)"docuteamPacker.droid.extensionUsage", (String)"");
        if (droidExtensionUsage != null && !droidExtensionUsage.isEmpty()) {
            Logger.info((java.lang.Object)("    Init droid with extension usage: " + droidExtensionUsage));
            if (StringUtil.isNumeric((String)droidExtensionUsage)) {
                MetadataProviderDROID.setExtensionUsage((int)Integer.parseInt(droidExtensionUsage));
            } else {
                Logger.warn((java.lang.Object)("Parameter must be a numerical value: " + droidExtensionUsage));
            }
        }
        SubmissionAgreement.initializeBaseURL(PropertyFile.get((String)"docuteamPacker.SA.BASE.URL", (String)""));
        Logger.info((java.lang.Object)("    SABaseURL: " + SubmissionAgreement.getBaseURL()));
        if ("true".equalsIgnoreCase(PropertyFile.get((String)"docuteamPacker.SA.getSAsFromServerOnStartup", (String)"false"))) {
            Logger.info((java.lang.Object)"    getSAsFromServerOnStartup: true");
            try {
                saNamesToBeDeleted = this.updateSAsFromServer();
                if (saNamesToBeDeleted.isEmpty() || this.inDevelopMode) ** GOTO lbl137
                confirmMessage = new StringBuilder(I18N.translate((String)"QuestionDeleteExcessiveSAs") + "\n");
                for (String s : saNamesToBeDeleted) {
                    confirmMessage.append("\n").append(s);
                }
                optionPane = new JOptionPane(confirmMessage, 3, 0);
                dialog = optionPane.createDialog("Confirmation");
                dialog.pack();
                screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                dialogSize = dialog.getSize();
                x = (screenSize.width - dialogSize.width) / 2;
                y = (screenSize.height / 2 - dialogSize.height) / 2;
                dialog.setLocation(x, y);
                dialog.setVisible(true);
                result = optionPane.getValue();
                if (result == null || (Integer)result != 0) ** GOTO lbl137
                for (String s : saNamesToBeDeleted) {
                    Logger.debug((java.lang.Object)("Deleting SA: " + s));
                    FileUtil.delete((String)(SubmissionAgreement.getSAFolder() + "/" + s));
                }
            }
            catch (Exception ex) {
                Logger.warn((java.lang.Object)("Could not update SAs from Server: " + ex.getMessage()));
            }
        } else {
            Logger.info((java.lang.Object)"    getSAsFromServerOnStartup: false");
        }
lbl137:
        // 5 sources

        ooConverterInitRetries = PropertyFile.get((String)"docuteamPacker.OOConverter.initializationRetries", (String)"");
        if (!ooConverterInitRetries.isEmpty()) {
            OOConverter.setNumberOfInitializationRetries((Integer)new Integer(ooConverterInitRetries));
        }
        Logger.info((java.lang.Object)("    ooConverterInitRetries: " + OOConverter.getNumberOfInitializationRetries()));
        OOConverter.initializeDontWait((String)PropertyFile.get((String)("docuteamPacker.OOConverter.path" + PackerConstants.PROPERTY_FILE_PATH_OS_SUFFIX), (String)""));
        Logger.info((java.lang.Object)("    ooConverterPath: " + OOConverter.getConverterPath()));
        pdftoolsURL = PropertyFile.get((String)"docuteamPacker.pdftools.url", (String)"");
        if (!pdftoolsURL.isEmpty()) {
            Logger.getLogger().info("    3-Heights Document Converter URL: " + pdftoolsURL);
            try {
                PDFToolsConverter.initialize((String)pdftoolsURL);
            }
            catch (PDFToolsConverterBadVMArgumentException | SocketException e) {
                Logger.warn((java.lang.Object)"Couldn't connect to the converter service", (Throwable)e);
            }
        }
        if (!(filePreviewCacheSizeLimit = PropertyFile.get((String)"docuteamPacker.filePreviewer.cacheSizeLimit", (String)"")).isEmpty()) {
            FilePreviewer.setCacheSizeLimit(new Integer(filePreviewCacheSizeLimit));
        }
        Logger.info((java.lang.Object)("    filePreviewCacheSizeLimit: " + FilePreviewer.getCacheSizeLimit()));
        try {
            if (Boolean.parseBoolean(PropertyFile.get((String)"docuteamPacker.useSystemLookAndFeel", (String)"true"))) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
        }
        catch (Exception var18_26) {
            // empty catch block
        }
        Logger.info((java.lang.Object)("    lookAndFeel: " + UIManager.getLookAndFeel().getName()));
    }

    protected void shutdown() {
        try {
            for (SIPView sipView : this.openedSIPViews) {
                if (sipView.getDocument() == null) continue;
                sipView.getDocument().unlockIfNecessary();
            }
        }
        catch (Exception e) {
            Logger.error((java.lang.Object)e.getMessage(), (Throwable)e);
        }
    }

    protected List<String> updateSAsFromServer() {
        try {
            return SubmissionAgreement.updateSAsFromServer();
        }
        catch (MalformedURLException ex) {
            JOptionPane.showMessageDialog(this, I18N.translate((String)"MessageCantUpdateSAsFromServer"), I18N.translate((String)"TitleCantUpdateSAsFromServer"), 0);
        }
        catch (Exception e) {
            Logger.error((java.lang.Object)e.getMessage(), (Throwable)e);
        }
        return new ArrayList<String>();
    }

    public boolean requestQuit() {
        Logger.debug((java.lang.Object)"Requesting quit...");
        if (this.sipsWithSavingInProgress.size() > 0) {
            Logger.debug((java.lang.Object)("Quit stopped by SIPs currently being saved:\n" + this.sipsWithSavingInProgress));
            return false;
        }
        ArrayList<SIPView> openedSIPViews = new ArrayList<SIPView>(this.openedSIPViews);
        for (SIPView sipView : openedSIPViews) {
            sipView.toFront();
            if (sipView.closeButtonClicked()) continue;
            Logger.debug((java.lang.Object)("Quit stopped by: '" + sipView.getFileProperty().getFile().getAbsolutePath() + "'"));
            return false;
        }
        SearchView.closeAndDispose();
        this.setVisible(false);
        this.dispose();
        FileUtil.setWritable((String)FileUtil.getTempFolder());
        System.exit(0);
        return true;
    }

    public void unregister(SIPView sipView) {
        int row;
        FileProperty fileProperty;
        if (this.openedSIPViews.contains(sipView)) {
            this.openedSIPViews.remove(sipView);
        }
        if ((fileProperty = sipView.getFileProperty()).isInWorkspace() && (row = this.sipTable.getSipTableModel().getRowIndexOfSip(fileProperty)) > -1) {
            fileProperty.setLockedBy("");
            this.sipTable.getSipTableModel().fireTableCellUpdated(row, Column.LOCKED_BY.ordinal());
        }
    }

    public KeyStroke getKeyStroke(int keyEvent, int modifiers) {
        return this.getKeyStroke(keyEvent, modifiers, keyEvent, modifiers);
    }

    public KeyStroke getKeyStroke(int macKeyEvent, int macModifiers, int pcKeyEvent, int pcModifiers) {
        return this.getKeyStroke(macKeyEvent, macModifiers, pcKeyEvent, pcModifiers, pcKeyEvent, pcModifiers);
    }

    public KeyStroke getKeyStroke(int macKeyEvent, int macModifiers, int winKeyEvent, int winModifiers, int linuxKeyEvent, int linuxModifiers) {
        if (OperatingSystem.isMacOSX()) {
            return KeyStroke.getKeyStroke(macKeyEvent, macModifiers);
        }
        if (OperatingSystem.isWindows()) {
            return KeyStroke.getKeyStroke(winKeyEvent, winModifiers);
        }
        if (OperatingSystem.isLinux()) {
            return KeyStroke.getKeyStroke(linuxKeyEvent, linuxModifiers);
        }
        return KeyStroke.getKeyStroke(winKeyEvent, winModifiers);
    }

    public void savingDocumentInProgress(SIPView sipView) {
        this.sipsWithSavingInProgress.add(sipView.getFileProperty());
    }

    public void savingDocumentFinished(SIPView sipView) {
        this.sipsWithSavingInProgress.remove(sipView.getFileProperty());
    }

    public void refreshSIPTable() {
        int sel = this.sipTable.getTable().getSelectedRow();
        this.sipTable.getSipTableModel().fireTableDataChanged();
        try {
            this.sipTable.getTable().getSelectionModel().setSelectionInterval(sel, sel);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void versionLabelClicked(MouseEvent e) {
        for (SIPView sipView : this.openedSIPViews) {
            Logger.info((java.lang.Object)sipView.getFileProperty().getFile().getPath());
        }
    }

    protected void showWorkspaceManager(boolean doShow) {
        if (doShow) {
            this.showWorkspaceManagerAction.setEnabled(false);
            this.hideWorkspaceManagerAction.setEnabled(true);
            this.workspaceManagerPanel.setVisible(true);
            this.showWorkspaceManagerButton.setVisible(false);
            this.hideWorkspaceManagerButton.setVisible(true);
            if (this.isVisible()) {
                this.getSize(this.ScreenSizeWithoutWorkspaceManager);
            }
            this.setPreferredSize(this.ScreenSizeWithWorkspaceManager);
            this.setResizable(true);
            this.pack();
        } else {
            this.sipTable.getTable().clearSelection();
            this.showWorkspaceManagerAction.setEnabled(true);
            this.hideWorkspaceManagerAction.setEnabled(false);
            this.workspaceManagerPanel.setVisible(false);
            this.showWorkspaceManagerButton.setVisible(true);
            this.hideWorkspaceManagerButton.setVisible(false);
            if (this.isVisible()) {
                this.getSize(this.ScreenSizeWithWorkspaceManager);
            }
            this.setPreferredSize(this.ScreenSizeWithoutWorkspaceManager);
            this.setResizable(true);
            this.pack();
        }
    }

    protected void createNewSIP() {
        String initialSourceFileOrFolder;
        CreateNewSIPDialog createNewSIPDialog = new CreateNewSIPDialog(this);
        if (!createNewSIPDialog.goButtonWasClicked) {
            return;
        }
        String rootFolderName = createNewSIPDialog.rootFolderNameTextField.getText();
        String sourceFileOrFolderName = createNewSIPDialog.sourceFileOrFolderTextField.getText();
        final boolean createEmptySIP = createNewSIPDialog.selectSIPEmptyRadioButton.isSelected();
        final boolean deleteSources = createNewSIPDialog.isDeleteSourcesCheckBoxSelected();
        String destinationFolderName = createNewSIPDialog.destinationFolderTextField.getText();
        String destinationFileName = createNewSIPDialog.destinationNameTextField.getText();
        boolean beZIP = createNewSIPDialog.beZIPCheckBox.isSelected();
        final SubmissionAgreement.Overview saOverview = (SubmissionAgreement.Overview)createNewSIPDialog.saComboBox.getSelectedItem();
        String string = initialSourceFileOrFolder = createEmptySIP ? rootFolderName : sourceFileOrFolderName;
        if (initialSourceFileOrFolder.isEmpty() || destinationFileName.isEmpty()) {
            return;
        }
        if (beZIP) {
            if (!destinationFileName.toLowerCase().endsWith(".zip")) {
                destinationFileName = destinationFileName + ".zip";
            }
        } else if (destinationFileName.toLowerCase().endsWith(".zip")) {
            destinationFileName = destinationFileName.substring(0, destinationFileName.length() - 4);
        }
        final String newSIPFileName = destinationFolderName + "/" + destinationFileName;
        new SwingWorker<Integer, java.lang.Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer doInBackground() {
                LauncherView.this.footerTextField.setText(I18N.translate((String)"MessageFooterNewFile") + newSIPFileName + "...");
                SmallPeskyMessageWindow waitWindow = SmallPeskyMessageWindow.openBlocking((Window)LauncherView.this, (String)I18N.translate((String)"MessageTempCreatingSIP"));
                Document document = null;
                try {
                    LauncherView.this.setCursor(Cursor.getPredefinedCursor(3));
                    String selectedSAid = null;
                    String selectedDSSid = null;
                    if (saOverview != null) {
                        selectedSAid = saOverview.saId;
                        selectedDSSid = saOverview.dssId;
                    }
                    ExceptionCollector.clear();
                    document = createEmptySIP ? Document.createNewWithRootFolderName(newSIPFileName, initialSourceFileOrFolder, selectedSAid, selectedDSSid, "docuteam packer", (Observer)waitWindow) : Document.createNewWithRoot(newSIPFileName, initialSourceFileOrFolder, selectedSAid, selectedDSSid, "docuteam packer", (Observer)waitWindow);
                    LauncherView.this.footerTextField.setText(I18N.translate((String)"MessageFooterNewFile") + newSIPFileName);
                    Util.showAllFromExceptionCollector(waitWindow, LauncherView.this);
                    if (deleteSources && JOptionPane.showConfirmDialog(LauncherView.this, I18N.translate((String)"QuestionDeleteSources"), I18N.translate((String)"TitleDeleteSources"), 0) == 0) {
                        try {
                            FileUtil.delete((String)initialSourceFileOrFolder);
                        }
                        catch (FileUtilExceptionListException e) {
                            JOptionPane.showMessageDialog(LauncherView.this, e.toString(), I18N.translate((String)"TitleCouldNotDeleteSources"), 2);
                        }
                    }
                }
                catch (Exception e) {
                    Logger.error((java.lang.Object)e.getMessage(), (Throwable)e);
                    document = null;
                    LauncherView.this.footerTextField.setText(I18N.translate((String)"MessageFooterCantCreateFile") + newSIPFileName);
                    waitWindow.close();
                    JOptionPane.showMessageDialog(LauncherView.this, e.toString(), I18N.translate((String)"TitleCantCreateSIP"), 0);
                }
                finally {
                    if (document != null) {
                        try {
                            document.unlockIfNecessary();
                            document.cleanupWorkingCopy();
                        }
                        catch (Exception e) {
                            Logger.error((java.lang.Object)e.getMessage(), (Throwable)e);
                            JOptionPane.showMessageDialog(LauncherView.this, e.toString(), "Unable to cleanup working folder due to errors", 0);
                        }
                        LauncherView.this.sipTable.rereadSIPTable();
                        FileProperty fileProperty = LauncherView.this.findFilePropertyInSIPList(new File(document.getOriginalSIPFolder()));
                        LauncherView.this.openSIP(fileProperty, Document.Mode.ReadWrite, null);
                    }
                    waitWindow.close();
                    LauncherView.this.setCursor(Cursor.getPredefinedCursor(0));
                }
                return 0;
            }
        }.execute();
    }

    protected void createNewSIPFromTemplate() {
        CreateNewSIPFromTemplateDialog createNewSIPFromTemplateDialog = new CreateNewSIPFromTemplateDialog(this);
        if (!createNewSIPFromTemplateDialog.goButtonWasClicked) {
            return;
        }
        final String templateName = (String)createNewSIPFromTemplateDialog.templateComboBox.getSelectedItem();
        String destinationFolderName = createNewSIPFromTemplateDialog.destinationFolderTextField.getText();
        String destinationFileName = createNewSIPFromTemplateDialog.destinationNameTextField.getText();
        boolean beZIP = createNewSIPFromTemplateDialog.beZIPCheckBox.isSelected();
        if (destinationFileName.isEmpty()) {
            return;
        }
        if (beZIP) {
            if (!destinationFileName.toLowerCase().endsWith(".zip")) {
                destinationFileName = destinationFileName + ".zip";
            }
        } else if (destinationFileName.toLowerCase().endsWith(".zip")) {
            destinationFileName = destinationFileName.substring(0, destinationFileName.length() - 4);
        }
        final String newSIPFileName = destinationFolderName + "/" + destinationFileName;
        new SwingWorker<Integer, java.lang.Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer doInBackground() {
                LauncherView.this.footerTextField.setText(I18N.translate((String)"MessageFooterNewFile") + newSIPFileName + "...");
                SmallPeskyMessageWindow waitWindow = SmallPeskyMessageWindow.openBlocking((Window)LauncherView.this, (String)I18N.translate((String)"MessageTempCreatingSIP"));
                Document document = null;
                try {
                    LauncherView.this.setCursor(Cursor.getPredefinedCursor(3));
                    ExceptionCollector.clear();
                    document = Document.createNewFromTemplate(LauncherView.this.templateDirectory + "/" + templateName, newSIPFileName, "docuteam packer");
                    LauncherView.this.footerTextField.setText(I18N.translate((String)"MessageFooterNewFile") + newSIPFileName);
                    Util.showAllFromExceptionCollector(waitWindow, LauncherView.this);
                }
                catch (Exception e) {
                    Logger.error((java.lang.Object)e.getMessage(), (Throwable)e);
                    document = null;
                    LauncherView.this.footerTextField.setText(I18N.translate((String)"MessageFooterCantCreateFile") + newSIPFileName);
                    waitWindow.close();
                    JOptionPane.showMessageDialog(LauncherView.this, e.toString(), I18N.translate((String)"TitleCantCreateSIP"), 0);
                }
                finally {
                    if (document != null) {
                        try {
                            document.unlockIfNecessary();
                            document.cleanupWorkingCopy();
                        }
                        catch (Exception e) {
                            Logger.error((java.lang.Object)e.getMessage(), (Throwable)e);
                            JOptionPane.showMessageDialog(LauncherView.this, e.toString(), "Unable to cleanup working folder due to errors", 0);
                        }
                        FileProperty fileProperty = LauncherView.this.findFilePropertyInSIPList(new File(document.getOriginalSIPFolder()));
                        LauncherView.this.openSIP(fileProperty, Document.Mode.ReadWrite, null);
                    }
                    waitWindow.close();
                    LauncherView.this.setCursor(Cursor.getPredefinedCursor(0));
                }
                return 0;
            }
        }.execute();
    }

    protected FileProperty findFilePropertyInSIPList(File file) {
        FileProperty fileProperty = null;
        for (int i = 0; i < this.sipTable.getSipTableModel().getRowCount(); ++i) {
            FileProperty entry = this.sipTable.getSipTableModel().getSipAtIndex(i);
            if (entry == null || !entry.getFile().getAbsolutePath().equals(file.getAbsolutePath())) continue;
            fileProperty = entry;
            break;
        }
        if (fileProperty == null) {
            fileProperty = new FileProperty(file, false);
        }
        return fileProperty;
    }

    protected void selectWorkspaceFolder() {
        JFileChooser fileChooser = new JFileChooser(this.sipDirectory);
        fileChooser.setName("WORKSPACE_SELECT_FOLDER_FILE_CHOOSER");
        fileChooser.setDialogType(0);
        fileChooser.setFileSelectionMode(1);
        if (fileChooser.showOpenDialog(this) != 0) {
            return;
        }
        this.sipDirectory = FileUtil.asCanonicalFileName((File)fileChooser.getSelectedFile());
        this.setTitle(this.sipDirectory);
        this.sipTable.rereadSIPTable();
    }

    protected void rereadWorkspaceFolder() {
        this.sipTable.rereadSIPTable();
    }

    protected void openSearchView() {
        SearchView.open(this);
    }

    protected Optional<String> askNewSIPName(FileProperty sip) {
        String title = I18N.translate((String)"TitleRenameSIP");
        String message = I18N.translate((String)"MessageEnterNewSIPName");
        int messageType = 3;
        String newSIPName = "";
        String textFieldContent = sip.getName();
        String DOT_ZIP = ".zip";
        boolean hasZipExtension = textFieldContent.endsWith(".zip");
        boolean keepLooping = true;
        while (keepLooping) {
            newSIPName = hasZipExtension ? textFieldContent.substring(0, textFieldContent.lastIndexOf(".zip")) : textFieldContent;
            if ((newSIPName = (String)JOptionPane.showInputDialog(this, message, title, messageType, null, null, newSIPName)) == null) {
                return Optional.empty();
            }
            if (newSIPName.length() == 0) {
                message = I18N.translate((String)"MessageEnterNewSIPName");
                messageType = 3;
                continue;
            }
            if (!hasZipExtension && newSIPName.endsWith(".zip")) {
                message = I18N.translate((String)"MessageFolderToZipNotOk") + "\n" + I18N.translate((String)"MessageEnterNewSIPName");
                messageType = 2;
                continue;
            }
            if (hasZipExtension && !newSIPName.endsWith(".zip")) {
                newSIPName = newSIPName + ".zip";
            }
            if (!FileUtil.isFileNameAllowed((String)newSIPName)) {
                title = I18N.translate((String)"TitleCantRenameSIP");
                message = I18N.translate((String)"MessageBadSIPName") + "\n" + newSIPName + "\n" + I18N.translate((String)"MessageEnterNewSIPName");
                messageType = 2;
                continue;
            }
            File newSIP = new File(sip.getFile().getParent() + File.separator + newSIPName);
            if (newSIP.exists()) {
                title = I18N.translate((String)"TitleCantRenameSIP");
                message = I18N.translate((String)"MessageSIPAlreadyExists") + "\n" + newSIPName + "\n" + I18N.translate((String)"MessageEnterNewSIPName");
                messageType = 2;
                continue;
            }
            keepLooping = false;
        }
        return Optional.of(newSIPName);
    }

    protected void renameSIP() {
        if (this.selectedSIP == null || Document.isLocked(this.selectedSIP.getFile())) {
            return;
        }
        while (true) {
            Optional<String> theNewSIPName;
            if (!(theNewSIPName = this.askNewSIPName(this.selectedSIP)).isPresent()) {
                return;
            }
            try {
                FileUtil.renameTo((File)this.selectedSIP.getFile(), (File)new File(this.selectedSIP.getFile().getParent() + File.separator + theNewSIPName.get()));
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, ex.getMessage() + "\n" + I18N.translate((String)"MessageEnterNewSIPName"), I18N.translate((String)"TitleCantRenameSIP"), 2);
                continue;
            }
            break;
        }
        this.sipTable.rereadSIPTable();
    }

    protected void copySIP() {
        Boolean ok;
        if (this.selectedSIP == null) {
            return;
        }
        String title = I18N.translate((String)"TitleCopySIP");
        String message = I18N.translate((String)"MessageEnterNewSIPName");
        String textFieldContent = FileUtil.asFilePathWithoutExtension((String)this.selectedSIP.getName());
        do {
            String newItemName;
            if ((newItemName = CopySIPDialog.open(this, message, title, textFieldContent)) == null || newItemName.length() == 0) {
                return;
            }
            ok = false;
            if (!FileUtil.isFileNameAllowed((String)newItemName)) {
                title = I18N.translate((String)"TitleCantCopySIP");
                message = I18N.translate((String)"MessageBadLettersInFilename") + "\n" + I18N.translate((String)"MessageEnterNewSIPName");
                textFieldContent = FileUtil.asFilePathWithoutExtension((String)newItemName);
                continue;
            }
            File newSIP = new File(this.selectedSIP.getFile().getParent() + "/" + newItemName);
            if (newSIP.exists()) {
                title = I18N.translate((String)"TitleCantCopySIP");
                message = I18N.translate((String)"MessageSIPAlreadyExists") + "\n" + I18N.translate((String)"MessageEnterNewSIPName");
                textFieldContent = FileUtil.asFilePathWithoutExtension((String)newItemName);
                continue;
            }
            try {
                Document.copy(this.selectedSIP.getFile().getPath(), newSIP.getPath());
            }
            catch (Exception ex) {
                title = I18N.translate((String)"TitleCantCopySIP");
                message = ex.getMessage() + "\n" + I18N.translate((String)"MessageEnterNewSIPName");
                textFieldContent = FileUtil.asFilePathWithoutExtension((String)newItemName);
                try {
                    FileUtil.delete((File)newSIP);
                }
                catch (FileUtilExceptionListException fileUtilExceptionListException) {}
                continue;
            }
            ok = true;
        } while (!ok.booleanValue());
        this.sipTable.rereadSIPTable();
    }

    protected void deleteSIP() {
        if (this.selectedSIP == null || Document.isLocked(this.selectedSIP.getFile())) {
            return;
        }
        if (JOptionPane.showConfirmDialog(this, I18N.translate((String)"QuestionDeleteSIP"), I18N.translate((String)"TitleDeleteSIP"), 0) != 0) {
            return;
        }
        try {
            FileUtil.delete((File)this.selectedSIP.getFile());
        }
        catch (Exception e) {
            Logger.error((java.lang.Object)e.getMessage(), (Throwable)e);
        }
        this.sipTable.getSipTableModel().removeSipFromView(this.selectedSIP);
    }

    protected void checkIngestFeedback(boolean withFeedbackIfNothingFound) {
        if (!AIPCreatorProxy.isUsable()) {
            return;
        }
        Logger.debug((java.lang.Object)"Checking overall ingest feedback...");
        try {
            List<String> feedbackFoundForSIPs = AIPCreatorProxy.getAIPCreator().checkIngestFeedback(this.sipDirectory);
            Logger.debug((java.lang.Object)("Found ingest feedback: " + feedbackFoundForSIPs));
            if (feedbackFoundForSIPs == null || feedbackFoundForSIPs.isEmpty()) {
                if (withFeedbackIfNothingFound) {
                    JOptionPane.showMessageDialog(this, I18N.translate((String)"MessageCheckIngestFeedbackEmpty"), I18N.translate((String)"HeaderCheckIngestFeedback"), 1);
                }
                return;
            }
            StringBuilder feedbackFoundForSIPsMessage = new StringBuilder(I18N.translate((String)"MessageCheckIngestFeedbackFound"));
            for (String sipName : feedbackFoundForSIPs) {
                feedbackFoundForSIPsMessage.append("\n").append(sipName);
            }
            new ScrollableMessageDialog((Window)this, I18N.translate((String)"HeaderCheckIngestFeedback"), feedbackFoundForSIPsMessage.toString());
            this.rereadWorkspaceFolder();
            for (String sipName : feedbackFoundForSIPs) {
                String sipPath = this.sipDirectory + File.separator + sipName;
                for (SIPView openSIPView : this.openedSIPViews) {
                    if (!openSIPView.getFileProperty().getFile().getAbsolutePath().equals(sipPath)) continue;
                    openSIPView.read(sipPath, Document.Mode.ReadOnly, null);
                }
            }
        }
        catch (Exception e) {
            Logger.error((java.lang.Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void openSIP(CommandLine commandLine) {
        if (commandLine.hasOption("open")) {
            Logger.debug((java.lang.Object)("open: " + commandLine.getOptionValue("open")));
            FileProperty fileProperty = this.findFilePropertyInSIPList(new File(commandLine.getOptionValue("open")));
            this.openSIP(fileProperty, Document.Mode.ReadWrite, null);
        } else if (this.inDevelopMode) {
            // empty if block
        }
    }

    protected void openSIP(Document.Mode mode) {
        SIPFileChooser fileChooser = new SIPFileChooser(this.lastUsedOpenOrSaveDirectory);
        if (fileChooser.showOpenDialog(this) != 0) {
            return;
        }
        this.lastUsedOpenOrSaveDirectory = FileUtil.asCanonicalFileName((String)fileChooser.getSelectedFile().getParent());
        FileProperty fileProperty = this.findFilePropertyInSIPList(fileChooser.getSelectedFile());
        this.openSIP(fileProperty, mode, null);
    }

    protected void openSIP(FileProperty fileProperty, Document.Mode mode, String admIdToSelect) {
        if (this.sipsWithSavingInProgress.contains(fileProperty)) {
            JOptionPane.showMessageDialog(this, I18N.translate((String)"MessageCantOpenSIPWhileBeingSaved"), I18N.translate((String)"TitleOpenSIP"), 1);
            return;
        }
        Logger.debug((java.lang.Object)("Opening SIP: " + fileProperty.getFile().getAbsolutePath()));
        for (SIPView openSIPView : this.openedSIPViews) {
            if (!openSIPView.getFileProperty().equals(fileProperty)) continue;
            openSIPView.toFront();
            openSIPView.requestFocus();
            openSIPView.selectNode(admIdToSelect);
            return;
        }
        SIPView sipView = SIPView.open(this, fileProperty, mode, admIdToSelect);
        this.openedSIPViews.add(sipView);
        int row = this.sipTable.getSipTableModel().getRowIndexOfSip(fileProperty);
        if (row > -1) {
            this.sipTable.getSipTableModel().getSipAtIndex(row).setLockedBy(OperatingSystem.userName());
            this.sipTable.getSipTableModel().fireTableCellUpdated(row, Column.LOCKED_BY.ordinal());
        }
    }

    public void openSelectedSIPInWorkspace(Document.Mode mode) {
        if (this.selectedSIP == null) {
            return;
        }
        this.openSIP(this.selectedSIP, mode, null);
    }

    protected void openSIPInWorkspace(String sipName, Document.Mode mode) {
        String sipPath = this.sipDirectory + File.separator + sipName;
        FileProperty fileProperty = this.findFilePropertyInSIPList(new File(sipPath));
        this.openSIP(fileProperty, mode, null);
    }

    public void openSIPInWorkspace(String sipName, Document.Mode mode, String admIdToSelect) {
        String sipPath = this.sipDirectory + File.separator + sipName;
        FileProperty fileProperty = this.findFilePropertyInSIPList(new File(sipPath));
        this.openSIP(fileProperty, mode, admIdToSelect);
    }

    public void enableOrDisableActions() {
        if (this.selectedSIP == null) {
            this.openSIPInWorkspaceAction.setEnabled(false);
            this.openSIPInWorkspaceReadWriteNoFileOpsAction.setEnabled(false);
            this.openSIPInWorkspaceReadOnlyAction.setEnabled(false);
            this.renameSIPInWorkspaceAction.setEnabled(false);
            this.copySIPInWorkspaceAction.setEnabled(false);
            this.deleteSIPInWorkspaceAction.setEnabled(false);
        } else if (Document.isLockedBySomebodyElse(this.selectedSIP.getFile())) {
            this.openSIPInWorkspaceAction.setEnabled(false);
            this.openSIPInWorkspaceReadWriteNoFileOpsAction.setEnabled(false);
            this.openSIPInWorkspaceReadOnlyAction.setEnabled(true);
            this.renameSIPInWorkspaceAction.setEnabled(false);
            this.copySIPInWorkspaceAction.setEnabled(true);
            this.deleteSIPInWorkspaceAction.setEnabled(false);
        } else if (Document.isLocked(this.selectedSIP.getFile())) {
            this.openSIPInWorkspaceAction.setEnabled(true);
            this.openSIPInWorkspaceReadWriteNoFileOpsAction.setEnabled(true);
            this.openSIPInWorkspaceReadOnlyAction.setEnabled(true);
            this.renameSIPInWorkspaceAction.setEnabled(false);
            this.copySIPInWorkspaceAction.setEnabled(true);
            this.deleteSIPInWorkspaceAction.setEnabled(false);
        } else {
            this.openSIPInWorkspaceAction.setEnabled(true);
            this.openSIPInWorkspaceReadWriteNoFileOpsAction.setEnabled(true);
            this.openSIPInWorkspaceReadOnlyAction.setEnabled(true);
            this.renameSIPInWorkspaceAction.setEnabled(true);
            this.copySIPInWorkspaceAction.setEnabled(true);
            this.deleteSIPInWorkspaceAction.setEnabled(true);
        }
    }

    private static void debugClasspath() {
        URL[] urls;
        boolean inDevelopMode = Boolean.parseBoolean(PropertyFile.get((String)"docuteamPacker.isDevMode", (String)"false"));
        if (!inDevelopMode) {
            return;
        }
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        for (URL url : urls = ((URLClassLoader)cl).getURLs()) {
            Logger.info((java.lang.Object)url.getFile());
        }
    }
}

