/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.packer.gui.sipView.actions;

import ch.docuteam.darc.exceptions.FileAlreadyExistsException;
import ch.docuteam.darc.exceptions.FileOperationNotAllowedException;
import ch.docuteam.darc.mets.Document;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.darc.mets.structmap.NodeFile;
import ch.docuteam.packer.gui.PackerConstants;
import ch.docuteam.packer.gui.sipView.SIPView;
import ch.docuteam.packer.gui.sipView.actions.AbstractSIPViewAction;
import ch.docuteam.packer.gui.sipView.actions.AppendMigratedFileDialog;
import ch.docuteam.packer.gui.util.Util;
import ch.docuteam.tools.exception.ExceptionCollector;
import ch.docuteam.tools.file.exception.FileUtilExceptionListException;
import ch.docuteam.tools.out.Logger;
import ch.docuteam.tools.translations.I18N;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;

public class AppendMigratedFileAction
extends AbstractSIPViewAction {
    private static final long serialVersionUID = 1L;

    public AppendMigratedFileAction(SIPView sipView) {
        super(I18N.translate((String)"ButtonAppendMigratedFile"), PackerConstants.getImageIcon("Migrate.png"), sipView);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int selectedRow = this.sipView.getTreeTable().getSelectedRow();
        NodeAbstract selectedNode = (NodeAbstract)this.sipView.getTreeTable().getPathForRow(selectedRow).getLastPathComponent();
        String admId = selectedNode.getAdmId();
        AppendMigratedFileDialog dialog = new AppendMigratedFileDialog(this.sipView, selectedNode);
        if (!dialog.goButtonWasClicked) {
            return;
        }
        File newFile = new File(dialog.derivedFileTextField.getText());
        if (!newFile.exists()) {
            return;
        }
        ExceptionCollector.clear();
        if (dialog.keepOriginalCheckBox.isSelected()) {
            try {
                ((NodeFile)selectedNode).migrateToFileKeepOriginal(newFile.getAbsolutePath(), "docuteam packer");
            }
            catch (FileAlreadyExistsException | FileOperationNotAllowedException | FileUtilExceptionListException | IOException e1) {
                Logger.error((Object)e1.getMessage(), (Throwable)e1);
            }
        } else {
            try {
                ((NodeFile)selectedNode).migrateToFile(newFile.getAbsolutePath(), "docuteam packer");
            }
            catch (FileAlreadyExistsException | FileOperationNotAllowedException | FileUtilExceptionListException | IOException e1) {
                Logger.error((Object)e1.getMessage(), (Throwable)e1);
            }
        }
        Util.showAllFromExceptionCollector(null, this.sipView);
        this.sipView.getTreeTableModel().refreshTreeStructure(this.sipView.getTreeTable().getPathForRow(selectedRow).getParentPath());
        this.sipView.selectNode(admId);
        this.sipView.enableOrDisableActions();
    }

    @Override
    public void enableOrDisable() {
        boolean isEnabled = false;
        if (this.sipView.getTreeTable().getSelectedRowCount() == 1) {
            int selectedRow = this.sipView.getTreeTable().getSelectedRow();
            NodeAbstract node = (NodeAbstract)this.sipView.getTreeTable().getPathForRow(selectedRow).getLastPathComponent();
            isEnabled = this.sipView.getDocument().getMode().equals((Object)Document.Mode.ReadWrite) && node.isFile() && node.canRead() && node.canWrite() && ((NodeFile)node).getMigrationDerivedNode() == null && node.getSubmitStatus().isEditingAllowed();
        }
        this.setEnabled(isEnabled);
    }
}

