/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.packer.gui.sipView;

import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.darc.mets.structmap.NodeFolder;
import ch.docuteam.packer.gui.sipView.SIPView;
import ch.docuteam.packer.gui.sipView.TreeNodeListTransferable;
import ch.docuteam.packer.gui.sipView.tableModel.TreeTableModel;
import ch.docuteam.tools.out.Logger;
import ch.docuteam.tools.translations.I18N;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.treetable.TreeTableNode;

public class TreeTableTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 1L;
    private final SIPView sipView;

    public TreeTableTransferHandler(SIPView sipView) {
        this.sipView = sipView;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        return new TreeNodeListTransferable((JXTreeTable)c);
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport transferSupport) {
        if (!this.sipView.getDocument().areFileOperationsAllowed()) {
            return false;
        }
        if (!transferSupport.isDrop()) {
            return false;
        }
        if (!transferSupport.isDataFlavorSupported(TreeNodeListTransferable.DocuteamPackerTreeNodeListDataFlavor) && !transferSupport.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            return false;
        }
        int targetIndex = ((JTable.DropLocation)transferSupport.getDropLocation()).getRow();
        if (targetIndex == -1) {
            return false;
        }
        JXTreeTable treeTableNode = (JXTreeTable)transferSupport.getComponent();
        TreePath pathForRow = treeTableNode.getPathForRow(targetIndex);
        if (pathForRow == null) {
            return false;
        }
        NodeAbstract targetNode = (NodeAbstract)pathForRow.getLastPathComponent();
        if (!targetNode.fileExists() || !targetNode.canRead() || !targetNode.canWrite() || targetNode.hasPredecessorNotReadableOrWritableByCurrentUser()) {
            return false;
        }
        if (transferSupport.isDataFlavorSupported(TreeNodeListTransferable.DocuteamPackerTreeNodeListDataFlavor)) {
            String targetSIP = this.sipView.getDocument().getSIPFolder();
            TreeNodeListTransferable transferData = null;
            String sourceSIP = "";
            try {
                transferData = (TreeNodeListTransferable)transferSupport.getTransferable().getTransferData(TreeNodeListTransferable.DocuteamPackerTreeNodeListDataFlavor);
                sourceSIP = transferData.getSipPath();
            }
            catch (UnsupportedFlavorException ex) {
                if (this.sipView.getLauncherView().isInDevelopMode()) {
                    Logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
                return false;
            }
            catch (IOException ex) {
                if (this.sipView.getLauncherView().isInDevelopMode()) {
                    Logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
                return false;
            }
            if (!targetSIP.equals(sourceSIP)) {
                return false;
            }
            TreeTableNode sourceParent = transferData.getDraggedNodes().get(0).getParent();
            if (sourceParent == targetNode) {
                return false;
            }
            for (NodeAbstract node : transferData.getDraggedNodes()) {
                if (node.isRoot().booleanValue()) {
                    return false;
                }
                if (node.getParent() != sourceParent) {
                    return false;
                }
                if (node == targetNode) {
                    return false;
                }
                if (node.isFolder() && ((NodeFolder)node).isPredecessorOf(targetNode)) {
                    return false;
                }
                if (node.getSubmitStatus().equals((Object)NodeAbstract.SubmitStatus.SubmitRequestPending) || node.getSubmitStatus().equals((Object)NodeAbstract.SubmitStatus.Submitted)) {
                    return false;
                }
                if (!node.fileExists() || !node.canRead() || !node.canWrite() || node.hasPredecessorNotReadableOrWritableByCurrentUser()) {
                    return false;
                }
                if (!node.isFolder() || !((NodeFolder)node).hasDescendantNotReadableOrWritableByCurrentUser()) continue;
                return false;
            }
            return true;
        }
        if (transferSupport.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            if (targetNode.isFile()) {
                return false;
            }
            transferSupport.setDropAction(1);
            this.sipView.selectNode(targetNode.getAdmId());
            return true;
        }
        return false;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport transferSupport) {
        if (!this.canImport(transferSupport)) {
            return false;
        }
        boolean isOK = false;
        if (transferSupport.isDataFlavorSupported(TreeNodeListTransferable.DocuteamPackerTreeNodeListDataFlavor)) {
            isOK = this.moveNodesWithinSIP(transferSupport);
        } else if (transferSupport.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            isOK = this.importFileList(transferSupport);
        } else {
            return false;
        }
        return isOK;
    }

    @Override
    public void exportDone(JComponent component, Transferable t, int action) {
    }

    private boolean moveNodesWithinSIP(TransferHandler.TransferSupport transferSupport) {
        TreePath sourceParentPath;
        JXTreeTable treeTable = (JXTreeTable)transferSupport.getComponent();
        int targetRow = ((JTable.DropLocation)transferSupport.getDropLocation()).getRow();
        TreePath targetPath = treeTable.getPathForRow(targetRow);
        Logger.debug((Object)("D&D TargetPath       = " + targetPath));
        TreePath nextParentPath = targetPath.getParentPath();
        NodeAbstract targetNode = (NodeAbstract)targetPath.getLastPathComponent();
        Logger.debug((Object)("D&D TargetNode       = " + targetNode));
        boolean insertRow = ((JTable.DropLocation)transferSupport.getDropLocation()).isInsertRow();
        ArrayList<NodeAbstract> movedNodes = new ArrayList<NodeAbstract>();
        try {
            TreeNodeListTransferable transferData = (TreeNodeListTransferable)transferSupport.getTransferable().getTransferData(TreeNodeListTransferable.DocuteamPackerTreeNodeListDataFlavor);
            sourceParentPath = transferData.getParentPath();
            Logger.debug((Object)("D&D SourceParentPath = " + sourceParentPath));
            for (NodeAbstract n : transferData.getDraggedNodes()) {
                if (insertRow) {
                    n.moveBeforeNode(targetNode);
                    continue;
                }
                if (!(targetNode instanceof NodeFolder)) continue;
                n.moveTo((NodeFolder)targetNode);
                movedNodes.add(n);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.sipView, e.toString(), I18N.translate((String)"TitleCantMoveItem"), 2);
            return false;
        }
        TreeTableModel model = (TreeTableModel)treeTable.getTreeTableModel();
        model.refreshTreeStructure(sourceParentPath);
        model.refreshTreeStructure(nextParentPath);
        treeTable.expandPath(sourceParentPath);
        treeTable.expandPath(nextParentPath);
        for (NodeAbstract movedNode : movedNodes) {
            TreePath newTreePath = targetPath.pathByAddingChild(movedNode);
            treeTable.expandPath(newTreePath);
        }
        return true;
    }

    private boolean importFileList(TransferHandler.TransferSupport transferSupport) {
        try {
            List droppedFiles = (List)transferSupport.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
            Logger.debug((Object)("D&D files = " + droppedFiles));
            this.sipView.importFilesAndFolders(droppedFiles);
        }
        catch (Exception ex) {
            Logger.error((Object)ex.getMessage(), (Throwable)ex);
            return false;
        }
        return true;
    }
}

