/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.sdk.formatting;

import java.text.DecimalFormat;

public class FileSizeFormatter {
    private static final String bytes = "bytes";
    private static final String KB = "KB";
    private static final String MB = "MB";
    private static final String GB = "GB";
    private static final String TB = "TB";
    private static final double KILO_BYTES = Math.pow(2.0, 10.0);
    private static final double MEGA_BYTES = Math.pow(2.0, 20.0);
    private static final double GIGA_BYTES = Math.pow(2.0, 30.0);
    private static final double TERA_BYTES = Math.pow(2.0, 40.0);

    public static String convertLengthToFileSize(long fileLength) {
        if ((double)fileLength / KILO_BYTES < 1.0) {
            return fileLength + " " + bytes;
        }
        if ((double)fileLength / MEGA_BYTES < 1.0) {
            return FileSizeFormatter.numberFormat((double)fileLength / KILO_BYTES) + " " + KB;
        }
        if ((double)fileLength / GIGA_BYTES < 1.0) {
            return FileSizeFormatter.numberFormat((double)fileLength / MEGA_BYTES) + " " + MB;
        }
        if ((double)fileLength / TERA_BYTES < 1.0) {
            return FileSizeFormatter.numberFormat((double)fileLength / GIGA_BYTES) + " " + GB;
        }
        return FileSizeFormatter.numberFormat((double)fileLength / TERA_BYTES) + " " + TB;
    }

    private static String numberFormat(double number) {
        DecimalFormat formatter = new DecimalFormat("0.00");
        if (number < 10.0) {
            return formatter.format(number);
        }
        return String.valueOf((int)number);
    }
}

