/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.sdk.parser;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.sax.SaxRemoveCDATA;
import com.exlibris.core.infra.common.util.IOUtil;
import com.exlibris.core.infra.common.util.StringUtils;
import com.exlibris.core.infra.svc.api.GeneralParameterManager;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.core.sdk.consts.Enum;
import com.exlibris.core.sdk.formatting.DublinCore;
import com.exlibris.core.sdk.formatting.DublinCoreFactory;
import com.exlibris.core.sdk.parser.CoreIEParser;
import com.exlibris.core.sdk.parser.IEParserException;
import gov.loc.mets.AmdSecType;
import gov.loc.mets.FileType;
import gov.loc.mets.MdSecType;
import gov.loc.mets.MetsDocument;
import gov.loc.mets.MetsType;
import gov.loc.mets.StructMapType;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.apache.xmlbeans.StringEnumAbstractBase;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.dom4j.DocumentException;
import org.xml.sax.InputSource;

public class CoreIEParserImpl
implements CoreIEParser {
    public static final String IE_DMD = "ie-dmd";
    public static final String CMS_DMD = "cms-dmd";
    public static final String COLLECTION_DMD = "collection-dmd";
    public static final String GROUP_ID_PREFIX = "rep";
    public static final String FILE_ID_PREFIX = "fid";
    public static final String STRUCT_MAP_TYPE_PHYSICAL = "PHYSICAL";
    public static final String STRUCT_MAP_TYPE_LOGICAL = "LOGICAL";
    public static final String DIV_TYPE_FILE = "FILE";
    public static final String AMD_SUFFIX = "-amd";
    public static final String STRUCT_MAP_PREFIX = "";
    public static final String TECH_SUFFIX = "-tech";
    public static final String DIGIPROV_SUFFIX = "-digiprov";
    public static final String RIGHTS_SUFFIX = "-rights";
    public static final String SOURCE_SUFFIX = "-source";
    public static final String CONNECTOR = "-";
    private static final String PRESERVATION_MASTER = "PRESERVATION_MASTER";
    private static final String DMD_SUFFIX = "-dmd";
    private static final String DEFAULT_METS_XMLNS = "xmlns=\"http://www.loc.gov/METS/\"";
    protected MetsDocument doc;
    protected MetsDocument.Mets mets;
    protected HashMap<String, AmdSecType> amdMap;
    protected HashMap<String, MdSecType> dmdMap;
    protected HashMap<String, MetsType.FileSec.FileGrp> fileGrpMap;
    protected HashMap<String, FileType> fileTypeMap;
    private ExLogger logger = ExLogger.getExLogger(CoreIEParserImpl.class, "PER");

    protected CoreIEParserImpl(MetsDocument metsDoc) {
        this.doc = metsDoc;
        this.mets = this.doc.getMets();
    }

    protected MetsDocument.Mets getMets() {
        return this.mets;
    }

    @Override
    @Deprecated
    public MetsType.FileSec.FileGrp addNewFileGrp(Enum.UsageType ut, Enum.PreservationType pt) throws IEParserException {
        return this.addNewFileGrp(ut, pt.name());
    }

    @Override
    public MetsType.FileSec.FileGrp addNewFileGrp(Enum.UsageType ut, String pt) throws IEParserException {
        int newFileGrpCount = this.getFileGrpCount() + 1;
        String id = GROUP_ID_PREFIX + newFileGrpCount;
        if (pt == null) {
            pt = PRESERVATION_MASTER;
        }
        if (ut == null) {
            ut = Enum.UsageType.VIEW;
        }
        if (this.mets.getFileSec() == null) {
            this.mets.addNewFileSec();
        }
        MetsType.FileSec.FileGrp fileGrp = this.mets.getFileSec().addNewFileGrp();
        fileGrp.setID(id);
        ArrayList<String> al = new ArrayList<String>();
        al.add(id + AMD_SUFFIX);
        fileGrp.setADMID(al);
        this.addFileGrpToMap(fileGrp);
        return fileGrp;
    }

    @Override
    public FileType addNewFile(MetsType.FileSec.FileGrp fileGrp, String mimeType, String fileLocation, String label) throws IEParserException {
        return this.addNewFile(fileGrp, mimeType, fileLocation, label, null);
    }

    @Override
    public FileType addNewFile(MetsType.FileSec.FileGrp fileGrp, String mimeType, String fileLocation, String label, String groupId) throws IEParserException {
        int newFileCount = this.getFileCount(fileGrp) + 1;
        String id = FILE_ID_PREFIX + newFileCount + CONNECTOR + fileGrp.getID().replace(GROUP_ID_PREFIX, STRUCT_MAP_PREFIX);
        FileType file = fileGrp.addNewFile();
        file.setID(id);
        if (!StringUtils.isEmptyString(groupId)) {
            file.setGROUPID(groupId);
        }
        FileType.FLocat flocat = file.addNewFLocat();
        flocat.setLOCTYPE(FileType.FLocat.LOCTYPE.URL);
        flocat.setHref(fileLocation);
        ArrayList<String> al = new ArrayList<String>();
        al.add(id + AMD_SUFFIX);
        file.setADMID(al);
        this.addFileTypeToMap(file);
        return file;
    }

    @Override
    public FileType[] getFileArray(String fileGrpId) {
        MetsType.FileSec.FileGrp fileGrp = this.getFileGrp(fileGrpId);
        if (fileGrp == null) {
            return null;
        }
        FileType[] fileTypes = null;
        fileTypes = fileGrp.getFileArray();
        return fileTypes;
    }

    @Override
    public MetsType.FileSec.FileGrp[] getFileGrpArray() {
        if (this.mets.getFileSec() == null) {
            return null;
        }
        MetsType.FileSec.FileGrp[] fileGrps = null;
        fileGrps = this.mets.getFileSec().getFileGrpArray();
        return fileGrps;
    }

    @Override
    public StructMapType addNewStructMap(String fileGrpId) throws IEParserException {
        StructMapType[] sms = null;
        sms = this.mets.getStructMapArray();
        for (int i = 0; i < sms.length; ++i) {
            if (!sms[i].getID().equals(fileGrpId + CONNECTOR + 1)) continue;
            this.mets.removeStructMap(i);
            break;
        }
        StructMapType sm = this.mets.addNewStructMap();
        sm.setID(fileGrpId + CONNECTOR + 1);
        sm.setTYPE(STRUCT_MAP_TYPE_PHYSICAL);
        return sm;
    }

    protected StructMapType addAdditionalStructMap(String fileGrpId, Boolean forLocicalTemplate) throws IEParserException {
        String smId = this.getNextStructMapId(fileGrpId);
        StructMapType sm = this.mets.addNewStructMap();
        sm.setID(forLocicalTemplate != false ? STRUCT_MAP_PREFIX : smId);
        sm.setTYPE(forLocicalTemplate != false ? STRUCT_MAP_TYPE_LOGICAL : STRUCT_MAP_TYPE_PHYSICAL);
        return sm;
    }

    protected String getNextStructMapId(String fileGrpId) {
        StructMapType[] sms = this.mets.getStructMapArray();
        ArrayList<String> idsList = new ArrayList<String>();
        for (StructMapType structMap : sms) {
            idsList.add(structMap.getID());
        }
        String smId = null;
        for (int i = 1; i < sms.length + 2 && idsList.contains(smId = fileGrpId + CONNECTOR + i); ++i) {
        }
        return smId;
    }

    @Override
    public StructMapType[] getStructMapArray() {
        if (this.mets != null) {
            StructMapType[] structMapTypes = null;
            structMapTypes = this.mets.getStructMapArray();
            return structMapTypes;
        }
        return null;
    }

    @Override
    public DublinCore getDublinCoreParser() {
        return DublinCoreFactory.getInstance().createDocument();
    }

    @Override
    public MdSecType[] getDmdSecArray() throws IEParserException {
        if (this.mets != null) {
            MdSecType[] dmdSecArray = null;
            dmdSecArray = this.mets.getDmdSecArray();
            return dmdSecArray;
        }
        return null;
    }

    @Override
    public AmdSecType[] getAmdSecArray() throws IEParserException {
        if (this.mets != null) {
            AmdSecType[] amdSecArray = null;
            amdSecArray = this.mets.getAmdSecArray();
            return amdSecArray;
        }
        return null;
    }

    @Override
    public FileType getFile(String id) throws IEParserException {
        MetsType.FileSec.FileGrp[] fileGrps = this.getFileGrpArray();
        if (fileGrps == null) {
            return null;
        }
        this.populateFileTypeMap();
        return this.fileTypeMap.get(id);
    }

    protected void addFileTypeToMap(FileType fileType) {
        this.populateFileTypeMap();
        if (this.fileTypeMap.get(fileType.getID()) == null) {
            this.fileTypeMap.put(fileType.getID(), fileType);
        }
    }

    protected void populateFileTypeMap() {
        MetsType.FileSec.FileGrp[] fileGrps = this.getFileGrpArray();
        if (this.fileTypeMap == null && this.mets != null) {
            this.fileTypeMap = new HashMap();
            fileGrps = this.mets.getFileSec().getFileGrpArray();
            for (int i = 0; i < fileGrps.length; ++i) {
                FileType[] fs = this.getFileArray(fileGrps[i].getID());
                for (int j = 0; j < fs.length; ++j) {
                    this.fileTypeMap.put(fs[j].getID(), fs[j]);
                }
            }
        }
    }

    @Override
    public MetsType.FileSec.FileGrp getFileGrp(String id) {
        if (this.mets.getFileSec() == null) {
            return null;
        }
        this.populateFileGrpMap();
        return this.fileGrpMap.get(id);
    }

    protected void addFileGrpToMap(MetsType.FileSec.FileGrp fileGrp) {
        this.populateFileGrpMap();
        if (this.fileGrpMap.get(fileGrp.getID()) == null) {
            this.fileGrpMap.put(fileGrp.getID(), fileGrp);
        }
    }

    protected void populateFileGrpMap() {
        if (this.fileGrpMap == null && this.mets != null) {
            MetsType.FileSec.FileGrp[] fileGrps = null;
            this.fileGrpMap = new HashMap();
            fileGrps = this.mets.getFileSec().getFileGrpArray();
            for (int i = 0; i < fileGrps.length; ++i) {
                this.fileGrpMap.put(fileGrps[i].getID(), fileGrps[i]);
            }
        }
    }

    @Override
    public MetsType.FileSec getFileSec() {
        if (this.mets != null) {
            if (this.mets.getFileSec() == null) {
                this.mets.addNewFileSec();
            }
            return this.mets.getFileSec();
        }
        return null;
    }

    @Override
    public DublinCore getIeDublinCore() throws IEParserException {
        return this.getDMDDC(IE_DMD);
    }

    @Override
    public DublinCore getDMDDC(String dmdId) throws IEParserException {
        this.populateDmdMap();
        MdSecType md = this.getDmdSec(dmdId);
        if (md == null || md.getMdWrap() == null || md.getMdWrap().getXmlData() == null) {
            return null;
        }
        if (((Object)((Object)md.getMdWrap().getMDTYPE())).equals((Object)MdSecType.MdWrap.MDTYPE.DC)) {
            try {
                return DublinCoreFactory.getInstance().createDocument(md.getMdWrap().getXmlData().xmlText());
            }
            catch (DocumentException e) {
                throw new IEParserException(IEParserException.Descriptor.DC_DOCUMENT_EXCEPTION, (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void setDublinCore(DublinCore dc, String id) throws IEParserException {
        this.setDublinCore(dc, id, false, null);
    }

    @Override
    public void setDublinCore(DublinCore dc, String id, boolean useRef, String idForRef) throws IEParserException {
        this.setDMDDC(dc, this.formatDmdId(id), useRef, idForRef);
    }

    private String formatDmdId(String id) {
        return id + DMD_SUFFIX;
    }

    @Override
    public void setIEDublinCore(DublinCore dc) throws IEParserException {
        this.setDMDDC(dc, IE_DMD);
    }

    private void setDMDDC(DublinCore dc, String dmdId) throws IEParserException {
        this.setDMDDC(dc, dmdId, false, null);
    }

    private void setDMDDC(DublinCore dc, String dmdId, boolean useRef, String idForRef) throws IEParserException {
        XmlObject xmlObject = null;
        try {
            xmlObject = useRef ? null : XmlObject.Factory.parse((String)dc.toXml());
        }
        catch (XmlException e) {
            throw new IEParserException(IEParserException.Descriptor.XML_PARSING_EXCEPTION, (Throwable)e);
        }
        catch (IOException e) {
            throw new IEParserException(IEParserException.Descriptor.IO_EXCEPTION, (Throwable)e);
        }
        this.generateDmdSec(useRef, idForRef, MdSecType.MdWrap.MDTYPE.DC, xmlObject, dmdId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void export(String fileName) throws IEParserException {
        block9: {
            XmlOptions opt = new XmlOptions();
            opt.setSavePrettyPrint();
            File f = new File(fileName);
            FileWriter fw = null;
            BufferedWriter out = null;
            try {
                GeneralParameterManager gpm;
                String stripCData;
                File parentFile = f.getParentFile();
                if (parentFile != null && !parentFile.exists()) {
                    parentFile.mkdirs();
                }
                if (Boolean.valueOf(stripCData = (gpm = (GeneralParameterManager)ServiceLocator.getInstance().lookUp(GeneralParameterManager.class)).getParameter("general", "strip_cdata_from_dc")).booleanValue()) {
                    try {
                        InputSource is = new InputSource();
                        SaxRemoveCDATA parser = new SaxRemoveCDATA("mets:dmdSec", true);
                        is.setCharacterStream(new StringReader(this.doc.xmlText(opt)));
                        parser.parse(is);
                        fw = new FileWriter(f);
                        out = new BufferedWriter(fw);
                        out.write(parser.getIeXml());
                        IOUtil.closeQuietly(out);
                    }
                    catch (Exception e) {
                        this.logger.error("could not parse METS", e, new String[0]);
                        this.doc.save(f, opt);
                        break block9;
                    }
                    finally {
                        IOUtil.closeQuietly(out);
                        IOUtil.closeQuietly(fw);
                    }
                    IOUtil.closeQuietly(fw);
                    break block9;
                }
                this.doc.save(f, opt);
            }
            catch (IOException e) {
                throw new IEParserException(IEParserException.Descriptor.IO_EXCEPTION, (Throwable)e);
            }
        }
    }

    @Override
    public StructMapType getStructMap(String grpId) {
        StructMapType grpMap = null;
        StructMapType[] structMapArray = this.getStructMapArray();
        for (int i = 0; i < structMapArray.length; ++i) {
            String smId = structMapArray[i].getID();
            if (smId.startsWith(STRUCT_MAP_PREFIX)) {
                smId = smId.substring(STRUCT_MAP_PREFIX.length());
            }
            if (!structMapArray[i].getTYPE().toUpperCase().equals(STRUCT_MAP_TYPE_PHYSICAL)) continue;
            grpMap = structMapArray[i];
            break;
        }
        if (grpMap == null) {
            grpMap = structMapArray[0];
        }
        return grpMap;
    }

    @Override
    public void generateGID() throws IEParserException {
        if (this.validateCompatible()) {
            MetsType.FileSec.FileGrp[] fileGrp = null;
            try {
                fileGrp = this.mets.getFileSec().getFileGrpArray();
            }
            catch (NullPointerException e) {
                throw new IEParserException(IEParserException.Descriptor.NO_FILE_SEC, (Throwable)e);
            }
            for (int i = 0; i < fileGrp.length; ++i) {
                FileType[] file = fileGrp[i].getFileArray();
                for (int j = 0; j < file.length; ++j) {
                    file[j].setGROUPID(String.valueOf(j + 1));
                }
            }
        }
    }

    private StructMapType createStructMapType(String value) throws IEParserException {
        Object smt = null;
        try {
            if (value != null && value.contains("<mets:mets xmlns:mets=\"http://www.loc.gov/METS/\">")) {
                return MetsDocument.Factory.parse(value).getMets().getStructMapArray(0);
            }
            return MetsDocument.Factory.parse("<?xml version=\"1.0\" encoding=\"UTF-8\"?><mets xmlns=\"http://www.loc.gov/METS/\">" + value + "</mets>").getMets().getStructMapArray(0);
        }
        catch (XmlException e) {
            throw new IEParserException(IEParserException.Descriptor.XML_PARSING_EXCEPTION, (Throwable)e);
        }
    }

    @Override
    public void setStructMap(MetsType.FileSec.FileGrp fileGrp, String structMapXml) throws IEParserException {
        structMapXml = structMapXml.replace(DEFAULT_METS_XMLNS, STRUCT_MAP_PREFIX);
        StructMapType newSm = this.createStructMapType(structMapXml);
        this.setStructMap(newSm);
    }

    @Override
    public void setStructMap(StructMapType structMap) throws IEParserException {
        StructMapType[] sms = this.mets.getStructMapArray();
        sms = this.mets.getStructMapArray();
        StructMapType[] structMapArray = new StructMapType[sms.length + 1];
        System.arraycopy(sms, 0, structMapArray, 0, sms.length);
        structMapArray[sms.length] = structMap;
        this.mets.setStructMapArray(structMapArray);
    }

    @Override
    public void addAdditionalStructMap(MetsType.FileSec.FileGrp fileGrp, StructMapType newSm) throws IEParserException {
        StructMapType[] sms = this.mets.getStructMapArray();
        int count = 0;
        for (int i = 0; i < sms.length; ++i) {
            if (!sms[i].getID().substring(0, sms[i].getID().lastIndexOf(CONNECTOR)).equals(fileGrp.getID())) continue;
            ++count;
        }
        newSm.setID(fileGrp.getID() + CONNECTOR + ++count);
        sms = this.mets.getStructMapArray();
        StructMapType[] structMapArray = new StructMapType[sms.length + 1];
        System.arraycopy(sms, 0, structMapArray, 0, sms.length);
        structMapArray[sms.length] = newSm;
        this.mets.setStructMapArray(structMapArray);
    }

    @Override
    public StructMapType getStructMapById(String structMapId) throws IEParserException {
        StructMapType grpMap = null;
        StructMapType[] structMapArray = this.getStructMapArray();
        for (int i = 0; i < structMapArray.length; ++i) {
            String smId = structMapArray[i].getID();
            if (!smId.equals(structMapId)) continue;
            grpMap = structMapArray[i];
            break;
        }
        return grpMap;
    }

    @Override
    public StructMapType[] getStructMapsByFileGrpId(String fileGrpId) {
        StructMapType[] structMapArray = this.getStructMapArray();
        ArrayList<StructMapType> structMapArrayById = new ArrayList<StructMapType>();
        for (int i = 0; i < structMapArray.length; ++i) {
            String smId = structMapArray[i].getID();
            if (!smId.substring(0, smId.lastIndexOf(CONNECTOR)).equals(fileGrpId)) continue;
            structMapArrayById.add(structMapArray[i]);
        }
        StructMapType[] structMapsFileGrp = new StructMapType[structMapArrayById.size()];
        structMapsFileGrp = structMapArrayById.toArray(structMapsFileGrp);
        return structMapsFileGrp;
    }

    @Override
    public void removeFGStructMaps(String grpId) {
        StructMapType[] structMapArray = this.getStructMapArray();
        for (int i = 0; i < structMapArray.length; ++i) {
            String smId = structMapArray[i].getID();
            if (!smId.substring(0, smId.lastIndexOf(CONNECTOR)).equals(grpId)) continue;
            this.mets.removeStructMap(i);
            this.removeFGStructMaps(grpId);
            break;
        }
    }

    protected void removeAmdSec(String grpId) throws IEParserException {
        AmdSecType[] amdSecTypeArray = this.getAmdSecArray();
        for (int i = 0; i < amdSecTypeArray.length; ++i) {
            String id = amdSecTypeArray[i].getID();
            if (!id.substring(0, id.lastIndexOf(CONNECTOR)).equals(grpId)) continue;
            this.mets.removeAmdSec(i);
            this.removeAmdSec(grpId);
            break;
        }
    }

    protected void removeFGDmdSec(String grpId) throws IEParserException {
        MdSecType[] mdSecTypeArray = this.getDmdSecArray();
        for (int i = 0; i < mdSecTypeArray.length; ++i) {
            String id = mdSecTypeArray[i].getID();
            if (!id.substring(0, id.lastIndexOf(CONNECTOR)).equals(grpId)) continue;
            this.mets.removeDmdSec(i);
            this.removeFGDmdSec(grpId);
            break;
        }
    }

    protected void removeFGSec(String grpId) throws IEParserException {
        MetsType.FileSec.FileGrp[] fileGrp = this.getFileSec().getFileGrpArray();
        for (int i = 0; i < fileGrp.length; ++i) {
            String id = fileGrp[i].getID();
            if (!id.equals(grpId)) continue;
            this.mets.getFileSec().removeFileGrp(i);
            break;
        }
    }

    @Override
    public String toXML() {
        XmlOptions opt = new XmlOptions();
        opt.setSavePrettyPrint();
        return this.doc.xmlText(opt);
    }

    @Override
    public void toXML(File file) throws IOException {
        XmlOptions opt = new XmlOptions();
        opt.setSavePrettyPrint();
        this.doc.save(file, opt);
    }

    @Override
    public boolean validate(XmlOptions xmloptions) {
        return this.mets.validate(xmloptions);
    }

    @Override
    public boolean validate() {
        return this.mets.validate();
    }

    protected MdSecType getDmdSec(String dmdId) {
        return this.dmdMap.get(dmdId);
    }

    protected AmdSecType getAmd(String id, boolean createNew) {
        return this.getAmd(id, createNew, false, null);
    }

    protected AmdSecType getAmd(String id, boolean createNew, boolean useRef, String idForRef) {
        AmdSecType amd = null;
        this.populateAmdMap();
        if (this.amdMap.get(id) == null && createNew) {
            amd = this.createNewAmdSec(id, useRef, idForRef);
            this.amdMap.put(amd.getID(), amd);
        }
        return this.amdMap.get(id);
    }

    protected void addAmdSecToMap(AmdSecType amd) {
        this.populateAmdMap();
        if (this.amdMap.get(amd.getID()) == null) {
            this.amdMap.put(amd.getID(), amd);
        }
    }

    protected void populateAmdMap() {
        AmdSecType[] amds = null;
        if (this.amdMap == null) {
            this.amdMap = new HashMap();
            if (this.mets != null) {
                amds = this.mets.getAmdSecArray();
                for (int i = 0; i < amds.length; ++i) {
                    this.amdMap.put(amds[i].getID(), amds[i]);
                }
            }
        }
    }

    private void populateDmdMap() {
        MdSecType[] dmds = null;
        if (this.dmdMap == null) {
            this.dmdMap = new HashMap();
            if (this.mets != null) {
                dmds = this.mets.getDmdSecArray();
                for (int i = 0; i < dmds.length; ++i) {
                    this.dmdMap.put(dmds[i].getID(), dmds[i]);
                }
            }
        }
    }

    protected AmdSecType createNewAmdSec(String id) {
        return this.createNewAmdSec(id, false, null);
    }

    protected AmdSecType createNewAmdSec(String id, boolean useRef, String idForRef) {
        AmdSecType amd = this.mets.addNewAmdSec();
        amd.setID(id);
        MdSecType md = amd.addNewTechMD();
        md.setID(id + TECH_SUFFIX);
        this.addProperWrapRef(useRef, idForRef, MdSecType.MdWrap.MDTYPE.OTHER, "dnx", null, md);
        md = amd.addNewDigiprovMD();
        md.setID(id + DIGIPROV_SUFFIX);
        this.addProperWrapRef(useRef, idForRef, MdSecType.MdWrap.MDTYPE.OTHER, "dnx", null, md);
        md = amd.addNewRightsMD();
        md.setID(id + RIGHTS_SUFFIX);
        this.addProperWrapRef(useRef, idForRef, MdSecType.MdWrap.MDTYPE.OTHER, "dnx", null, md);
        md = amd.addNewSourceMD();
        md.setID(id + SOURCE_SUFFIX);
        this.addProperWrapRef(useRef, idForRef, MdSecType.MdWrap.MDTYPE.OTHER, "dnx", null, md);
        return amd;
    }

    protected XmlObject getXmlObject(String xml) throws IEParserException {
        try {
            return XmlObject.Factory.parse((String)xml);
        }
        catch (XmlException e) {
            throw new IEParserException(IEParserException.Descriptor.XML_PARSING_EXCEPTION, (Throwable)e);
        }
    }

    protected int getFileGrpCount() throws IEParserException {
        int length;
        if (this.mets.getFileSec() == null) {
            return 0;
        }
        try {
            length = this.mets.getFileSec().getFileGrpArray().length;
        }
        catch (NullPointerException e) {
            throw new IEParserException(IEParserException.Descriptor.NO_FILE_SEC, (Throwable)e);
        }
        return length;
    }

    protected int getFileCount(MetsType.FileSec.FileGrp fileGrp) {
        if (fileGrp == null) {
            return 0;
        }
        return fileGrp.getFileArray().length;
    }

    protected boolean validateCompatible() throws IEParserException {
        MetsType.FileSec.FileGrp[] fileGrp = null;
        try {
            fileGrp = this.mets.getFileSec().getFileGrpArray();
        }
        catch (NullPointerException e) {
            throw new IEParserException(IEParserException.Descriptor.NO_FILE_SEC, (Throwable)e);
        }
        for (int i = 0; i < fileGrp.length - 1; ++i) {
            if (fileGrp[i].getFileArray().length == fileGrp[i + 1].getFileArray().length) continue;
            return false;
        }
        return true;
    }

    protected void updateAmdIds(String correctId, String currentIdAmdSec) throws IEParserException {
        AmdSecType amdSecType = this.getAmd(currentIdAmdSec, false);
        if (amdSecType != null) {
            amdSecType.setID(correctId + AMD_SUFFIX);
            try {
                amdSecType.getTechMDArray(0).setID(correctId + AMD_SUFFIX + TECH_SUFFIX);
            }
            catch (Exception e) {
                throw new IEParserException(IEParserException.Descriptor.ERROR_IN_TECH_MD_ARRAY, (Throwable)e);
            }
            try {
                amdSecType.getDigiprovMDArray(0).setID(correctId + AMD_SUFFIX + DIGIPROV_SUFFIX);
            }
            catch (Exception e) {
                throw new IEParserException(IEParserException.Descriptor.ERROR_IN_DIGIPROOV_MD_ARRAY, (Throwable)e);
            }
            try {
                amdSecType.getRightsMDArray(0).setID(correctId + AMD_SUFFIX + RIGHTS_SUFFIX);
            }
            catch (Exception e) {
                throw new IEParserException(IEParserException.Descriptor.ERROR_IN_RIGHTS_MD_ARRAY, (Throwable)e);
            }
            try {
                amdSecType.getSourceMDArray(0).setID(correctId + AMD_SUFFIX + SOURCE_SUFFIX);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void generateDmdSec(boolean useRef, String idForRef, MdSecType.MdWrap.MDTYPE.Enum mdType, XmlObject xmlObject, String dmdId) {
        this.populateDmdMap();
        MdSecType dmd = this.getDmdSec(dmdId);
        if (dmd == null) {
            dmd = this.mets.addNewDmdSec();
            this.dmdMap.put(dmdId, dmd);
        } else if (useRef) {
            dmd.unsetMdRef();
        } else {
            dmd.unsetMdWrap();
        }
        dmd.setID(dmdId);
        this.addProperWrapRef(useRef, idForRef, mdType, null, xmlObject, dmd);
    }

    protected void addProperWrapRef(boolean useRef, String idForRef, MdSecType.MdWrap.MDTYPE.Enum mdType, String otherType, XmlObject xmlObject, MdSecType secType) {
        if (useRef) {
            secType.addNewMdRef().setID(idForRef);
            secType.getMdRef().setMDTYPE(this.convertMDWrapTypeToMdRefType(mdType));
            if (otherType != null) {
                secType.getMdRef().setOTHERMDTYPE(otherType);
            }
        } else {
            secType.addNewMdWrap().setMDTYPE(mdType);
            if (otherType != null) {
                secType.getMdWrap().setOTHERMDTYPE(otherType);
            }
            secType.getMdWrap().addNewXmlData();
            if (xmlObject != null) {
                secType.getMdWrap().getXmlData().set(xmlObject);
            }
        }
    }

    private MdSecType.MdRef.MDTYPE.Enum convertMDWrapTypeToMdRefType(MdSecType.MdWrap.MDTYPE.Enum mdType) {
        return MdSecType.MdRef.MDTYPE.Enum.forString(mdType.toString());
    }

    protected void updateProperWrapRef(boolean useRef, String idForRef, XmlObject xmlObject, MdSecType secType) {
        if (useRef) {
            secType.getMdRef().setID(idForRef);
        } else {
            secType.getMdWrap().getXmlData().set(xmlObject);
        }
    }

    @Override
    public void setSourceMd(String id, MdSecType.MdWrap.MDTYPE.Enum mdType, XmlObject xmlObject, String mid) {
        this.setSourceMd(id, mdType, xmlObject, mid, false, null);
    }

    @Override
    public void setSourceMd(String id, MdSecType.MdWrap.MDTYPE.Enum mdType, XmlObject xmlObject, String mid, boolean useRef, String otherMdType) {
        this.setSourceMd(useRef, mid, id + AMD_SUFFIX, mdType, xmlObject, otherMdType);
    }

    @Override
    public void setIeSourceMd(MdSecType.MdWrap.MDTYPE.Enum mdType, XmlObject xmlObject) {
        this.setSourceMd(false, null, "ie-amd", mdType, xmlObject, null);
    }

    @Override
    public void setIeSourceMd(MdSecType.MdWrap.MDTYPE.Enum mdType, XmlObject xmlObject, String mid, String otherMdType) {
        this.setSourceMd(false, mid, "ie-amd", mdType, xmlObject, otherMdType);
    }

    @Override
    public String getFileDmdId(String id) {
        return this.formatDmdId(id);
    }

    private void setSourceMd(boolean useRef, String mid, String amdId, MdSecType.MdWrap.MDTYPE.Enum mdType, XmlObject xmlObject, String otherMdType) {
        AmdSecType amd = this.getAmd(amdId, true, useRef, mid);
        String mdTypeAsString = null;
        Integer mdNumber = 1;
        if (amd != null) {
            MdSecType[] sourceMDs;
            mdTypeAsString = mdType == null ? otherMdType.substring(otherMdType.indexOf(":") + 1, otherMdType.length()) : mdType.toString();
            for (MdSecType sourceMd : sourceMDs = amd.getSourceMDArray()) {
                StringEnumAbstractBase sourceType = null;
                if (useRef) {
                    MdSecType.MdRef sourceMdRef = sourceMd.getMdRef();
                    sourceType = sourceMdRef.getMDTYPE();
                } else {
                    MdSecType.MdWrap sourceMdWrap = sourceMd.getMdWrap();
                    sourceType = sourceMdWrap.getMDTYPE();
                }
                if (!mdTypeAsString.equals(ObjectUtils.toString((Object)sourceType)) && mdType != null) continue;
                Integer n = mdNumber;
                Integer n2 = mdNumber = Integer.valueOf(mdNumber + 1);
            }
        } else {
            amd = this.createNewAmdSec(amdId, useRef, mid);
        }
        MdSecType newSourceMD = amd.addNewSourceMD();
        String sourceMDId = null;
        sourceMDId = mid != null ? mid : StringUtils.concat(new Object[]{amdId, "-source-", mdType, CONNECTOR, mdNumber});
        newSourceMD.setID(sourceMDId);
        if (mdType == null) {
            this.addProperWrapRef(useRef, mid, MdSecType.MdWrap.MDTYPE.OTHER, mdTypeAsString, xmlObject, newSourceMD);
        } else {
            this.addProperWrapRef(useRef, mid, mdType, null, xmlObject, newSourceMD);
        }
        this.addAmdSecToMap(amd);
    }

    @Override
    public void setSourceMd(String id, MdSecType.MdWrap.MDTYPE.Enum mdType, XmlObject xmlObject) {
        this.setSourceMd(false, null, id + AMD_SUFFIX, mdType, xmlObject, null);
    }

    @Override
    public List<MdSecType.MdWrap> getIeSourceMDs() {
        return this.getSourceMDs("ie-amd");
    }

    @Override
    public List<MdSecType.MdWrap> getSourceMDs(String id) {
        ArrayList<MdSecType.MdWrap> mdWraps = new ArrayList<MdSecType.MdWrap>();
        AmdSecType amd = this.getAmd(id, false);
        if (amd != null) {
            MdSecType[] sourceMDs;
            for (MdSecType sourceMd : sourceMDs = amd.getSourceMDArray()) {
                MdSecType.MdWrap sourceMdWrap = sourceMd.getMdWrap();
                if (sourceMdWrap == null || this.isDnxMdWrap(sourceMdWrap)) continue;
                mdWraps.add(sourceMdWrap);
            }
        }
        return mdWraps;
    }

    @Override
    public MdSecType[] getIeSourceMDsArray() {
        AmdSecType amd = this.getAmd("ie-amd", false);
        MdSecType[] sourceMDs = null;
        if (amd != null) {
            sourceMDs = amd.getSourceMDArray();
        }
        return sourceMDs;
    }

    @Override
    public void setIeSourceMds(MdSecType[] sourceMdsArray) {
        AmdSecType amd = this.getAmd("ie-amd", false);
        amd.setSourceMDArray(sourceMdsArray);
    }

    protected boolean isDnxMdWrap(MdSecType.MdWrap mdWrap) {
        return ((Object)((Object)MdSecType.MdWrap.MDTYPE.OTHER)).equals((Object)mdWrap.getMDTYPE()) && "dnx".equals(mdWrap.getOTHERMDTYPE());
    }

    @Override
    public DublinCore getIeCMSDublinCore() throws IEParserException {
        return this.getDMDDC(CMS_DMD);
    }

    @Override
    public void setIeCMSDublinCore(DublinCore dc) throws IEParserException {
        this.setIeCMSDublinCore(dc, false, null);
    }

    @Override
    public void setIeCMSDublinCore(DublinCore dc, boolean useRef, String idForRef) throws IEParserException {
        this.setDMDDC(dc, CMS_DMD, useRef, idForRef);
    }
}

