/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.sdk.utils.metsHrefUtils;

import com.exlibris.core.infra.common.email.EncryptionUtil;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.sdk.utils.FileUtil;
import com.exlibris.core.sdk.utils.metsHrefUtils.HrefUrlUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.provider.http.HttpFileObject;

public class HrefUrlHttpUtil
implements HrefUrlUtil {
    private HttpFileObject httpFileObject;
    private String formattedPath;
    private String fileName = null;
    public static final String SEPARATOR = "/";
    private static final String CONTENT_DISPOSITION = "Content-Disposition";
    private static final String FILENAME = "filename=";
    private static final ExLogger log = ExLogger.getExLogger(HrefUrlHttpUtil.class);

    public HrefUrlHttpUtil(String fileUrl) {
        this.formattedPath = fileUrl;
    }

    @Override
    public void init() throws FileSystemException {
        FileSystemManager fsManager = VFS.getManager();
        this.httpFileObject = (HttpFileObject)fsManager.resolveFile(this.formattedPath);
        VFS.getManager().getFilesCache().clear(this.httpFileObject.getFileSystem());
    }

    @Override
    public long getFileSize() throws Exception {
        return this.httpFileObject.getContent().getSize();
    }

    @Override
    public InputStream getFileInputStream() throws Exception {
        return this.httpFileObject.getContent().getInputStream();
    }

    @Override
    public void closeFileConnection() throws Exception {
        this.httpFileObject.close();
    }

    @Override
    public String getFormattedFilePath() {
        return this.formattedPath;
    }

    @Override
    public String getFileName() throws IOException {
        if (StringUtils.isBlank((String)this.fileName)) {
            URL url = new URL(this.formattedPath);
            HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
            int responseCode = httpConn.getResponseCode();
            if (responseCode == 200) {
                String disposition = httpConn.getHeaderField(CONTENT_DISPOSITION);
                if (StringUtils.isNotBlank((String)disposition)) {
                    this.fileName = disposition.substring(disposition.indexOf(FILENAME) + FILENAME.length(), disposition.length()).trim();
                } else if (StringUtils.isNotBlank((String)FilenameUtils.getExtension((String)this.formattedPath))) {
                    this.fileName = FilenameUtils.getName((String)this.formattedPath);
                }
            }
            httpConn.disconnect();
            if (StringUtils.isBlank((String)this.fileName)) {
                log.warn((Object)"Could not retrive file name from url or from header. generate random numeric filename.", new String[0]);
                this.fileName = FileUtil.fileNameNormalizer(EncryptionUtil.encryptAes(this.formattedPath, 10));
            }
        }
        return this.fileName;
    }

    @Override
    public boolean supportsMove() {
        return false;
    }

    @Override
    public File getFile() {
        return null;
    }

    @Override
    public boolean isRelative() {
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.formattedPath == null ? 0 : this.formattedPath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HrefUrlHttpUtil other = (HrefUrlHttpUtil)obj;
        return !(this.formattedPath == null ? other.formattedPath != null : !this.formattedPath.equals(other.formattedPath));
    }

    public String toString() {
        return this.formattedPath;
    }

    @Override
    public String getRelativePath() throws IOException {
        return this.getFileName();
    }
}

