/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.batik.bridge.SVGFontFamily;
import org.apache.batik.gvt.font.GVTFont;
import org.apache.batik.gvt.font.GVTFontFamily;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontTriplet;

public final class ACIUtils {
    private static final Log LOG = LogFactory.getLog(ACIUtils.class);

    private ACIUtils() {
    }

    public static Font[] findFontsForBatikACI(AttributedCharacterIterator aci, FontInfo fontInfo) {
        ArrayList<Font> fonts = new ArrayList<Font>();
        List gvtFonts = (List)aci.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.GVT_FONT_FAMILIES);
        Float posture = (Float)aci.getAttribute(TextAttribute.POSTURE);
        Float taWeight = (Float)aci.getAttribute(TextAttribute.WEIGHT);
        Float fontSize = (Float)aci.getAttribute(TextAttribute.SIZE);
        String style = ACIUtils.toStyle(posture);
        int weight = ACIUtils.toCSSWeight(taWeight);
        int fsize = (int)(fontSize.floatValue() * 1000.0f);
        String firstFontFamily = null;
        GVTFont gvtFont = (GVTFont)aci.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.GVT_FONT);
        if (gvtFont != null) {
            String gvtFontFamily = gvtFont.getFamilyName();
            if (fontInfo.hasFont(gvtFontFamily, style, weight)) {
                FontTriplet triplet = fontInfo.fontLookup(gvtFontFamily, style, weight);
                Font f = fontInfo.getFontInstance(triplet, fsize);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Found a font that matches the GVT font: " + gvtFontFamily + ", " + weight + ", " + style + " -> " + f));
                }
                fonts.add(f);
            }
            firstFontFamily = gvtFontFamily;
        }
        if (gvtFonts != null) {
            boolean haveInstanceOfSVGFontFamily = false;
            for (GVTFontFamily fam : gvtFonts) {
                String fontFamily;
                if (fam instanceof SVGFontFamily) {
                    haveInstanceOfSVGFontFamily = true;
                }
                if (fontInfo.hasFont(fontFamily = fam.getFamilyName(), style, weight)) {
                    FontTriplet triplet = fontInfo.fontLookup(fontFamily, style, weight);
                    Font f = fontInfo.getFontInstance(triplet, fsize);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Found a font that matches the GVT font family: " + fontFamily + ", " + weight + ", " + style + " -> " + f));
                    }
                    fonts.add(f);
                }
                if (firstFontFamily != null) continue;
                firstFontFamily = fontFamily;
            }
            if (fonts.isEmpty() && haveInstanceOfSVGFontFamily) {
                fontInfo.notifyStrokingSVGTextAsShapes(firstFontFamily);
                return null;
            }
        }
        if (fonts.isEmpty()) {
            if (firstFontFamily == null) {
                firstFontFamily = "any";
            }
            FontTriplet triplet = fontInfo.fontLookup(firstFontFamily, style, weight);
            Font f = fontInfo.getFontInstance(triplet, fsize);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Falling back to adjustable font lookup up for: " + firstFontFamily + ", " + weight + ", " + style + " -> " + f));
            }
            fonts.add(f);
        }
        return fonts.toArray(new Font[fonts.size()]);
    }

    private static int toCSSWeight(Float weight) {
        if (weight == null) {
            return 400;
        }
        if (weight.floatValue() <= TextAttribute.WEIGHT_EXTRA_LIGHT.floatValue()) {
            return 100;
        }
        if (weight.floatValue() <= TextAttribute.WEIGHT_LIGHT.floatValue()) {
            return 200;
        }
        if (weight.floatValue() <= TextAttribute.WEIGHT_DEMILIGHT.floatValue()) {
            return 300;
        }
        if (weight.floatValue() <= TextAttribute.WEIGHT_REGULAR.floatValue()) {
            return 400;
        }
        if (weight.floatValue() <= TextAttribute.WEIGHT_SEMIBOLD.floatValue()) {
            return 500;
        }
        if (weight.floatValue() < TextAttribute.WEIGHT_BOLD.floatValue()) {
            return 600;
        }
        if (weight.floatValue() == TextAttribute.WEIGHT_BOLD.floatValue()) {
            return 700;
        }
        if (weight.floatValue() <= TextAttribute.WEIGHT_HEAVY.floatValue()) {
            return 800;
        }
        if (weight.floatValue() <= TextAttribute.WEIGHT_EXTRABOLD.floatValue()) {
            return 900;
        }
        return 900;
    }

    private static String toStyle(Float posture) {
        return posture != null && (double)posture.floatValue() > 0.0 ? "italic" : "normal";
    }

    public static void dumpAttrs(AttributedCharacterIterator aci) {
        aci.first();
        Set<Map.Entry<AttributedCharacterIterator.Attribute, Object>> entries = aci.getAttributes().entrySet();
        for (Map.Entry<AttributedCharacterIterator.Attribute, Object> entry : entries) {
            if (entry.getValue() == null) continue;
            System.out.println(entry.getKey() + ": " + entry.getValue());
        }
        int start = aci.getBeginIndex();
        System.out.print("AttrRuns: ");
        while (aci.current() != '\uffff') {
            int end = aci.getRunLimit();
            System.out.print("" + (end - start) + ", ");
            aci.setIndex(end);
            if (start == end) break;
            start = end;
        }
        System.out.println("");
    }
}

