/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfile;

public final class TiffProfileClassF
extends TiffProfile {
    public TiffProfileClassF() {
        this._profileText = "Class F";
    }

    public boolean satisfiesThisProfile(IFD iFD) {
        long l;
        if (!(iFD instanceof TiffIFD)) {
            return false;
        }
        TiffIFD tiffIFD = (TiffIFD)iFD;
        NisoImageMetadata nisoImageMetadata = tiffIFD.getNisoImageMetadata();
        if (nisoImageMetadata.getImageLength() == -1L || nisoImageMetadata.getStripOffsets() == null || nisoImageMetadata.getRowsPerStrip() == -1L || nisoImageMetadata.getStripByteCounts() == null || tiffIFD.getPageNumber() == null || nisoImageMetadata.getScanningSoftware() == null) {
            return false;
        }
        if (!this.satisfiesCompression(tiffIFD, new int[]{3, 4})) {
            return false;
        }
        int n = tiffIFD.getFillOrder();
        if (n != 1 && n != 2) {
            return false;
        }
        int n2 = nisoImageMetadata.getCompressionScheme();
        if (n2 == 3) {
            l = tiffIFD.getT4Options();
            if (l != 0L && l != 1L && l != 4L && l != 5L) {
                return false;
            }
        } else if (n2 == 4) {
            l = tiffIFD.getT4Options();
            long l2 = tiffIFD.getT6Options();
            if (l2 != 2L) {
                return false;
            }
        }
        if (!this.satisfiesImageWidth(tiffIFD, new int[]{1728, 2048, 2432, 2592, 3072, 3648, 3456, 4096, 4864})) {
            return false;
        }
        if (!this.satisfiesNewSubfileType(tiffIFD, 2L)) {
            return false;
        }
        if (!this.satisfiesResolutionUnit(tiffIFD, new int[]{2, 3})) {
            return false;
        }
        if (!this.satisfiesXResolution(tiffIFD, new int[]{204, 200, 300, 400, 408})) {
            return false;
        }
        if (!this.satisfiesYResolution(tiffIFD, new int[]{98, 196, 100, 200, 300, 391, 400})) {
            return false;
        }
        int[] nArray = nisoImageMetadata.getBitsPerSample();
        if (nArray == null || nArray[0] != 1) {
            return false;
        }
        if (!this.satisfiesPhotometricInterpretation(tiffIFD, new int[]{0, 1})) {
            return false;
        }
        if (!this.satisfiesSamplesPerPixel(tiffIFD, 1)) {
            return false;
        }
        int n3 = (int)nisoImageMetadata.getImageWidth();
        int n4 = (int)nisoImageMetadata.getXSamplingFrequency().toLong();
        int n5 = (int)nisoImageMetadata.getYSamplingFrequency().toLong();
        switch (n3) {
            case 1728: 
            case 2048: 
            case 2432: {
                if (n4 == 204 && n5 == 391 && (n4 != 200 || n5 != 100) && (n4 != 200 || n5 != 200)) break;
                return false;
            }
            case 2592: 
            case 3072: 
            case 3648: {
                if (n4 == 300 && n5 == 300) break;
                return false;
            }
            case 3456: 
            case 4096: 
            case 4864: {
                if (n4 == 408 && n5 == 391 && (n4 != 400 || n5 != 400)) break;
                return false;
            }
        }
        return true;
    }
}

