/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.archive;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SevenZipIteratorAdapter
implements Iterable<SevenZArchiveEntry> {
    private final ArchiveInputStream archiveStream;

    public SevenZipIteratorAdapter(ArchiveInputStream archiveStream) {
        this.archiveStream = archiveStream;
    }

    @Override
    public Iterator<SevenZArchiveEntry> iterator() {
        return new SevenZipIterator();
    }

    private class SevenZipIterator
    implements Iterator<SevenZArchiveEntry> {
        private final Log log = LogFactory.getLog(this.getClass());
        private SevenZArchiveEntry entry;

        private SevenZipIterator() {
        }

        @Override
        public boolean hasNext() {
            boolean retStatus = false;
            try {
                if (this.entry == null) {
                    this.entry = (SevenZArchiveEntry)SevenZipIteratorAdapter.this.archiveStream.getNextEntry();
                    retStatus = this.entry != null;
                } else {
                    retStatus = true;
                }
            }
            catch (IOException e) {
                this.log.error((Object)"exception thrown when walking 7zip archive", (Throwable)e);
                retStatus = false;
            }
            return retStatus;
        }

        @Override
        public SevenZArchiveEntry next() {
            if (this.entry == null) {
                boolean hasMore = this.hasNext();
                if (hasMore) {
                    return this.returnAndNullEntry();
                }
                throw new NoSuchElementException("no mode elements");
            }
            return this.returnAndNullEntry();
        }

        private SevenZArchiveEntry returnAndNullEntry() {
            SevenZArchiveEntry entryToReturn = this.entry;
            this.entry = null;
            return entryToReturn;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not implemented");
        }
    }
}

