/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import net.byteseek.io.reader.ReaderInputStream;
import net.byteseek.io.reader.WindowReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;
import uk.gov.nationalarchives.droid.core.interfaces.resource.ResourceUtils;

public class TarEntryIdentificationRequest
implements IdentificationRequest<InputStream> {
    private static final int TOP_TAIL_CAPACITY = 0x200000;
    private final String fileName;
    private final String extension;
    private final RequestMetaData requestMetaData;
    private final RequestIdentifier identifier;
    private File tempDir;
    private Long size;
    private WindowReader reader;
    private Log log = LogFactory.getLog(this.getClass());

    public TarEntryIdentificationRequest(RequestMetaData metaData, RequestIdentifier identifier, File tempDir) {
        this.identifier = identifier;
        this.size = metaData.getSize();
        this.fileName = metaData.getName();
        this.extension = ResourceUtils.getExtension(this.fileName);
        this.tempDir = tempDir;
        this.requestMetaData = metaData;
    }

    @Override
    public final void open(InputStream in) throws IOException {
        this.reader = ResourceUtils.getStreamReader(in, this.tempDir, 0x200000, false);
        long readSize = this.reader.length();
        if (readSize != this.size) {
            String resourceIdentifier = "";
            if (this.getIdentifier() != null && this.getIdentifier().getUri() != null) {
                resourceIdentifier = this.getIdentifier().getUri().toString();
            }
            this.log.warn((Object)("The tar entry " + resourceIdentifier + "  states it is " + this.size + " in length, but reading it produced: " + readSize));
            this.size = readSize;
        }
    }

    @Override
    public final void close() throws IOException {
        this.reader.close();
    }

    @Override
    public final String getExtension() {
        return this.extension;
    }

    @Override
    public final String getFileName() {
        return this.fileName;
    }

    @Override
    public final long size() {
        return this.size;
    }

    @Override
    public final InputStream getSourceInputStream() throws IOException {
        return new ReaderInputStream(this.reader, false);
    }

    @Override
    public final RequestMetaData getRequestMetaData() {
        return this.requestMetaData;
    }

    @Override
    public final RequestIdentifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public byte getByte(long position) throws IOException {
        int result = this.reader.readByte(position);
        if (result < 0) {
            throw new IOException("No byte at position " + position);
        }
        return (byte)result;
    }

    @Override
    public WindowReader getWindowReader() {
        return this.reader;
    }
}

