/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.resource;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import net.byteseek.io.reader.InputStreamReader;
import net.byteseek.io.reader.cache.DoubleCache;
import net.byteseek.io.reader.cache.LeastRecentlyUsedCache;
import net.byteseek.io.reader.cache.TempFileCache;
import net.byteseek.io.reader.cache.TopAndTailStreamCache;
import net.byteseek.io.reader.cache.TwoLevelCache;
import net.byteseek.io.reader.cache.WindowCache;
import net.byteseek.io.reader.windows.SoftWindowRecovery;
import org.apache.commons.io.FilenameUtils;

public final class ResourceUtils {
    public static final double FREE_MEMORY_THRESHOLD = 6.7108864E7;
    private static final int BUFFER_SIZE = 8192;
    private static final int NINENTYEIGHT = 98;
    private static final int THIRTYTHREE = 33;
    private static final int NINENTYFOUR = 94;
    private static final int HEX_F = 15;
    private static final int HEX_7F = 127;
    private static final int UNSIGNED_RIGHT_SHIFT_BY_4 = 4;
    private static final int UNSIGNED_RIGHT_SHIFT_BY_11 = 11;
    private static final int UNSIGNED_RIGHT_SHIFT_BY_18 = 18;
    private static final int UNSIGNED_RIGHT_SHIFT_BY_25 = 25;
    private static final int ARRAYLENGTH = 5;

    private ResourceUtils() {
        throw new UnsupportedOperationException("ExtensionUtils is a static utility class and cannot be constructed.");
    }

    public static String getExtension(String filename) {
        int queryPos = filename.indexOf(63);
        String bareFilename = queryPos > -1 ? filename.substring(0, queryPos) : filename;
        String nameOnly = FilenameUtils.getName((String)bareFilename);
        int dotPos = nameOnly.lastIndexOf(46);
        return dotPos > 0 ? nameOnly.substring(dotPos + 1) : "";
    }

    public static InputStreamReader getStreamReader(InputStream in, File tempDir, int topTailCapacity) {
        InputStreamReader reader;
        if ((double)Runtime.getRuntime().freeMemory() > 6.7108864E7) {
            TwoLevelCache cache = TwoLevelCache.create((WindowCache)new TopAndTailStreamCache((long)topTailCapacity), (WindowCache)new TempFileCache(tempDir));
            reader = new InputStreamReader(in, (WindowCache)cache);
        } else {
            LeastRecentlyUsedCache memoryCache = new LeastRecentlyUsedCache(1024);
            TempFileCache persistentCache = new TempFileCache(tempDir);
            DoubleCache cache = DoubleCache.create((WindowCache)memoryCache, (WindowCache)persistentCache);
            reader = new InputStreamReader(in, (WindowCache)cache);
            reader.setSoftWindowRecovery((SoftWindowRecovery)persistentCache);
        }
        return reader;
    }

    public static InputStreamReader getStreamReader(InputStream in, File tempDir, int topTailCapacity, boolean closeStream) {
        InputStreamReader reader;
        if ((double)Runtime.getRuntime().freeMemory() > 6.7108864E7) {
            TwoLevelCache cache = TwoLevelCache.create((WindowCache)new TopAndTailStreamCache((long)topTailCapacity), (WindowCache)new TempFileCache(tempDir));
            reader = new InputStreamReader(in, (WindowCache)cache, closeStream);
        } else {
            LeastRecentlyUsedCache memoryCache = new LeastRecentlyUsedCache(1024);
            TempFileCache persistentCache = new TempFileCache(tempDir);
            DoubleCache cache = DoubleCache.create((WindowCache)memoryCache, (WindowCache)persistentCache);
            reader = new InputStreamReader(in, (WindowCache)cache, closeStream);
            reader.setSoftWindowRecovery((SoftWindowRecovery)persistentCache);
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File createTemporaryFileFromStream(File tempDir, InputStream stream) throws IOException {
        File file;
        File tempFile = File.createTempFile("droid-temp~", null, tempDir);
        FileOutputStream out = new FileOutputStream(tempFile);
        try {
            int len;
            byte[] buf = new byte[8192];
            while ((len = stream.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            file = tempFile;
        }
        catch (Throwable throwable) {
            try {
                ((OutputStream)out).close();
                throw throwable;
            }
            catch (IOException ex) {
                if (tempFile != null) {
                    tempFile.delete();
                }
                throw ex;
            }
        }
        ((OutputStream)out).close();
        return file;
    }

    public static int readBuffer(InputStream in, byte[] buffer) throws IOException {
        int totalBytesRead;
        int numRead;
        int bytesToRead = buffer.length;
        for (totalBytesRead = 0; totalBytesRead < bytesToRead && (numRead = in.read(buffer, totalBytesRead, bytesToRead - totalBytesRead)) != -1; totalBytesRead += numRead) {
        }
        return totalBytesRead;
    }

    public static int readBuffer(RandomAccessFile file, byte[] buffer) throws IOException {
        int totalBytesRead;
        int numRead;
        int bytesToRead = buffer.length;
        for (totalBytesRead = 0; totalBytesRead < bytesToRead && (numRead = file.read(buffer, totalBytesRead, bytesToRead - totalBytesRead)) != -1; totalBytesRead += numRead) {
        }
        return totalBytesRead;
    }

    private static long printableValue(long value) {
        return value < 94L ? value + 33L : value + 98L;
    }

    public static String getBase128Integer(long value) {
        char[] values = new char[5];
        int i = 0;
        values[i++] = (char)ResourceUtils.printableValue(value >>> 25 & 0x7FL);
        values[i++] = (char)ResourceUtils.printableValue(value >>> 18 & 0x7FL);
        values[i++] = (char)ResourceUtils.printableValue(value >>> 11 & 0x7FL);
        values[i++] = (char)ResourceUtils.printableValue(value >>> 4 & 0x7FL);
        values[i++] = (char)ResourceUtils.printableValue(value & 0xFL);
        return new String(values);
    }

    public static void getBase128IntegerCharArray(long value, char[] values) {
        int i = 0;
        values[i++] = (char)ResourceUtils.printableValue(value >>> 25 & 0x7FL);
        values[i++] = (char)ResourceUtils.printableValue(value >>> 18 & 0x7FL);
        values[i++] = (char)ResourceUtils.printableValue(value >>> 11 & 0x7FL);
        values[i++] = (char)ResourceUtils.printableValue(value >>> 4 & 0x7FL);
        values[i++] = (char)ResourceUtils.printableValue(value & 0xFL);
    }

    public static void attemptToDeleteTempFiles(File tempDir) {
        FileFilter tmpFileFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isFile() && FilenameUtils.isExtension((String)f.getName(), (String)"tmp");
            }
        };
        if (tempDir != null) {
            File[] files;
            for (File file : files = tempDir.listFiles(tmpFileFilter)) {
                if (file.delete()) continue;
                file.deleteOnExit();
            }
        }
    }
}

