/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.tools.file;

import ch.docuteam.tools.file.ResourceUtil;
import ch.docuteam.tools.os.EnvironmentVariable;
import ch.docuteam.tools.out.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public abstract class PropertyFile {
    private static final String AssignmentString = "=";
    protected static String PropertyFileName = null;
    private static Map<String, String> Map = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(String propsFileName) {
        PropertyFileName = null;
        Map = null;
        Logger.info("Reading file: " + propsFileName);
        BufferedReader reader = null;
        int lineNr = 0;
        try {
            String line;
            InputStreamReader inReader = null;
            inReader = new File(propsFileName).exists() ? new FileReader(propsFileName) : new InputStreamReader(ResourceUtil.getResourceAsStream(propsFileName));
            reader = new BufferedReader(inReader);
            Map = new HashMap<String, String>();
            do {
                ++lineNr;
                line = reader.readLine();
                if (line == null) {
                    break;
                }
                if ((line = line.trim()).length() == 0 || line.startsWith("#") || line.startsWith("//")) continue;
                int indexOfAssignmentString = line.indexOf(AssignmentString);
                if (indexOfAssignmentString == -1) {
                    throw new IllegalArgumentException("Error in row " + lineNr + ":'" + line + "': Assignment string '" + AssignmentString + "' missing");
                }
                String key = line.substring(0, indexOfAssignmentString).trim();
                String value = line.substring(indexOfAssignmentString + 1).trim();
                value = EnvironmentVariable.resolveIn(value);
                Logger.debug("Reading item(" + lineNr + "): " + key + AssignmentString + value);
                if (Map.containsKey(key)) {
                    Logger.warn("Duplicate key in file='" + propsFileName + "': " + key);
                }
                Map.put(key, value);
            } while (line != null);
        }
        catch (FileNotFoundException e) {
            Logger.warn("Could not find or access property file: " + propsFileName, e);
        }
        catch (IOException e) {
            Logger.warn("Error reading/accessing property file: " + propsFileName, e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    Logger.warn("Error closing property file: " + propsFileName, e);
                }
            }
        }
    }

    public static String get(String key, String ifAbsent, String ifEmpty) {
        String value;
        if (Map == null) {
            PropertyFile.initialize();
        }
        if ((value = PropertyFile.get(key, ifAbsent)) != null && value.trim().isEmpty()) {
            return ifEmpty;
        }
        return value;
    }

    public static String get(String key, String ifAbsent) {
        if (Map == null) {
            PropertyFile.initialize();
        }
        return Map.containsKey(key) ? Map.get(key) : ifAbsent;
    }

    public static String get(String key) {
        if (Map == null) {
            PropertyFile.initialize();
        }
        if (!Map.containsKey(key)) {
            Logger.warn("Couldn't find value for key '" + key + "'");
            return "";
        }
        return Map.get(key);
    }

    public static Properties getProperties() {
        Properties props = new Properties();
        for (String key : Map.keySet()) {
            props.setProperty(key, Map.get(key));
        }
        return props;
    }

    public static List<String> getKeys() {
        return new ArrayList<String>(Map.keySet());
    }

    private static void initialize() {
        PropertyFile.initialize(PropertyFileName);
    }

    public static boolean isPropertyConfigured(String propertyKey) {
        return !PropertyFile.get(propertyKey, "").trim().isEmpty();
    }

    public static boolean isAllPropertiesDefined(Properties propertyFile, String[] propertyKeys) {
        boolean result = true;
        for (String propertyKey : propertyKeys) {
            if (propertyFile.getProperty(propertyKey) != null && !propertyFile.getProperty(propertyKey).isEmpty()) continue;
            Logger.error("Property not defined: " + propertyKey);
            result = false;
        }
        return result;
    }
}

