/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.command;

import java.io.PrintWriter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;
import uk.gov.nationalarchives.droid.command.action.CommandExecutionException;
import uk.gov.nationalarchives.droid.command.action.CommandFactory;
import uk.gov.nationalarchives.droid.command.action.CommandFactoryImpl;
import uk.gov.nationalarchives.droid.command.action.CommandLineException;
import uk.gov.nationalarchives.droid.command.action.CommandLineParam;
import uk.gov.nationalarchives.droid.command.action.CommandLineSyntaxException;
import uk.gov.nationalarchives.droid.command.context.GlobalContext;
import uk.gov.nationalarchives.droid.command.context.SpringUiContext;
import uk.gov.nationalarchives.droid.core.interfaces.config.RuntimeConfig;

public final class DroidCommandLine
implements AutoCloseable {
    public static final String USAGE = "droid [options]";
    public static final int WRAP_WIDTH = 120;
    public static boolean systemExit = true;
    private final String[] args;
    private GlobalContext context = SpringUiContext.getInstance();
    private CommandFactory commandFactory;
    private CommandLine cli;

    DroidCommandLine(String[] args) {
        this.args = args;
    }

    public GlobalContext getContext() {
        return this.context;
    }

    public void setContext(GlobalContext context) {
        this.context = context;
    }

    public void run() throws CommandLineException {
        GnuParser parser = new GnuParser();
        try {
            Option opt;
            this.cli = parser.parse(CommandLineParam.options(), this.args);
            String logThreshold = "INFO";
            if (this.cli.hasOption(CommandLineParam.QUIET.toString())) {
                logThreshold = "ERROR";
            }
            System.setProperty("consoleLogThreshold", logThreshold);
            CommandLineParam option = null;
            Option[] arr$ = this.cli.getOptions();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (option = CommandLineParam.TOP_LEVEL_COMMANDS.get((opt = arr$[i$]).getOpt())) == null; ++i$) {
            }
            if (option == null) {
                throw new CommandLineSyntaxException("No command line options specified (use -h to see all available options)");
            }
            option.getCommand(this.commandFactory, this.cli).execute();
        }
        catch (ParseException pe) {
            throw new CommandLineSyntaxException(pe);
        }
    }

    public static void main(String[] args) throws CommandLineException {
        RuntimeConfig.configureRuntimeEnvironment();
        int returnCode = 0;
        try (DroidCommandLine commandLine = new DroidCommandLine(args);){
            returnCode = commandLine.processExecution();
        }
        if (systemExit) {
            System.exit(returnCode);
        }
    }

    public int processExecution() throws CommandLineException {
        PrintWriter out = new PrintWriter(System.out);
        CommandFactoryImpl localCommandFactory = new CommandFactoryImpl(this.context, out);
        this.setCommandFactory(localCommandFactory);
        int returnCode = 0;
        try {
            this.run();
            out.flush();
            this.context.close();
        }
        catch (CommandExecutionException ceex) {
            returnCode = 1;
            PrintWriter err = new PrintWriter(System.err);
            HelpFormatter formatter = new HelpFormatter();
            formatter.printWrapped(err, 120, ceex.getMessage());
            err.flush();
            throw ceex;
        }
        catch (CommandLineException clex) {
            returnCode = 1;
            PrintWriter err = new PrintWriter(System.err);
            HelpFormatter formatter = new HelpFormatter();
            formatter.printWrapped(err, 120, clex.getMessage());
            err.flush();
            throw clex;
        }
        return returnCode;
    }

    public CommandFactory getCommandFactory() {
        return this.commandFactory;
    }

    public void setCommandFactory(CommandFactory commandFactory) {
        this.commandFactory = commandFactory;
    }

    public CommandLine getCommandLine() {
        return this.cli;
    }

    @Override
    public void close() {
        this.getContext().close();
    }
}

