/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.command.action;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import uk.gov.nationalarchives.droid.command.action.CommandExecutionException;
import uk.gov.nationalarchives.droid.command.action.DroidCommand;
import uk.gov.nationalarchives.droid.command.action.LocationResolver;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureFileException;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureManager;
import uk.gov.nationalarchives.droid.profile.ProfileInstance;
import uk.gov.nationalarchives.droid.profile.ProfileManager;
import uk.gov.nationalarchives.droid.profile.ProfileManagerException;
import uk.gov.nationalarchives.droid.profile.ProfileState;
import uk.gov.nationalarchives.droid.results.handlers.ProgressObserver;

public class ProfileRunCommand
implements DroidCommand {
    private static final int SLEEP_TIME = 1000;
    private String destination;
    private String[] resources;
    private boolean recursive;
    private ProfileManager profileManager;
    private SignatureManager signatureManager;
    private LocationResolver locationResolver;

    @Override
    public void execute() throws CommandExecutionException {
        try {
            Map sigs = this.signatureManager.getDefaultSignatures();
            ProfileInstance profile = this.profileManager.createProfile(sigs);
            profile.changeState(ProfileState.VIRGIN);
            for (String resource : this.resources) {
                profile.addResource(this.locationResolver.getResource(resource, this.recursive));
            }
            Future future = this.profileManager.start(profile.getUuid());
            future.get();
            ProgressObserver progressCallback = new ProgressObserver(){

                public void onProgress(Integer progress) {
                }
            };
            Thread.sleep(1000L);
            this.profileManager.save(profile.getUuid(), new File(this.destination), progressCallback);
            this.profileManager.closeProfile(profile.getUuid());
        }
        catch (ProfileManagerException e) {
            throw new CommandExecutionException(e);
        }
        catch (InterruptedException e) {
            throw new CommandExecutionException(e);
        }
        catch (ExecutionException e) {
            throw new CommandExecutionException(e.getCause());
        }
        catch (IOException e) {
            throw new CommandExecutionException(e);
        }
        catch (SignatureFileException e) {
            throw new CommandExecutionException(e);
        }
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public void setResources(String[] resources) {
        this.resources = resources;
    }

    public void setProfileManager(ProfileManager profileManager) {
        this.profileManager = profileManager;
    }

    public void setSignatureManager(SignatureManager signatureManager) {
        this.signatureManager = signatureManager;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public void setLocationResolver(LocationResolver locationResolver) {
        this.locationResolver = locationResolver;
    }
}

