/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.command.archive;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Iterator;
import org.jwat.arc.ArcReaderFactory;
import org.jwat.arc.ArcRecord;
import org.jwat.arc.ArcRecordBase;
import org.jwat.common.Uri;
import uk.gov.nationalarchives.droid.command.action.CommandExecutionException;
import uk.gov.nationalarchives.droid.command.archive.ArchiveContentIdentifier;
import uk.gov.nationalarchives.droid.container.ContainerSignatureDefinitions;
import uk.gov.nationalarchives.droid.core.BinarySignatureIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.archive.WebArchiveEntryRequestFactory;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;

public class ArcArchiveContentIdentifier
extends ArchiveContentIdentifier {
    public ArcArchiveContentIdentifier(BinarySignatureIdentifier binarySignatureIdentifier, ContainerSignatureDefinitions containerSignatureDefinitions, String path, String slash, String slash1) {
        super(binarySignatureIdentifier, containerSignatureDefinitions, path, slash, slash1, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void identify(URI uri, IdentificationRequest request) throws CommandExecutionException {
        int httpACCEPTED = 200;
        String newPath = this.makeContainerURI("arc", request.getFileName());
        this.setSlash1("");
        WebArchiveEntryRequestFactory factory = new WebArchiveEntryRequestFactory();
        InputStream arcIn = null;
        try {
            arcIn = request.getSourceInputStream();
            Iterator iterator = ArcReaderFactory.getReader((InputStream)arcIn).iterator();
            ArcRecordBase base = null;
            try {
                while (iterator.hasNext()) {
                    base = (ArcRecordBase)iterator.next();
                    if (!(base instanceof ArcRecord) || base.getHttpHeader() == null || base.getHttpHeader().statusCode != 200) continue;
                    String name = null;
                    Uri baseUrl = base.getUrl();
                    name = baseUrl != null ? base.getUrl().toString() : base.getUrlStr();
                    if (name == null) {
                        String errMsg = "Skipping record with invalid URL in ArcArchiveContentIdentifier: " + base.getHttpHeader().toString();
                        System.err.println(errMsg);
                        continue;
                    }
                    RequestMetaData metaData = new RequestMetaData(base.getArchiveLength(), Long.valueOf(base.getArchiveDate().getTime()), name);
                    RequestIdentifier identifier = new RequestIdentifier(uri);
                    IdentificationRequest arcRequest = factory.newRequest(metaData, identifier);
                    InputStream in = base.getPayloadContent();
                    this.expandContainer(arcRequest, in, newPath);
                }
            }
            catch (NullPointerException npe) {
                System.err.println("Skipping invalid record header in " + newPath + npe);
            }
            finally {
                if (arcIn != null) {
                    arcIn.close();
                }
            }
        }
        catch (IOException ioe) {
            System.err.println("Skipping invalid record in " + newPath + ioe);
        }
    }
}

