/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.command.archive;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.compressors.gzip.GzipUtils;
import uk.gov.nationalarchives.droid.command.ResultPrinter;
import uk.gov.nationalarchives.droid.command.action.CommandExecutionException;
import uk.gov.nationalarchives.droid.command.archive.ArchiveContentIdentifier;
import uk.gov.nationalarchives.droid.container.ContainerSignatureDefinitions;
import uk.gov.nationalarchives.droid.core.BinarySignatureIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResultCollection;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.resource.GZipIdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;

public class GZipArchiveContentIdentifier
extends ArchiveContentIdentifier {
    private static final long SIZE = 12L;
    private static final long TIME = 13L;

    public GZipArchiveContentIdentifier(BinarySignatureIdentifier binarySignatureIdentifier, ContainerSignatureDefinitions containerSignatureDefinitions, String path, String slash, String slash1, Boolean webArchives) {
        super(binarySignatureIdentifier, containerSignatureDefinitions, path, slash, slash1, webArchives);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void identify(URI uri, IdentificationRequest request) throws CommandExecutionException {
        String newPath = "gzip:" + this.slash1 + this.path + request.getFileName() + "!" + this.slash;
        this.slash1 = "";
        URI newUri = URI.create(GzipUtils.getUncompressedFilename((String)uri.toString()));
        RequestIdentifier identifier = new RequestIdentifier(newUri);
        RequestMetaData metaData = new RequestMetaData(Long.valueOf(12L), Long.valueOf(13L), uri.getPath());
        GZipIdentificationRequest gzRequest = new GZipIdentificationRequest(metaData, identifier, this.tmpDir);
        GZIPInputStream gzin = null;
        try {
            gzin = new GZIPInputStream(request.getSourceInputStream());
            gzRequest.open((InputStream)gzin);
            IdentificationResultCollection gzResults = this.binarySignatureIdentifier.matchBinarySignatures((IdentificationRequest)gzRequest);
            ResultPrinter resultPrinter = new ResultPrinter(this.binarySignatureIdentifier, this.containerSignatureDefinitions, newPath, this.slash, this.slash1, true, super.getExpandWebArchives());
            resultPrinter.print(gzResults, (IdentificationRequest)gzRequest);
        }
        catch (IOException ioe) {
            System.err.println(ioe + " (" + newPath + ")");
        }
        finally {
            if (gzin != null) {
                try {
                    gzin.close();
                }
                catch (IOException ioe) {
                    throw new CommandExecutionException(ioe.getMessage(), ioe);
                }
            }
            if (gzRequest != null) {
                try {
                    gzRequest.close();
                }
                catch (IOException ioe) {
                    throw new CommandExecutionException(ioe.getMessage(), ioe);
                }
            }
        }
    }
}

