/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import net.byteseek.io.reader.ReaderInputStream;
import net.byteseek.io.reader.WindowReader;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;
import uk.gov.nationalarchives.droid.core.interfaces.resource.ResourceUtils;

public class GZipIdentificationRequest
implements IdentificationRequest<InputStream> {
    private static final int TOP_TAIL_CAPACITY = 0x200000;
    private final String extension;
    private final String fileName;
    private long size;
    private File tempDir;
    private RequestMetaData requestMetaData;
    private final RequestIdentifier identifier;
    private WindowReader reader;
    private Log log = LogFactory.getLog(this.getClass());

    public GZipIdentificationRequest(RequestMetaData metaData, RequestIdentifier identifier, File tempDir) {
        this.identifier = identifier;
        String path = identifier.getUri().getSchemeSpecificPart();
        this.extension = ResourceUtils.getExtension(path);
        this.fileName = FilenameUtils.getName((String)path);
        this.tempDir = tempDir;
        this.requestMetaData = metaData;
    }

    @Override
    public final void open(InputStream in) throws IOException {
        this.reader = ResourceUtils.getStreamReader(in, this.tempDir, 0x200000);
        this.size = this.reader.length();
    }

    @Override
    public final void close() throws IOException {
        this.reader.close();
    }

    @Override
    public final String getExtension() {
        return this.extension;
    }

    @Override
    public final String getFileName() {
        return this.fileName;
    }

    @Override
    public final long size() {
        return this.size;
    }

    @Override
    public final InputStream getSourceInputStream() throws IOException {
        return new ReaderInputStream(this.reader, false);
    }

    @Override
    public final RequestMetaData getRequestMetaData() {
        return this.requestMetaData;
    }

    @Override
    public final RequestIdentifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public byte getByte(long position) throws IOException {
        int result = this.reader.readByte(position);
        if (result < 0) {
            throw new IOException("No byte at position " + position);
        }
        return (byte)result;
    }

    @Override
    public WindowReader getWindowReader() {
        return this.reader;
    }
}

