/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.impl;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.AbstractModel;
import org.eclipse.rdf4j.model.impl.ContextStatement;
import org.eclipse.rdf4j.model.impl.FilteredModel;
import org.eclipse.rdf4j.model.impl.SimpleIRI;
import org.eclipse.rdf4j.model.impl.SimpleNamespace;
import org.eclipse.rdf4j.model.util.LexicalValueComparator;
import org.eclipse.rdf4j.model.util.PatternIterator;

public class TreeModel
extends AbstractModel
implements SortedSet<Statement> {
    private static final long serialVersionUID = 7893197431354524479L;
    static final Resource[] NULL_CTX = new Resource[]{null};
    static final IRI BEFORE = new SimpleIRI("urn:from");
    static final IRI AFTER = new SimpleIRI("urn:to");
    private final LexicalValueComparator vc = new LexicalValueComparator();
    final Set<Namespace> namespaces = new TreeSet<Namespace>();
    final List<StatementTree> trees = new ArrayList<StatementTree>();

    public TreeModel() {
        this.trees.add(new StatementTree("spog".toCharArray()));
    }

    public TreeModel(Model model) {
        this(model.getNamespaces());
        this.addAll(model);
    }

    public TreeModel(Collection<? extends Statement> c) {
        this();
        this.addAll(c);
    }

    public TreeModel(Set<Namespace> namespaces, Collection<? extends Statement> c) {
        this(c);
        this.namespaces.addAll(namespaces);
    }

    public TreeModel(Set<Namespace> namespaces) {
        this();
        this.namespaces.addAll(namespaces);
    }

    @Override
    public Optional<Namespace> getNamespace(String prefix) {
        for (Namespace nextNamespace : this.namespaces) {
            if (!prefix.equals(nextNamespace.getPrefix())) continue;
            return Optional.of(nextNamespace);
        }
        return Optional.empty();
    }

    @Override
    public Set<Namespace> getNamespaces() {
        return this.namespaces;
    }

    @Override
    public Namespace setNamespace(String prefix, String name) {
        this.removeNamespace(prefix);
        SimpleNamespace result = new SimpleNamespace(prefix, name);
        this.namespaces.add(result);
        return result;
    }

    @Override
    public void setNamespace(Namespace namespace) {
        this.removeNamespace(namespace.getPrefix());
        this.namespaces.add(namespace);
    }

    @Override
    public Optional<Namespace> removeNamespace(String prefix) {
        Optional<Namespace> result = this.getNamespace(prefix);
        if (result.isPresent()) {
            this.namespaces.remove(result.get());
        }
        return result;
    }

    @Override
    public int size() {
        return this.trees.get(0).size();
    }

    @Override
    public void clear() {
        for (StatementTree tree : this.trees) {
            tree.clear();
        }
    }

    @Override
    public Comparator<? super Statement> comparator() {
        return this.trees.get((int)0).tree.comparator();
    }

    @Override
    public Statement first() {
        return this.trees.get((int)0).tree.first();
    }

    @Override
    public Statement last() {
        return this.trees.get((int)0).tree.last();
    }

    public Statement lower(Statement e) {
        return this.trees.get((int)0).tree.lower(e);
    }

    public Statement floor(Statement e) {
        return this.trees.get((int)0).tree.floor(e);
    }

    public Statement ceiling(Statement e) {
        return this.trees.get((int)0).tree.ceiling(e);
    }

    public Statement higher(Statement e) {
        return this.trees.get((int)0).tree.higher(e);
    }

    public Statement pollFirst() {
        try {
            Statement first = this.trees.get((int)0).tree.first();
            this.remove(first);
            return first;
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public Statement pollLast() {
        try {
            Statement last = this.trees.get((int)0).tree.last();
            this.remove(last);
            return last;
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    @Override
    public SortedSet<Statement> subSet(Statement fromElement, Statement toElement) {
        return this.subSet(fromElement, true, toElement, false);
    }

    @Override
    public SortedSet<Statement> headSet(Statement toElement) {
        return this.subSet(this.before(null, null, null, null), true, toElement, false);
    }

    @Override
    public SortedSet<Statement> tailSet(Statement fromElement) {
        return this.subSet(fromElement, true, this.after(null, null, null, null), true);
    }

    @Override
    public boolean add(Resource subj, IRI pred, Value obj, Resource ... contexts) {
        if (subj == null || pred == null || obj == null) {
            throw new UnsupportedOperationException("Incomplete statement");
        }
        boolean changed = false;
        for (Value ctx : this.notEmpty(contexts)) {
            if (ctx != null && !(ctx instanceof Resource)) continue;
            TreeStatement st = new TreeStatement(subj, pred, obj, (Resource)ctx);
            for (StatementTree tree : this.trees) {
                changed |= tree.add(st);
            }
        }
        return changed;
    }

    @Override
    public boolean contains(Resource subj, IRI pred, Value obj, Resource ... contexts) {
        if (contexts == null || contexts.length == 1 && contexts[0] == null) {
            Iterator<Statement> iter = this.matchPattern(subj, pred, obj, null);
            while (iter.hasNext()) {
                if (iter.next().getContext() != null) continue;
                return true;
            }
            return false;
        }
        if (contexts.length == 0) {
            return this.matchPattern(subj, pred, obj, null).hasNext();
        }
        for (Resource ctx : contexts) {
            if (!(ctx == null ? this.contains(subj, pred, obj, (Resource[])null) : this.matchPattern(subj, pred, obj, ctx).hasNext())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Resource subj, IRI pred, Value obj, Resource ... contexts) {
        boolean changed = false;
        if (contexts == null || contexts.length == 1 && contexts[0] == null) {
            Iterator<Statement> iter = this.matchPattern(subj, pred, obj, null);
            while (iter.hasNext()) {
                if (iter.next().getContext() != null) continue;
                iter.remove();
                changed = true;
            }
        } else if (contexts.length == 0) {
            Iterator<Statement> iter = this.matchPattern(subj, pred, obj, null);
            while (iter.hasNext()) {
                iter.next();
                iter.remove();
                changed = true;
            }
        } else {
            for (Resource ctx : contexts) {
                if (ctx == null) {
                    changed |= this.remove(subj, pred, obj, (Resource[])null);
                    continue;
                }
                Iterator<Statement> iter = this.matchPattern(subj, pred, obj, ctx);
                while (iter.hasNext()) {
                    iter.next();
                    iter.remove();
                    changed = true;
                }
            }
        }
        return changed;
    }

    @Override
    public Iterator<Statement> iterator() {
        return this.matchPattern(null, null, null, null);
    }

    @Override
    public Model filter(Resource subj, IRI pred, Value obj, Resource ... contexts) {
        if (contexts != null && contexts.length == 0) {
            return new FilteredModel(this, subj, pred, obj, contexts){
                private static final long serialVersionUID = 396293781006255959L;

                @Override
                public Iterator<Statement> iterator() {
                    return TreeModel.this.matchPattern(this.subj, this.pred, this.obj, null);
                }

                @Override
                protected void removeFilteredTermIteration(Iterator<Statement> iter, Resource subj, IRI pred, Value obj, Resource ... contexts) {
                    TreeModel.this.removeTermIteration(iter, subj, pred, obj, contexts);
                }
            };
        }
        if (contexts != null && contexts.length == 1 && contexts[0] != null) {
            return new FilteredModel(this, subj, pred, obj, contexts){

                @Override
                public Iterator<Statement> iterator() {
                    return TreeModel.this.matchPattern(this.subj, this.pred, this.obj, this.contexts[0]);
                }

                @Override
                protected void removeFilteredTermIteration(Iterator<Statement> iter, Resource subj, IRI pred, Value obj, Resource ... contexts) {
                    TreeModel.this.removeTermIteration(iter, subj, pred, obj, contexts);
                }
            };
        }
        return new FilteredModel(this, subj, pred, obj, contexts){
            private static final long serialVersionUID = 396293781006255959L;

            @Override
            public Iterator<Statement> iterator() {
                return new PatternIterator<Statement>(TreeModel.this.matchPattern(this.subj, this.pred, this.obj, null), this.subj, this.pred, this.obj, this.contexts);
            }

            @Override
            protected void removeFilteredTermIteration(Iterator<Statement> iter, Resource subj, IRI pred, Value obj, Resource ... contexts) {
                TreeModel.this.removeTermIteration(iter, subj, pred, obj, contexts);
            }
        };
    }

    @Override
    public void removeTermIteration(Iterator<Statement> iterator, Resource subj, IRI pred, Value obj, Resource ... contexts) {
        TreeSet<Statement> owner = ((ModelIterator)iterator).getOwner();
        if (contexts == null || contexts.length == 1 && contexts[0] == null) {
            StatementTree chosen = this.choose(subj, pred, obj, null);
            Iterator<Statement> iter = chosen.subIterator(this.before(subj, pred, obj, null), true, this.after(subj, pred, obj, null), true);
            iter = new PatternIterator<Statement>(iter, subj, pred, obj, contexts);
            this.removeAll(owner, chosen, iter);
        } else if (contexts.length == 0) {
            StatementTree chosen = this.choose(subj, pred, obj, null);
            Iterator<Statement> iter = chosen.subIterator(this.before(subj, pred, obj, null), true, this.after(subj, pred, obj, null), true);
            this.removeAll(owner, chosen, iter);
        } else {
            for (Value ctx : this.notEmpty(contexts)) {
                if (ctx == null) {
                    this.removeTermIteration(iterator, subj, pred, obj, null);
                    continue;
                }
                StatementTree chosen = this.choose(subj, pred, obj, ctx);
                Iterator<Statement> iter = chosen.subIterator(this.before(subj, pred, obj, ctx), true, this.after(subj, pred, obj, ctx), true);
                this.removeAll(owner, chosen, iter);
            }
        }
    }

    Iterator<Statement> matchPattern(Resource subj, IRI pred, Value obj, Resource ctx) {
        if (!this.isResourceURIResource(subj, pred, ctx)) {
            Set emptySet = Collections.emptySet();
            return emptySet.iterator();
        }
        StatementTree tree = this.choose(subj, pred, obj, ctx);
        Iterator<Statement> it = tree.subIterator(this.before(subj, pred, obj, ctx), true, this.after(subj, pred, obj, ctx), true);
        return new ModelIterator(it, tree);
    }

    int compareValue(Value o1, Value o2) {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == BEFORE) {
            return -1;
        }
        if (o2 == BEFORE) {
            return 1;
        }
        if (o1 == AFTER) {
            return 1;
        }
        if (o2 == AFTER) {
            return -1;
        }
        return this.vc.compare(o1, o2);
    }

    SortedSet<Statement> subSet(Statement lo, boolean loInclusive, Statement hi, boolean hiInclusive) {
        return new SubSet(this, new TreeStatement(lo), loInclusive, new TreeStatement(hi), hiInclusive);
    }

    private void removeAll(TreeSet<Statement> owner, StatementTree chosen, Iterator<Statement> iter) {
        while (iter.hasNext()) {
            Statement last = iter.next();
            for (StatementTree tree : this.trees) {
                if (tree.owns(owner)) {
                    tree.reindex();
                    tree.remove(last);
                    continue;
                }
                if (tree == chosen) continue;
                tree.remove(last);
            }
            iter.remove();
        }
    }

    private boolean isResourceURIResource(Value subj, Value pred, Value ctx) {
        return !(subj != null && !(subj instanceof Resource) || pred != null && !(pred instanceof IRI) || ctx != null && !(ctx instanceof Resource));
    }

    private Value[] notEmpty(Value[] contexts) {
        if (contexts == null || contexts.length == 0) {
            return new Resource[]{null};
        }
        return contexts;
    }

    private Statement before(Value subj, Value pred, Value obj, Value ctx) {
        Resource s = subj instanceof Resource ? (Resource)subj : BEFORE;
        IRI p = pred instanceof IRI ? (IRI)pred : BEFORE;
        Value o = obj instanceof Value ? obj : BEFORE;
        Resource c = ctx instanceof Resource ? (Resource)ctx : BEFORE;
        return new TreeStatement(s, p, o, c);
    }

    private Statement after(Value subj, Value pred, Value obj, Value ctx) {
        Resource s = subj instanceof Resource ? (Resource)subj : AFTER;
        IRI p = pred instanceof IRI ? (IRI)pred : AFTER;
        Value o = obj instanceof Value ? obj : AFTER;
        Resource c = ctx instanceof Resource ? (Resource)ctx : AFTER;
        return new TreeStatement(s, p, o, c);
    }

    private StatementTree choose(Value subj, Value pred, Value obj, Value ctx) {
        for (StatementTree tree : this.trees) {
            if (!tree.isIndexed(subj, pred, obj, ctx)) continue;
            return tree;
        }
        return this.index(subj, pred, obj, ctx);
    }

    private StatementTree index(Value subj, Value pred, Value obj, Value ctx) {
        int idx = 0;
        char[] index = new char[4];
        if (subj != null) {
            index[idx++] = 115;
        }
        if (pred != null) {
            index[idx++] = 112;
        }
        if (obj != null) {
            index[idx++] = 111;
        }
        if (ctx != null) {
            index[idx++] = 103;
        }
        if (pred == null) {
            index[idx++] = 112;
        }
        if (obj == null) {
            index[idx++] = 111;
        }
        if (ctx == null) {
            index[idx++] = 103;
        }
        if (subj == null) {
            index[idx++] = 115;
        }
        StatementTree tree = new StatementTree(index);
        tree.addAll(this.trees.get(0));
        this.trees.add(tree);
        return tree;
    }

    static class SubSet
    extends AbstractSet<Statement>
    implements Serializable,
    SortedSet<Statement> {
        private static final long serialVersionUID = 6362727792092563793L;
        private final TreeModel model;
        private final TreeStatement lo;
        private final TreeStatement hi;
        private final boolean loInclusive;
        private final boolean hiInclusive;

        public SubSet(TreeModel model, TreeStatement lo, boolean loInclusive, TreeStatement hi, boolean hiInclusive) {
            this.model = model;
            this.lo = lo;
            this.loInclusive = loInclusive;
            this.hi = hi;
            this.hiInclusive = hiInclusive;
        }

        public Optional<Namespace> getNamespace(String prefix) {
            return this.model.getNamespace(prefix);
        }

        public Set<Namespace> getNamespaces() {
            return this.model.getNamespaces();
        }

        public Namespace setNamespace(String prefix, String name) {
            return this.model.setNamespace(prefix, name);
        }

        public void setNamespace(Namespace namespace) {
            this.model.setNamespace(namespace);
        }

        public Optional<Namespace> removeNamespace(String prefix) {
            return this.model.removeNamespace(prefix);
        }

        @Override
        public int size() {
            return this.subSet().size();
        }

        @Override
        public void clear() {
            StatementTree tree = this.model.trees.get(0);
            ModelIterator it = tree.subIterator(this.lo, this.loInclusive, this.hi, this.hiInclusive);
            TreeModel treeModel = this.model;
            treeModel.getClass();
            it = treeModel.new ModelIterator(it, tree);
            while (it.hasNext()) {
                it.remove();
            }
        }

        @Override
        public Comparator<? super Statement> comparator() {
            return this.model.comparator();
        }

        @Override
        public Statement first() {
            return (Statement)this.subSet().first();
        }

        @Override
        public Statement last() {
            return (Statement)this.subSet().last();
        }

        public Statement lower(Statement e) {
            return this.subSet().lower(e);
        }

        @Override
        public boolean isEmpty() {
            return this.subSet().isEmpty();
        }

        public Statement floor(Statement e) {
            return this.subSet().floor(e);
        }

        public Statement ceiling(Statement e) {
            return this.subSet().ceiling(e);
        }

        public Statement higher(Statement e) {
            return this.subSet().higher(e);
        }

        public Statement pollFirst() {
            try {
                Statement first = (Statement)this.subSet().first();
                this.model.remove(first);
                return first;
            }
            catch (NoSuchElementException e) {
                return null;
            }
        }

        public Statement pollLast() {
            try {
                Statement last = (Statement)this.subSet().last();
                this.model.remove(last);
                return last;
            }
            catch (NoSuchElementException e) {
                return null;
            }
        }

        @Override
        public SortedSet<Statement> subSet(Statement fromElement, Statement toElement) {
            boolean fromInclusive = true;
            boolean toInclusive = false;
            if (this.comparator().compare(fromElement, this.lo) < 0) {
                fromElement = this.lo;
                fromInclusive = this.loInclusive;
            }
            if (this.comparator().compare(this.hi, toElement) < 0) {
                toElement = this.hi;
                toInclusive = this.hiInclusive;
            }
            return this.model.subSet(fromElement, fromInclusive, toElement, toInclusive);
        }

        @Override
        public SortedSet<Statement> headSet(Statement toElement) {
            boolean toInclusive = false;
            if (this.comparator().compare(this.hi, toElement) < 0) {
                toElement = this.hi;
                toInclusive = this.hiInclusive;
            }
            return this.model.subSet(this.lo, this.loInclusive, toElement, toInclusive);
        }

        @Override
        public SortedSet<Statement> tailSet(Statement fromElement) {
            boolean fromInclusive = true;
            if (this.comparator().compare(fromElement, this.lo) < 0) {
                fromElement = this.lo;
                fromInclusive = this.loInclusive;
            }
            return this.model.subSet(fromElement, fromInclusive, this.hi, this.hiInclusive);
        }

        @Override
        public Iterator<Statement> iterator() {
            StatementTree tree = this.model.trees.get(0);
            Iterator<Statement> it = tree.subIterator(this.lo, this.loInclusive, this.hi, this.hiInclusive);
            TreeModel treeModel = this.model;
            treeModel.getClass();
            return treeModel.new ModelIterator(it, tree);
        }

        private NavigableSet<Statement> subSet() {
            return this.model.trees.get((int)0).tree.subSet(this.lo, this.loInclusive, this.hi, this.hiInclusive);
        }
    }

    static class StatementComparator
    implements Serializable,
    Comparator<Statement> {
        private static final long serialVersionUID = -5602364720279633641L;
        private final Comparator<Statement>[] comparators;

        public StatementComparator(Comparator<Statement> ... comparators) {
            this.comparators = comparators;
        }

        @Override
        public int compare(Statement s1, Statement s2) {
            for (Comparator<Statement> c : this.comparators) {
                int r1 = c.compare(s1, s2);
                if (r1 == 0) continue;
                return r1;
            }
            return 0;
        }
    }

    class GraphComparator
    implements Serializable,
    Comparator<Statement> {
        private static final long serialVersionUID = 7027824614533897706L;

        GraphComparator() {
        }

        @Override
        public int compare(Statement s1, Statement s2) {
            return TreeModel.this.compareValue(s1.getContext(), s2.getContext());
        }
    }

    class ObjectComparator
    implements Serializable,
    Comparator<Statement> {
        private static final long serialVersionUID = 1768294714884456242L;

        ObjectComparator() {
        }

        @Override
        public int compare(Statement s1, Statement s2) {
            return TreeModel.this.compareValue(s1.getObject(), s2.getObject());
        }
    }

    class PredicateComparator
    implements Serializable,
    Comparator<Statement> {
        private static final long serialVersionUID = -883414941022127103L;

        PredicateComparator() {
        }

        @Override
        public int compare(Statement s1, Statement s2) {
            return TreeModel.this.compareValue(s1.getPredicate(), s2.getPredicate());
        }
    }

    class SubjectComparator
    implements Serializable,
    Comparator<Statement> {
        private static final long serialVersionUID = 5275239384134217143L;

        SubjectComparator() {
        }

        @Override
        public int compare(Statement s1, Statement s2) {
            return TreeModel.this.compareValue(s1.getSubject(), s2.getSubject());
        }
    }

    class StatementTree
    implements Serializable {
        private static final long serialVersionUID = -7580746419791799953L;
        private final char[] index;
        TreeSet<Statement> tree;

        public StatementTree(char[] index) {
            this.index = index;
            Comparator[] comparators = new Comparator[index.length];
            block6: for (int i = 0; i < index.length; ++i) {
                switch (index[i]) {
                    case 's': {
                        comparators[i] = new SubjectComparator();
                        continue block6;
                    }
                    case 'p': {
                        comparators[i] = new PredicateComparator();
                        continue block6;
                    }
                    case 'o': {
                        comparators[i] = new ObjectComparator();
                        continue block6;
                    }
                    case 'g': {
                        comparators[i] = new GraphComparator();
                        continue block6;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            this.tree = new TreeSet<Statement>(new StatementComparator(comparators));
        }

        public boolean owns(TreeSet<Statement> set) {
            return this.tree == set;
        }

        public boolean isIndexed(Value subj, Value pred, Value obj, Value ctx) {
            boolean wild = false;
            block6: for (int i = 0; i < this.index.length; ++i) {
                switch (this.index[i]) {
                    case 's': {
                        if (subj == null) {
                            wild = true;
                            continue block6;
                        }
                        if (!wild) continue block6;
                        return false;
                    }
                    case 'p': {
                        if (pred == null) {
                            wild = true;
                            continue block6;
                        }
                        if (!wild) continue block6;
                        return false;
                    }
                    case 'o': {
                        if (obj == null) {
                            wild = true;
                            continue block6;
                        }
                        if (!wild) continue block6;
                        return false;
                    }
                    case 'g': {
                        if (ctx == null) {
                            wild = true;
                            continue block6;
                        }
                        if (!wild) continue block6;
                        return false;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            return true;
        }

        public void reindex() {
            TreeSet<Statement> treeSet = new TreeSet<Statement>(this.tree.comparator());
            treeSet.addAll(this.tree);
            this.tree = treeSet;
        }

        public boolean add(Statement e) {
            return this.tree.add(e);
        }

        public boolean addAll(StatementTree c) {
            return this.tree.addAll(c.tree);
        }

        public int size() {
            return this.tree.size();
        }

        public void clear() {
            this.tree.clear();
        }

        public boolean remove(Object o) {
            return this.tree.remove(o);
        }

        public Iterator<Statement> subIterator(Statement fromElement, boolean fromInclusive, Statement toElement, boolean toInclusive) {
            return this.tree.subSet(fromElement, true, toElement, true).iterator();
        }
    }

    static class TreeStatement
    extends ContextStatement {
        private static final long serialVersionUID = -7720419322256724495L;

        public TreeStatement(Statement st) {
            super(st.getSubject(), st.getPredicate(), st.getObject(), st.getContext());
        }

        public TreeStatement(Resource subject, IRI predicate, Value object, Resource ctx) {
            super(subject, predicate, object, ctx);
        }
    }

    private class ModelIterator
    implements Iterator<Statement> {
        private Iterator<Statement> iter;
        private TreeSet<Statement> owner;
        private Statement last;

        public ModelIterator(Iterator<Statement> iter, StatementTree owner) {
            this.iter = iter;
            this.owner = owner.tree;
        }

        public TreeSet<Statement> getOwner() {
            return this.owner;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Statement next() {
            this.last = this.iter.next();
            return this.last;
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            for (StatementTree tree : TreeModel.this.trees) {
                this.removeFrom(tree);
            }
            this.iter.remove();
        }

        private void removeFrom(StatementTree subjects) {
            if (!subjects.owns(this.owner)) {
                subjects.remove(this.last);
            }
        }
    }
}

