/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.signature.droid6;

import java.io.IOException;
import java.util.List;
import net.byteseek.compiler.CompileException;
import net.byteseek.compiler.matcher.SequenceMatcherCompiler;
import net.byteseek.io.reader.WindowReader;
import net.byteseek.matcher.MatchResult;
import net.byteseek.matcher.sequence.SequenceMatcher;
import net.byteseek.searcher.Searcher;
import net.byteseek.searcher.bytes.ByteMatcherSearcher;
import net.byteseek.searcher.sequence.horspool.HorspoolFinalFlagSearcher;
import uk.gov.nationalarchives.droid.core.signature.droid6.FragmentRewriter;
import uk.gov.nationalarchives.droid.core.signature.xml.SimpleElement;

public class SideFragment
extends SimpleElement
implements Cloneable {
    private static final String FRAGMENT_PARSE_ERROR = "The signature fragment [%s] could not be parsed. The error returned was [%s]";
    private static final SequenceMatcherCompiler EXPRESSION_COMPILER = new SequenceMatcherCompiler();
    private int myPosition;
    private int myMinOffset;
    private int myMaxOffset;
    private SequenceMatcher matcher;
    private Searcher searcher;
    private boolean isInvalidFragment;

    public final void setPosition(int thePosition) {
        this.myPosition = thePosition;
    }

    public final void setMinOffset(int theMinOffset) {
        this.myMinOffset = theMinOffset;
        if (this.myMaxOffset < this.myMinOffset) {
            this.myMaxOffset = theMinOffset;
        }
    }

    public final void setMaxOffset(int theMaxOffset) {
        this.myMaxOffset = theMaxOffset;
        if (this.myMinOffset > this.myMaxOffset) {
            this.myMinOffset = theMaxOffset;
        }
    }

    public final void setFragment(String expression) {
        try {
            String transformed = FragmentRewriter.rewriteFragment(expression);
            this.matcher = (SequenceMatcher)EXPRESSION_COMPILER.compile(transformed);
            this.searcher = this.matcher.length() == 1 ? new ByteMatcherSearcher(this.matcher.getMatcherForPosition(0)) : new HorspoolFinalFlagSearcher(this.matcher);
        }
        catch (CompileException ex) {
            String warning = String.format(FRAGMENT_PARSE_ERROR, expression, ex.getMessage());
            this.isInvalidFragment = true;
            this.getLog().warn((Object)warning);
        }
    }

    public boolean isInvalidFragment() {
        return this.isInvalidFragment;
    }

    @Override
    public final void setAttributeValue(String name, String value) {
        if ("Position".equals(name)) {
            this.setPosition(Integer.parseInt(value));
        } else if ("MinOffset".equals(name)) {
            this.setMinOffset(Integer.parseInt(value));
        } else if ("MaxOffset".equals(name)) {
            this.setMaxOffset(Integer.parseInt(value));
        } else {
            this.unknownAttributeWarning(name, this.getElementName());
        }
    }

    public final int getPosition() {
        return this.myPosition;
    }

    public final int getMinOffset() {
        return this.myMinOffset;
    }

    public final int getMaxOffset() {
        return this.myMaxOffset;
    }

    public final int getNumBytes() {
        return this.matcher == null ? 0 : this.matcher.length();
    }

    @Override
    public final void completeElementContent() {
        this.setFragment(this.getText());
    }

    public final boolean matchesBytes(WindowReader bytes, long matchFrom) throws IOException {
        return this.matcher.matches(bytes, matchFrom);
    }

    public final List<MatchResult> findFragmentForwards(WindowReader bytes, long from, long to) throws IOException {
        return this.searcher.searchForwards(bytes, from, to);
    }

    public final List<MatchResult> findBackwards(WindowReader bytes, long from, long to) throws IOException {
        return this.searcher.searchBackwards(bytes, from, to);
    }

    public final String toRegularExpression(boolean prettyPrint) {
        return this.matcher == null ? "" : this.matcher.toRegularExpression(prettyPrint);
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.toRegularExpression(true) + ']';
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public SideFragment copy() {
        SideFragment copy = null;
        try {
            copy = (SideFragment)this.clone();
        }
        catch (CloneNotSupportedException e) {
            System.out.println("Error cloning fragment " + this.toString() + ":" + e.getMessage());
        }
        return copy;
    }
}

