/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.signature.droid6;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import net.byteseek.compiler.CompileException;
import net.byteseek.compiler.matcher.SequenceMatcherCompiler;
import net.byteseek.io.reader.WindowReader;
import net.byteseek.matcher.sequence.SequenceMatcher;
import net.byteseek.searcher.SearchResult;
import net.byteseek.searcher.Searcher;
import net.byteseek.searcher.bytes.ByteMatcherSearcher;
import net.byteseek.searcher.sequence.horspool.HorspoolFinalFlagSearcher;
import org.apache.commons.lang.ArrayUtils;
import uk.gov.nationalarchives.droid.core.signature.ByteReader;
import uk.gov.nationalarchives.droid.core.signature.droid6.ByteSequence;
import uk.gov.nationalarchives.droid.core.signature.droid6.FragmentRewriter;
import uk.gov.nationalarchives.droid.core.signature.droid6.LeftFragment;
import uk.gov.nationalarchives.droid.core.signature.droid6.RightFragment;
import uk.gov.nationalarchives.droid.core.signature.droid6.Shift;
import uk.gov.nationalarchives.droid.core.signature.droid6.SideFragment;
import uk.gov.nationalarchives.droid.core.signature.xml.SimpleElement;

public class SubSequence
extends SimpleElement {
    private static final String SEQUENCE_PARSE_ERROR = "The signature sub-sequence [%s] could not be parsed. The error returned was [%s]";
    private static final SequenceMatcherCompiler SEQUENCE_COMPILER = new SequenceMatcherCompiler();
    private static final boolean EXPRESSION_BEFORE_GAPS = true;
    private static final boolean GAPS_BEFORE_EXPRESSION = false;
    private int minSeqOffset;
    private int maxSeqOffset;
    private int minLeftFragmentLength;
    private int maxLeftFragmentLength;
    private int minRightFragmentLength;
    private int maxRightFragmentLength;
    private int numLeftFragmentPositions;
    private int numRightFragmentPositions;
    private boolean fullFileScan;
    private List<LeftFragment> leftFragments = new ArrayList<LeftFragment>();
    private List<RightFragment> rightFragments = new ArrayList<RightFragment>();
    private SequenceMatcher matcher;
    private Searcher searcher;
    private final List<List<SideFragment>> orderedLeftFragments = new ArrayList<List<SideFragment>>();
    private final List<List<SideFragment>> orderedRightFragments = new ArrayList<List<SideFragment>>();
    private boolean backwardsSearch;
    private boolean isInvalidSubSequence;
    private boolean hasLeftFragments;
    private boolean hasRightFragments;
    private String subsequenceText;
    private boolean[] orderedLeftFragsHaveVariableOffset;
    private boolean[] orderedRightFragsHaveVariableOffset;
    private boolean useLeftFragmentBackTrack;
    private boolean useRightFragmentBackTrack;

    public final void addLeftFragment(LeftFragment leftFrag) {
        this.leftFragments.add(leftFrag);
    }

    public final void addRightFragment(RightFragment rightFrag) {
        this.rightFragments.add(rightFrag);
    }

    @Deprecated
    public final void setShift(Shift theShift) {
    }

    @Deprecated
    public final void setDefaultShift(String theValue) {
    }

    public final void setSequence(String seq) {
        this.subsequenceText = FragmentRewriter.rewriteFragment(seq);
    }

    public final void setMinSeqOffset(int theOffset) {
        this.minSeqOffset = theOffset;
        if (this.maxSeqOffset < this.minSeqOffset) {
            this.maxSeqOffset = this.minSeqOffset;
        }
    }

    public final void setMaxSeqOffset(int theOffset) {
        this.maxSeqOffset = theOffset;
        if (this.maxSeqOffset < this.minSeqOffset) {
            this.maxSeqOffset = this.minSeqOffset;
        }
    }

    @Deprecated
    public void setMinFragLength(int theLength) {
    }

    @Override
    public final void setAttributeValue(String name, String value) {
        if ("SubSeqMinOffset".equals(name)) {
            this.setMinSeqOffset(Integer.parseInt(value));
        } else if ("SubSeqMaxOffset".equals(name)) {
            this.setMaxSeqOffset(Integer.parseInt(value));
        } else if ("MinFragLength".equals(name)) {
            this.setMinFragLength(-1);
        } else if (!"Position".equals(name)) {
            this.unknownAttributeWarning(name, this.getElementName());
        }
    }

    public final int getNumFragmentPositions(boolean leftFrag) {
        return leftFrag ? this.numLeftFragmentPositions : this.numRightFragmentPositions;
    }

    public final int getNumAlternativeFragments(boolean leftFrag, int thePosition) {
        return leftFrag ? this.orderedLeftFragments.get(thePosition - 1).size() : this.orderedRightFragments.get(thePosition - 1).size();
    }

    public final int getNumAlternativeFragments(int thePosition, List<List<SideFragment>> orderedFragments) {
        return orderedFragments.get(thePosition - 1).size();
    }

    public final SideFragment getFragment(boolean leftFrag, int thePosition, int alternateIndex) {
        return leftFrag ? this.orderedLeftFragments.get(thePosition - 1).get(alternateIndex) : this.orderedRightFragments.get(thePosition - 1).get(alternateIndex);
    }

    public final int getNumBytes() {
        return this.matcher == null ? 0 : this.matcher.length();
    }

    public final int getMinSeqOffset() {
        return this.minSeqOffset;
    }

    public final int getMaxSeqOffset() {
        return this.maxSeqOffset;
    }

    public final void prepareForUse(boolean reverseOrder, boolean fullScan) {
        this.backwardsSearch = reverseOrder;
        this.fullFileScan = fullScan;
        this.processSequenceFragments();
        this.hasLeftFragments = !this.orderedLeftFragments.isEmpty();
        this.hasRightFragments = !this.orderedRightFragments.isEmpty();
    }

    private void processSequenceFragments() {
        this.buildOrderedLeftFragments();
        this.buildOrderedRightFragments();
        this.optimiseSingleByteAlternatives(this.orderedLeftFragments);
        this.optimiseSingleByteAlternatives(this.orderedRightFragments);
        this.captureLeftFragments();
        this.captureRightFragments();
        this.calculateMinMaxLeftFragmentLength();
        this.calculateMinMaxRightFragmentLength();
        this.buildMatcherAndSearcher();
        this.leftFragments = null;
        this.rightFragments = null;
        this.numLeftFragmentPositions = this.orderedLeftFragments.size();
        this.numRightFragmentPositions = this.orderedRightFragments.size();
        boolean bl = this.isInvalidSubSequence = this.isInvalidSubSequence ? true : this.checkForInvalidFragments();
        if (this.numLeftFragmentPositions > 0) {
            this.orderedLeftFragsHaveVariableOffset = this.determineFragmentPositionVariableOffsetStatus(this.orderedLeftFragments);
            this.useLeftFragmentBackTrack = ArrayUtils.contains((boolean[])this.orderedLeftFragsHaveVariableOffset, (boolean)true);
        }
        if (this.numRightFragmentPositions > 0) {
            this.orderedRightFragsHaveVariableOffset = this.determineFragmentPositionVariableOffsetStatus(this.orderedRightFragments);
            this.useRightFragmentBackTrack = ArrayUtils.contains((boolean[])this.orderedRightFragsHaveVariableOffset, (boolean)true);
        }
    }

    private void buildOrderedLeftFragments() {
        int i;
        int numPositions = 0;
        for (i = 0; i < this.leftFragments.size(); ++i) {
            int currentPosition = this.getRawLeftFragment(i).getPosition();
            if (currentPosition <= numPositions) continue;
            numPositions = currentPosition;
        }
        for (i = 0; i < numPositions; ++i) {
            ArrayList alternativeFragments = new ArrayList();
            this.orderedLeftFragments.add(alternativeFragments);
        }
        for (i = 0; i < this.leftFragments.size(); ++i) {
            LeftFragment fragment = this.getRawLeftFragment(i);
            int currentPosition = fragment.getPosition();
            this.orderedLeftFragments.get(currentPosition - 1).add(fragment);
        }
    }

    private void buildOrderedRightFragments() {
        int i;
        int numPositions = 0;
        for (i = 0; i < this.rightFragments.size(); ++i) {
            int currentPosition = this.getRawRightFragment(i).getPosition();
            if (currentPosition <= numPositions) continue;
            numPositions = currentPosition;
        }
        for (i = 0; i < numPositions; ++i) {
            ArrayList alternativeFragments = new ArrayList();
            this.orderedRightFragments.add(alternativeFragments);
        }
        for (i = 0; i < this.rightFragments.size(); ++i) {
            RightFragment fragment = this.getRawRightFragment(i);
            int currentPosition = fragment.getPosition();
            this.orderedRightFragments.get(currentPosition - 1).add(fragment);
        }
    }

    private void optimiseSingleByteAlternatives(List<List<SideFragment>> fragments) {
        for (int fragPos = 0; fragPos < fragments.size(); ++fragPos) {
            List<SideFragment> fragmentsToMatch = fragments.get(fragPos);
            int noOfFragments = fragmentsToMatch.size();
            if (noOfFragments <= 1) continue;
            boolean allFragmentsLengthOne = true;
            SideFragment frag = null;
            StringBuilder expression = new StringBuilder();
            expression.append('[');
            for (int fragmentIndex = 0; fragmentIndex < noOfFragments; ++fragmentIndex) {
                frag = fragmentsToMatch.get(fragmentIndex);
                if (frag.getNumBytes() > 1) {
                    allFragmentsLengthOne = false;
                    break;
                }
                expression.append(frag.toRegularExpression(false));
            }
            if (!allFragmentsLengthOne || frag == null) continue;
            LeftFragment newFrag = new LeftFragment();
            newFrag.setPosition(frag.getPosition());
            newFrag.setMinOffset(frag.getMinOffset());
            newFrag.setMaxOffset(frag.getMaxOffset());
            expression.append(']');
            newFrag.setFragment(expression.toString());
            ArrayList<LeftFragment> newList = new ArrayList<LeftFragment>();
            newList.add(newFrag);
            fragments.set(fragPos, newList);
        }
    }

    private void captureLeftFragments() {
        List<SideFragment> fragsAtPos;
        int captureFragPos = -1;
        int numLeftFragmentPos = this.orderedLeftFragments.size();
        block0: for (int position = 0; position < numLeftFragmentPos && (fragsAtPos = this.orderedLeftFragments.get(position)).size() == 1; ++position) {
            for (SideFragment frag : fragsAtPos) {
                if (frag.getMinOffset() == 0 && frag.getMaxOffset() == 0) {
                    this.subsequenceText = frag.toRegularExpression(true) + ' ' + this.subsequenceText;
                    captureFragPos = position;
                    continue;
                }
                if (frag.getMinOffset() != frag.getMaxOffset() || this.backwardsSearch) break block0;
                this.subsequenceText = frag.toRegularExpression(true) + " .{" + frag.getMinOffset() + "} " + this.subsequenceText;
                captureFragPos = position;
            }
        }
        this.rewriteRemainingFragments(this.orderedLeftFragments, captureFragPos);
    }

    private void captureRightFragments() {
        List<SideFragment> fragsAtPos;
        int captureFragPos = -1;
        int numRightPos = this.orderedRightFragments.size();
        block0: for (int position = 0; position < numRightPos && (fragsAtPos = this.orderedRightFragments.get(position)).size() == 1; ++position) {
            for (SideFragment frag : fragsAtPos) {
                if (frag.getMinOffset() == 0 && frag.getMaxOffset() == 0) {
                    this.subsequenceText = this.subsequenceText + ' ' + frag.toRegularExpression(true);
                    captureFragPos = position;
                    continue;
                }
                if (frag.getMinOffset() != frag.getMaxOffset() || !this.backwardsSearch) break block0;
                this.subsequenceText = this.subsequenceText + " .{" + frag.getMinOffset() + "} " + frag.toRegularExpression(true);
                captureFragPos = position;
            }
        }
        this.rewriteRemainingFragments(this.orderedRightFragments, captureFragPos);
    }

    private void rewriteRemainingFragments(List<List<SideFragment>> orderedList, int captureFragPos) {
        if (captureFragPos > -1) {
            for (int deleteCount = 0; deleteCount <= captureFragPos; ++deleteCount) {
                orderedList.remove(0);
            }
            for (int changePos = 0; changePos < orderedList.size(); ++changePos) {
                List<SideFragment> fragments = orderedList.get(changePos);
                for (SideFragment fragment : fragments) {
                    fragment.setPosition(changePos);
                }
            }
        }
    }

    private void calculateMinMaxLeftFragmentLength() {
        this.minLeftFragmentLength = 0;
        this.maxLeftFragmentLength = 0;
        for (int position = 0; position < this.orderedLeftFragments.size(); ++position) {
            List<SideFragment> fragmentList = this.orderedLeftFragments.get(position);
            int minFragSize = Integer.MAX_VALUE;
            int maxFragSize = 0;
            for (int fragmentIndex = 0; fragmentIndex < fragmentList.size(); ++fragmentIndex) {
                SideFragment frag = fragmentList.get(fragmentIndex);
                int fragMinSpace = frag.getNumBytes() + frag.getMinOffset();
                int fragMaxSpace = frag.getNumBytes() + frag.getMaxOffset();
                if (fragMinSpace < minFragSize) {
                    minFragSize = fragMinSpace;
                }
                if (fragMaxSpace <= maxFragSize) continue;
                maxFragSize = fragMaxSpace;
            }
            this.minLeftFragmentLength += minFragSize;
            this.maxLeftFragmentLength += maxFragSize;
        }
    }

    private void calculateMinMaxRightFragmentLength() {
        this.minRightFragmentLength = 0;
        this.maxRightFragmentLength = 0;
        for (int position = 0; position < this.orderedRightFragments.size(); ++position) {
            List<SideFragment> fragmentList = this.orderedRightFragments.get(position);
            int minFragSize = Integer.MAX_VALUE;
            int maxFragSize = 0;
            for (int fragmentIndex = 0; fragmentIndex < fragmentList.size(); ++fragmentIndex) {
                SideFragment frag = fragmentList.get(fragmentIndex);
                int fragMinSpace = frag.getNumBytes() + frag.getMinOffset();
                int fragMaxSpace = frag.getNumBytes() + frag.getMaxOffset();
                if (fragMinSpace < minFragSize) {
                    minFragSize = fragMinSpace;
                }
                if (fragMaxSpace <= maxFragSize) continue;
                maxFragSize = fragMaxSpace;
            }
            this.minRightFragmentLength += minFragSize;
            this.maxRightFragmentLength += maxFragSize;
        }
    }

    private void buildMatcherAndSearcher() {
        try {
            this.matcher = (SequenceMatcher)SEQUENCE_COMPILER.compile(this.subsequenceText);
            this.searcher = this.matcher.length() == 1 ? new ByteMatcherSearcher(this.matcher.getMatcherForPosition(0)) : new HorspoolFinalFlagSearcher(this.matcher);
        }
        catch (CompileException ex) {
            String warning = String.format(SEQUENCE_PARSE_ERROR, this.subsequenceText, ex.getMessage());
            this.getLog().warn((Object)warning);
            this.isInvalidSubSequence = true;
        }
    }

    private int getNumberOfFragmentPositions(List<SideFragment> fragments) {
        int numPositions = 0;
        for (int i = 0; i < this.leftFragments.size(); ++i) {
            int currentPosition = fragments.get(i).getPosition();
            if (currentPosition <= numPositions) continue;
            numPositions = currentPosition;
        }
        return numPositions;
    }

    public boolean isInvalidSubSequence() {
        return this.isInvalidSubSequence;
    }

    private boolean checkForInvalidFragments() {
        return this.checkFragmentList(this.orderedLeftFragments) || this.checkFragmentList(this.orderedRightFragments);
    }

    private boolean checkFragmentList(List<List<SideFragment>> orderedFragmentList) {
        for (List<SideFragment> fragmentList : orderedFragmentList) {
            for (SideFragment fragment : fragmentList) {
                if (!fragment.isInvalidFragment()) continue;
                return true;
            }
        }
        return false;
    }

    private String getFragmentAlternativesAsRegularExpression(boolean prettyPrint, int positionIndex, List<SideFragment> fragments) {
        StringBuffer regularExpression = new StringBuffer();
        regularExpression.append(prettyPrint ? " (" : "(");
        int lastAlternate = fragments.size();
        for (int alternateIndex = 0; alternateIndex < lastAlternate; ++alternateIndex) {
            if (alternateIndex > 0) {
                regularExpression.append("|");
            }
            SideFragment fragment = fragments.get(alternateIndex);
            regularExpression.append(fragment.toRegularExpression(prettyPrint));
        }
        regularExpression.append(prettyPrint ? ") " : ")");
        return regularExpression.toString();
    }

    private void appendFragmentstoRegularExpression(boolean prettyPrint, StringBuffer regularExpression, boolean expressionFirst, int positionIndex, List<SideFragment> fragments) {
        SideFragment fragment = fragments.get(0);
        int minFragmentOffset = fragment.getMinOffset();
        int maxFragmentOffset = fragment.getMaxOffset();
        String fragmentExpression = fragments.size() > 1 ? this.getFragmentAlternativesAsRegularExpression(prettyPrint, positionIndex, fragments) : fragment.toRegularExpression(prettyPrint);
        ByteSequence.appendBoundedGapExpression(prettyPrint, expressionFirst, regularExpression, fragmentExpression, minFragmentOffset, maxFragmentOffset);
    }

    private boolean[] determineFragmentPositionVariableOffsetStatus(List<List<SideFragment>> orderedFragmentsList) {
        boolean[] orderedFragsHaveVariableOffset = new boolean[orderedFragmentsList.size()];
        for (int i = 0; i < orderedFragmentsList.size(); ++i) {
            orderedFragsHaveVariableOffset[i] = this.fragmentsContainVariableOffset(orderedFragmentsList.get(i));
        }
        return orderedFragsHaveVariableOffset;
    }

    private boolean fragmentsContainVariableOffset(List<SideFragment> fragmentList) {
        boolean hasAtLeastOneVariableOffset = false;
        for (SideFragment fragment : fragmentList) {
            if (fragment.getMinOffset() == fragment.getMaxOffset()) continue;
            hasAtLeastOneVariableOffset = true;
            break;
        }
        return hasAtLeastOneVariableOffset;
    }

    public final String toRegularExpression(boolean prettyPrint) {
        List<SideFragment> fragments;
        int positionIndex;
        StringBuffer regularExpression = new StringBuffer();
        for (positionIndex = this.numLeftFragmentPositions; positionIndex > 0; --positionIndex) {
            fragments = this.orderedLeftFragments.get(positionIndex - 1);
            this.appendFragmentstoRegularExpression(prettyPrint, regularExpression, true, positionIndex, fragments);
        }
        regularExpression.append(this.matcher.toRegularExpression(prettyPrint));
        for (positionIndex = 1; positionIndex <= this.numRightFragmentPositions; ++positionIndex) {
            fragments = this.orderedRightFragments.get(positionIndex - 1);
            this.appendFragmentstoRegularExpression(prettyPrint, regularExpression, false, positionIndex, fragments);
        }
        return regularExpression.toString();
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.toRegularExpression(true) + ']';
    }

    public final boolean findSequenceFromPosition(long position, ByteReader targetFile, long maxBytesToScan, boolean bofSubsequence, boolean eofSubsequence) {
        boolean entireSequenceFound;
        block29: {
            entireSequenceFound = false;
            try {
                long endSearchWindow;
                boolean hasLeftFragments = !this.orderedLeftFragments.isEmpty();
                boolean hasRightFragments = !this.orderedRightFragments.isEmpty();
                long lastBytePositionInFile = targetFile.getNumBytes() - 1L;
                int matchLength = this.matcher.length();
                int lastBytePositionInAnchor = matchLength - 1;
                long firstPossibleBytePosition = this.minLeftFragmentLength;
                long lastPossibleBytePosition = lastBytePositionInFile - (long)this.minRightFragmentLength;
                WindowReader windowReader = targetFile.getWindowReader();
                if (this.backwardsSearch) {
                    long endSearchWindow2;
                    long maximumPossibleStartingPosition = position - (long)this.minRightFragmentLength - (long)lastBytePositionInAnchor;
                    long startSearchWindow = maximumPossibleStartingPosition - (long)this.getMinSeqOffset();
                    int rightFragmentWindow = this.maxRightFragmentLength - this.minRightFragmentLength;
                    long l = endSearchWindow2 = this.fullFileScan ? 0L : maximumPossibleStartingPosition - (long)this.getMaxSeqOffset() - (long)rightFragmentWindow;
                    if (maxBytesToScan > 0L && endSearchWindow2 < lastBytePositionInFile - maxBytesToScan) {
                        endSearchWindow2 = lastBytePositionInFile - maxBytesToScan;
                    }
                    if (startSearchWindow > lastPossibleBytePosition) {
                        return false;
                    }
                    if (endSearchWindow2 < firstPossibleBytePosition) {
                        endSearchWindow2 = firstPossibleBytePosition;
                    }
                    for (long matchPosition = startSearchWindow; matchPosition >= endSearchWindow2; --matchPosition) {
                        if (matchPosition == endSearchWindow2) {
                            matchPosition = this.matcher.matches(windowReader, matchPosition) ? matchPosition : -1L;
                        } else {
                            List matches = this.searcher.searchBackwards(windowReader, matchPosition, endSearchWindow2);
                            long l2 = matchPosition = matches.size() > 0 ? ((SearchResult)matches.get(0)).getMatchPosition() : -1L;
                        }
                        if (matchPosition != -1L) {
                            boolean matchFound = true;
                            if (hasRightFragments) {
                                List<List<SideFragment>> furthestRightFragmentOption = this.orderedRightFragments.subList(this.orderedRightFragments.size() - 1, this.orderedRightFragments.size());
                                OffsetAndFilePositions finalOptionOffSetFoundPositions = new OffsetAndFilePositions(furthestRightFragmentOption.get(0));
                                long[] rightFragmentPositions = this.bytePosForRightFragments(windowReader, matchPosition + (long)matchLength, targetFile.getFileMarker(), 1, 0, this.orderedRightFragments, finalOptionOffSetFoundPositions);
                                matchFound = rightFragmentPositions.length > 0;
                                boolean rightMostFragmentPositionInvalid = true;
                                if (matchFound) {
                                    long currentFurthestEOFRightmostFragmentPosition;
                                    long currentNearestEOFRightmostFragmentPosition = rightFragmentPositions[rightFragmentPositions.length - 1];
                                    long l3 = currentFurthestEOFRightmostFragmentPosition = rightFragmentPositions.length > 1 ? rightFragmentPositions[0] : currentNearestEOFRightmostFragmentPosition;
                                    if (currentFurthestEOFRightmostFragmentPosition <= position - (long)this.minSeqOffset) {
                                        rightMostFragmentPositionInvalid = currentNearestEOFRightmostFragmentPosition < position - (long)this.maxSeqOffset && this.checkRightFragmentForInvalidOffset(windowReader, currentNearestEOFRightmostFragmentPosition + 1L, position, this.maxSeqOffset, this.minSeqOffset, furthestRightFragmentOption, finalOptionOffSetFoundPositions);
                                    }
                                }
                                boolean bl = matchFound = !rightMostFragmentPositionInvalid;
                            }
                            if (!matchFound) continue;
                            if (hasLeftFragments) {
                                long[] leftFragmentPositions = this.bytePosForLeftFragments(windowReader, 0L, matchPosition - 1L, -1, 0, this.orderedLeftFragments, null);
                                matchFound = leftFragmentPositions.length > 0;
                                long l4 = matchPosition = matchFound ? leftFragmentPositions[0] : matchPosition;
                            }
                            if (!matchFound) continue;
                            targetFile.setFileMarker(matchPosition - 1L);
                            entireSequenceFound = true;
                        }
                        break block29;
                    }
                    break block29;
                }
                long minimumPossibleStartingPosition = position + (long)this.minLeftFragmentLength + (long)lastBytePositionInAnchor;
                long startSearchWindow = minimumPossibleStartingPosition + (long)this.getMinSeqOffset();
                int leftFragmentWindow = this.maxLeftFragmentLength - this.minLeftFragmentLength;
                long l = endSearchWindow = this.fullFileScan ? lastPossibleBytePosition : minimumPossibleStartingPosition + (long)this.getMaxSeqOffset() + (long)leftFragmentWindow;
                if (maxBytesToScan > 0L && endSearchWindow > maxBytesToScan) {
                    endSearchWindow = maxBytesToScan;
                }
                if (startSearchWindow < firstPossibleBytePosition) {
                    return false;
                }
                if (endSearchWindow > lastPossibleBytePosition) {
                    endSearchWindow = lastPossibleBytePosition;
                }
                for (long matchPosition = startSearchWindow; matchPosition <= endSearchWindow; ++matchPosition) {
                    long matchStarterPosition = matchPosition - (long)matchLength + 1L;
                    long matchEndingPosition = endSearchWindow - (long)matchLength + 1L;
                    if (matchStarterPosition == matchEndingPosition) {
                        matchPosition = this.matcher.matches(windowReader, matchStarterPosition) ? matchStarterPosition + (long)matchLength - 1L : -1L;
                    } else {
                        List matches = this.searcher.searchForwards(windowReader, matchStarterPosition, matchEndingPosition);
                        long l5 = matchPosition = matches.size() > 0 ? ((SearchResult)matches.get(0)).getMatchPosition() + (long)matchLength - 1L : -1L;
                    }
                    if (matchPosition != -1L) {
                        boolean matchFound = true;
                        if (hasLeftFragments) {
                            List<List<SideFragment>> furthestLeftFragmentOption = this.orderedLeftFragments.subList(this.orderedLeftFragments.size() - 1, this.orderedLeftFragments.size());
                            OffsetAndFilePositions finalOptionOffSetFoundPositions = new OffsetAndFilePositions(furthestLeftFragmentOption.get(0));
                            long[] leftFragmentPositions = this.bytePosForLeftFragments(windowReader, targetFile.getFileMarker(), matchPosition - (long)matchLength, -1, 0, this.orderedLeftFragments, finalOptionOffSetFoundPositions);
                            matchFound = leftFragmentPositions.length > 0;
                            boolean leftMostFragmentPositionInvalid = true;
                            if (matchFound) {
                                long currentNearestBOFLeftmostFragmentPosition = leftFragmentPositions[leftFragmentPositions.length - 1];
                                long currentFurthestBOFLeftmostFragmentPosition = leftFragmentPositions.length > 1 ? leftFragmentPositions[0] : currentNearestBOFLeftmostFragmentPosition;
                                long minOffsetFromBOF = (long)this.minSeqOffset + position;
                                long maxOffsetFromBOF = (long)this.maxSeqOffset + position;
                                if (currentNearestBOFLeftmostFragmentPosition >= minOffsetFromBOF) {
                                    boolean bl = leftMostFragmentPositionInvalid = currentFurthestBOFLeftmostFragmentPosition > maxOffsetFromBOF && this.checkLeftFragmentForInvalidOffset(windowReader, 0L, currentNearestBOFLeftmostFragmentPosition, maxOffsetFromBOF, minOffsetFromBOF, furthestLeftFragmentOption, finalOptionOffSetFoundPositions);
                                }
                            }
                            if (matchFound && bofSubsequence && leftMostFragmentPositionInvalid) {
                                matchFound = false;
                            }
                        }
                        if (!matchFound) continue;
                        if (hasRightFragments) {
                            long[] rightFragmentPositions = this.bytePosForRightFragments(windowReader, matchPosition + 1L, lastBytePositionInFile, 1, 0, this.orderedRightFragments, null);
                            boolean bl = matchFound = rightFragmentPositions.length > 0;
                            if (matchFound && eofSubsequence && rightFragmentPositions[0] > (long)this.maxSeqOffset) {
                                matchFound = false;
                            }
                            long l6 = matchPosition = matchFound ? rightFragmentPositions[0] : matchPosition;
                        }
                        if (!matchFound) continue;
                        targetFile.setFileMarker(matchPosition + 1L);
                        entireSequenceFound = true;
                    }
                    break;
                }
            }
            catch (IndexOutOfBoundsException e) {
                this.getLog().debug((Object)e.getMessage());
            }
            catch (IOException e) {
                this.getLog().error((Object)e.getMessage());
            }
            catch (Exception e) {
                this.getLog().debug((Object)e.getMessage());
            }
        }
        return entireSequenceFound;
    }

    private long[] bytePosForRightFragments(WindowReader bytes, long leftBytePos, long rightBytePos, int searchDirection, int offsetRange, List<List<SideFragment>> fragments, OffsetAndFilePositions finalOffsetFoundPositions) {
        boolean leftFrag = false;
        long startPos = leftBytePos;
        int posLoopStart = 1;
        int numFragPos = fragments.size();
        if (searchDirection == -1) {
            startPos = rightBytePos;
            posLoopStart = numFragPos;
        }
        int totalNumOptions = offsetRange + 1;
        for (int iFragPos = 1; iFragPos <= numFragPos; ++iFragPos) {
            totalNumOptions *= this.getNumAlternativeFragments(iFragPos, fragments);
        }
        long[] markerPos = new long[totalNumOptions];
        for (int iOffset = 0; iOffset <= offsetRange; ++iOffset) {
            markerPos[iOffset] = startPos + (long)(iOffset * searchDirection);
        }
        int numOptions = 1 + offsetRange;
        boolean seqNotFound = false;
        Stack<FragmentHit> fragmentHits = null;
        if (this.useRightFragmentBackTrack) {
            fragmentHits = new Stack<FragmentHit>();
        }
        boolean recheckingFinalFragmentOption = finalOffsetFoundPositions != null && finalOffsetFoundPositions.getFirstPositionInFile() != -1L;
        for (int iFragPos = posLoopStart; !seqNotFound && iFragPos <= numFragPos && iFragPos >= 1; iFragPos += searchDirection) {
            int iOption;
            List<SideFragment> fragmentsAtPosition = fragments.get(iFragPos - 1);
            int numAltFrags = fragmentsAtPosition.size();
            long[] tempEndPos = new long[numAltFrags * numOptions];
            int numEndPos = 0;
            block3: for (iOption = 0; iOption < numOptions; ++iOption) {
                block4: for (int iAlt = 0; iAlt < numAltFrags; ++iAlt) {
                    long tempFragEnd;
                    SideFragment fragment = fragmentsAtPosition.get(iAlt);
                    long previousInstanceOffsetFoundPosition = finalOffsetFoundPositions == null || !recheckingFinalFragmentOption ? -1L : finalOffsetFoundPositions.getOffsetPosition(iAlt);
                    long previousInstanceFilePosition = -1L;
                    if (finalOffsetFoundPositions != null && recheckingFinalFragmentOption && previousInstanceOffsetFoundPosition != -1L) {
                        fragment = fragment.copy();
                        previousInstanceFilePosition = finalOffsetFoundPositions.getFilePosition(iAlt);
                        long newMaxOffset = (long)fragment.getMaxOffset() - previousInstanceOffsetFoundPosition - (leftBytePos - (previousInstanceFilePosition - (long)fragment.getNumBytes() + 1L));
                        long newMinOffset = (long)fragment.getMinOffset() - previousInstanceOffsetFoundPosition - (leftBytePos - (previousInstanceFilePosition - (long)fragment.getNumBytes() + 1L));
                        fragment.setMinOffset((int)Math.max(newMinOffset, 0L));
                        fragment.setMaxOffset((int)newMaxOffset);
                        if (fragment.getMaxOffset() < 0) continue;
                    }
                    if ((tempFragEnd = searchDirection == -1 ? this.endBytePosForSeqFrag(bytes, leftBytePos, markerPos[iOption], false, searchDirection, iFragPos, fragment) : this.endBytePosForSeqFrag(bytes, markerPos[iOption], rightBytePos, false, searchDirection, iFragPos, fragment)) > -1L) {
                        tempEndPos[numEndPos] = tempFragEnd + (long)searchDirection;
                        ++numEndPos;
                        long offSetFound = tempFragEnd - markerPos[iOption] - (long)fragment.getNumBytes() + 1L;
                        if (fragmentHits != null && iFragPos < numFragPos && (this.orderedRightFragsHaveVariableOffset[iFragPos] || this.orderedRightFragsHaveVariableOffset[iFragPos - 1])) {
                            FragmentHit fragmentHit = new FragmentHit(iFragPos, iAlt, tempEndPos[numEndPos - 1], offSetFound);
                            fragmentHits.push(fragmentHit);
                        }
                        if (iFragPos != numFragPos || finalOffsetFoundPositions == null) continue;
                        finalOffsetFoundPositions.setPosition(iAlt, (int)offSetFound, tempFragEnd);
                        continue;
                    }
                    if (iAlt != numAltFrags - 1 || numEndPos != 0 || iOption != numOptions - 1) continue;
                    while (fragmentHits != null && !fragmentHits.empty()) {
                        FragmentHit lastGoodFragRef = (FragmentHit)fragmentHits.pop();
                        fragment = fragments.get(lastGoodFragRef.getFragmentSignaturePosition() - 1).get(lastGoodFragRef.getAlternativeFragmentNumber()).copy();
                        fragment.setMinOffset(Math.max(fragment.getMinOffset() - (int)lastGoodFragRef.getOffsetFound() - fragment.getNumBytes(), 0));
                        fragment.setMaxOffset(fragment.getMaxOffset() - (int)lastGoodFragRef.getOffsetFound() - fragment.getNumBytes());
                        if (fragment.getMaxOffset() < 0) continue block4;
                        tempFragEnd = searchDirection == 1 ? this.endBytePosForSeqFrag(bytes, lastGoodFragRef.getPositionInFile(), rightBytePos, false, searchDirection, lastGoodFragRef.getFragmentSignaturePosition(), fragment) : this.endBytePosForSeqFrag(bytes, leftBytePos, lastGoodFragRef.getPositionInFile(), false, searchDirection, lastGoodFragRef.getFragmentSignaturePosition(), fragment);
                        if (tempFragEnd <= -1L) continue;
                        tempEndPos[numEndPos] = tempFragEnd + (long)searchDirection;
                        iFragPos = lastGoodFragRef.getFragmentSignaturePosition();
                        iAlt = lastGoodFragRef.getAlternativeFragmentNumber();
                        long newOffSetFoundFromPreviousMatch = tempEndPos[numEndPos] - lastGoodFragRef.getPositionInFile() + lastGoodFragRef.getOffsetFound();
                        FragmentHit fragmentHit = new FragmentHit(iFragPos, iAlt, tempEndPos[numEndPos], newOffSetFoundFromPreviousMatch);
                        fragmentHits.push(fragmentHit);
                        ++numEndPos;
                        continue block3;
                    }
                }
            }
            if (numEndPos == 0) {
                seqNotFound = true;
                continue;
            }
            numOptions = 0;
            for (iOption = 0; iOption < numEndPos; ++iOption) {
                boolean addEndPos = true;
                for (int iMarker = 0; iMarker < numOptions; ++iMarker) {
                    if (markerPos[iMarker] != tempEndPos[iOption]) continue;
                    addEndPos = false;
                    break;
                }
                if (!addEndPos) continue;
                markerPos[numOptions] = tempEndPos[iOption];
                ++numOptions;
            }
        }
        if (fragmentHits != null) {
            fragmentHits.clear();
        }
        if (seqNotFound) {
            return new long[0];
        }
        long[] outArray = new long[numOptions];
        if (searchDirection < 0) {
            for (int iOption = 0; iOption < numOptions; ++iOption) {
                markerPos[iOption] = -markerPos[iOption];
            }
        }
        Arrays.sort(markerPos, 0, numOptions);
        if (searchDirection < 0) {
            for (int iOption = 0; iOption < numOptions; ++iOption) {
                markerPos[iOption] = -markerPos[iOption];
            }
        }
        System.arraycopy(markerPos, 0, outArray, 0, numOptions);
        int iOption = 0;
        while (iOption < numOptions) {
            int n = iOption++;
            outArray[n] = outArray[n] - (long)searchDirection;
        }
        return outArray;
    }

    private long endBytePosForSeqFrag(WindowReader bytes, long leftEndBytePos, long rightEndBytePos, boolean leftFrag, int searchDirection, int fragPos, SideFragment fragment) {
        long lastStartPosInFile;
        long lastStartPosInFile2;
        long startPosInFile;
        int maxOffset;
        int minOffset;
        int byteOffset;
        long endPosInFile = -1L;
        long searchDirectionL = searchDirection;
        int numBytes = fragment.getNumBytes();
        int n = byteOffset = searchDirection == 1 ? 0 : numBytes - 1;
        if (leftFrag && searchDirection == -1) {
            minOffset = fragment.getMinOffset();
            maxOffset = fragment.getMaxOffset();
        } else if (!leftFrag && searchDirection == 1) {
            minOffset = fragment.getMinOffset();
            maxOffset = fragment.getMaxOffset();
        } else if (fragPos < this.getNumFragmentPositions(leftFrag)) {
            SideFragment nextFragment = this.getFragment(leftFrag, fragPos + 1, 0);
            minOffset = nextFragment.getMinOffset();
            maxOffset = nextFragment.getMaxOffset();
        } else {
            minOffset = 0;
            maxOffset = 0;
        }
        if (searchDirection == -1) {
            startPosInFile = rightEndBytePos - (long)minOffset;
            long lastStartPosInFile1 = leftEndBytePos + (long)numBytes - 1L;
            lastStartPosInFile2 = rightEndBytePos - (long)maxOffset;
            lastStartPosInFile = lastStartPosInFile1 < lastStartPosInFile2 ? lastStartPosInFile2 : lastStartPosInFile1;
        } else {
            startPosInFile = leftEndBytePos + (long)minOffset;
            long lastStartPosInFile1 = rightEndBytePos - (long)numBytes + 1L;
            lastStartPosInFile2 = leftEndBytePos + (long)maxOffset;
            long l = lastStartPosInFile = lastStartPosInFile1 < lastStartPosInFile2 ? lastStartPosInFile1 : lastStartPosInFile2;
        }
        while (searchDirectionL * (lastStartPosInFile - startPosInFile) >= 0L) {
            try {
                if (fragment.matchesBytes(bytes, startPosInFile - (long)byteOffset)) {
                    endPosInFile = startPosInFile + (long)numBytes * searchDirectionL - searchDirectionL;
                    break;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            startPosInFile += searchDirectionL;
        }
        return endPosInFile;
    }

    private long[] bytePosForLeftFragments(WindowReader bytes, long leftBytePos, long rightBytePos, int searchDirection, int offsetRange, List<List<SideFragment>> fragments, OffsetAndFilePositions finalOffsetFoundPositions) {
        int posLoopStart;
        long startPos;
        boolean leftFrag = true;
        int numFragPos = fragments.size();
        if (searchDirection == 1) {
            startPos = leftBytePos;
            posLoopStart = numFragPos;
        } else {
            startPos = rightBytePos;
            posLoopStart = 1;
        }
        int totalNumOptions = offsetRange + 1;
        for (int iFragPos = 1; iFragPos <= numFragPos; ++iFragPos) {
            totalNumOptions *= this.getNumAlternativeFragments(iFragPos, fragments);
        }
        long[] markerPos = new long[totalNumOptions];
        for (int iOffset = 0; iOffset <= offsetRange; ++iOffset) {
            markerPos[iOffset] = startPos + (long)(iOffset * searchDirection);
        }
        int numOptions = 1 + offsetRange;
        boolean seqNotFound = false;
        Stack<FragmentHit> fragmentHits = null;
        if (this.useLeftFragmentBackTrack) {
            fragmentHits = new Stack<FragmentHit>();
        }
        boolean recheckingFinalFragmentOption = finalOffsetFoundPositions != null && finalOffsetFoundPositions.getFirstPositionInFile() != -1L;
        for (int iFragPos = posLoopStart; !seqNotFound && iFragPos <= numFragPos && iFragPos >= 1; iFragPos -= searchDirection) {
            int iOption;
            List<SideFragment> fragmentsAtPosition = fragments.get(iFragPos - 1);
            int numAltFrags = fragmentsAtPosition.size();
            long[] tempEndPos = new long[numAltFrags * numOptions];
            int numEndPos = 0;
            block3: for (iOption = 0; iOption < numOptions; ++iOption) {
                block4: for (int iAlt = 0; iAlt < numAltFrags; ++iAlt) {
                    long tempFragEnd;
                    SideFragment fragment = fragmentsAtPosition.get(iAlt);
                    long previousInstanceOffsetFoundPosition = finalOffsetFoundPositions == null || !recheckingFinalFragmentOption ? -1L : finalOffsetFoundPositions.getOffsetPosition(iAlt);
                    long previousInstanceFilePosition = -1L;
                    if (finalOffsetFoundPositions != null && recheckingFinalFragmentOption && previousInstanceOffsetFoundPosition != -1L) {
                        fragment = fragment.copy();
                        previousInstanceFilePosition = finalOffsetFoundPositions.getFilePosition(iAlt);
                        fragment.setMinOffset((int)Math.max((long)fragment.getMinOffset() - previousInstanceOffsetFoundPosition - (long)fragment.getNumBytes() - (previousInstanceFilePosition - rightBytePos) + 1L, 0L));
                        fragment.setMaxOffset((int)((long)fragment.getMaxOffset() - previousInstanceOffsetFoundPosition - (long)fragment.getNumBytes() - (previousInstanceFilePosition - rightBytePos) + 1L));
                        if (fragment.getMaxOffset() < 0) continue;
                    }
                    if ((tempFragEnd = searchDirection == 1 ? this.endBytePosForSeqFrag(bytes, markerPos[iOption], rightBytePos, true, searchDirection, iFragPos, fragment) : this.endBytePosForSeqFrag(bytes, leftBytePos, markerPos[iOption], true, searchDirection, iFragPos, fragment)) > -1L) {
                        tempEndPos[numEndPos] = tempFragEnd + (long)searchDirection;
                        ++numEndPos;
                        long offSetFound = markerPos[iOption] - tempFragEnd - (long)fragment.getNumBytes() + 1L;
                        if (fragmentHits != null && iFragPos < numFragPos && (this.orderedLeftFragsHaveVariableOffset[iFragPos] || this.orderedLeftFragsHaveVariableOffset[iFragPos - 1])) {
                            FragmentHit fragmentHit = new FragmentHit(iFragPos, iAlt, tempEndPos[numEndPos - 1], offSetFound);
                            fragmentHits.push(fragmentHit);
                        }
                        if (iFragPos != numFragPos || finalOffsetFoundPositions == null) continue;
                        finalOffsetFoundPositions.setPosition(iAlt, (int)offSetFound, tempFragEnd);
                        continue;
                    }
                    if (iAlt != numAltFrags - 1 || numEndPos != 0 || iOption != numOptions - 1) continue;
                    while (fragmentHits != null && !fragmentHits.empty()) {
                        FragmentHit lastGoodFragRef = (FragmentHit)fragmentHits.pop();
                        fragment = fragments.get(lastGoodFragRef.getFragmentSignaturePosition() - 1).get(lastGoodFragRef.getAlternativeFragmentNumber()).copy();
                        fragment.setMinOffset(Math.max(fragment.getMinOffset() - (int)lastGoodFragRef.getOffsetFound() - fragment.getNumBytes(), 0));
                        fragment.setMaxOffset(fragment.getMaxOffset() - (int)lastGoodFragRef.getOffsetFound() - fragment.getNumBytes());
                        if (fragment.getMaxOffset() < 0) continue block4;
                        tempFragEnd = searchDirection == 1 ? this.endBytePosForSeqFrag(bytes, lastGoodFragRef.getPositionInFile(), rightBytePos, true, searchDirection, lastGoodFragRef.getFragmentSignaturePosition(), fragment) : this.endBytePosForSeqFrag(bytes, leftBytePos, lastGoodFragRef.getPositionInFile(), true, searchDirection, lastGoodFragRef.getFragmentSignaturePosition(), fragment);
                        if (tempFragEnd <= -1L) continue;
                        tempEndPos[numEndPos] = tempFragEnd + (long)searchDirection;
                        iFragPos = lastGoodFragRef.getFragmentSignaturePosition();
                        iAlt = lastGoodFragRef.getAlternativeFragmentNumber();
                        long newOffSetFoundFromPreviousMatch = lastGoodFragRef.getPositionInFile() - tempFragEnd + lastGoodFragRef.getOffsetFound() + 1L;
                        FragmentHit fragmentHit = new FragmentHit(iFragPos, iAlt, tempEndPos[numEndPos], newOffSetFoundFromPreviousMatch);
                        fragmentHits.push(fragmentHit);
                        ++numEndPos;
                        continue block3;
                    }
                }
            }
            if (numEndPos == 0) {
                seqNotFound = true;
                continue;
            }
            numOptions = 0;
            for (iOption = 0; iOption < numEndPos; ++iOption) {
                boolean addEndPos = true;
                for (int iMarker = 0; iMarker < numOptions; ++iMarker) {
                    if (markerPos[iMarker] != tempEndPos[iOption]) continue;
                    addEndPos = false;
                    break;
                }
                if (!addEndPos) continue;
                markerPos[numOptions] = tempEndPos[iOption];
                ++numOptions;
            }
        }
        if (fragmentHits != null) {
            fragmentHits.clear();
        }
        if (seqNotFound) {
            return new long[0];
        }
        long[] outArray = new long[numOptions];
        if (searchDirection < 0) {
            for (int iOption = 0; iOption < numOptions; ++iOption) {
                markerPos[iOption] = -markerPos[iOption];
            }
        }
        Arrays.sort(markerPos, 0, numOptions);
        if (searchDirection < 0) {
            for (int iOption = 0; iOption < numOptions; ++iOption) {
                markerPos[iOption] = -markerPos[iOption];
            }
        }
        System.arraycopy(markerPos, 0, outArray, 0, numOptions);
        int iOption = 0;
        while (iOption < numOptions) {
            int n = iOption++;
            outArray[n] = outArray[n] - (long)searchDirection;
        }
        return outArray;
    }

    private boolean checkLeftFragmentForInvalidOffset(WindowReader windowReader, long leftBytePos, long rightBytePos, long maxOffset, long minOffset, List<List<SideFragment>> leftFragOpt, OffsetAndFilePositions lastOffsetFoundPositions) {
        long[] fragmentPositions;
        long currentRightBytePos = rightBytePos;
        do {
            if ((fragmentPositions = this.bytePosForLeftFragments(windowReader, leftBytePos, currentRightBytePos, -1, 0, leftFragOpt, lastOffsetFoundPositions)).length <= 0) continue;
            currentRightBytePos = fragmentPositions[0] - 1L;
        } while (fragmentPositions.length > 0 && fragmentPositions[fragmentPositions.length - 1] > maxOffset);
        return fragmentPositions.length == 0 || fragmentPositions[0] > maxOffset || fragmentPositions[0] < minOffset;
    }

    private boolean checkRightFragmentForInvalidOffset(WindowReader windowReader, long leftBytePos, long rightBytePos, long maxOffset, long minOffset, List<List<SideFragment>> rightFragOpt, OffsetAndFilePositions lastOffsetFoundPositions) {
        long[] fragmentPositions;
        long currentLeftBytePos = leftBytePos;
        do {
            if ((fragmentPositions = this.bytePosForRightFragments(windowReader, currentLeftBytePos, rightBytePos, 1, 0, rightFragOpt, lastOffsetFoundPositions)).length <= 0) continue;
            currentLeftBytePos = fragmentPositions[0] + 1L;
        } while (fragmentPositions.length > 0 && fragmentPositions[0] < rightBytePos - maxOffset);
        return fragmentPositions.length == 0 || fragmentPositions[0] < rightBytePos - maxOffset || fragmentPositions[0] > rightBytePos - minOffset;
    }

    private LeftFragment getRawLeftFragment(int theIndex) {
        return this.leftFragments.get(theIndex);
    }

    private RightFragment getRawRightFragment(int theIndex) {
        return this.rightFragments.get(theIndex);
    }

    private class OffsetAndFilePositions {
        private static final int NO_OFFSET_POSITION_FOUND = -1;
        private int[] offsetPositions;
        private long[] filePositions;

        public OffsetAndFilePositions(List<SideFragment> fragments) {
            this.offsetPositions = new int[fragments.size()];
            this.filePositions = new long[fragments.size()];
            for (int i = 0; i < fragments.size(); ++i) {
                this.offsetPositions[i] = -1;
                this.filePositions[i] = -1L;
            }
        }

        public void setPosition(int altPos, int offsetPos, long filePos) {
            this.offsetPositions[altPos] = offsetPos;
            this.filePositions[altPos] = filePos;
        }

        public long getOffsetPosition(int altPos) {
            return this.offsetPositions[altPos];
        }

        public long getFilePosition(int altPos) {
            return this.filePositions[altPos];
        }

        public long getFirstPositionInFile() {
            if (this.offsetPositions == null) {
                return -1L;
            }
            long temp = Long.MAX_VALUE;
            for (int i = 0; i < this.offsetPositions.length; ++i) {
                if ((long)this.offsetPositions[i] >= temp || this.offsetPositions[i] == -1) continue;
                temp = this.offsetPositions[i];
            }
            return temp == Long.MAX_VALUE ? -1L : temp;
        }
    }

    private class FragmentHit
    implements Comparable<FragmentHit> {
        private int fragmentSignaturePosition;
        private int alternativeFragmentNumber;
        private long positionInFile;
        private long offsetFound;

        public FragmentHit(int fragmentSignaturePosition, int alternativeFragmentNumber, long positionInFile, long offsetFound) {
            this.fragmentSignaturePosition = fragmentSignaturePosition;
            this.alternativeFragmentNumber = alternativeFragmentNumber;
            this.positionInFile = positionInFile;
            this.offsetFound = offsetFound;
        }

        public int getAlternativeFragmentNumber() {
            return this.alternativeFragmentNumber;
        }

        public int getFragmentSignaturePosition() {
            return this.fragmentSignaturePosition;
        }

        public long getPositionInFile() {
            return this.positionInFile;
        }

        public long getOffsetFound() {
            return this.offsetFound;
        }

        @Override
        public int compareTo(FragmentHit other) {
            int result = this.getPositionInFile() > other.getPositionInFile() ? 1 : (this.getPositionInFile() < other.getPositionInFile() ? -1 : 0);
            return result;
        }
    }
}

