/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.sail;

import java.io.File;
import org.apache.http.client.HttpClient;
import org.eclipse.rdf4j.http.client.HttpClientDependent;
import org.eclipse.rdf4j.http.client.HttpClientSessionManager;
import org.eclipse.rdf4j.http.client.SessionManagerDependent;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolver;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolverClient;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryLockedException;
import org.eclipse.rdf4j.repository.RepositoryResolver;
import org.eclipse.rdf4j.repository.RepositoryResolverClient;
import org.eclipse.rdf4j.repository.base.AbstractRepository;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.SailLockedException;
import org.eclipse.rdf4j.sail.StackableSail;

public class SailRepository
extends AbstractRepository
implements FederatedServiceResolverClient,
RepositoryResolverClient,
HttpClientDependent,
SessionManagerDependent {
    private final Sail sail;

    public SailRepository(Sail sail) {
        this.sail = sail;
    }

    public File getDataDir() {
        return this.sail.getDataDir();
    }

    public void setDataDir(File dataDir) {
        this.sail.setDataDir(dataDir);
    }

    public void setFederatedServiceResolver(FederatedServiceResolver resolver) {
        FederatedServiceResolverClient stack = this.findSailOf(this.sail, FederatedServiceResolverClient.class);
        if (stack != null) {
            stack.setFederatedServiceResolver(resolver);
        }
    }

    public void setRepositoryResolver(RepositoryResolver resolver) {
        RepositoryResolverClient stack = this.findSailOf(this.sail, RepositoryResolverClient.class);
        if (stack != null) {
            stack.setRepositoryResolver(resolver);
        }
    }

    public HttpClientSessionManager getHttpClientSessionManager() {
        SessionManagerDependent stack = this.findSailOf(this.sail, SessionManagerDependent.class);
        if (stack != null) {
            return stack.getHttpClientSessionManager();
        }
        return null;
    }

    public void setHttpClientSessionManager(HttpClientSessionManager client) {
        SessionManagerDependent stack = this.findSailOf(this.sail, SessionManagerDependent.class);
        if (stack != null) {
            stack.setHttpClientSessionManager(client);
        }
    }

    public HttpClient getHttpClient() {
        HttpClientDependent stack = this.findSailOf(this.sail, HttpClientDependent.class);
        if (stack != null) {
            return stack.getHttpClient();
        }
        return null;
    }

    public void setHttpClient(HttpClient client) {
        HttpClientDependent stack = this.findSailOf(this.sail, HttpClientDependent.class);
        if (stack != null) {
            stack.setHttpClient(client);
        }
    }

    protected void initializeInternal() throws RepositoryException {
        try {
            this.sail.initialize();
        }
        catch (SailLockedException e) {
            String l = e.getLockedBy();
            String r = e.getRequestedBy();
            String m = e.getMessage();
            throw new RepositoryLockedException(l, r, m, (Throwable)e);
        }
        catch (SailException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
    }

    protected void shutDownInternal() throws RepositoryException {
        try {
            this.sail.shutDown();
        }
        catch (SailException e) {
            throw new RepositoryException("Unable to shutdown Sail", (Throwable)e);
        }
    }

    public Sail getSail() {
        return this.sail;
    }

    public boolean isWritable() throws RepositoryException {
        try {
            return this.sail.isWritable();
        }
        catch (SailException e) {
            throw new RepositoryException("Unable to determine writable status of Sail", (Throwable)e);
        }
    }

    public ValueFactory getValueFactory() {
        return this.sail.getValueFactory();
    }

    public SailRepositoryConnection getConnection() throws RepositoryException {
        try {
            return new SailRepositoryConnection(this, this.sail.getConnection());
        }
        catch (SailException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public String toString() {
        return this.sail.toString();
    }

    private <T> T findSailOf(Sail sail, Class<T> type) {
        if (type.isInstance(sail)) {
            return type.cast(sail);
        }
        if (sail instanceof StackableSail) {
            return this.findSailOf(((StackableSail)sail).getBaseSail(), type);
        }
        return null;
    }
}

