/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.wave;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.WaveModule;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import java.io.DataInputStream;
import java.io.IOException;

public class ExifVersionChunk
extends Chunk {
    public ExifVersionChunk(ModuleBase moduleBase, ChunkHeader chunkHeader, DataInputStream dataInputStream) {
        super(moduleBase, chunkHeader, dataInputStream);
    }

    public boolean readChunk(RepInfo repInfo) throws IOException {
        WaveModule waveModule = (WaveModule)this._module;
        if (this.bytesLeft != 4L) {
            repInfo.setMessage((Message)new ErrorMessage("Incorrect length for Exif Version Chunk"));
            repInfo.setWellFormed(false);
            return false;
        }
        byte[] byArray = new byte[4];
        ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])byArray, (ModuleBase)waveModule);
        String string = new String(byArray);
        waveModule.getExifInfo().setExifVersion(string);
        return true;
    }
}

