/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.dc;

import ch.docuteam.darc.common.NodeAbstract;
import ch.docuteam.darc.dc.DC;
import ch.docuteam.darc.mets.dmdsec.DMDSectionAbstract;
import ch.docuteam.darc.mets.dmdsec.DMDSectionWithOAI_DC;
import ch.docuteam.tools.exception.Exception;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;

public class OAI_DC
extends NodeAbstract {
    private static final String OAI_DCNamespacePrefix = "OAI_DC";
    private static final String OAI_DCNamespaceURI = "http://www.openarchives.org/OAI/2.0/oai_dc/";
    private final List<DC> contributors = new ArrayList<DC>();
    private final List<DC> coverages = new ArrayList<DC>();
    private final List<DC> creators = new ArrayList<DC>();
    private final List<DC> dates = new ArrayList<DC>();
    private final List<DC> descriptions = new ArrayList<DC>();
    private final List<DC> formats = new ArrayList<DC>();
    private final List<DC> identifiers = new ArrayList<DC>();
    private final List<DC> languages = new ArrayList<DC>();
    private final List<DC> publishers = new ArrayList<DC>();
    private final List<DC> relations = new ArrayList<DC>();
    private final List<DC> rights = new ArrayList<DC>();
    private final List<DC> sources = new ArrayList<DC>();
    private final List<DC> subjects = new ArrayList<DC>();
    private final List<DC> titles = new ArrayList<DC>();
    private final List<DC> types = new ArrayList<DC>();

    private OAI_DC(DMDSectionAbstract parent, Element element) {
        this.document = parent.getDocument();
        this.parent = parent;
        List oaiDcs = element.selectNodes("./METS:mdWrap[@MDTYPE='" + DC.getNamespacePrefix() + "']/METS:xmlData/" + OAI_DCNamespacePrefix + ":dc");
        if (oaiDcs.size() == 0) {
            this.element = ((Element)element.selectSingleNode("./METS:mdWrap[@MDTYPE='" + DC.getNamespacePrefix() + "']/METS:xmlData")).addElement("OAI_DC:dc");
            this.document.getRootElement().addNamespace(OAI_DCNamespacePrefix, OAI_DCNamespaceURI);
            DC.parse(this, element, true);
        } else {
            if (oaiDcs.size() >= 2) {
                Exception.remember((String)("Bad number of OAI_DC Elements in the METS file. Expected: 0 or 1, found: " + oaiDcs.size()));
            }
            this.element = (Element)oaiDcs.get(0);
            DC.parse(this, element, false);
        }
    }

    private OAI_DC(DMDSectionWithOAI_DC parent, Document oaiDcDocument) {
        this.document = parent.getDocument();
        this.parent = parent;
        Element mdWrapElement = parent.getElement().addElement("METS:mdWrap").addAttribute("MDTYPE", "DC");
        this.element = mdWrapElement.addElement("METS:xmlData").addElement("OAI_DC:dc");
        parent.setOaiDc(this);
        DC.create(this, oaiDcDocument);
    }

    public static OAI_DC parse(DMDSectionWithOAI_DC parent, Element element) {
        if (element.selectNodes("./METS:mdWrap[@MDTYPE='" + DC.getNamespacePrefix() + "']//" + DC.getNamespacePrefix() + ":*").size() == 0) {
            return null;
        }
        return new OAI_DC((DMDSectionAbstract)parent, element);
    }

    public static OAI_DC create(ch.docuteam.darc.mets.Document metsDocument, Document oaiDcDocument) {
        String dcNamespacePrefixUsedInFile = oaiDcDocument.getRootElement().getNamespaceForURI("http://purl.org/dc/elements/1.1/").getPrefix();
        if (dcNamespacePrefixUsedInFile == null || dcNamespacePrefixUsedInFile.isEmpty()) {
            return null;
        }
        if (oaiDcDocument.selectNodes(".//" + dcNamespacePrefixUsedInFile + ":*").size() == 0) {
            return null;
        }
        DMDSectionWithOAI_DC dmdSection = new DMDSectionWithOAI_DC(metsDocument);
        return new OAI_DC(dmdSection, oaiDcDocument);
    }

    public List<DC> getContributors() {
        return this.contributors;
    }

    public List<DC> getCoverages() {
        return this.coverages;
    }

    public List<DC> getCreators() {
        return this.creators;
    }

    public List<DC> getDates() {
        return this.dates;
    }

    public List<DC> getDescriptions() {
        return this.descriptions;
    }

    public List<DC> getFormats() {
        return this.formats;
    }

    public List<DC> getIdentifiers() {
        return this.identifiers;
    }

    public List<DC> getLanguages() {
        return this.languages;
    }

    public List<DC> getPublishers() {
        return this.publishers;
    }

    public List<DC> getRelations() {
        return this.relations;
    }

    public List<DC> getRights() {
        return this.rights;
    }

    public List<DC> getSources() {
        return this.sources;
    }

    public List<DC> getSubjects() {
        return this.subjects;
    }

    public List<DC> getTitles() {
        return this.titles;
    }

    public List<DC> getTypes() {
        return this.types;
    }

    public String toString() {
        int maxLen = 2;
        return "[OAI_DC:identifiers=" + (this.identifiers != null ? this.identifiers.subList(0, Math.min(this.identifiers.size(), 2)) : null) + ", titles=" + (this.titles != null ? this.titles.subList(0, Math.min(this.titles.size(), 2)) : null) + "]";
    }
}

