/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.mdconfig;

import ch.docuteam.darc.exceptions.MetadataElementValidatorException;
import ch.docuteam.darc.mdconfig.MetadataElement;
import ch.docuteam.darc.mdconfig.MetadataElementValidator;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.tools.translations.I18N;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.regex.Pattern;

public class MetadataElementValidatorDateCH
implements MetadataElementValidator {
    private static final DateFormat[] StandardDateFormat = new DateFormat[]{new SimpleDateFormat("yyyy"), new SimpleDateFormat("M.yyyy"), new SimpleDateFormat("d.M.yyyy")};
    private static final Pattern[] StandardDatePattern = new Pattern[]{Pattern.compile("\\d{4}"), Pattern.compile("\\d{1,2}\\.\\d{4}"), Pattern.compile("\\d{1,2}\\.\\d{1,2}\\.\\d{4}")};

    @Override
    public void check(String value, NodeAbstract context, MetadataElement metadataElement) throws MetadataElementValidatorException {
        if (value == null || value.isEmpty()) {
            return;
        }
        if (value.equals(I18N.translate_NoCheck((String)"NoDate"))) {
            return;
        }
        for (int i = 0; i < StandardDatePattern.length; ++i) {
            if (!StandardDatePattern[i].matcher(value).matches()) continue;
            try {
                DateFormat df = StandardDateFormat[i];
                df.setLenient(false);
                df.parse(value);
                return;
            }
            catch (ParseException ex) {
                throw new MetadataElementValidatorException(I18N.translate_NoCheck((String)"MessageValidatorDateCHCantConvert", (Object[])new Object[]{value}));
            }
        }
        throw new MetadataElementValidatorException(I18N.translate_NoCheck((String)"MessageValidatorDateCHCantConvert", (Object[])new Object[]{value}));
    }
}

