/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.sa;

import ch.docuteam.darc.exceptions.InvalidSubmissionAgreement;
import ch.docuteam.darc.sa.SubmissionAgreementStatus;
import ch.docuteam.darc.sa.archive.Archive;
import ch.docuteam.darc.sa.dss.DataSubmissionSession;
import ch.docuteam.darc.sa.producer.Producer;
import ch.docuteam.tools.exception.ExceptionCollector;
import ch.docuteam.tools.exception.ExceptionCollectorException;
import ch.docuteam.tools.file.FileUtil;
import ch.docuteam.tools.file.ResourceUtil;
import ch.docuteam.tools.file.exception.FileIsNotADirectoryException;
import ch.docuteam.tools.file.exception.FileUtilExceptionListException;
import ch.docuteam.tools.os.SystemProcess;
import ch.docuteam.tools.os.SystemProcessCantLaunchApplicationException;
import ch.docuteam.tools.os.SystemProcessException;
import ch.docuteam.tools.out.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.Vector;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.dom4j.tree.DefaultDocument;

public class SubmissionAgreement
extends DefaultDocument {
    private static final long serialVersionUID = 1L;
    private static final String URLForHTMLReplacementString = "{saId}";
    private static final String URLForHTMLExtension = "/sites/{saId}/index.html";
    private static final String URLForUpdateExtension = "/contribXML/";
    private static final String SAFolderDefault = "agreements";
    private static final String SAFolderTemp = FileUtil.getTempFolder() + "/agreements";
    private static String BaseURL;
    private static String SAFolder;
    private String fileName;
    private String saId;
    private String title;
    private SubmissionAgreementStatus status;
    private List<Producer> producers;
    private Archive archive;
    private Map<String, DataSubmissionSession> dataSubmissionSessions;

    public static SubmissionAgreement read(String saFilePath) throws FileNotFoundException, DocumentException, ExceptionCollectorException {
        saFilePath = SubmissionAgreement.getSAFolder() + "/" + saFilePath;
        if (!new File(saFilePath).exists()) {
            throw new FileNotFoundException(saFilePath);
        }
        File saFile = new File(saFilePath);
        SAXReader reader = new SAXReader();
        reader.setDocumentFactory((DocumentFactory)new SubmissionAgreementFactory());
        SubmissionAgreement sa = (SubmissionAgreement)reader.read(saFile);
        ExceptionCollector.clear();
        sa.parse(saFilePath);
        if (!ExceptionCollector.isEmpty().booleanValue()) {
            throw new ExceptionCollectorException();
        }
        return sa;
    }

    public static String cloneSA(Path newSAFolderPath, String sourceSAName, Optional<String> iSilCodeOptional, Optional<String> dssIDOptional, Optional<String> dssTitleOptional) throws DocumentException, IOException, InvalidSubmissionAgreement {
        File saFile;
        if (!sourceSAName.toLowerCase().endsWith(".xml")) {
            sourceSAName = sourceSAName + ".xml";
        }
        if (!(saFile = new File(SubmissionAgreement.getSAFolder(), sourceSAName)).exists()) {
            throw new FileNotFoundException(sourceSAName);
        }
        String targetSAName = sourceSAName;
        if (iSilCodeOptional.isPresent()) {
            targetSAName = "sa_" + iSilCodeOptional.get() + ".xml";
        }
        Path cloneSAFilePath = newSAFolderPath.resolve(targetSAName);
        if (!saFile.toPath().equals(cloneSAFilePath)) {
            Files.copy(saFile.toPath(), cloneSAFilePath, StandardCopyOption.REPLACE_EXISTING);
            SAXReader reader = new SAXReader();
            reader.setDocumentFactory((DocumentFactory)new SubmissionAgreementFactory());
            SubmissionAgreement sa = (SubmissionAgreement)reader.read(cloneSAFilePath.toFile());
            sa.parse(saFile.toPath().toString());
            if (iSilCodeOptional.isPresent()) {
                Archive archive = sa.getArchive();
                archive.setIsil(iSilCodeOptional.get());
            }
            if (!sourceSAName.equals(targetSAName)) {
                String targetSaID = targetSAName.replaceFirst("\\.xml$", "");
                sa.setSaId(targetSaID);
            }
            if (dssIDOptional.isPresent() && dssTitleOptional.isPresent()) {
                sa.addDataSubmissionSession(sa, dssIDOptional.get(), dssTitleOptional.get());
            }
            SubmissionAgreement.save((Document)sa, cloneSAFilePath);
            return targetSAName;
        }
        return null;
    }

    public void delete() {
        File saFile;
        if (this.fileName != null && (saFile = new File(this.fileName)).exists()) {
            saFile.delete();
        }
    }

    private void addDataSubmissionSession(SubmissionAgreement sa, String id, String title) throws InvalidSubmissionAgreement {
        Map<String, DataSubmissionSession> dataSubmissionSessions = sa.getDataSubmissionSessions();
        Optional<DataSubmissionSession> optionalDss = dataSubmissionSessions.values().stream().filter(dss -> dss.getTitle().equals(title)).findFirst();
        if (!optionalDss.isPresent()) {
            DataSubmissionSession.cloneDataSubmissionSession(sa, id, title);
        }
    }

    private static void save(Document document, Path filePath) throws IOException {
        try (OutputStreamWriter oswriter = new OutputStreamWriter((OutputStream)new FileOutputStream(filePath.toFile()), "utf-8");){
            XMLWriter writer = new XMLWriter((Writer)oswriter);
            writer.write(document);
            writer.flush();
            writer.close();
        }
    }

    public static void initializeBaseURL(String baseURL) {
        BaseURL = baseURL;
    }

    public static String getBaseURL() {
        return BaseURL;
    }

    public static void setSAFolder(String newSAFolder) {
        Logger.debug((Object)("setSAFolder: " + SAFolder + " newSAFolder: " + newSAFolder));
        SAFolder = newSAFolder;
    }

    public static File getSAFolder() {
        if (!new File(SAFolder).exists()) {
            return ResourceUtil.getResource((String)SAFolder);
        }
        return new File(SAFolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> updateSAsFromServer() throws IOException, FileUtilExceptionListException {
        Object saName;
        int foundStart;
        if (BaseURL == null || BaseURL.isEmpty()) {
            throw new MalformedURLException("BaseURL for retrieving SAs from the server is not initialized");
        }
        URL saDirURL = new URL(BaseURL + URLForUpdateExtension);
        Logger.info((Object)("Updating SAs from URL: " + saDirURL));
        HttpURLConnection connection = null;
        InputStream inputStream = null;
        StringBuilder content = new StringBuilder(5000);
        try {
            int c;
            connection = (HttpURLConnection)saDirURL.openConnection();
            connection.connect();
            inputStream = (InputStream)connection.getContent();
            while ((c = inputStream.read()) != -1) {
                content.append((char)c);
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (connection != null) {
                    connection.disconnect();
                }
            }
            catch (IOException c) {}
        }
        Vector<ArrayList<String>> saNames = new Vector<ArrayList<String>>(20);
        int foundEnd = 0;
        while ((foundStart = content.indexOf("<li><a href=", foundEnd)) != -1 && (foundEnd = content.indexOf("/\"> ", foundStart)) != -1) {
            saName = content.substring(foundStart + 13, foundEnd).trim();
            if (!((String)saName).startsWith("/")) {
                saNames.add((ArrayList<String>)saName);
            }
            if (foundEnd != -1) continue;
        }
        File saFolderTemp = new File(SAFolderTemp);
        try {
            FileUtil.delete((File)saFolderTemp);
            saFolderTemp.mkdirs();
            for (String string : saNames) {
                String string2 = string + ".xml";
                Logger.debug((Object)("Downloading SA: " + string2));
                URL saURL = null;
                try {
                    saURL = new URL(saDirURL + string + "/" + string2);
                }
                catch (MalformedURLException ex) {
                    Logger.warn((Object)("Exception in URL <" + saURL + ">: " + ex));
                    continue;
                }
                File file = new File(SAFolderTemp + "/" + string2);
                FileOutputStream fileOutputStream = null;
                try {
                    int c;
                    fileOutputStream = new FileOutputStream(file);
                    connection = (HttpURLConnection)saURL.openConnection();
                    connection.connect();
                    inputStream = (InputStream)connection.getContent();
                    while ((c = inputStream.read()) != -1) {
                        fileOutputStream.write(c);
                    }
                }
                finally {
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (connection == null) continue;
                        connection.disconnect();
                    }
                    catch (IOException iOException) {}
                }
            }
            if (saFolderTemp.list().length == 0) {
                saName = new ArrayList<String>();
                return saName;
            }
            Vector<String> saNamesToBeDeleted = new Vector<String>(10);
            File file = SubmissionAgreement.getSAFolder();
            if (!file.exists()) {
                file.mkdirs();
            }
            for (String s : file.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".xml") || name.endsWith(".XML");
                }
            })) {
                if (new File(SAFolderTemp + "/" + s).exists()) continue;
                saNamesToBeDeleted.add(s);
            }
            for (File f : saFolderTemp.listFiles()) {
                Logger.debug((Object)("Copying/overwriting: " + f));
                FileUtil.copyToFolderOverwriting((File)f, (File)file);
            }
            Vector<String> vector = saNamesToBeDeleted;
            return vector;
        }
        finally {
            FileUtil.delete((File)saFolderTemp);
        }
    }

    public static List<Overview> getAllFinalOverviews() {
        Vector<Overview> saOverviewList = new Vector<Overview>(20);
        for (String fileName : SubmissionAgreement.getFilesFromSAFolder()) {
            if (!fileName.endsWith(".xml") && !fileName.endsWith(".XML") || fileName.startsWith(".") || fileName.startsWith("~")) continue;
            Logger.debug((Object)("Retrieving overviews for SA file: '" + fileName + "'"));
            try {
                SubmissionAgreement sa = SubmissionAgreement.read(fileName);
                if (sa.isFinal()) {
                    List<Overview> overviews = sa.getOverviews();
                    Logger.debug((Object)("Found " + overviews.size() + " overviews"));
                    saOverviewList.addAll(overviews);
                    continue;
                }
                Logger.debug((Object)("Skipping SA '" + fileName + "' because it is not final"));
            }
            catch (ExceptionCollectorException ex) {
                Logger.warn((Object)("Ignoring SA '" + fileName + "' because of parsing errors: " + ex.getMessage()));
            }
            catch (Exception ex) {
                Logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return saOverviewList;
    }

    private static String[] getFilesFromSAFolder() {
        File saFolder = SubmissionAgreement.getSAFolder();
        if (saFolder != null && saFolder.exists()) {
            return saFolder.list();
        }
        return new String[0];
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getSaId() {
        return this.saId;
    }

    public void setSaId(String saID) {
        this.saId = saID;
        Attribute attribute = this.getRootElement().attribute("saID");
        if (attribute != null) {
            this.getRootElement().remove(attribute);
        }
        this.getRootElement().addAttribute("saID", saID);
    }

    public String getTitle() {
        return this.title;
    }

    public SubmissionAgreementStatus getStatus() {
        return this.status;
    }

    public List<Producer> getProducers() {
        return this.producers;
    }

    public Archive getArchive() {
        return this.archive;
    }

    public Map<String, DataSubmissionSession> getDataSubmissionSessions() {
        return this.dataSubmissionSessions;
    }

    public DataSubmissionSession getDataSubmissionSession(String dssID) {
        if (!this.dataSubmissionSessions.containsKey(dssID)) {
            throw new IndexOutOfBoundsException("The Submission Agreement '" + this.saId + "' doesn't contain the Data Submission Session '" + dssID + "'");
        }
        return this.dataSubmissionSessions.get(dssID);
    }

    public List<Overview> getOverviews() {
        return Overview.createOverviews(this);
    }

    public boolean allowsFile(String dssId, String filePath) throws FileNotFoundException {
        return this.getDataSubmissionSession(dssId).allowsFile(filePath);
    }

    public boolean allowsFileType(String dssId, String filePath, String puid, String mimeType) {
        return this.getDataSubmissionSession(dssId).allowsFileType(filePath, puid, mimeType);
    }

    public boolean isFinal() {
        return SubmissionAgreementStatus.get("Final") == this.getStatus();
    }

    public void openAsHTMLExternally() throws MalformedURLException, IOException, InterruptedException, SystemProcessException, FileIsNotADirectoryException, URISyntaxException, SystemProcessCantLaunchApplicationException {
        if (BaseURL == null) {
            throw new MalformedURLException("BaseURL for retrieving SAs from the server is not initialized");
        }
        String actualURL = (BaseURL + URLForHTMLExtension).replace(URLForHTMLReplacementString, this.saId);
        Logger.debug((Object)("Opening Submission Agreement URL externally: " + actualURL));
        new URL(actualURL).getContent();
        SystemProcess.openExternally((String)actualURL);
    }

    private SubmissionAgreement parse(String saFilePath) {
        this.fileName = saFilePath;
        Element root = this.getRootElement();
        this.saId = root.attributeValue("saID");
        this.title = root.attributeValue("title");
        this.status = SubmissionAgreementStatus.get(root.attributeValue("status"));
        this.producers = Producer.parse(this, root);
        this.archive = Archive.parse(this, root);
        this.dataSubmissionSessions = DataSubmissionSession.parse(this, root);
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("\n====\tSubmissionAgreement on '").append(this.fileName).append("'\t====\n\t").append(this.saId).append("/").append(this.title).append("/").append((Object)this.status);
        for (Producer p : this.producers) {
            stringBuilder.append("\n\t\t").append(p);
        }
        stringBuilder.append("\n\t\t").append(this.archive);
        for (DataSubmissionSession d : this.dataSubmissionSessions.values()) {
            stringBuilder.append("\n\t\t").append(d);
        }
        return stringBuilder.toString();
    }

    static {
        SAFolder = SAFolderDefault;
    }

    private static class SubmissionAgreementFactory
    extends DocumentFactory {
        private static final long serialVersionUID = 1L;

        private SubmissionAgreementFactory() {
        }

        public Document createDocument() {
            TreeMap<String, String> namespaces = new TreeMap<String, String>();
            namespaces.put("SA", "http://www.docuteam.ch/xmlns/submAgr");
            this.setXPathNamespaceURIs(namespaces);
            SubmissionAgreement sa = new SubmissionAgreement();
            sa.setDocumentFactory(this);
            return sa;
        }
    }

    public static class Overview
    implements Comparable<Overview> {
        public String saId;
        public String title;
        public String fileName;
        public SubmissionAgreementStatus status;
        public String dssId;
        public String dssTitle;

        Overview(SubmissionAgreement sa, DataSubmissionSession dss) {
            this.saId = sa.saId;
            this.title = sa.title;
            this.fileName = sa.fileName;
            this.status = sa.status;
            this.dssId = dss.getDssID();
            this.dssTitle = dss.getTitle();
        }

        static List<Overview> createOverviews(SubmissionAgreement sa) {
            ArrayList<Overview> overviews = new ArrayList<Overview>(sa.dataSubmissionSessions.size());
            for (DataSubmissionSession dss : sa.dataSubmissionSessions.values()) {
                overviews.add(new Overview(sa, dss));
            }
            Collections.sort(overviews);
            return overviews;
        }

        public SubmissionAgreement getSubmissionAgreement() throws FileNotFoundException, DocumentException, ExceptionCollectorException {
            return SubmissionAgreement.read(this.saId + ".xml");
        }

        public String toString() {
            return this.title + "/" + this.dssTitle + "\t    (" + this.saId + "/" + this.dssId + ")";
        }

        private String compareString() {
            return this.title + this.dssTitle;
        }

        @Override
        public int compareTo(Overview o) {
            return this.compareString().compareTo(o.compareString());
        }
    }
}

