/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.util;

import ch.docuteam.tools.out.Logger;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;

public abstract class XML2PDF {
    public static File createPDF(String xml, String xslt) throws IOException {
        return XML2PDF.createPDF(new File(xml), new File(xslt));
    }

    public static File createPDF(File xml, File xslt) throws IOException {
        File pdf = new File(xml.getParent() + "/" + xml.getName().replace("xml", "pdf"));
        return XML2PDF.createPDF(xml, xslt, pdf);
    }

    public static File createPDF(String xml, String xslt, String pdf) throws IOException {
        return XML2PDF.createPDF(new File(xml), new File(xslt), new File(pdf));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File createPDF(File xml, File xslt, File pdf) throws IOException {
        Logger.info((Object)"Initializing transformation...");
        pdf.getParentFile().mkdirs();
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(pdf));
        Logger.info((Object)("Input: XML (" + xml + ")"));
        Logger.info((Object)("Stylesheet: " + xslt));
        Logger.info((Object)("Output: PDF (" + pdf + ")"));
        Logger.info((Object)"Transforming...");
        FopFactory fopFactory = FopFactory.newInstance();
        try {
            Fop fop = fopFactory.newFop("application/pdf", (OutputStream)out);
            TransformerFactoryImpl factory = new TransformerFactoryImpl();
            Transformer transformer = factory.newTransformer(new StreamSource(xslt));
            transformer.setParameter("versionParam", "2.0");
            StreamSource src = new StreamSource(xml);
            SAXResult res = new SAXResult(fop.getDefaultHandler());
            transformer.transform(src, res);
        }
        catch (FOPException e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
            File file = null;
            return file;
        }
        catch (TransformerConfigurationException e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
            File file = null;
            return file;
        }
        catch (TransformerException e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
            File file = null;
            return file;
        }
        finally {
            ((OutputStream)out).close();
        }
        return pdf;
    }
}

