/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.model.plugins;

import com.exlibris.core.infra.model.HFrEvent;
import com.exlibris.core.infra.model.plugins.HFrPluginInstance;
import com.exlibris.core.infra.model.plugins.HFrPluginType;
import com.exlibris.core.infra.model.plugins.PluginContactPerson;
import com.exlibris.core.infra.model.plugins.PluginImplType;
import com.exlibris.core.infra.model.plugins.PluginStatus;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class PluginMetadata {
    private static final Logger logger = Logger.getLogger(PluginMetadata.class);
    private String pluginTypeId;
    private String pluginId;
    private String pluginTypeName;
    private String pluginType;
    private String description;
    private String pluginInterface;
    private String materialType;
    private String resourceType;
    private String module;
    private String generalType;
    private String pluginImplType;
    private Boolean allowedPublicAPI;
    private String owner;
    private String pluginName;
    private double pluginVersion;
    private String contactPerson;
    private String configXml;
    private String parmsXml;
    private boolean systemImplemented;
    private String implName;
    private String status;
    private String submitedBy;
    private PluginContactPerson contactInfo;
    private String contactName;
    private List<HFrEvent> eventList;
    private String jarFilePath;
    private String jarFileName;
    private boolean inUse;
    private List<String> errorMsgs = new ArrayList<String>();
    List<HFrPluginInstance> implInstances;

    public List<HFrPluginInstance> getImplInstances() {
        return this.implInstances;
    }

    public void setImplInstances(List<HFrPluginInstance> implInstances) {
        this.implInstances = implInstances;
    }

    public PluginMetadata() {
    }

    public PluginMetadata(PluginMetadata meta) {
        this.pluginTypeId = meta.pluginTypeId;
        this.pluginId = meta.pluginId;
        this.pluginTypeName = meta.pluginTypeName;
        this.pluginType = meta.pluginType;
        this.description = meta.description;
        this.pluginInterface = meta.pluginInterface;
        this.materialType = meta.materialType;
        this.resourceType = meta.resourceType;
        this.module = meta.module;
        this.generalType = meta.generalType;
        this.pluginImplType = meta.pluginImplType;
        this.allowedPublicAPI = meta.allowedPublicAPI;
        this.owner = meta.owner;
        this.pluginName = meta.pluginName;
        this.pluginVersion = meta.pluginVersion;
        this.contactPerson = meta.contactPerson;
        this.configXml = meta.configXml;
        this.parmsXml = meta.parmsXml;
        this.systemImplemented = meta.systemImplemented;
        this.implName = meta.implName;
        this.status = meta.status;
        this.contactInfo = meta.contactInfo;
        this.contactName = meta.contactName;
        this.eventList = meta.eventList;
        this.jarFileName = meta.jarFileName;
        this.jarFilePath = meta.jarFilePath;
        this.inUse = meta.inUse;
        this.errorMsgs = meta.errorMsgs;
        this.implInstances = meta.implInstances;
    }

    public PluginMetadata reset() {
        this.setPluginTypeName(" ");
        this.setPluginName(" ");
        this.setImplName(" ");
        this.setPluginImplType(" ");
        this.setStatus(" ");
        this.setDescription(" ");
        this.setOwner(" ");
        this.setContactName(" ");
        this.setMaterialType(" ");
        this.setGeneralType(" ");
        return this;
    }

    public PluginMetadata(HFrPluginInstance instance) {
        if (instance != null) {
            if (instance.getPluginType() != null) {
                if (instance.getPluginType().getId() != null) {
                    this.setPluginTypeId(instance.getPluginType().getId().toString());
                }
                this.setPluginTypeName(instance.getPluginType().getPluginTypeName());
                if (instance.getPluginType().getMaterialType() != null) {
                    this.setMaterialType(instance.getPluginType().getMaterialType().name());
                }
                if (instance.getPluginType().getGeneralType() != null) {
                    this.setGeneralType(instance.getPluginType().getGeneralType().name());
                }
            }
            this.setPluginId(instance.getId().toString());
            if (instance.getPluginImplType() != null) {
                this.setPluginImplType(instance.getPluginImplType().name());
            }
            this.setPluginName(instance.getPluginName());
            this.setImplName(instance.getImplName());
            if (instance.getStatus() != null) {
                this.setStatus(instance.getStatus().name());
            }
            this.setDescription(instance.getDescription());
            this.setOwner(instance.getOwner());
            this.setContactName(instance.getContactName());
            this.setParmsXml(instance.getInitParmXml());
            this.setJarFileName(instance.getJarFileName());
            this.setPluginVersion(instance.getPluginVersion());
        }
    }

    public HFrPluginInstance setInstanceContent(HFrPluginInstance.DeploymentMode deploymentMode, HFrPluginType pluginType, boolean active) {
        HFrPluginInstance instance = new HFrPluginInstance();
        if (this.getPluginId() != null) {
            instance.setId(Long.valueOf(this.getPluginId()));
        }
        instance.setContactPerson(this.getContactPerson());
        instance.setDescription(this.getDescription());
        instance.setImplName(this.getImplName());
        if (this.getPluginImplType() != null) {
            instance.setPluginImplType(PluginImplType.valueOf(this.getPluginImplType().toUpperCase()));
        }
        instance.setIsPublicApi(this.getAllowedPublicAPI());
        instance.setCreator(this.getSubmitedBy());
        instance.setInitParmXml(this.getParmsXml());
        instance.setPluginType(pluginType);
        instance.setPluginName(this.getPluginName());
        instance.setPluginVersion(this.getPluginVersion());
        instance.setConfigXml(this.getConfigXml());
        instance.setApplication(pluginType.getApplication());
        instance.setStatus(active ? PluginStatus.ACTIVE : PluginStatus.INACTIVE);
        if (this.contactInfo != null) {
            instance.setContactLastName(this.contactInfo.getLastName());
            instance.setContactFirstName(this.contactInfo.getFirstName());
        }
        instance.setOwner(this.getOwner());
        instance.setJarFileName(this.getJarFileName());
        instance.setDeploymentMode(deploymentMode);
        return instance;
    }

    public HFrPluginInstance setInstanceContent(HFrPluginInstance.DeploymentMode deploymentMode, HFrPluginType pluginType, String user, String owner, boolean active) {
        this.setOwner(owner);
        this.setSubmitedBy(user);
        return this.setInstanceContent(deploymentMode, pluginType, active);
    }

    public String compareMetadatas(HFrPluginType pluginType) {
        String msg = null;
        if (this.getPluginTypeName() != null && this.getPluginTypeName().length() > 0 && pluginType.getPluginTypeName() == null) {
            msg = "Plugin type name are different -  Plugin Type is " + this.getPluginTypeName() + " but incoming is null!!";
            logger.info((Object)msg);
            return msg;
        }
        if (this.getPluginTypeName() == null && pluginType.getPluginTypeName() != null && pluginType.getPluginTypeName().length() > 0) {
            msg = "Plugin type name are different - Plugin Type is null and incoming is " + pluginType.getPluginTypeName();
            logger.info((Object)msg);
            return msg;
        }
        if (this.getPluginTypeName() != null && pluginType.getPluginTypeName() != null && this.getPluginTypeName().compareTo(pluginType.getPluginTypeName()) != 0) {
            msg = "Plugin type name are different - Plugin Type is " + pluginType.getPluginTypeName() + " and incoming is " + this.getPluginTypeName();
            logger.info((Object)msg);
            return msg;
        }
        if (this.getMaterialType() == null && pluginType.getMaterialType() != null) {
            msg = "Plugin material type are different -  incoming type " + pluginType.getMaterialType().name() + " and Plugin Type is null!!";
            logger.info((Object)msg);
            return msg;
        }
        if (this.getMaterialType() != null && this.getMaterialType().length() > 0 && pluginType.getMaterialType() == null) {
            msg = "Plugin material type are different -  incoming is null and Plugin Type is " + this.getMaterialType();
            logger.info((Object)msg);
            return msg;
        }
        if (this.getMaterialType() != null && pluginType.getMaterialType() != null && this.getMaterialType().compareTo(pluginType.getMaterialType().name()) != 0) {
            msg = "Plugin material type are different - incoming is " + pluginType.getMaterialType().name() + " and Plugin Type is " + this.getMaterialType();
            logger.info((Object)msg);
            return msg;
        }
        if (this.getModule() != null && this.getModule().length() > 0 && pluginType.getModule() == null) {
            msg = "Plugin modules are different - Plugin Type is " + this.getModule() + " and incoming is null!!";
            logger.info((Object)msg);
            return msg;
        }
        if (this.getModule() == null && pluginType.getModule() != null && pluginType.getModule().length() > 0) {
            msg = "Plugin modules are different - Plugin Type is null and incoming is " + pluginType.getModule();
            logger.info((Object)msg);
            return msg;
        }
        if (this.getModule() != null && pluginType.getModule() != null && this.getModule().compareTo(pluginType.getModule()) != 0) {
            msg = "Plugin modules are different - Plugin Type is " + this.getModule() + " and  incoming is " + pluginType.getModule();
            logger.info((Object)msg);
            return msg;
        }
        if (this.getResourceType() == null && pluginType.getResourceType() != null && pluginType.getResourceType().length() > 0) {
            msg = "Plugin resource type are different - incoming is " + pluginType.getResourceType() + " and Plugin Type is null!!";
            logger.info((Object)msg);
            return msg;
        }
        if (this.getResourceType() != null && this.getResourceType().length() > 0 && pluginType.getResourceType() == null) {
            msg = "Plugin resource type are different - incoming is null and Plugin Type is " + this.getResourceType();
            logger.info((Object)msg);
            return msg;
        }
        if (this.getResourceType() != null && pluginType.getResourceType() != null && this.getResourceType().compareTo(pluginType.getResourceType()) != 0) {
            msg = "Plugin resource type are different -  incoming is " + pluginType.getResourceType() + " and Plugin Type is " + this.getResourceType();
            logger.info((Object)msg);
            return msg;
        }
        if (this.getGeneralType() == null && pluginType.getGeneralType() != null) {
            msg = "Plugin general type are different - " + pluginType.getGeneralType().name() + " and null!!";
            logger.info((Object)msg);
            return msg;
        }
        if (this.getGeneralType() != null && this.getGeneralType().length() > 0 && pluginType.getGeneralType() == null) {
            msg = "Plugin general type are different - Plugin Type is null and incoming is " + this.getGeneralType();
            logger.info((Object)msg);
            return msg;
        }
        if (this.getGeneralType() != null && pluginType.getGeneralType() != null && this.getGeneralType().compareTo(pluginType.getGeneralType().name()) != 0) {
            msg = "Plugin general type are different - incoming is " + pluginType.getGeneralType().name() + " and  Plugin Type is " + this.getGeneralType();
            logger.info((Object)msg);
            return msg;
        }
        if (this.getAllowedPublicAPI() != null && pluginType.getAllowedPublicAPI() == null) {
            msg = "Plugin allowed public api are different - Plugin Type is " + this.getAllowedPublicAPI() + " and incoming is null!!";
            logger.info((Object)msg);
            return msg;
        }
        if (this.getAllowedPublicAPI() == null && pluginType.getAllowedPublicAPI() != null) {
            msg = "Plugin allowed public api are different - Plugin Type is null and  incoming is " + pluginType.getAllowedPublicAPI();
            logger.info((Object)msg);
            return msg;
        }
        if (this.getAllowedPublicAPI() != null && pluginType.getAllowedPublicAPI() != null && pluginType.getAllowedPublicAPI().compareTo(this.getAllowedPublicAPI()) != 0) {
            msg = "Plugin allowed public api are different - Plugin Type is " + this.getAllowedPublicAPI() + " and incoming is " + pluginType.getAllowedPublicAPI();
            logger.info((Object)msg);
            return msg;
        }
        return null;
    }

    public String getContactPerson() {
        return this.contactPerson;
    }

    public void setContactPerson(String contactPerson) {
        this.contactPerson = contactPerson;
    }

    public String getPluginTypeName() {
        return this.pluginTypeName;
    }

    public void setPluginTypeName(String pluginTypeName) {
        this.pluginTypeName = pluginTypeName;
    }

    public String getPluginType() {
        return this.pluginType;
    }

    public void setPluginType(String pluginType) {
        this.pluginType = pluginType;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getPluginInterface() {
        return this.pluginInterface;
    }

    public void setPluginInterface(String pluginInterface) {
        this.pluginInterface = pluginInterface;
    }

    public String getMaterialType() {
        return this.materialType;
    }

    public void setMaterialType(String materialType) {
        this.materialType = materialType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public String getGeneralType() {
        return this.generalType;
    }

    public void setGeneralType(String generalType) {
        this.generalType = generalType;
    }

    public Boolean getAllowedPublicAPI() {
        return this.allowedPublicAPI;
    }

    public void setAllowedPublicAPI(Boolean allowedPublicAPI) {
        this.allowedPublicAPI = allowedPublicAPI;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getImplName() {
        return this.implName;
    }

    public void setImplName(String implName) {
        this.implName = implName;
    }

    public double getPluginVersion() {
        return this.pluginVersion;
    }

    public void setPluginVersion(double pluginVersion) {
        this.pluginVersion = pluginVersion;
    }

    public boolean isSystemImplemented() {
        return this.systemImplemented;
    }

    public void setSystemImplemented(boolean systemImplemented) {
        this.systemImplemented = systemImplemented;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    public PluginContactPerson getContactInfo() {
        return this.contactInfo;
    }

    public void setContactInfo(PluginContactPerson contactInfo) {
        this.contactInfo = contactInfo;
    }

    public String getContactName() {
        return this.contactName;
    }

    public void setContactName(String contactName) {
        this.contactName = contactName;
    }

    public void setContactName(PluginContactPerson contact) {
        this.contactName = contact.getLastName() + " " + contact.getFirstName();
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public List<HFrEvent> getEventList() {
        return this.eventList;
    }

    public void setEventList(List<HFrEvent> eventList) {
        this.eventList = eventList;
    }

    public String getPluginImplType() {
        return this.pluginImplType;
    }

    public void setPluginImplType(String pluginImplType) {
        this.pluginImplType = pluginImplType;
    }

    public List<String> getErrorMsgs() {
        return this.errorMsgs;
    }

    public void setErrorMsgs(List<String> errorMsgs) {
        this.errorMsgs = errorMsgs;
    }

    public void setErrorMsg(String errorMsg) {
        if (this.errorMsgs == null) {
            this.errorMsgs = new ArrayList<String>();
        }
        this.errorMsgs.add(errorMsg);
    }

    public boolean isInUse() {
        return this.inUse;
    }

    public void setInUse(boolean inUse) {
        this.inUse = inUse;
    }

    public String getJarFilePath() {
        return this.jarFilePath;
    }

    public void setJarFilePath(String jarFilePath) {
        this.jarFilePath = jarFilePath;
    }

    public String getJarFileName() {
        return this.jarFileName;
    }

    public void setJarFileName(String jarFileName) {
        this.jarFileName = jarFileName;
    }

    public String getPluginTypeId() {
        return this.pluginTypeId;
    }

    public void setPluginTypeId(String pluginTypeId) {
        this.pluginTypeId = pluginTypeId;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public void setPluginId(String pluginId) {
        this.pluginId = pluginId;
    }

    public String getSubmitedBy() {
        return this.submitedBy;
    }

    public void setSubmitedBy(String submitedBy) {
        this.submitedBy = submitedBy;
    }

    public String getConfigXml() {
        return this.configXml;
    }

    public void setConfigXml(String configXml) {
        this.configXml = configXml;
    }

    public String getParmsXml() {
        return this.parmsXml;
    }

    public void setParmsXml(String parmsXml) {
        this.parmsXml = parmsXml;
    }
}

