/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.tools;

import com.exlibris.core.infra.common.dao.ejb3.BoundedVariable;
import com.exlibris.core.infra.common.exceptions.InfraException;
import com.exlibris.core.infra.common.exceptions.logging.DescriptorConstants;
import com.exlibris.core.infra.common.normalizers.NormalizerUtil;
import com.exlibris.core.infra.common.util.StringUtils;
import com.exlibris.core.infra.model.codetables.HCodeTables;
import com.exlibris.core.infra.svc.api.tools.WhereClauser;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class WhereClauserUtil {
    private static final String INDEX_XML = "indexXml";

    public static String getSQLQuery(String tableName, String tableAlias, List<WhereClauser> whereClausers, List<WhereClauser> mandatoryWhereClausers, String orderBy, boolean asc, List<BoundedVariable> boundedVariables) throws InfraException {
        boolean orderByCodeTable = false;
        String codeTableName = null;
        String code = null;
        if (orderBy.contains(".")) {
            orderByCodeTable = true;
            String[] orderByParams = WhereClauserUtil.getCodeTableAttributes(orderBy);
            codeTableName = orderByParams[0] + "." + orderByParams[1];
            code = orderByParams[1];
        }
        StringBuffer queryString = new StringBuffer();
        String fromTable = tableAlias;
        String selectPart = WhereClauserUtil.getSelectPart(fromTable);
        String fromPart = WhereClauserUtil.getFromPart(tableName, fromTable, orderByCodeTable);
        String wherePart = WhereClauserUtil.getWherePart(whereClausers, fromTable, INDEX_XML, mandatoryWhereClausers, orderByCodeTable, codeTableName, code, boundedVariables);
        String orderByPart = WhereClauserUtil.getOrderByPart(orderBy, asc, fromTable, orderByCodeTable);
        queryString.append(selectPart).append(fromPart).append(wherePart).append(orderByPart);
        return queryString.toString();
    }

    private static String[] getCodeTableAttributes(String orderBy) {
        if (StringUtils.isEmptyString(orderBy)) {
            return null;
        }
        String[] orderByArray = orderBy.split(",");
        if (orderByArray != null) {
            int orderByArraySize = orderByArray.length;
            for (int i = 0; i < orderByArraySize; ++i) {
                String[] orderByOodeTable = orderByArray[i].split("\\.");
                if (StringUtils.isEmptyString(orderByOodeTable[0]) || !orderByOodeTable[0].equals("CodeTable")) continue;
                return new String[]{orderByOodeTable[1], orderByOodeTable[2]};
            }
        }
        return null;
    }

    public static String getSelectPart(String fromTable) {
        String selectPart = "select " + fromTable + " ";
        return selectPart;
    }

    public static String getFromPart(String tableName, String fromTable, boolean orderByCodeTable) {
        String fromPart = "from " + tableName + " " + fromTable + " ";
        if (orderByCodeTable) {
            fromPart = fromPart + ", " + HCodeTables.class.getName() + " ct ";
        }
        return fromPart;
    }

    public static String getOrderByPart(String orderBy, boolean asc, String fromTable, boolean orderByCodeTable) {
        String orderByPart = null;
        if (orderByCodeTable) {
            orderBy = "ct.description";
            orderByPart = " order by ";
        } else {
            orderByPart = " order by " + fromTable + ".";
        }
        String ascStr = asc ? "asc" : "desc";
        orderByPart = StringUtils.isEmptyString(orderBy) || orderBy.equals("sortBy") ? orderByPart + "modificationDate desc " : orderByPart + orderBy + " " + ascStr;
        if (!orderBy.trim().equalsIgnoreCase("modificationDate")) {
            orderByPart = orderByPart + " ," + fromTable + "." + "modificationDate desc";
        }
        orderByPart = orderByPart + " ," + fromTable + "." + "id asc";
        return orderByPart;
    }

    public static String getWherePart(List<WhereClauser> whereClausers, String fromTable, String indexXmlFieldName, List<WhereClauser> mandatoryWhereClausers, boolean orderByCodeTable, String codeTableName, String code, List<BoundedVariable> boundedVariables) throws InfraException {
        boolean thereAreMandatories;
        StringBuffer wherePart = new StringBuffer("where ");
        boolean thereAreWhereClausers = whereClausers != null && whereClausers.size() > 0;
        boolean bl = thereAreMandatories = mandatoryWhereClausers != null && mandatoryWhereClausers.size() > 0;
        if (!thereAreWhereClausers && !thereAreMandatories) {
            if (orderByCodeTable) {
                wherePart.append(" ct.codeTableName = '").append(codeTableName).append("'");
                wherePart.append(" and ct.code = ").append(code);
                return wherePart.toString();
            }
            return "";
        }
        if (thereAreWhereClausers && (thereAreMandatories || orderByCodeTable)) {
            wherePart.append("(");
        }
        int currentConditionNumber = WhereClauserUtil.parseWhereClausers(whereClausers, fromTable, indexXmlFieldName, wherePart, 0, boundedVariables);
        if (thereAreWhereClausers && (thereAreMandatories || orderByCodeTable)) {
            wherePart.append(") ");
        }
        WhereClauserUtil.parseWhereClausers(mandatoryWhereClausers, fromTable, indexXmlFieldName, wherePart, currentConditionNumber, boundedVariables);
        if (orderByCodeTable) {
            wherePart.append(" and ct.codeTableName = '").append(codeTableName).append("'");
            wherePart.append(" and ct.code = ").append(code);
        }
        return wherePart.toString();
    }

    private static int parseWhereClausers(List<WhereClauser> whereClausers, String fromTable, String indexXmlFieldName, StringBuffer wherePart, int currentConditionNumber, List<BoundedVariable> boundedVariables) throws InfraException {
        if (whereClausers != null) {
            boolean inXml = false;
            String fieldName = "";
            String compareType = "";
            String compareValue = "";
            WhereClauser.LogicalOperator operator = WhereClauser.LogicalOperator.AND;
            for (WhereClauser whereClauser : whereClausers) {
                fieldName = whereClauser.getFieldName();
                compareType = WhereClauserUtil.convertXType(whereClauser.getCompareType());
                compareValue = whereClauser.getCompareValue();
                operator = whereClauser.getLogicalOperator();
                if (WhereClauserUtil.isIndexXmlCondition(whereClauser)) {
                    compareValue = WhereClauserUtil.normalize(compareValue, whereClauser.getNormalizingProfile());
                    WhereClauserUtil.validate(compareValue);
                    compareValue = WhereClauserUtil.convertCompareValue(compareValue, whereClauser.getCompareType());
                    if (!inXml) {
                        inXml = WhereClauserUtil.openXmlClause(wherePart, currentConditionNumber == 0 ? null : operator, fromTable, indexXmlFieldName);
                        WhereClauserUtil.conditionXmlClause(wherePart, fieldName, compareType, compareValue);
                        if (operator.equals((Object)WhereClauser.LogicalOperator.OR) || operator.equals((Object)WhereClauser.LogicalOperator.NOT)) {
                            inXml = WhereClauserUtil.closeXmlClause(wherePart);
                        }
                    } else if (operator.equals((Object)WhereClauser.LogicalOperator.AND)) {
                        wherePart.append(" ").append((Object)operator).append(" ");
                        WhereClauserUtil.conditionXmlClause(wherePart, fieldName, compareType, compareValue);
                    } else if (operator.equals((Object)WhereClauser.LogicalOperator.OR) || operator.equals((Object)WhereClauser.LogicalOperator.NOT)) {
                        inXml = WhereClauserUtil.closeXmlClause(wherePart);
                        inXml = WhereClauserUtil.openXmlClause(wherePart, operator, fromTable, indexXmlFieldName);
                        WhereClauserUtil.conditionXmlClause(wherePart, fieldName, compareType, compareValue);
                        inXml = WhereClauserUtil.closeXmlClause(wherePart);
                    }
                } else {
                    if (inXml) {
                        WhereClauserUtil.closeXmlClause(wherePart);
                    }
                    if (currentConditionNumber != 0) {
                        wherePart.append(" ").append((Object)operator).append(" ");
                    }
                    if (StringUtils.isEmptyString(compareValue)) {
                        throw new InfraException(DescriptorConstants.RP_NothingToSearchFor);
                    }
                    if (WhereClauser.XType.EQUAL.equals((Object)whereClauser.getCompareType())) {
                        compareType = "=";
                    }
                    if ("Date".equals(whereClauser.getSearchType())) {
                        String[] split = compareValue.split("-");
                        int year = Integer.parseInt(split[0]);
                        int month = Integer.parseInt(split[1]);
                        int day = Integer.parseInt(split[2]);
                        if (WhereClauser.XType.AFTER.equals((Object)whereClauser.getCompareType()) || WhereClauser.XType.BEFORE.equals((Object)whereClauser.getCompareType())) {
                            Calendar calendar = Calendar.getInstance();
                            calendar.set(year, month - 1, day, 0, 0, 0);
                            Date date = new Date(calendar.getTimeInMillis());
                            boundedVariables.add(new BoundedVariable(date, date.getClass()));
                            wherePart.append(" ").append(fromTable).append(".").append(fieldName).append(" ").append(compareType).append(" ").append("?").append(boundedVariables.size()).append(" ");
                        } else {
                            String dayString = day < 10 ? "0" + day : "" + day;
                            String monthString = month < 10 ? "0" + month : "" + month;
                            wherePart.append(" to_char(").append(fromTable).append(".").append(fieldName).append(",'DD/MM/YYYY') ").append(compareType).append(" ").append("'").append(dayString).append("/").append(monthString).append("/").append(year).append("'").append(" ");
                        }
                    } else {
                        wherePart.append(" ").append(fromTable).append(".").append(fieldName).append(" ").append(compareType).append(" ").append("'").append(compareValue).append("'").append(" ");
                    }
                    inXml = false;
                }
                ++currentConditionNumber;
            }
            if (inXml) {
                WhereClauserUtil.closeXmlClause(wherePart);
            }
        }
        return currentConditionNumber;
    }

    private static void validate(String compareValue) throws InfraException {
        if (StringUtils.isEmptyString(compareValue)) {
            throw new InfraException(DescriptorConstants.RP_NothingToSearchFor);
        }
        if (WhereClauserUtil.isSearchTextNotValid(compareValue)) {
            throw new InfraException(DescriptorConstants.RP_NotSupportedWildcardSearch);
        }
    }

    private static boolean isIndexXmlCondition(WhereClauser whereClauser) {
        return !"Date".equals(whereClauser.getSearchType()) && !"Lookup".equals(whereClauser.getSearchType());
    }

    private static String normalize(String compareValue, String normalizingProfile) {
        compareValue = !normalizingProfile.equals("generic") ? NormalizerUtil.normalizeWithProfileName(normalizingProfile, compareValue) : NormalizerUtil.normalizeWithProfileName("search", compareValue);
        return compareValue;
    }

    private static void conditionXmlClause(StringBuffer wherePart, String fieldName, String compareType, String compareValue) {
        wherePart.append(" ").append(compareValue).append(" ");
        if (!fieldName.equalsIgnoreCase("all")) {
            wherePart.append(compareType).append(" ").append(fieldName).append(" ");
        }
    }

    private static boolean closeXmlClause(StringBuffer wherePart) {
        wherePart.append("')>0 ");
        return false;
    }

    private static boolean openXmlClause(StringBuffer wherePart, WhereClauser.LogicalOperator operator, String fromTable, String indexXmlFieldName) {
        if (operator != null) {
            wherePart.append(" ");
            if (operator.equals((Object)WhereClauser.LogicalOperator.NOT)) {
                wherePart.append(WhereClauser.LogicalOperator.AND.toString()).append(" ");
            }
            wherePart.append((Object)operator).append(" ");
        }
        wherePart.append(" contains(").append(fromTable).append(".").append(indexXmlFieldName).append(",'");
        return true;
    }

    private static String convertXType(WhereClauser.XType type) {
        if (WhereClauser.XType.OUTER_EQUAL.equals((Object)type)) {
            return "=";
        }
        if (WhereClauser.XType.NOT_EQUAL.equals((Object)type)) {
            return "<>";
        }
        if (WhereClauser.XType.IS_NOT_EMPTY.equals((Object)type)) {
            return "IS_NOT_EMPTY";
        }
        if (WhereClauser.XType.IS_EMPTY.equals((Object)type)) {
            return "IS_EMPTY";
        }
        if (WhereClauser.XType.CONTAIN.equals((Object)type)) {
            return "WITHIN";
        }
        if (WhereClauser.XType.END_WITH.equals((Object)type)) {
            return "WITHIN";
        }
        if (WhereClauser.XType.EQUAL.equals((Object)type)) {
            return "WITHIN";
        }
        if (WhereClauser.XType.PATTERN.equals((Object)type)) {
            return "WITHIN";
        }
        if (WhereClauser.XType.START_WITH.equals((Object)type)) {
            return "WITHIN";
        }
        if (WhereClauser.XType.BEFORE.equals((Object)type)) {
            return "<";
        }
        if (WhereClauser.XType.AFTER.equals((Object)type)) {
            return ">";
        }
        return "ERROR";
    }

    private static String convertCompareValue(String value, WhereClauser.XType type) {
        if (WhereClauser.XType.EQUAL.equals((Object)type)) {
            return "(" + value + ")";
        }
        if (WhereClauser.XType.CONTAIN.equals((Object)type)) {
            return WhereClauserUtil.parseContainValue(value);
        }
        if (WhereClauser.XType.START_WITH.equals((Object)type)) {
            return value + "%";
        }
        if (WhereClauser.XType.END_WITH.equals((Object)type)) {
            return "%" + value;
        }
        return value;
    }

    private static String parseContainValue(String value) {
        if (StringUtils.isEmptyString(value)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder("(");
        String[] splitValues = value.split(" ");
        stringBuilder.append(splitValues[0]);
        for (int i = 1; i < splitValues.length; ++i) {
            stringBuilder.append(" and ");
            stringBuilder.append(splitValues[i]);
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private static boolean isSearchTextNotValid(String searchText) {
        return false;
    }
}

