/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.repository.persistence.sip;

import com.exlibris.repository.persistence.HPersistent;
import java.util.Calendar;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import org.hibernate.validator.Length;

@Entity
@Table(name="SIP_NOTES")
@NamedQueries(value={@NamedQuery(name="findBySipId", query="select note from HsSipNote note where note.sipId = :sipId"), @NamedQuery(name="findByPidAndType", query="select note from HsSipNote note where note.sipId = :sipId and note.pid = :pid and note.type = :type"), @NamedQuery(name="findLastOnlySipNoteByType", query="select note from HsSipNote note where note.sipId = :sipId and note.pid is null and note.type = :type order by updateDate desc"), @NamedQuery(name="findBySipIdAndNonInternal", query="select note from HsSipNote note where note.sipId = :sipId and note.type != 'INTERNAL' order by update_date")})
@NamedNativeQueries(value={@NamedNativeQuery(name="findBySipIdForDeposit", query="select * from SIP_NOTES where sip_id = :sipId and (type = 'DEPOSIT' or type = 'REJECT_DECLINE' or type = 'ACTION_REASON') order by update_date", resultClass=HsSipNote.class)})
public class HsSipNote
extends HPersistent {
    private static final long serialVersionUID = 1L;
    private Long sipId;
    private String pid;
    private SipNoteType type;
    private String note;
    private String updatedBy;
    private Calendar updateDate;

    @Column(name="SIP_ID", nullable=false)
    public Long getSipId() {
        return this.sipId;
    }

    public void setSipId(Long sipId) {
        this.sipId = sipId;
    }

    @Column(name="PID")
    public String getPid() {
        return this.pid;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    @Column(name="TYPE", nullable=false)
    @Enumerated(value=EnumType.STRING)
    public SipNoteType getType() {
        return this.type;
    }

    public void setType(SipNoteType type) {
        this.type = type;
    }

    @Column(name="NOTE", nullable=false)
    @Length(max=2048)
    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    @Column(name="UPDATED_BY")
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    @Column(name="UPDATE_DATE")
    public Calendar getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Calendar updateDate) {
        this.updateDate = updateDate;
    }

    public static enum SipNoteType {
        INTERNAL,
        CURATORIAL,
        TECHNICAL,
        REJECT_DECLINE,
        DEPOSIT,
        ACTION_REASON,
        EMAIL;

    }
}

