/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.container.httpservice;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.configuration.event.ConfigurationEvent;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.util.DateParseException;
import org.apache.commons.httpclient.util.DateUtil;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.gov.nationalarchives.droid.core.interfaces.config.DroidGlobalConfig;
import uk.gov.nationalarchives.droid.core.interfaces.config.DroidGlobalProperty;
import uk.gov.nationalarchives.droid.core.interfaces.signature.ProxySettings;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureFileInfo;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureServiceException;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureType;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureUpdateService;

public class ContainerSignatureHttpService
implements SignatureUpdateService {
    private static final String DATE_PATTERN = "yyyyMMdd";
    private static final String LAST_MODIFIED_HEADER = "Last-Modified";
    private static final String FILENAME_PATTERN = "container-signature-%s.xml";
    private static final String ERROR_MESSAGE_PATTERN = "The web server could not serve the signature file from the address\n[%s]\nThe server gave the response [%s]";
    private static final String COULD_NOT_FIND_SERVER = "Could not contact the signature web server at\n%s";
    private static final String FILE_NOT_FOUND_404 = "The signature file was not found on the signature webserver at\n[%s]";
    private final Log log = LogFactory.getLog(this.getClass());
    private String endpointUrl;
    private HttpClient client = new HttpClient();

    public SignatureFileInfo getLatestVersion(int currentVersion) throws SignatureServiceException {
        GetMethod get = new GetMethod(this.endpointUrl);
        try {
            SignatureFileInfo signatureFileInfo;
            Date versionDate = ContainerSignatureHttpService.getDateFromVersion(currentVersion);
            String dateString = DateUtil.formatDate((Date)versionDate);
            get.addRequestHeader("If-Modified-Since", dateString);
            int statusCode = this.client.executeMethod((HttpMethod)get);
            if (statusCode == 404) {
                throw new SignatureServiceException(String.format(FILE_NOT_FOUND_404, this.endpointUrl));
            }
            if (statusCode != 200 && statusCode != 304) {
                throw new SignatureServiceException(String.format(ERROR_MESSAGE_PATTERN, this.endpointUrl, statusCode));
            }
            int version = ContainerSignatureHttpService.getVersion((HttpMethod)get);
            SignatureFileInfo signatureFileInfo2 = signatureFileInfo = new SignatureFileInfo(version, false, SignatureType.CONTAINER);
            return signatureFileInfo2;
        }
        catch (UnknownHostException e) {
            throw new SignatureServiceException(String.format(COULD_NOT_FIND_SERVER, this.endpointUrl));
        }
        catch (IOException e) {
            throw new SignatureServiceException((Throwable)e);
        }
        catch (DateParseException e) {
            throw new SignatureServiceException((Throwable)e);
        }
        catch (ParseException e) {
            throw new SignatureServiceException((Throwable)e);
        }
        finally {
            get.releaseConnection();
        }
    }

    private static int getVersion(HttpMethod httpMethod) throws DateParseException {
        int version = 0;
        Header header = httpMethod.getResponseHeader(LAST_MODIFIED_HEADER);
        if (header != null) {
            String lastModified = header.getValue();
            Date lastModifiedDate = DateUtil.parseDate((String)lastModified);
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_PATTERN);
            version = Integer.parseInt(sdf.format(lastModifiedDate));
        }
        return version;
    }

    private static Date getDateFromVersion(int versionNumber) throws ParseException {
        String versionString = Integer.toString(versionNumber);
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_PATTERN);
        return sdf.parse(versionString);
    }

    public SignatureFileInfo importSignatureFile(File targetDir) throws SignatureServiceException {
        GetMethod get = new GetMethod(this.endpointUrl);
        OutputStreamWriter writer = null;
        try {
            int statusCode = this.client.executeMethod((HttpMethod)get);
            if (statusCode == 404) {
                throw new SignatureServiceException(String.format(FILE_NOT_FOUND_404, this.endpointUrl));
            }
            if (statusCode != 200 && statusCode != 304) {
                throw new SignatureServiceException(String.format(ERROR_MESSAGE_PATTERN, this.endpointUrl, statusCode));
            }
            int version = ContainerSignatureHttpService.getVersion((HttpMethod)get);
            SignatureFileInfo signatureFileInfo = new SignatureFileInfo(version, false, SignatureType.CONTAINER);
            String fileName = String.format(FILENAME_PATTERN, version);
            File targetFile = new File(targetDir, fileName);
            writer = new FileWriter(targetFile);
            IOUtils.copy((InputStream)get.getResponseBodyAsStream(), (Writer)writer);
            signatureFileInfo.setFile(targetFile);
            SignatureFileInfo signatureFileInfo2 = signatureFileInfo;
            return signatureFileInfo2;
        }
        catch (UnknownHostException e) {
            throw new SignatureServiceException(String.format(COULD_NOT_FIND_SERVER, this.endpointUrl));
        }
        catch (IOException e) {
            throw new SignatureServiceException((Throwable)e);
        }
        catch (DateParseException e) {
            throw new SignatureServiceException((Throwable)e);
        }
        finally {
            get.releaseConnection();
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                this.log.error((Object)"Error closing file writer", (Throwable)e);
            }
        }
    }

    void setEndpointUrl(String url) {
        this.endpointUrl = url;
    }

    public void configurationChanged(ConfigurationEvent evt) {
        String propertyName = evt.getPropertyName();
        if (propertyName.equals(DroidGlobalProperty.CONTAINER_UPDATE_URL.getName())) {
            this.setEndpointUrl((String)evt.getPropertyValue());
        }
    }

    public void onProxyChange(ProxySettings proxySettings) {
        if (proxySettings.isEnabled()) {
            this.client = new HttpClient();
            this.client.getHostConfiguration().setProxy(proxySettings.getProxyHost(), proxySettings.getProxyPort());
        } else {
            this.client = new HttpClient();
        }
    }

    public void init(DroidGlobalConfig config) {
        this.setEndpointUrl(config.getProperties().getString(DroidGlobalProperty.CONTAINER_UPDATE_URL.getName()));
    }
}

