/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.model;

import com.exlibris.core.infra.model.FormInt;
import com.exlibris.core.infra.model.HDpFormField;
import com.exlibris.core.infra.model.HDpFormSection;
import com.exlibris.core.infra.model.HOwneredEntity;
import com.exlibris.core.infra.model.annotation.Searchable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.AttributeOverride;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Index;

@Entity
@NamedQueries(value={@NamedQuery(name="findFormByPrivacyLevel", query="from HDpForm where privacyLevel = :level and owner = :owner"), @NamedQuery(name="FIND_FORM_WITH_NULL_INDEX", query="select r from HDpForm r where r.indexXml is NULL")})
@AttributeOverride(column=@Column(name="id"), name="id")
public class HDpForm
extends HOwneredEntity
implements FormInt {
    private static final long serialVersionUID = 1L;
    public static final String PAGE_BEAN_PREFIX = "pageBean.";
    private Long id;
    private static long nextLong = -1000L;
    private String institution = "";
    private String formName = "";
    private String description = "";
    private String formType = "";
    private String mandatories = null;
    private int gridX = 1;
    private Status status;
    private MdFormType mdFormat;
    private Long producerId;
    private PrivacyLevel privacyLevel;
    private String formPrivacyLevelType;
    private String indexXml;
    @Transient
    private String version;
    @Transient
    private String fieldsetLegend;
    private List<HDpFormField> formFields = new ArrayList<HDpFormField>();
    private List<HDpFormSection> formSections = new ArrayList<HDpFormSection>();
    private List<String> formErrors = new ArrayList<String>();
    private List<HDpFormField> formAndSectionfields;

    @Override
    @Transient
    public List<String> getErrors() {
        return this.formErrors;
    }

    public void setFormErrors(List<String> formErrors) {
        this.formErrors = formErrors;
    }

    @Transient
    public List<HDpFormSection> getFormSections() {
        return this.formSections;
    }

    public void setFormSections(List<HDpFormSection> formSections) {
        this.formSections = formSections;
    }

    @Transient
    public String getFormPrivacyLevelType() {
        return this.privacyLevel.toString();
    }

    public void setFormPrivacyLevelType(String s) {
        this.privacyLevel = PrivacyLevel.valueOf(s);
        this.formPrivacyLevelType = s;
    }

    public void setPrivacyLevelStr(String s) {
        this.privacyLevel = PrivacyLevel.valueOf(s);
    }

    @Transient
    public String getPrivacyLevelStr() {
        return this.privacyLevel.toString();
    }

    @Override
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long long1) {
        this.id = long1;
    }

    public void addField(HDpFormField f) {
        if (!this.formFields.contains(f)) {
            this.formFields.add(f);
        }
    }

    public void addSection(HDpFormSection f) {
        if (!this.formSections.contains(f)) {
            this.formSections.add(f);
        }
    }

    @Enumerated
    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    @Searchable
    @Column(length=4000)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Searchable
    public String getFormType() {
        return this.formType;
    }

    public void setFormType(String formType) {
        this.formType = formType;
    }

    @Searchable
    public String getMandatories() {
        return this.mandatories;
    }

    public void setMandatories(String mandatories) {
        this.mandatories = mandatories;
    }

    @Searchable
    public int getGridX() {
        return this.gridX;
    }

    public void setGridX(int gridX) {
        this.gridX = gridX;
    }

    @Enumerated
    @Searchable
    @Index(name="HDPFORM_MDFORMAT")
    public MdFormType getMdFormat() {
        return this.mdFormat;
    }

    public void setMdFormat(MdFormType mdFormat) {
        this.mdFormat = mdFormat;
    }

    @Searchable
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    public Object cloneObject() {
        HDpForm f = new HDpForm();
        f.setStatus(this.getStatus());
        f.setOwner(this.getOwner());
        f.setFormType(this.getFormType());
        f.setPrivacyLevel(this.getPrivacyLevel());
        f.setMandatories(this.getMandatories());
        f.setDescription(this.getDescription());
        f.setFormName(this.getFormName());
        f.setGridX(this.getGridX());
        f.setMdFormat(this.getMdFormat());
        List<HDpFormField> fl = this.getFormFields();
        for (HDpFormField field : fl) {
            HDpFormField clonedField = (HDpFormField)field.cloneObject();
            long id = this.nextLong();
            clonedField.setId(id);
            clonedField.setIdStr(Long.toString(id));
            f.addField(clonedField);
        }
        return f;
    }

    private long nextLong() {
        return --nextLong;
    }

    @Searchable
    public Long getProducerId() {
        return this.producerId;
    }

    public void setProducerId(Long sourceId) {
        this.producerId = sourceId;
    }

    @Searchable
    public PrivacyLevel getPrivacyLevel() {
        return this.privacyLevel;
    }

    public void setPrivacyLevel(PrivacyLevel privacyLevel) {
        this.privacyLevel = privacyLevel;
    }

    @OneToMany(fetch=FetchType.LAZY)
    @JoinColumn(name="form_id")
    @Cascade(value={CascadeType.ALL})
    @OrderBy(value="orderInList")
    public List<HDpFormField> getFormFields() {
        return this.formFields;
    }

    public void setFormFields(List<HDpFormField> formFields) {
        this.formFields = formFields;
    }

    public String getInstitution() {
        return this.institution;
    }

    public void setInstitution(String institution) {
        this.institution = institution;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof HDpForm) {
            HDpForm mdForm = (HDpForm)o;
            if (this.getId() == null || mdForm.getId() == null) {
                return false;
            }
            return this.getId().equals(mdForm.getId());
        }
        return false;
    }

    @Column(name="index_xml")
    @Lob
    public String getIndexXml() {
        return this.indexXml;
    }

    public void setIndexXml(String indexXml) {
        this.indexXml = indexXml;
    }

    @Override
    @Transient
    public List<HDpFormField> getAllFields() {
        if (this.formAndSectionfields == null) {
            this.formAndSectionfields = new ArrayList<HDpFormField>();
            this.formAndSectionfields.addAll(this.formFields);
            if (this.formSections != null) {
                for (HDpFormSection section : this.formSections) {
                    if (section == null || section.getFields() == null) continue;
                    this.formAndSectionfields.addAll(section.getFields());
                }
            }
        }
        return this.formAndSectionfields;
    }

    @Override
    @Transient
    public String getValue(String propertyName) {
        String value = null;
        List<HDpFormField> fields = this.getAllFields();
        for (HDpFormField dpFormField : fields) {
            String fieldName = dpFormField.getFieldName();
            if (fieldName == null || !fieldName.equals(propertyName) && !fieldName.equals(PAGE_BEAN_PREFIX + propertyName)) continue;
            value = dpFormField.getDefaultValue();
            break;
        }
        return value;
    }

    @Transient
    public String getVersion() {
        return this.version;
    }

    @Transient
    public void setVersion(String version) {
        this.version = version;
    }

    @Transient
    public String getFieldsetLegend() {
        return this.fieldsetLegend;
    }

    public void setFieldsetLegend(String fieldsetLegend) {
        this.fieldsetLegend = fieldsetLegend;
    }

    public void setDynamicValues(Map<String, String> fieldsValues) {
        if (fieldsValues == null) {
            return;
        }
        for (HDpFormField field : this.getFormFields()) {
            if (!fieldsValues.containsKey(field.getFieldName())) continue;
            field.setFieldValue(fieldsValues.get(field.getFieldName()));
        }
    }

    @Transient
    public HDpFormField getFormField(String fieldName) {
        if (this.getFormFields() == null || fieldName == null) {
            return null;
        }
        for (HDpFormField dpFormField : this.getFormFields()) {
            if (!dpFormField.getFieldName().equalsIgnoreCase(fieldName)) continue;
            return dpFormField;
        }
        return null;
    }

    public static enum Status {
        ACTIVE,
        INACTIVE,
        DELETED;

    }

    public static enum PrivacyLevel {
        GENERIC,
        PERSONALIZED;

    }

    public static enum MdFormType {
        DUBLIN_CORE,
        GENERAL;

    }
}

