/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.pdf.PdfDictionary;
import edu.harvard.hul.ois.jhove.module.pdf.PdfSimpleObject;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.InflaterInputStream;

public class PdfFlateInputStream
extends FilterInputStream {
    private InflaterInputStream iis;
    private PdfDictionary decodeParms;
    private int predictor;
    private int columns;
    private int bpc;
    private int colors;
    private int colBytes;
    private int rowLen;
    private byte[] rowBuf;
    private byte[] rowBuf2;
    private int rowBufOff;
    private boolean eof;
    private int iisBufOff;
    private byte[] iisBuf;
    private static final int IISBUF_SIZE = 4096;
    private int iisBufLen;
    private boolean iisEof;

    public PdfFlateInputStream(InputStream inputStream) {
        this(inputStream, null);
    }

    public PdfFlateInputStream(InputStream inputStream, PdfDictionary pdfDictionary) {
        super(inputStream);
        this.iis = new InflaterInputStream(inputStream);
        this.predictor = 1;
        this.columns = 1;
        this.bpc = 8;
        this.colors = 1;
        this.decodeParms = pdfDictionary;
        this.iisBuf = new byte[4096];
        this.iisBufLen = 0;
        this.iisBufOff = 0;
        this.iisEof = false;
        this.eof = false;
        if (pdfDictionary != null) {
            PdfSimpleObject pdfSimpleObject;
            try {
                pdfSimpleObject = (PdfSimpleObject)pdfDictionary.get("Predictor");
                if (pdfSimpleObject != null) {
                    this.predictor = pdfSimpleObject.getIntValue();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                pdfSimpleObject = (PdfSimpleObject)pdfDictionary.get("Columns");
                if (pdfSimpleObject != null) {
                    this.columns = pdfSimpleObject.getIntValue();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                pdfSimpleObject = (PdfSimpleObject)pdfDictionary.get("BitsPerComponent");
                if (pdfSimpleObject != null) {
                    this.bpc = pdfSimpleObject.getIntValue();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.predictor != 1) {
            this.colBytes = (this.colors * this.bpc + 7) / 8;
            this.rowLen = (this.columns * this.colors * this.bpc + 7) / 8 + this.colBytes;
            this.rowBuf = new byte[this.rowLen];
            this.rowBuf2 = new byte[this.rowLen];
            this.rowBufOff = this.rowLen;
        }
    }

    public int read() throws IOException {
        if (this.eof) {
            return -1;
        }
        if (this.predictor == 1) {
            return this.iis.read();
        }
        if (this.rowBufOff == this.rowLen) {
            this.readRow();
            if (this.eof) {
                return -1;
            }
        }
        return this.rowBuf[this.rowBufOff++] & 0xFF;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.eof) {
            return -1;
        }
        if (this.predictor == 1) {
            return this.iis.read(byArray, n, n2);
        }
        if (this.rowBufOff == this.rowLen) {
            this.readRow();
            if (this.eof) {
                return -1;
            }
        }
        if (n2 > this.rowLen - this.rowBufOff) {
            n2 = this.rowLen - this.rowBufOff;
        }
        for (int i = 0; i < n2; ++i) {
            byArray[n + i] = this.rowBuf[this.rowBufOff++];
        }
        return n2;
    }

    private int processBytes() {
        int n = 0;
        return n;
    }

    private void readRow() throws IOException {
        int n;
        byte[] byArray = this.rowBuf;
        this.rowBuf = this.rowBuf2;
        this.rowBuf2 = byArray;
        this.rowBufOff = this.colBytes;
        if (this.predictor >= 10) {
            this.readIISByte();
        }
        for (int i = this.colBytes; i < this.rowLen; i += n) {
            n = this.readIISBytes(this.rowBuf, i, this.rowLen - i);
            if (n > 0) {
                continue;
            }
            this.eof = true;
            return;
        }
        switch (this.predictor) {
            case 1: 
            case 10: {
                break;
            }
            case 2: 
            case 11: {
                for (n = this.colBytes; n < this.rowLen; ++n) {
                    int n2 = n;
                    this.rowBuf[n2] = (byte)(this.rowBuf[n2] + this.rowBuf[n - this.colBytes]);
                }
                break;
            }
            case 12: {
                for (n = this.colBytes; n < this.rowLen; ++n) {
                    int n3 = n;
                    this.rowBuf[n3] = (byte)(this.rowBuf[n3] + this.rowBuf2[n]);
                }
                break;
            }
            case 13: {
                for (n = this.colBytes; n < this.rowLen; ++n) {
                    int n4 = n;
                    this.rowBuf[n4] = (byte)(this.rowBuf[n4] + ((this.rowBuf[n - this.colBytes] & 0xFF) + (this.rowBuf2[n] & 0xFF)) / 2);
                }
                break;
            }
            case 14: {
                n = 0 + this.colBytes;
                while (n < this.rowLen) {
                    int n5 = this.rowBuf[n - this.colBytes] & 0xFF;
                    int n6 = this.rowBuf2[n] & 0xFF;
                    int n7 = this.rowBuf2[n - this.colBytes] & 0xFF;
                    int n8 = n5 + n6 - n7;
                    int n9 = Math.abs(n8 - n5);
                    int n10 = Math.abs(n8 - n6);
                    int n11 = Math.abs(n8 - n7);
                    int n12 = n9 <= n10 && n9 <= n11 ? n5 : (n10 <= n11 ? n6 : n7);
                    int n13 = n++;
                    this.rowBuf[n13] = (byte)(this.rowBuf[n13] + (byte)n12);
                }
                break;
            }
        }
    }

    private int readIISByte() throws IOException {
        if (this.iisBufOff >= this.iisBufLen && !this.iisEof) {
            this.readIIS();
        }
        if (this.iisEof) {
            return -1;
        }
        return this.iisBuf[this.iisBufOff++] & 0xFF;
    }

    private int readIISBytes(byte[] byArray, int n, int n2) throws IOException {
        if (this.iisBufOff >= this.iisBufLen && !this.iisEof) {
            this.readIIS();
        }
        if (this.iisEof) {
            return -1;
        }
        if (this.iisBufLen - this.iisBufOff < n2) {
            n2 = this.iisBufLen - this.iisBufOff;
        }
        for (int i = n; i < n + n2; ++i) {
            byArray[i] = this.iisBuf[this.iisBufOff++];
        }
        return n2;
    }

    private int readIIS() throws IOException {
        if (this.iisEof) {
            return -1;
        }
        int n = this.iis.read(this.iisBuf);
        this.iisBufOff = 0;
        this.iisBufLen = n;
        if (n <= 0) {
            this.iisEof = true;
        }
        return n;
    }
}

