/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.config;

import com.exlibris.core.sdk.utils.FSUtil;
import com.exlibris.core.sdk.utils.FileUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class SetSessionTimeout {
    static String mngEar;
    static String[] modulesInAll;
    static String[] modulesInStaff;
    static String[] modules;

    public static void main(String[] args) {
        mngEar = FSUtil.getDeployDir() + "digitool-mng.ear" + File.separator;
        if (args == null || args.length < 1) {
            SetSessionTimeout.usage();
            return;
        }
        String module = args[0];
        if ("report".equals(module)) {
            SetSessionTimeout.getCurrentSettings();
            return;
        }
        Integer newTimeout = Integer.valueOf(args[1]);
        if (newTimeout <= 0) {
            newTimeout = Integer.valueOf("60");
        }
        if (module.equalsIgnoreCase("ALL")) {
            for (int i = 0; i < modulesInAll.length; ++i) {
                String mod = modulesInAll[i];
                SetSessionTimeout.setModuleSessionTimeout(mod, newTimeout.toString());
            }
        } else if (module.equalsIgnoreCase("STAFF")) {
            for (int i = 0; i < modulesInAll.length; ++i) {
                String mod = modulesInStaff[i];
                SetSessionTimeout.setModuleSessionTimeout(mod, newTimeout.toString());
            }
        } else {
            SetSessionTimeout.setModuleSessionTimeout(module, newTimeout.toString());
        }
    }

    private static void getCurrentSettings() {
        System.out.println("Current settings:");
        for (int i = 0; i < modules.length; ++i) {
            String mod = modules[i];
            SetSessionTimeout.getCurrentSettings(mod);
        }
    }

    private static void getCurrentSettings(String module) {
        File moduleWebXml = new File(mngEar + "digitool-" + module + ".war" + File.separator + "WEB-INF" + File.separator + "web.xml");
        if (!moduleWebXml.exists()) {
            System.out.println(moduleWebXml.getAbsolutePath() + " not exists");
            return;
        }
        String fileStr = FileUtil.getContents(moduleWebXml);
        int timeoutIndex = fileStr.indexOf("<session-timeout>");
        int timeoutIndex2 = fileStr.indexOf("</session-timeout>");
        if (timeoutIndex > -1) {
            System.out.println(module + " - set at " + fileStr.substring(timeoutIndex + 17, timeoutIndex2));
            return;
        }
        System.out.println(module + " - not set");
    }

    private static void setModuleSessionTimeout(String module, String newTimeout) {
        File moduleWebXml = new File(mngEar + "digitool-" + module + ".war" + File.separator + "WEB-INF" + File.separator + "web.xml");
        if (!moduleWebXml.exists()) {
            System.out.println(moduleWebXml.getAbsolutePath() + " not exists");
            return;
        }
        String fileStr = FileUtil.getContents(moduleWebXml);
        if (fileStr.indexOf("<session-timeout>") == -1) {
            System.out.println("could not find - <session-timeout> in " + moduleWebXml.getAbsolutePath());
            System.out.println("SessionTimeout is not configured for module " + module);
            return;
        }
        String newXml = fileStr;
        newXml = fileStr.replaceAll("<session-timeout>[^<]*</session-timeout>", "<session-timeout>" + newTimeout + "</session-timeout>");
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(moduleWebXml));
            out.write(newXml);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("SessionTimeout is set to " + newTimeout + " for module " + module);
    }

    private static void usage() {
        System.out.println("usage:");
        System.out.println("SetSessionTimeout report - to see current settings");
        System.out.println("SetSessionTimeout <module_name/STAFF/ALL> <timeout>");
        System.out.println("e.g. set SessionTimeout for mng module - SetSessionTimeout mng 60");
        System.out.println("Available modules : ");
        System.out.println("(included in - ALL) ");
        for (int i = 0; i < modulesInAll.length; ++i) {
            String mn = modulesInAll[i];
            System.out.println(mn);
        }
    }

    static {
        modulesInAll = new String[]{"approver", "collection", "deposit", "j2k", "metsviewer", "mng", "view", "webclient", "webingest"};
        modulesInStaff = new String[]{"approver", "collection", "mng", "webingest"};
        modules = new String[]{"approver", "collection", "deposit", "j2k", "metsviewer", "mng", "view", "webclient", "webingest"};
    }
}

