/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.config;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.gov.nationalarchives.droid.core.interfaces.config.DroidGlobalProperty;

public class DroidGlobalConfig {
    public static final String DROID_PROPERTIES = "droid.properties";
    private static final String DEFAULT_DROID_PROPERTIES = "default_droid.properties";
    private static final String DROID_SIGNATURE_FILE = "DROID_SignatureFile_V91.xml";
    private static final String CONTAINER_SIGNATURE_FILE = "container-signature-20170330.xml";
    private static final String TEXT_SIGNATURE_FILE = "text-signature-20101101.xml";
    private static final String DATABASE_DURABILITY = "database.durability";
    private static final String AVAILABLE_HASH_ALGORITHMS = "availableHashAlgorithms";
    private static final String TEMPLATE_SCHEMA_VERSION = "schema 6.04";
    private static final List<String> NON_CONFIGURABLE_PROPERTIES = Arrays.asList("availableHashAlgorithms");
    private final Log log = LogFactory.getLog(this.getClass());
    private File droidWorkDir;
    private File signatureFilesDir;
    private File profileTemplateDir;
    private File containerSignatureDir;
    private File textSignatureFileDir;
    private File reportDefinitionDir;
    private File filterDir;
    private PropertiesConfiguration props;
    private PropertiesConfiguration defaultProps;
    private File profilesDir;
    private File tempDir;

    public DroidGlobalConfig() throws IOException {
        String droidHomePath = System.getProperty("droidUserDir");
        this.droidWorkDir = new File(droidHomePath);
        this.droidWorkDir.mkdirs();
        this.signatureFilesDir = new File(this.droidWorkDir, "signature_files");
        this.signatureFilesDir.mkdir();
        this.createResourceFile(this.signatureFilesDir, DROID_SIGNATURE_FILE, DROID_SIGNATURE_FILE);
        this.containerSignatureDir = new File(this.droidWorkDir, "container_sigs");
        this.containerSignatureDir.mkdir();
        this.createResourceFile(this.containerSignatureDir, CONTAINER_SIGNATURE_FILE, CONTAINER_SIGNATURE_FILE);
        this.reportDefinitionDir = new File(this.droidWorkDir, "report_definitions");
        this.reportDefinitionDir.mkdir();
        this.filterDir = new File(this.droidWorkDir, "filter_definitions");
        this.filterDir.mkdir();
        this.profileTemplateDir = new File(this.droidWorkDir, "profile_templates");
        this.profileTemplateDir.mkdir();
        this.profileTemplateDir = new File(this.profileTemplateDir, TEMPLATE_SCHEMA_VERSION);
        this.profileTemplateDir.mkdir();
        String droidTempPath = System.getProperty("droidTempDir");
        this.profilesDir = new File(droidTempPath, "profiles");
        this.profilesDir.mkdirs();
        this.tempDir = new File(droidTempPath, "tmp");
        this.tempDir.mkdirs();
    }

    public void init() throws ConfigurationException {
        boolean durability;
        File droidProperties = new File(this.droidWorkDir, DROID_PROPERTIES);
        this.props = new PropertiesConfiguration(droidProperties);
        URL defaultPropsUrl = this.getClass().getClassLoader().getResource(DEFAULT_DROID_PROPERTIES);
        this.defaultProps = new PropertiesConfiguration(defaultPropsUrl);
        boolean saveProperties = false;
        Iterator it = this.defaultProps.getKeys();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (this.props.containsKey(key)) continue;
            this.props.addProperty(key, this.defaultProps.getProperty(key));
            saveProperties = true;
        }
        if (saveProperties) {
            this.props.save();
        }
        if (this.props.containsKey(DATABASE_DURABILITY) && !(durability = this.props.getBoolean(DATABASE_DURABILITY))) {
            System.setProperty("derby.system.durability", "test");
        }
    }

    public File getDroidWorkDir() {
        return this.droidWorkDir;
    }

    public Properties getProfileProperties() {
        Properties profileProperties = new Properties();
        Configuration profilePropsConfig = this.props.subset("profile");
        Iterator it = profilePropsConfig.getKeys();
        while (it.hasNext()) {
            String key = (String)it.next();
            profileProperties.setProperty(key, profilePropsConfig.getProperty(key).toString());
        }
        return profileProperties;
    }

    public PropertiesConfiguration getProperties() {
        return this.props;
    }

    public PropertiesConfiguration getDefaultProperties() {
        return this.defaultProps;
    }

    public void update(Map<String, Object> properties) throws ConfigurationException {
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            if (NON_CONFIGURABLE_PROPERTIES.contains(entry.getKey())) continue;
            this.props.setProperty(entry.getKey(), entry.getValue());
        }
        this.props.save();
    }

    public Map<String, Object> getPropertiesMap() {
        HashMap<String, Object> allSettings = new HashMap<String, Object>();
        Iterator it = this.props.getKeys();
        while (it.hasNext()) {
            String key = (String)it.next();
            DroidGlobalProperty property = DroidGlobalProperty.forName(key);
            if (property == null) continue;
            allSettings.put(key, property.getType().getTypeSafeValue((Configuration)this.props, key));
        }
        ArrayList<String> availableHashAlgorithms = new ArrayList<String>();
        availableHashAlgorithms.add("md5");
        availableHashAlgorithms.add("sha1");
        availableHashAlgorithms.add("sha256");
        allSettings.put(AVAILABLE_HASH_ALGORITHMS, availableHashAlgorithms);
        return allSettings;
    }

    public File getSignatureFileDir() {
        return this.signatureFilesDir;
    }

    public File getProfileTemplateDir() {
        return this.profileTemplateDir;
    }

    public File getContainerSignatureDir() {
        return this.containerSignatureDir;
    }

    public File getTextSignatureFileDir() {
        return this.textSignatureFileDir;
    }

    public File getReportDefinitionDir() {
        return this.reportDefinitionDir;
    }

    public File getProfilesDir() {
        return this.profilesDir;
    }

    public File getFilterDir() {
        return this.filterDir;
    }

    public File getTempDir() {
        return this.tempDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createResourceFile(File resourceDir, String fileName, String resourceName) throws IOException {
        InputStream in = this.getClass().getClassLoader().getResourceAsStream(resourceName);
        if (in == null) {
            this.log.warn((Object)("Resource not found: " + resourceName));
        } else {
            File resourcefile = new File(resourceDir, fileName);
            if (resourcefile.createNewFile()) {
                FileOutputStream out = new FileOutputStream(resourcefile);
                try {
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
                finally {
                    if (out != null) {
                        ((OutputStream)out).close();
                    }
                    if (in != null) {
                        in.close();
                    }
                }
            }
        }
    }

    public boolean getBooleanProperty(DroidGlobalProperty propertyKey) {
        return this.props.getBoolean(propertyKey.getName());
    }
}

