/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.filter;

import java.util.Date;
import org.joda.time.DateMidnight;
import uk.gov.nationalarchives.droid.core.interfaces.filter.CriterionFieldEnum;
import uk.gov.nationalarchives.droid.core.interfaces.filter.FilterCriterion;
import uk.gov.nationalarchives.droid.core.interfaces.filter.expressions.Criterion;
import uk.gov.nationalarchives.droid.core.interfaces.filter.expressions.Restrictions;

public final class RestrictionFactory {
    private RestrictionFactory() {
    }

    public static Criterion forFilterCriterion(FilterCriterion criterion) {
        Criterion restriction;
        if (criterion.getValue() instanceof Date) {
            return RestrictionFactory.forDateCriterion(criterion);
        }
        CriterionFieldEnum field = criterion.getField();
        String propertyName = field.getPropertyName();
        Object value = criterion.getValue();
        switch (criterion.getOperator()) {
            case EQ: {
                restriction = Restrictions.eq(propertyName, value);
                break;
            }
            case NE: {
                restriction = Restrictions.neq(propertyName, value);
                break;
            }
            case GT: {
                restriction = Restrictions.gt(propertyName, value);
                break;
            }
            case GTE: {
                restriction = Restrictions.gte(propertyName, value);
                break;
            }
            case LT: {
                restriction = Restrictions.lt(propertyName, value);
                break;
            }
            case LTE: {
                restriction = Restrictions.lte(propertyName, value);
                break;
            }
            case ANY_OF: {
                restriction = Restrictions.in(propertyName, (Object[])value);
                break;
            }
            case CONTAINS: {
                restriction = Restrictions.like(propertyName, '%' + (String)value + '%');
                break;
            }
            case ENDS_WITH: {
                restriction = Restrictions.like(propertyName, '%' + (String)value);
                break;
            }
            case STARTS_WITH: {
                restriction = Restrictions.like(propertyName, (String)value + '%');
                break;
            }
            case NOT_CONTAINS: {
                restriction = Restrictions.notLike(propertyName, '%' + (String)value + '%');
                break;
            }
            case NOT_ENDS_WITH: {
                restriction = Restrictions.notLike(propertyName, '%' + (String)value);
                break;
            }
            case NOT_STARTS_WITH: {
                restriction = Restrictions.notLike(propertyName, (String)value + '%');
                break;
            }
            case NONE_OF: {
                restriction = Restrictions.notIn(propertyName, (Object[])value);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Invalid operator [%s]", new Object[]{criterion.getOperator()}));
            }
        }
        return restriction;
    }

    private static Criterion forDateCriterion(FilterCriterion dateCriterion) {
        Criterion criterion;
        CriterionFieldEnum field = dateCriterion.getField();
        Date dateValue = (Date)dateCriterion.getValue();
        Date from = new DateMidnight((Object)dateValue).toDate();
        Date to = new DateMidnight((Object)dateValue).plusDays(1).toDate();
        String propertyName = field.getPropertyName();
        switch (dateCriterion.getOperator()) {
            case EQ: {
                criterion = Restrictions.and(Restrictions.gte(propertyName, from), Restrictions.lt(propertyName, to));
                break;
            }
            case NE: {
                criterion = Restrictions.or(Restrictions.lt(propertyName, from), Restrictions.gte(propertyName, to));
                break;
            }
            case LT: {
                criterion = Restrictions.lt(propertyName, from);
                break;
            }
            case LTE: {
                criterion = Restrictions.lt(propertyName, to);
                break;
            }
            case GT: {
                criterion = Restrictions.gte(propertyName, to);
                break;
            }
            case GTE: {
                criterion = Restrictions.gte(propertyName, from);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Invalid operator for date [%s]", new Object[]{dateCriterion.getOperator()}));
            }
        }
        return criterion;
    }
}

