/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.tools.db;

import ch.docuteam.tools.out.Logger;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public abstract class MySQLJDBCConnection {
    public static final String PropertyNameDBHost = "DBHost";
    public static final String PropertyNameDBPort = "DBPort";
    public static final String PropertyNameDBName = "DBName";
    public static final String PropertyNameDBUserName = "DBUserName";
    public static final String PropertyNameDBUserPassword = "DBUserPassword";
    public static final String PropertyNameSSLKeyStore = "javax.net.ssl.keyStore";
    public static final String PropertyNameSSLKeyStorePassword = "javax.net.ssl.keyStorePassword";
    public static final String PropertyNameSSLTrustStore = "javax.net.ssl.trustStore";
    public static final String PropertyNameSSLTrustStorePassword = "javax.net.ssl.trustStorePassword";
    private static final String DBConnectionPrefix = "jdbc:mysql://";
    private static final String DBConnectionSSLPostfix = "?verifyServerCertificate=true&useSSL=true&requireSSL=true";
    private static String ConnectionString;
    private static String UserName;
    private static String Password;
    private static Connection Connection;

    public static Connection create(String dbHost, String dbPort, String dbName, String userName, String password) throws SQLException {
        ConnectionString = DBConnectionPrefix + dbHost + ":" + dbPort + "/" + dbName;
        UserName = userName;
        Password = password;
        return MySQLJDBCConnection.create();
    }

    public static Connection createUsingSSL(String dbHost, String dbPort, String dbName, String userName, String password, String sslKeyStore, String sslKeyStorePassword, String sslTrustStore, String sslTrustStorePassword) throws SQLException {
        System.setProperty(PropertyNameSSLKeyStore, sslKeyStore);
        System.setProperty(PropertyNameSSLKeyStorePassword, sslKeyStorePassword);
        System.setProperty(PropertyNameSSLTrustStore, sslTrustStore);
        System.setProperty(PropertyNameSSLTrustStorePassword, sslTrustStorePassword);
        ConnectionString = DBConnectionPrefix + dbHost + ":" + dbPort + "/" + dbName + DBConnectionSSLPostfix;
        UserName = userName;
        Password = password;
        return MySQLJDBCConnection.create();
    }

    public static Connection getConnection() {
        return Connection;
    }

    public static ResultSet executeQuery(String query) throws SQLException {
        MySQLJDBCConnection.reOpenIfNecessary();
        Logger.info("\t" + query);
        return Connection.createStatement().executeQuery(query);
    }

    public static int executeUpdate(String query) throws SQLException {
        MySQLJDBCConnection.reOpenIfNecessary();
        Logger.info("\t" + query);
        int rowCount = Connection.createStatement().executeUpdate(query);
        Logger.info("\t-> " + rowCount);
        return rowCount;
    }

    public static ResultSet executeInsert(String query) throws SQLException {
        MySQLJDBCConnection.reOpenIfNecessary();
        Logger.info("\t" + query);
        Statement statement = Connection.createStatement();
        int rowCount = statement.executeUpdate(query, new String[]{"id"});
        Logger.info("\t-> " + rowCount);
        return statement.getGeneratedKeys();
    }

    public static PreparedStatement prepareStatement(String query) throws SQLException {
        MySQLJDBCConnection.reOpenIfNecessary();
        Logger.info("\t" + query);
        return Connection.prepareStatement(query, new String[]{"id"});
    }

    public static void close() throws SQLException {
        Logger.debug("Closing");
        if (Connection != null) {
            Connection.close();
        }
    }

    private static Connection create() throws SQLException {
        Logger.debug("Creating: " + ConnectionString);
        Connection = DriverManager.getConnection(ConnectionString, UserName, Password);
        return Connection;
    }

    private static Connection reOpenIfNecessary() throws SQLException {
        if (Connection == null || !Connection.isValid(0)) {
            MySQLJDBCConnection.create();
        }
        return Connection;
    }
}

