/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.packer.gui.sipView.actions;

import ch.docuteam.converter.FileConverter;
import ch.docuteam.converter.exceptions.BadPronomIdException;
import ch.docuteam.converter.exceptions.FileConversionException;
import ch.docuteam.darc.exceptions.FileAlreadyExistsException;
import ch.docuteam.darc.exceptions.FileOperationNotAllowedException;
import ch.docuteam.darc.exceptions.FolderNameIsEmptyException;
import ch.docuteam.darc.mets.Document;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.darc.mets.structmap.NodeFile;
import ch.docuteam.packer.gui.PackerConstants;
import ch.docuteam.packer.gui.sipView.SIPView;
import ch.docuteam.packer.gui.sipView.actions.AbstractSIPViewAction;
import ch.docuteam.packer.gui.sipView.actions.ActionMonitoringDialog;
import ch.docuteam.packer.gui.sipView.actions.ConvertFilesStartDialog;
import ch.docuteam.packer.gui.util.CancellableOperation;
import ch.docuteam.tools.exception.ExceptionCollector;
import ch.docuteam.tools.exception.ExceptionCollectorException;
import ch.docuteam.tools.file.FileUtil;
import ch.docuteam.tools.file.exception.DROIDCouldNotInitializeException;
import ch.docuteam.tools.file.exception.DROIDMultipleIdentificationsFoundException;
import ch.docuteam.tools.file.exception.DROIDNoIdentificationFoundException;
import ch.docuteam.tools.file.exception.FileIsNotADirectoryException;
import ch.docuteam.tools.file.exception.FileUtilExceptionListException;
import ch.docuteam.tools.out.Logger;
import ch.docuteam.tools.translations.I18N;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.dom4j.DocumentException;

public class ConvertFilesAction
extends AbstractSIPViewAction {
    private static final long serialVersionUID = 1L;
    private final ActionMonitoringDialog convertMonitoringDialog;
    private int convertedFilesCount = 0;
    private List<NodeFile> nodeList = new ArrayList<NodeFile>();

    public ConvertFilesAction(SIPView sipView) {
        super(I18N.translate((String)"ButtonConvertFiles"), PackerConstants.getImageIcon("Convert.png"), sipView);
        this.putValue("ShortDescription", I18N.translate((String)"ToolTipConvertFiles"));
        this.convertMonitoringDialog = new ActionMonitoringDialog(null, I18N.translate((String)"ButtonConvertFiles"));
    }

    private List<NodeFile> getNodesForAction() {
        int[] selectedRows;
        ArrayList<NodeFile> nodesForAction = new ArrayList<NodeFile>();
        for (int selectedRow : selectedRows = this.sipView.getTreeTable().getSelectedRows()) {
            NodeAbstract node = (NodeAbstract)this.sipView.getTreeTable().getPathForRow(selectedRow).getLastPathComponent();
            if (!this.isNodeReadWrite(node)) continue;
            nodesForAction.add((NodeFile)node);
        }
        return nodesForAction;
    }

    private boolean isNodeReadWrite(NodeAbstract node) {
        return this.sipView.getDocument().getMode().equals((Object)Document.Mode.ReadWrite) && node.isFile() && node.canRead() && node.canWrite() && node.getSubmitStatus().isEditingAllowed() && ((NodeFile)node).getMigrationDerivedNode() == null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.nodeList = this.getNodesForAction();
        long totalSize = 0L;
        this.convertedFilesCount = 0;
        for (NodeFile node : this.nodeList) {
            totalSize += node.getSize().longValue();
        }
        ConvertFilesStartDialog d = new ConvertFilesStartDialog(this.sipView, this.nodeList.size(), totalSize);
        if (!d.goButtonWasClicked) {
            return;
        }
        ConvertTracker convertTracker = new ConvertTracker(this.convertMonitoringDialog, d.keepOriginalCheckBox.isSelected());
        this.convertMonitoringDialog.setOperation(convertTracker);
        convertTracker.execute();
    }

    @Override
    public void enableOrDisable() {
        this.nodeList = this.getNodesForAction();
        this.setEnabled(this.nodeList.size() > 0);
    }

    class ConvertTracker
    extends SwingWorker<Void, String>
    implements CancellableOperation {
        private final ActionMonitoringDialog convertTrackerDialog;
        private boolean isKeepOriginal = true;
        private final AtomicBoolean cancelRequested = new AtomicBoolean(false);
        private final String MessageSuccess = String.format(" : %s\n", I18N.translate((String)"MessageSuccess"));
        private final String MessageNoAction = String.format(" : %s\n", I18N.translate((String)"MessageNoAction"));
        private final String MessageFailure = String.format(" : %s\n", I18N.translate((String)"MessageFailure"));
        private final String MessageCancelled = String.format("\n%s\n", I18N.translate((String)"MessageCanceled"));

        public ConvertTracker(ActionMonitoringDialog convertTrackerDialog, boolean isKeepOriginal) {
            this.convertTrackerDialog = convertTrackerDialog;
            this.isKeepOriginal = isKeepOriginal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String migrateFile(NodeFile file, Boolean retainOriginalFile) {
            String result;
            block12: {
                result = this.MessageFailure;
                File convertedFile = null;
                try {
                    convertedFile = FileConverter.convertFile((String)file.getAbsolutePathString());
                    if (convertedFile != null) {
                        try {
                            Logger.info((Object)("Migrated file: '" + file.getPathString() + "' into '" + convertedFile.getName() + "'"));
                            String migrationToolName = FileConverter.getRecentlyUsedFileConverterName();
                            ExceptionCollector.clear();
                            if (retainOriginalFile.booleanValue()) {
                                file.migrateToFileKeepOriginal(convertedFile.getPath(), migrationToolName);
                            } else {
                                file.migrateToFile(convertedFile.getPath(), migrationToolName);
                            }
                            result = this.MessageSuccess;
                        }
                        catch (FileOperationNotAllowedException | FolderNameIsEmptyException migrationToolName) {
                        }
                        finally {
                            FileUtil.delete((File)convertedFile);
                        }
                        if (!ExceptionCollector.isEmpty().booleanValue()) {
                            throw new ExceptionCollectorException();
                        }
                        break block12;
                    }
                    result = this.MessageNoAction;
                }
                catch (BadPronomIdException | FileConversionException | FileAlreadyExistsException | ExceptionCollectorException | DROIDCouldNotInitializeException | DROIDMultipleIdentificationsFoundException | DROIDNoIdentificationFoundException | FileIsNotADirectoryException | FileUtilExceptionListException | IOException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | IndexOutOfBoundsException | InterruptedException | NoSuchMethodException | SecurityException | InvocationTargetException | DocumentException e) {
                    Logger.error((Object)String.format("Exception during migration for '%s', keepOriginal = %b", file.getAbsolutePathString(), retainOriginalFile), (Throwable)e);
                    result = this.MessageFailure;
                }
            }
            return result;
        }

        @Override
        protected void process(List<String> chunks) {
            for (String chunk : chunks) {
                this.convertTrackerDialog.appendMessage(chunk);
            }
        }

        @Override
        protected Void doInBackground() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ConvertTracker.this.convertTrackerDialog.init();
                    ConvertTracker.this.convertTrackerDialog.setVisible(true);
                }
            });
            for (NodeFile node : ConvertFilesAction.this.nodeList) {
                if (this.cancelRequested.get()) {
                    this.publish(this.MessageCancelled);
                    this.convertTrackerDialog.setOver();
                    break;
                }
                ConvertFilesAction.this.convertedFilesCount++;
                this.publish(ConvertFilesAction.this.convertedFilesCount + ": " + node.getPathString() + " ... ");
                String result = this.migrateFile(node, this.isKeepOriginal);
                this.publish(result);
            }
            ConvertFilesAction.this.sipView.getTreeTableModel().refreshTreeStructure(ConvertFilesAction.this.sipView.getTreeTable().getPathForRow(0));
            ConvertFilesAction.this.sipView.enableOrDisableActions();
            this.convertTrackerDialog.setOver();
            return null;
        }

        @Override
        public void cancelOperation() {
            this.cancelRequested.set(true);
        }
    }
}

