/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.mets.filesec;

import ch.docuteam.darc.common.NodeAbstract;
import ch.docuteam.darc.mets.Document;
import ch.docuteam.darc.mets.filesec.File;
import ch.docuteam.tools.exception.Exception;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class FileSection
extends NodeAbstract {
    protected Map<String, File> files = new HashMap<String, File>();

    protected FileSection() {
    }

    private FileSection(Document document) {
        this.document = document;
        this.element = (Element)this.document.selectSingleNode("./METS:mets/METS:fileSec");
        if (this.element == null) {
            this.element = DocumentHelper.createElement((String)"METS:fileSec");
            this.document.getRootElement().content().add(2, this.element);
            this.element.addElement("METS:fileGrp");
        }
        if (this.element.selectNodes("./METS:fileGrp").size() >= 2) {
            Exception.remember((String)("Bad number of file groups in the METS file's File Section. Expected: 1, found: " + this.element.selectNodes("./METS:fileGrp").size()));
        }
        for (File file : File.parse(this)) {
            this.files.put(file.getId(), file);
        }
    }

    public static FileSection parse(Document document) {
        return new FileSection(document);
    }

    public List<File> getFiles() {
        return new ArrayList<File>(this.files.values());
    }

    public File getFile(String id) {
        return this.files.get(id);
    }

    public void delete(File file) {
        this.files.remove(file.getId());
    }

    public void add(File file) {
        this.files.put(file.getId(), file);
        this.document.setIsModified();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("\n[FileSection:(files:" + this.files.size() + ")");
        for (File file : this.files.values()) {
            buf.append("\n\t" + file.toString());
        }
        buf.append("\n]");
        return buf.toString();
    }
}

